<?php

/**
 * Description of reportes_co
 *
 * @author pmercado
 */

include_once APPPATH.'modules/platc/models/reportes/reportes_base_model.php';

class Reportes_co extends Reportes_Base {

    public function __construct() {

        parent::__construct();
    }

    public function reportes_cie_por_especialidad( $especialidades, $id_site ) {

        $sql = "SELECT  t.TEL_ID AS FOLIO,
                        t.ESP_ID AS ESPECIALIDAD,
                        t.TEL_PAC_SEXO AS GENERO,
                        t.TEL_PAC_EDAD AS EDAD,
                        td.TEL_CIE_ID_RESPUESTA AS DIAGNOSTICOS
                FROM    TC_TELECONSULTA t
                        INNER JOIN TC_TELECONSULTA_CIE10_RESPUESTA td ON ( td.TEL_ID = t.TEL_ID )
                WHERE   t.EST_ID = 7
                    AND t.ESP_ID = " . (int)$especialidades . "
                    AND t.SIT_ID = " . (int)$id_site . "
--                    AND t.TEL_FECHA_HORA_RESPUESTA <= NOW()
                ORDER BY t.ESP_ID, t.TEL_ID DESC";

        $query = $this->db->query( $sql );
        if( $query->num_rows() > 0 ) {

            /*
             * Obtiene códigos CIE10: obtiene códigos propios CIE10 (id10) desde
             * identificadores de la base de datos (CIE_ID)
             */

            // Genera array temporal como cache que contiene códigos CIE_ID
            $reporte = $query->result_array( );
            $listado_id_codigos = array( );
            foreach( $reporte as $d ) {

                $id_codigos = json_decode( $d['DIAGNOSTICOS'], TRUE );
                if( !empty( $id_codigos ) ) {
                    foreach( $id_codigos as $id_codigo )
                        $listado_id_codigos[ $id_codigo ] = $id_codigo;
                }
            }

            // Genera array temporal que contiene códigos CIE10 en función del arreglo temporal
            $query = $this->db->from( 'TC_CIE10' )->where_in( 'CIE_ID', $listado_id_codigos );
            $resultado = $query->get();
            $listado_codigos_cie      = array();
            $listado_codigos_cie_temp = $resultado->result_array();
            foreach( $listado_codigos_cie_temp as $cie )
                $listado_codigos_cie[$cie['CIE_ID'] ] = $cie['descripcion'];

            // Establece nuevo campo "DIAGNOSTICO_CIE10" en listado principal
            // que contiene listado de códigos CIE10 y su descripción
            foreach( $reporte as &$d ) {

                $id_codigos = json_decode( $d['DIAGNOSTICOS'], TRUE );
                if( !empty( $id_codigos ) ) {
                    $t = array();
                    $id_codigo = null;
                    foreach( $id_codigos as $id_codigo )
                        $t[] = $listado_codigos_cie[ $id_codigo ];

                    $d['DIAGNOSTICOS_CIE10'] = implode( ", ", $t );
                }
            }

            return $reporte;
            // Crea array que permite establecer como índice el id de la especialidad
//            $reporte_final = array( );
//            foreach( $reporte as $r ) {
//
//
//                $reporte_final[ $r['ESPECIALIDAD'] ][] = $r;
//            }
//            return $reporte_final;
        } else
            return NULL;
    }

    /**
     * Zoho SI769 : Base de datos de teleconsultas.
     * Desde el área de Teleconsulta requieren una base de teleconsulta de las
     * tc contestadas a todos nuestros clientes de los meses febrero, marzo y
     * abril de 2014 con los items que se encuentran descritos en el archivo
     * adjunto, información que solicita gerencia y la cual necesito lo más
     * pronto posible.
     *
     * Columnas:
     * Folio TC
     * ID Paciente
     * Nombre y apellido del paciente
     * Establecimiento
     * Especialidad
     * Genero
     * Edad
     * CIE10 Medico general
     * CIE10 Especialista
     * Orientacion Diagnostica
     * Orientacion en manejo y tratamientos
     * Fundamento del diagnóstico / Manejo y tratamiento
     * Orientación para control y seguimiento
     */

    public function tc_contestadas( $id_site, $fecha_inicio, $fecha_fin ) {

        $sql = "SELECT  t.TEL_ID,
                        --        t.TEL_PAC_ID,
                        i.PAC_IDT_VALOR,
                        concat( t.TEL_PAC_PRIMER_NOMBRE, ' ', t.TEL_PAC_SEGUNDO_NOMBRE, ' ', t.TEL_PAC_PRIMER_APELLIDO, ' ', t.TEL_PAC_SEGUNDO_APELLIDO ) as NOMBRE_COMPLETO,
                        etb.ETB_NOMBRE,
                        e.ESP_NOMBRE,
                        t.TEL_PAC_SEXO,
                        t.TEL_PAC_EDAD,
                        g.TD_VALOR AS CIE10_GENERALISTA,
                        r.TEL_CIE_ID_RESPUESTA AS CIE10_ESPECIALISTA,
                        t.TEL_CON_ESPECIALISTA, -- ORIENTACION DIAGNOSTICA
                        t.TEL_DIA_ESPECIALISTA, -- ORIENTACION EN MANEJO Y TRATAMIENTO
                        t.TEL_DIA_FUNDAMENTOS, -- FUNDAMENTO DEL DIAGNOSTICO / MANEJO Y TRATAMIENTO
                        t.TEL_DIA_ORIENTACION -- ORIENTACION PARA CONTROL Y SEGUIMIENTO
                FROM    TC_TELECONSULTA t
                        -- ESTABLECIMIENTO
                        INNER JOIN TC_ESTABLECIMIENTO etb ON ( etb.ETB_ID = t.ETB_ID )
                        -- ESPECIALIDAD
                        INNER JOIN TC_ESPECIALIDAD e ON ( e.ESP_ID = t.ESP_ID )
                        -- CIE10 MEDICO GENERAL
                        LEFT JOIN TC_TELECONSULTA_DATA g ON ( g.TEL_ID = t.TEL_ID AND g.TD_CLAVE = 'dm_general' )
                        -- CIE10 MEDICO ESPECIALISTA
                        LEFT JOIN TC_TELECONSULTA_CIE10_RESPUESTA r ON ( r.TEL_ID = t.TEL_ID )
                        -- IDENTIFICADOR DEL PACIENTE
                        LEFT JOIN TC_PACIENTE_IDENTIFICADOR i ON ( i.PAC_ID = t.PAC_ID )
                WHERE   t.EST_ID = 7
                    AND t.TEL_FECHA_HORA_ENVIO >= '".$fecha_inicio."' and t.TEL_FECHA_HORA_ENVIO < '".$fecha_fin."'
                    AND t.SIT_ID = ".(int)$id_site."
                ORDER BY t.TEL_ID; ";

        $q = $this->db->query( $sql );
        if( $q->num_rows() > 0 ) {

            $reporte = $q->result_array();

            /*
             * Obtiene identificadores de códigos CIE10 para transformarlos a códigos propios XYYY
             */
            $listado_codigos = array( );
            $listado_codigos_g = array( );
            $listado_codigos_e = array( );
            foreach( $reporte as $r ) {
                $temp_g = json_decode( $r['CIE10_GENERALISTA'], TRUE );
                if( !empty( $temp_g ) )
                    foreach( $temp_g as $v )
                        $listado_codigos_g[$v] = $v;
            }

            foreach( $reporte as $r ) {
                $temp_g = json_decode( $r['CIE10_ESPECIALISTA'], TRUE );
                if( !empty( $temp_g ) )
                    foreach( $temp_g as $v )
                        $listado_codigos_e[$v] = $v;
            }

            $listado_codigos = array_merge( $listado_codigos_g, $listado_codigos_e );

            /*
             * Obtiene todos los códigos CIE10 desde base de datos
             */
            $listado_codigos_cie_cache = array( );
            $query = $this->db->from( 'TC_CIE10' )->where_in( 'CIE_ID', $listado_codigos );
            $resultado = $query->get();
            $l = $resultado->result_array();
            foreach( $l as $k => $v )
                $listado_codigos_cie_cache[ $v['CIE_ID'] ] = $v;


            //Codigos del generalista
            foreach( $reporte as &$r ) {

                $listado_codigos_cie10_g = array();
                $temp_g = json_decode( $r['CIE10_GENERALISTA'], TRUE );
                if( !empty( $temp_g ) ){

                    $listado_codigos_cie10_g = array( );
                    foreach( $temp_g as $v )
                        $listado_codigos_cie10_g[] = $listado_codigos_cie_cache[$v]['id10'];
                    $r['CIE10_GENERALISTA'] = implode( ",", $listado_codigos_cie10_g );
                }
            }

            //Codigos del especialista
            foreach( $reporte as &$r ) {

                $listado_codigos_cie10_g = array();
                $temp_e = json_decode( $r['CIE10_ESPECIALISTA'], TRUE );
                if( !empty( $temp_e ) ){

                    $listado_codigos_cie10_e = array( );
                    foreach( $temp_e as $v )
                        $listado_codigos_cie10_e[] = $listado_codigos_cie_cache[$v]['id10'];
                    $r['CIE10_ESPECIALISTA'] = implode( ",", $listado_codigos_cie10_e );
                }
            }

            return $reporte;
        }
    }

    /**
     * Zoho SI769 : Base de datos de teleconsultas.
     * Desde el área de Teleconsulta requieren una base de teleconsulta de las
     * tc contestadas a todos nuestros clientes de los meses febrero, marzo y
     * abril de 2014 con los items que se encuentran descritos en el archivo
     * adjunto, información que solicita gerencia y la cual necesito lo más
     * pronto posible.
     *
     * Columnas:
     * Folio TC
     * ID Paciente
     * Nombre y apellido del paciente
     * Establecimiento
     * Especialidad
     * Genero
     * Edad
     * CIE10 Medico general
     * CIE10 Especialista
     * Orientacion Diagnostica
     * Orientacion en manejo y tratamientos
     * Fundamento del diagnóstico / Manejo y tratamiento
     * Orientación para control y seguimiento
     */

    public function tc_contestadas_v2( $id_site, $fecha_inicio, $fecha_fin ) {

        $sql = "SELECT  t.TEL_ID,
                        --        t.TEL_PAC_ID,
                        i.PAC_IDT_VALOR,
                        concat( t.TEL_PAC_PRIMER_NOMBRE, ' ', t.TEL_PAC_SEGUNDO_NOMBRE, ' ', t.TEL_PAC_PRIMER_APELLIDO, ' ', t.TEL_PAC_SEGUNDO_APELLIDO ) as NOMBRE_COMPLETO,
                        etb.ETB_NOMBRE,
                        e.ESP_NOMBRE,
                        t.TEL_PAC_SEXO,
                        t.TEL_PAC_EDAD,
                        g.TD_VALOR AS CIE10_GENERALISTA,
                        r.TEL_CIE_ID_RESPUESTA AS CIE10_ESPECIALISTA
                        -- t.TEL_CON_ESPECIALISTA, -- ORIENTACION DIAGNOSTICA
                        -- t.TEL_DIA_ESPECIALISTA, -- ORIENTACION EN MANEJO Y TRATAMIENTO
                        -- t.TEL_DIA_FUNDAMENTOS, -- FUNDAMENTO DEL DIAGNOSTICO / MANEJO Y TRATAMIENTO
                        -- t.TEL_DIA_ORIENTACION -- ORIENTACION PARA CONTROL Y SEGUIMIENTO
                FROM    TC_TELECONSULTA t
                        -- ESTABLECIMIENTO
                        INNER JOIN TC_ESTABLECIMIENTO etb ON ( etb.ETB_ID = t.ETB_ID )
                        -- ESPECIALIDAD
                        INNER JOIN TC_ESPECIALIDAD e ON ( e.ESP_ID = t.ESP_ID )
                        -- CIE10 MEDICO GENERAL
                        LEFT JOIN TC_TELECONSULTA_DATA g ON ( g.TEL_ID = t.TEL_ID AND g.TD_CLAVE = 'dm_general' )
                        -- CIE10 MEDICO ESPECIALISTA
                        LEFT JOIN TC_TELECONSULTA_CIE10_RESPUESTA r ON ( r.TEL_ID = t.TEL_ID )
                        -- IDENTIFICADOR DEL PACIENTE
                        LEFT JOIN TC_PACIENTE_IDENTIFICADOR i ON ( i.PAC_ID = t.PAC_ID )
                WHERE   t.EST_ID = 7
                    AND t.TEL_FECHA_HORA_ENVIO >= '".$fecha_inicio."' and t.TEL_FECHA_HORA_ENVIO < '".$fecha_fin."'
                    AND t.SIT_ID = ".(int)$id_site."
                ORDER BY t.TEL_ID; ";

        $q = $this->db->query( $sql );
        if( $q->num_rows() > 0 ) {

            $reporte = $q->result_array();

            /*
             * Obtiene identificadores de códigos CIE10 para transformarlos a códigos propios XYYY
             */
            $listado_codigos = array( );
            $listado_codigos_g = array( );
            $listado_codigos_e = array( );
            foreach( $reporte as $r ) {
                $temp_g = json_decode( $r['CIE10_GENERALISTA'], TRUE );
                if( !empty( $temp_g ) )
                    foreach( $temp_g as $v )
                        $listado_codigos_g[$v] = $v;
            }

            foreach( $reporte as $r ) {
                $temp_g = json_decode( $r['CIE10_ESPECIALISTA'], TRUE );
                if( !empty( $temp_g ) )
                    foreach( $temp_g as $v )
                        $listado_codigos_e[$v] = $v;
            }

            $listado_codigos = array_merge( $listado_codigos_g, $listado_codigos_e );

            /*
             * Obtiene todos los códigos CIE10 desde base de datos
             */
            $listado_codigos_cie_cache = array( );
            $query = $this->db->from( 'TC_CIE10' )->where_in( 'CIE_ID', $listado_codigos );
            $resultado = $query->get();
            $l = $resultado->result_array();
            foreach( $l as $k => $v )
                $listado_codigos_cie_cache[ $v['CIE_ID'] ] = $v;


            //Codigos del generalista
            foreach( $reporte as &$r ) {

                $listado_codigos_cie10_g = array();
                $temp_g = json_decode( $r['CIE10_GENERALISTA'], TRUE );
                if( !empty( $temp_g ) ){

                    $listado_codigos_cie10_g = array( );
                    for( $i = 1 ; $i<=12 ; $i++ ) {
					    if( isset( $temp_g[$i-1] ) ) {
							// $listado_codigos_cie10_g[] = $listado_codigos_cie_cache[ $temp_g[$i-1] ]['id10'];
							$r['CIE10_GENERALISTA'.$i] = $listado_codigos_cie_cache[ $temp_g[$i-1] ]['id10'];
						} else 
							$r['CIE10_GENERALISTA'.$i] = "";
					}
                }
            }

            //Codigos del especialista
            foreach( $reporte as &$r ) {

                $listado_codigos_cie10_g = array();
                $temp_e = json_decode( $r['CIE10_ESPECIALISTA'], TRUE );
                if( !empty( $temp_e ) ){

                    $listado_codigos_cie10_e = array( );
                    for( $i = 1 ; $i<=12 ; $i++ ) {
						if( isset( $temp_e[$i-1] ) ) {						
							// $listado_codigos_cie10_e[] = $listado_codigos_cie_cache[ $temp_e[$i-1] ]['id10'];
							$r['CIE10_ESPECIALISTA'.$i] = $listado_codigos_cie_cache[ $temp_e[$i-1] ]['id10'];
						} else
							$r['CIE10_ESPECIALISTA'.$i] = "";
					}
                }
            }

            return $reporte;
        }
    }
}
