<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

$form = array(  'method' => 'post',
                'name' => 'add_agenda_form',
                'id' => 'add_agenda_form');
$descripcion_inpt = array(  'name' => 'descripcion',
                            'id' => 'descripcion',
                            'type' => 'text',
                            'rows' => '2',
                            'cols' => '30',
                            'value' => set_value('descripcion'),
                            'class' => 'text-input');
$hora_inicio_inpt = array(  'name' => 'hora_inicio',
                            'id' => 'hora_inicio',
                            'type' => 'text',
                            'maxlength' => '5',
                            'value' => set_value('hora_inicio'),
                            'class' => 'validate[required] text-input',
                            'size' => '5');
$hora_fin_inpt = array( 'name' => 'hora_fin',
                        'id' => 'hora_fin',
                        'type' => 'text',
                        'maxlength' => '5',
                        'value' => set_value('hora_fin'),
                        'class' => 'validate[required] text-input',
                        'size' => '5');
$intervalo = array('5' => '5', '10' => '10', '15' => '15', '20' => '20', '30' => '30',
                    '45' => '45', '60' => '60');
$fecha_inicio_inpt = array( 'name' => 'fecha_inicio',
                            'id' => 'fecha_inicio',
                            'type' => 'text',
                            'maxlength' => '10',
                            'value' => set_value('fecha_inicio'),
                            'class' => 'validate[required] text-input',
                            'size' => '10');
$fecha_fin_inpt = array('name' => 'fecha_fin',
                        'id' => 'fecha_fin',
                        'type' => 'text',
                        'maxlength' => '10',
                        'value' => set_value('fecha_fin'),
                        'class' => 'validate[required] text-input',
                        'size' => '10');

$agregar_buton = array( 'name' => 'button',
                        'id' => 'button',
                        'type' => 'submit',
                        'class' => 'boton_crear',
                        'content' => 'Agregar');
?>

<script type="text/javascript" language="javascript" >

    dayNames = [	'<?=$this->lang->line('domingo')?>',
                    '<?=$this->lang->line('lunes')?>',
                    '<?=$this->lang->line('martes')?>',
                    '<?=$this->lang->line('miercoles')?>',
                    '<?=$this->lang->line('jueves')?>',
                    '<?=$this->lang->line('viernes')?>',
                    '<?=$this->lang->line('sabado')?>'];
    dayNamesMin = [	'<?=$this->lang->line('dom')?>',
                    '<?=$this->lang->line('lun')?>',
                    '<?=$this->lang->line('mar')?>',
                    '<?=$this->lang->line('mie')?>',
                    '<?=$this->lang->line('jue')?>',
                    '<?=$this->lang->line('vie')?>',
                    '<?=$this->lang->line('sab')?>'];
    monthNames = [  '<?=$this->lang->line('enero')?>',
                    '<?=$this->lang->line('febrero')?>',
                    '<?=$this->lang->line('marzo')?>',
                    '<?=$this->lang->line('abril')?>',
                    '<?=$this->lang->line('mayo')?>',
                    '<?=$this->lang->line('junio')?>',
                    '<?=$this->lang->line('julio')?>',
                    '<?=$this->lang->line('agosto')?>',
                    '<?=$this->lang->line('septiembre')?>',
                    '<?=$this->lang->line('octubre')?>',
                    '<?=$this->lang->line('noviembre')?>',
                    '<?=$this->lang->line('diciembre')?>'];

    $.widget( "ui.timespinner", $.ui.spinner, {

        options: {
            // cada 10 minutos
            step: 60 * 10000,
            // hours
            page: 60
        },
        _parse: function( value ) {

            if ( typeof value === "string" ) {
                // already a timestamp
                if ( Number( value ) == value ) {
                    return Number( value );
                }
                return +Globalize.parseDate( value, "HH:mm" );
            }
            return value;
        },
        _format: function( value ) {

            return Globalize.format( new Date(value), "HH:mm" );
        }
    } );

    $(document).ready( function( ) {

        // Hora
        $('#hora_inicio').timespinner( );
        $('#hora_fin').timespinner( );

        $('#hora_inicio').val( '09:00' );
        $('#hora_fin').val( '19:00' );

        // Fecha
        fecha = {   minDate: new Date( '01/01/2010' ),
                    showOn: 'button',
                    buttonImageOnly: true,
                    buttonImage: '<?=base_url()?>images/calendario.png',
                    dateFormat: "dd-mm-yy",
                    dayNames: dayNames,
                    dayNamesMin: dayNamesMin,
                    monthNames: monthNames,
                    firstDay: 1,
                    gotoCurrentType: true,
                    showOtherMonths: true,
                    selectOtherMonths: true
                };

        $('#fecha_inicio').datepicker( fecha );
        $('#fecha_fin').datepicker( fecha );

        i = new Date();
        $('#fecha_inicio').val( '01-'+ ( ( i.getMonth() +1 < 10 ) ? '0'+( i.getMonth() +1 ) : ( i.getMonth() +1 ) ) + '-' + i.getFullYear() );
        f = new Date( i.getFullYear(), i.getMonth()+1, 0  );
        $('#fecha_fin').val( f.getDate()+'-'+ ( ( f.getMonth() +1 < 10 ) ? '0'+( f.getMonth() +1 ) : ( f.getMonth() +1 ) ) + '-' + f.getFullYear() );

        // Botón volver
        $('#volver').click( function( ){
            $('#deploy').load( '<?= base_url() ?>platc/agenda_resumen/'+Math.random( ) );
        } );

        // Envío de formulario usando ajax
        $('#add_agenda_form').validationEngine( {
            ajaxSubmit: true,
            ajaxSubmitFile: '<?=base_url()?>platc/agenda_agrega/'+Math.random( ),
            success : false,
            failure : false
        } );
    } );

    // Evita que se seleccione una hora de fin anterior a la de inicio
//    function customRange(input) {
//        return {minTime: (input.id == 'hora_fin' ? $('#hora_inicio').timeEntry('getTime') : null ),
//                maxTime: (input.id == 'hora_inicio' ? $('#hora_fin').timeEntry('getTime') : null) };
//    }

</script>

<?= form_open( '', $form) ?>
<table align="center" cellpadding="0" cellspacing="4" border="0" width="98%">

    <tr>
        <td align="left"><a href="#" id="volver"><img src="<?=base_url()?>images/volver.png" border="0" /></a></td>
    </tr>
    <tr>
        <td align="center" class="Subtitulo">&nbsp;<?= $this->lang->line('agenda_agregar') ?></td>
    </tr>
    <tr>
        <td>
            <table class="tab_data_form" align="center" cellpadding="0" cellspacing="0" border="0">
                <tr>
                    <td class="data_form"><span class="redtext">*</span><?=$this->lang->line('agenda_fecha_inicio')?></td>
                    <td align="left"><?=form_input($fecha_inicio_inpt)?></td>
                </tr>
                <tr>
                    <td class="data_form"><span class="redtext">*</span><?=$this->lang->line('agenda_fecha_fin')?></td>
                    <td align="left"><?=form_input($fecha_fin_inpt)?></td>
                </tr>
                <tr>
                    <td class="data_form"><span class="redtext">*</span><?=$this->lang->line('agenda_hora_inicio')?></td>
                    <td align="left"><?=form_input($hora_inicio_inpt)?></td>
                </tr>
                <tr>
                    <td class="data_form"><span class="redtext">*</span><?=$this->lang->line('agenda_hora_fin')?></td>
                    <td align="left"><?=form_input($hora_fin_inpt)?></td>
                </tr>
                <tr>
                    <td class="data_form"><span class="redtext">*</span><?=$this->lang->line('agenda_hora_intervalo')?></td>
                    <td align="left"><?=form_dropdown('intervalo', $intervalo)?> <?=$this->lang->line('agenda_intervalo_minutos')?></td>
                </tr>
                <tr>
                    <td class="data_form"><span class="redtext">*</span><?=$this->lang->line('rol_3')?> </td>
                    <td align="left"><?=form_dropdown( 'especialista', $especialistas, '', 'id="especialista" class="validate[required]"' )?></td>
                </tr>
                <tr>
                    <td class="data_form"><?=$this->lang->line('agenda_descripcion')?> </td>
                    <td align="left"><?=form_textarea($descripcion_inpt)?></td>
                </tr>
                <tr>
                    <td>&nbsp;</td>
                    <td align="left"><?=form_button($agregar_buton)?></td>
                </tr>
            </table>
        </td>
    </tr>
</table>
<?=form_close()?>
<br />
