<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); ?>

<script language="javascript" type="text/javascript">

    $(document).ready( function( ) {

        tableToGrid( '#agendamiento_grilla_tc', {

            // Numero total de registros a mostrar, usado para evitar que grilla
            // limite filas a su valor por omision (20 filas por pagina) cuando se ordena por columnas
            rowNum: 99999999,

            // Al seleccionar una TC se carga la vista para ver el calendario
            onSelectRow: function( rowid ) {

                $('#tabla_agendamiento_hora').css( 'display', '' );

                id = $(this).jqGrid( 'getCell', rowid, 0 );

                $('#agendamiento_id_tc').val( id );
                $('#agendamiento_teleconsulta_seleccionada').html( id );
                $('#agendamiento_medicos_especialistas').html( '' );
                $.getJSON( '<?=base_url()?>platc/agendamiento_obtener_medicos_especialidad',
                            { id_teleconsulta: id },
                            function( data ) {

                                $('#agendamiento_especialidad_teleconsulta').html( data.especialidad );

                                html = '<option value="0" ></option>';
                                for( i=0 ; i<data.medicos.length; i++ ) {
                                    html+= '<option value="'+data.medicos[i].id+'" >'+data.medicos[i].nombre+'</option>';
                                }
                                $('#agendamiento_medicos_especialistas').html( html );

                                $('[name=agendamiento_id_tc]').val( id );
                            }
                );
            },
            gridComplete: function( ) {

                $(this).jqGrid( 'hideCol', 'agenda_id_agenda' );
            }
        } );
    } );

</script>

<?php if( !empty( $teleconsultas ) ) { ?>
<?=$this->lang->line('agenda_seleccione_teleconsulta')?>
<table id="agendamiento_grilla_tc">
    <thead>
        <tr>
            <th>&nbsp;</th>
            <th><?= $this->lang->line('tc_id') ?></th>
            <th><?= $this->lang->line('tc_nom_ape') ?></th>
            <th><?= $this->lang->line('tc_establ') ?></th>
            <th><?= $this->lang->line('tc_time') ?></th>
            <th><?= $this->lang->line('tc_estado') ?></th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($teleconsultas as $tc) { ?>
            <tr>
                <td><?= form_radio( 'tc_seleccion', $tc['TEL_ID'] ) ?></td>
                <td><?= $tc['TEL_ID'] ?></td>
                <td><?= $tc['TEL_PAC_PRIMER_NOMBRE'] ?> <?= $tc['TEL_PAC_PRIMER_APELLIDO'] ?> <?= $tc[ 'TEL_PAC_SEGUNDO_APELLIDO' ] ?> </td>
                <td><?= $tc['ETB_NOMBRE'] ?></td>
                <td><?= $tc['TEL_FECHA_HORA_ENVIO'] ?></td>
                <td><?= $this->lang->line('estado_' . $tc['EST_ID']) ?></td>
            </tr>
        <?php } ?>
    </tbody>
</table>

<?php } else {?>

    <table style="text-align: center; width: 100%">
        <tr>
            <td ><?=$this->lang->line('tc_virtual_sin_teleconsultas')?></td>
        </tr>
    </table>
<?php } ?>
