<?php if( !defined( 'BASEPATH' ) ) exit( 'No direct script access allowed' );

$estado = 2;

// Búsqueda TC por Folio
$tcid_form          = array( 'method' => 'post', 'name' => 'tcid_form', 'id' => 'tcid_form' );
$tcid_inpt          = array( 'name' => 'tcid', 'id' => 'tcid', 'type' => 'text', 'size' => '30' );
$buscar_tcid_butn   = array( 'name' => 'buscar_tcid_butn', 'id' => 'buscar_tcid_butn', 'type' => 'button', 'class' => 'boton_buscar' );

// Búsqueda TC por rut paciente
$id_form        = array( 'method' => 'post', 'name' => 'id_form', 'id' => 'id_form' );
$id_inpt        = array( 'name' => 'id_paciente', 'id' => 'id_paciente', 'type' => 'text', 'size' => '30' );
$buscar_id_butn = array( 'name' => 'id_button', 'id' => 'id_button', 'type' => 'button', 'class' => 'boton_buscar' );

// Búsqueda por nombre y apellido del paciente
$nombre_apellido_form   = array( 'method' => 'post', 'name' => 'nombre_apellido_form', 'id' => 'nombre_apellido_form' );
$nombre_inpt            = array( 'name' => 'nombre', 'id' => 'nombre', 'type' => 'text', 'size' => '20' );
$apellido_inpt          = array( 'name' => 'apellido', 'id' => 'apellido', 'type' => 'text', 'size' => '20' );
$buscar_nombre_apellido_butn = array( 'name' => 'nombre_apellido_butn', 'id' => 'nombre_apellido_butn', 'type' => 'button', 'class' => 'boton_buscar' );

// Búsqueda por fecha
$tc_fecha_form      = array( 'method' => 'post', 'name' => 'tc_fecha_form', 'id' => 'tc_fecha_form' );
$fecha_desde_inpt	= array('name'  => 'fecha_desde',
                            'id'    => 'fecha_desde',
                            'class' => 'validate[required]',
                            'type'  => 'text',
                            'readonly' => 'readonly',
                            'value' => '01-'.date( 'm-Y' ),
                            'size'  => '10');
$fecha_hasta_inpt	= array('name'  => 'fecha_hasta',
                            'id'    => 'fecha_hasta',
                            'type'  => 'text',
                            'readonly' => 'readonly',
                            'size'  => '10');
$buscar_tc_fecha_butn   = array( 'name' => 'buscar_tc_fecha_butn', 'id' => 'buscar_tc_fecha_butn', 'type' => 'button', 'class' => 'boton_buscar' );
?>
<style>
    .ui-datepicker-trigger { vertical-align: middle; }
</style>

<script language="javascript" type="text/javascript">

    dayNames = [	'<?=$this->lang->line('domingo')?>',
                    '<?=$this->lang->line('lunes')?>',
                    '<?=$this->lang->line('martes')?>',
                    '<?=$this->lang->line('miercoles')?>',
                    '<?=$this->lang->line('jueves')?>',
                    '<?=$this->lang->line('viernes')?>',
                    '<?=$this->lang->line('sabado')?>'];
    dayNamesMin = [	'<?=$this->lang->line('dom')?>',
                    '<?=$this->lang->line('lun')?>',
                    '<?=$this->lang->line('mar')?>',
                    '<?=$this->lang->line('mie')?>',
                    '<?=$this->lang->line('jue')?>',
                    '<?=$this->lang->line('vie')?>',
                    '<?=$this->lang->line('sab')?>'];
    monthNames = [  '<?=$this->lang->line('enero')?>',
                    '<?=$this->lang->line('febrero')?>',
                    '<?=$this->lang->line('marzo')?>',
                    '<?=$this->lang->line('abril')?>',
                    '<?=$this->lang->line('mayo')?>',
                    '<?=$this->lang->line('junio')?>',
                    '<?=$this->lang->line('julio')?>',
                    '<?=$this->lang->line('agosto')?>',
                    '<?=$this->lang->line('septiembre')?>',
                    '<?=$this->lang->line('octubre')?>',
                    '<?=$this->lang->line('noviembre')?>',
                    '<?=$this->lang->line('diciembre')?>'];

    html = "";

    $(document).ready( function( ) {

        /*
         * Dropdown con listado de bolsas que al cambiar carga grilla de TC's asociadas
         */
        $('#bolsa').change( function( ) {

            if( $(this).val() != "" ) {
                bolsas_recargar_teleconsultas_asociadas( $(this).val() );
            } else {

                $('#div_tabla_teleconsultas_en_bolsa').slideUp();
                $('#div_tabla_teleconsultas_en_bolsa').empty( );
            }
//            $('#grilla_bolsas_examenes_asociados').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?= base_url() ?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
//            $('#grilla_bolsas_examenes_asociados').load('<?= base_url() ?>platc/bolsas_examenes_asociados/' + $(this).val() + '/' + Math.random() );
        } );

        /*
         * Botón para crear bolsa
         */
        $('#boton_crear').click(function( ) {
            $('#deploy').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?= base_url() ?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
            $('#deploy').load('<?= base_url() ?>platc/bolsas_crear/' + Math.random());
        });

        /*
         * Botón para editar bolsa establecido en dropdown #bolsa
         */
        $('#boton_editar').click( function( ) {

            id_bolsa = $('#bolsa').val();

            if( id_bolsa != "" ) {

                $('#deploy').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?= base_url() ?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
                $('#deploy').load('<?= base_url() ?>platc/bolsas_editar/' + id_bolsa + '/' + Math.random());
            }
        } );

        /*
         * Búsquedas de TC
         */

        // Busqueda por Folio de TC: Evita envío de formulario al apretar tecla Enter y cambia grilla con el resultado de la búsqueda
        $('#tcid').keypress( function( e ) {

            // e.which == 13: Comprueba tecla Enter
            if( e.which == 13 ) {

                e.preventDefault();     // Evita envío de formulario

                // Carga grilla con resultados de la búsqueda
                post_data = { id_teleconsulta: $('#tcid').val() };
                recrear_grilla_teleconsultas( '<?=base_url()?>platc/bolsas_teleconsultas_disponibles_tc_id', post_data );
            }

        } );

        // Búsqueda por Folio de TC: click en botón buscar
        $('#buscar_tcid_butn').click( function( ) {

            post_data = { id_teleconsulta: $('#tcid').val() };
            recrear_grilla_teleconsultas( '<?=base_url()?>platc/bolsas_teleconsultas_disponibles_tc_id', post_data );
        } );

        // Busqueda por nombre del paciente: Evita envío de formulario al apretar tecla Enter y cambia grilla con el resultado de la búsqueda
        $('#nombre').keypress( function( e ) {

            // e.which == 13: Comprueba tecla Enter
            if( e.which == 13 ) {

                e.preventDefault();     // Evita envío de formulario

                // Carga grilla con resultados de la búsqueda
                post_data = { nombre: $('#nombre').val(), apellido: $('#apellido').val() };
                recrear_grilla_teleconsultas( '<?=base_url()?>platc/bolsas_teleconsultas_disponibles_tc_na', post_data );
            }

        } );

        // Busqueda por apellido del paciente: Evita envío de formulario al apretar tecla Enter y cambia grilla con el resultado de la búsqueda
        $('#apellido').keypress( function( e ) {

            // e.which == 13: Comprueba tecla Enter
            if( e.which == 13 ) {

                e.preventDefault();     // Evita envío de formulario

                // Carga grilla con resultados de la búsqueda
                post_data = { nombre: $('#nombre').val(), apellido: $('#apellido').val() };
                recrear_grilla_teleconsultas( '<?=base_url()?>platc/bolsas_teleconsultas_disponibles_tc_na', post_data );
            }

        } );

        // Busqueda por nombre y apellido del paciente: click en botón buscar
        $('#nombre_apellido_butn').click( function( ) {

            post_data = { nombre: $('#nombre').val(), apellido: $('#apellido').val() };
            recrear_grilla_teleconsultas( '<?=base_url()?>platc/bolsas_teleconsultas_disponibles_tc_na', post_data );
        } );

        // Busqueda por rut del paciente: Evita envío de formulario al apretar tecla Enter y cambia grilla con el resultado de la búsqueda
        $('#id_paciente').keypress( function( e ) {

            // e.which == 13: Comprueba tecla Enter
            if( e.which == 13 ) {

                e.preventDefault();     // Evita envío de formulario

                // Carga grilla con resultados de la búsqueda
                post_data = { id_paciente: $('#id_paciente').val() };
                recrear_grilla_teleconsultas( '<?=base_url()?>platc/bolsas_teleconsultas_disponibles_id', post_data );
            }

        } );

        // Busqueda por rut del paciente: click en botón buscar
        $('#id_button').click( function( ) {

            post_data = { id_paciente: $('#id_paciente').val() };
            recrear_grilla_teleconsultas( '<?=base_url()?>platc/bolsas_teleconsultas_disponibles_id', post_data );
        } );


        // Búsqueda por fecha
        fecha = {   minDate: new Date( '01/01/2010' ),
                    showOn: 'button',
                    buttonImageOnly: true,
                    buttonImage: '<?=base_url()?>images/calendario.png',
                    dateFormat: "dd-mm-yy",
                    dayNames: dayNames,
                    dayNamesMin: dayNamesMin,
                    monthNames: monthNames,
                    firstDay: 1,
                    gotoCurrentType: true,
                    showOtherMonths: true,
                    selectOtherMonths: true
                };

        $('#fecha_desde').datepicker( fecha );
        $('#fecha_hasta').datepicker( fecha );

        // Elimina datos: cuando se agrega una fecha y se desea eliminar filtro
        $('#fecha_hasta').click( function( ) { $(this).val('') } );

        //
        $('#buscar_tc_fecha_butn').click( function( ) {

            if( !$.validationEngine.loadValidation("#fecha_desde") ) {

                post_data = { fecha_desde: $('#fecha_desde').val(), fecha_hasta: $('#fecha_hasta').val() };
                recrear_grilla_teleconsultas( '<?=base_url()?>platc/bolsas_teleconsultas_disponibles_fecha', post_data );
            }
        } );

        $('#tc_fecha_form').validationEngine();

        /*
         * Asociar bolsas <-> teleconsultas
         */
        // Grilla de teleconsultas en estado "nuevas/enviadas"
        $('#tabla_teleconsultas_disponibles').jqGrid( {
            url: "<?=base_url()?>platc/bolsas_teleconsultas_disponibles",
            datatype: "json",
            loadonce: true,
            multiselect: true,
            rowNum: 999999,
            colNames: [ "<?=$this->lang->line('tc_id')?>", "<?=$this->lang->line('tc_nom_ape')?>",
                        "<?=$this->lang->line('tc_establ')?>", "<?=$this->lang->line('tc_especialidad_busqueda')?>",
                        "<?=$this->lang->line('nivel')?>", "<?=$this->lang->line('tc_time')?>",
                        "<?=$this->lang->line('tc_estado')?>", "<?=$this->lang->line('tc_prioridad')?>",
                        "<?=$this->lang->line('dias')?>", "", "" ],
            colModel: [ {   name: "TEL_ID", width: 40, align: "center", index:"TEL_ID", sorttype:"int" },
                        {   name: "TEL_PAC_PRIMER_NOMBRE", sorttype:"text",
                            formatter : function( value, options, rData ) { return value + " " + rData['TEL_PAC_PRIMER_APELLIDO'] + " " + rData['TEL_PAC_SEGUNDO_APELLIDO']; },
                            width: 160 },
                        {   name: "ETB_NOMBRE", sorttype:"text"},
                        {   name: "ESP_NOMBRE", width: 90, align: "center", sorttype:"text" },
                        {   name: "ETB_NIVEL", width: 30, align: "center", sorttype:"text" },
                        {   name: "TEL_FECHA_HORA_ENVIO", width: 110, align: "center", sorttype:"date", formatter: "date", formatoptions: { srcformat:"Y-m-d H:i:s", newformat:"H:i:s d-m-Y", parseRe:"" } },
                        {   name: "EST_ID", sorttype:"text",
                            formatter : function( value, options, rData ) {

                                switch( parseInt( value ) ) {
                                    case 1 : return "<?=$this->lang->line('estado_1')?>";
                                    case 2 : return "<?=$this->lang->line('estado_2')?>";
                                    case 3 : return "<?=$this->lang->line('estado_3')?>";
                                    case 4 : return "<?=$this->lang->line('estado_4')?>";
                                    case 5 : return "<?=$this->lang->line('estado_5')?>";
                                    case 6 : return "<?=$this->lang->line('estado_6')?>";
                                    case 7 : return "<?=$this->lang->line('estado_7')?>";
                                }
                            return "<?=$this->lang->line('estado_')?>"; },
                            width: 50, align: "center"
                        },
                        {   name: "PRI_ID",
                            formatter : function( value, options, rData ) {

                                img = ""; txt = "";
                                switch( parseInt( value ) ) {
                                    case 1 : img = "prioridad_alta.png";  txt = "<?=$this->lang->line('prioridad_1')?>"; break;
                                    case 2 : img = "prioridad_media.png"; txt = "<?=$this->lang->line('prioridad_2')?>"; break;
                                    case 3 : img = "prioridad_baja.png";  txt = "<?=$this->lang->line('prioridad_3')?>"; break;
                                }
                                return '<img src="<?=base_url()?>/images/'+img+'">&nbsp;'+txt;
                            }, width: 60
                        },
                        {   name: "TEL_ATRASO", width: 30, align: "center", sorttype:"int" },
                        {   name: "TEL_PAC_PRIMER_APELLIDO", hidden: true },
                        {   name: "TEL_PAC_SEGUNDO_APELLIDO", hidden: true },
                    ],
            ignoreCase: true
        } );

        // Agrega filtro de textos en cabezera de grilla
        $("#tabla_teleconsultas_disponibles").jqGrid('filterToolbar', { searchOnEnter: false, defaultSearch: 'cn' } );

        // Grilla de bolsas
        $('#tabla_bolsas_disponibles').jqGrid( {
            url: "<?=base_url()?>platc/bolsas_bolsas_disponibles",
            datatype: "json",
            multiselect: true,
            loadonce: true,
            rowNum: 999999,
            colNames: [ "<?=$this->lang->line('tc_id')?>", "<?=$this->lang->line('bolsas_nombre')?>" ],
            colModel: [ {   name: "BOL_ID" },
                        {   name: "BOL_NOMBRE" } ]
        } );

        // Asocia en única variable teleconsultas y bolsas seleccionadas al momento
        // de enviar formulario
        $('#form_asociar_bolsas_teleconsultas').submit( function( ) {

            // Obtiene TC's seleccionados
            tc = $('#tabla_teleconsultas_disponibles').jqGrid( 'getGridParam', 'selarrrow' );
            if( tc.length > 0 ) {

                id_tc_array = Array( );
                for( i in tc )
                    id_tc_array.push( $('#tabla_teleconsultas_disponibles').jqGrid( 'getCell', tc[i], 1 ) );

                $('#form_asociar_bolsas_teleconsultas input[name="teleconsultas"]').val( id_tc_array );
            } else
                $('#form_asociar_bolsas_teleconsultas input[name="teleconsultas"]').val( "" );

            // Obtiene bolsas seleccionadas
            bolsas = $('#tabla_bolsas_disponibles').jqGrid( 'getGridParam', 'selarrrow' );
            if( bolsas.length > 0 ) {

                id_bolsas_array = Array( );
                for( i in bolsas )
                    id_bolsas_array.push( $('#tabla_bolsas_disponibles').jqGrid( 'getCell', bolsas[i], 1 ) );

                $('#form_asociar_bolsas_teleconsultas input[name="bolsas"]').val( id_bolsas_array );
            } else
                $('#form_asociar_bolsas_teleconsultas input[name="bolsas"]').val( "" );
        } );

        // Envío de formulario usando ajax
        $('#form_asociar_bolsas_teleconsultas').validationEngine( {
            ajaxSubmit: true,
            ajaxSubmitFile: '<?=base_url()?>platc/bolsas_teleconsultas_asociar/'+Math.random( ),
            success : false,
            failure : false
        } );

    } );

    function recrear_grilla_teleconsultas( url, post_data ) {

        configuracion = {
            url: url,
            mtype: "POST",
            postData: post_data,
            datatype: "json",
            multiselect: true,
            colNames: [ "<?=$this->lang->line('tc_id')?>", "<?=$this->lang->line('tc_nom_ape')?>",
                        "<?=$this->lang->line('tc_establ')?>", "<?=$this->lang->line('tc_especialidad_busqueda')?>",
                        "<?=$this->lang->line('nivel')?>", "<?=$this->lang->line('tc_time')?>",
                        "<?=$this->lang->line('tc_estado')?>", "<?=$this->lang->line('tc_prioridad')?>",
                        "<?=$this->lang->line('dias')?>" ],
            colModel: [ {   name: "TEL_ID", width: 40, align: "center", index:"TEL_ID", sorttype:"int" },
                        {   name: "TEL_PAC_PRIMER_NOMBRE",
                            formatter : function( value, options, rData ) { return value + " " + rData['TEL_PAC_PRIMER_APELLIDO'] + " " + rData['TEL_PAC_SEGUNDO_APELLIDO']; },
                            width: 160 },
                        {   name: "ETB_NOMBRE"},
                        {   name: "ESP_NOMBRE", width: 90, align: "center" },
                        {   name: "ETB_NIVEL", width: 30, align: "center" },
                        {   name: "TEL_FECHA_HORA_ENVIO", width: 110, align: "center", formatter: "date", formatoptions: { srcformat:"Y-m-d H:i:s", newformat:"H:i:s d-m-Y", parseRe:"" } },
                        {   name: "EST_ID",
                            formatter : function( value, options, rData ) {

                                switch( parseInt( value ) ) {
                                    case 1 : return "<?=$this->lang->line('estado_1')?>";
                                    case 2 : return "<?=$this->lang->line('estado_2')?>";
                                    case 3 : return "<?=$this->lang->line('estado_3')?>";
                                    case 4 : return "<?=$this->lang->line('estado_4')?>";
                                    case 5 : return "<?=$this->lang->line('estado_5')?>";
                                    case 6 : return "<?=$this->lang->line('estado_6')?>";
                                    case 7 : return "<?=$this->lang->line('estado_7')?>";
                                }
                            return "<?=$this->lang->line('estado_')?>"; },
                            width: 50, align: "center"
                        },
                        {   name: "PRI_ID",
                            formatter : function( value, options, rData ) {

                                img = ""; txt = "";
                                switch( parseInt( value ) ) {
                                    case 1 : img = "prioridad_alta.png";  txt = "<?=$this->lang->line('prioridad_1')?>"; break;
                                    case 2 : img = "prioridad_media.png"; txt = "<?=$this->lang->line('prioridad_2')?>"; break;
                                    case 3 : img = "prioridad_baja.png";  txt = "<?=$this->lang->line('prioridad_3')?>"; break;
                                }
                                return '<img src="<?=base_url()?>/images/'+img+'">&nbsp;'+txt;
                            }, width: 60
                        },
                        {   name: "TEL_ATRASO", width: 30, align: "center" }
                    ]
        };

        $('#tabla_teleconsultas').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?=base_url()?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
        $('#tabla_teleconsultas').html("<table id=\"tabla_teleconsultas_disponibles\"></table>");
        $('#tabla_teleconsultas_disponibles').jqGrid( configuracion );
    }

    function desvincular_tc_bolsa( id_teleconsulta ) {

		jConfirm( '<?= $this->lang->line( 'bolsas_desasociar_confirmacion' ) ?>', '<?= html_entity_decode( $this->lang->line( 'confirmacion' ), ENT_COMPAT, 'UTF-8' ) ?>', function(r) {
			if (r == true) {

                $.post(
                    '<?= base_url() ?>platc/bolsas_teleconsultas_desasociar/'+id_teleconsulta+'/'+Math.random(),
                    {   id_teleconsulta: id_teleconsulta,
                        id_bolsa: $('#bolsa').val()
                    },
                    function(data){

                    if( data == 'true' ) {
						jAlert('<?= $this->lang->line( 'bolsas_desasociar_ok' ) ?>', 'OK');
                        bolsas_recargar_teleconsultas_asociadas( $('#bolsa').val() );
	   				} else {
						jAlert('<?= $this->lang->line( 'bolsas_desasociar_error' ) ?>', '<?=$this->lang->line('error')?>');
	   				}
				});
			}
		} );
    }

    function bolsas_recargar_teleconsultas_asociadas( id_bolsa ) {

        html = "<table id=\"tabla_teleconsultas_en_bolsa\"><tr><td></td></tr></table>";
        $('#div_tabla_teleconsultas_en_bolsa').slideDown();
        $('#div_tabla_teleconsultas_en_bolsa').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?= base_url() ?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
        $('#div_tabla_teleconsultas_en_bolsa').html(html);
        $('#tabla_teleconsultas_en_bolsa').jqGrid( {
            url: "<?=base_url()?>platc/bolsas_teleconsultas_asociadas/"+parseInt( id_bolsa ),
            datatype: "json",
            multiselect: true,
            loadonce: true,
            rowNum: 999999,
            colNames: [ "<?=$this->lang->line('tc_id')?>", "<?=$this->lang->line('tc_nom_ape')?>",
                        "<?=$this->lang->line('tc_establ')?>", "<?=$this->lang->line('tc_especialidad_busqueda')?>",
                        "<?=$this->lang->line('nivel')?>", "<?=$this->lang->line('tc_time')?>",
                        "<?=$this->lang->line('tc_estado')?>", "<?=$this->lang->line('tc_prioridad')?>",
                        "<?=$this->lang->line('dias')?>", "", "" , "&nbsp;" ],
            colModel: [ {   name: "TEL_ID", width: 40, align: "center", index:"TEL_ID", sorttype:"int" },
                        {   name: "TEL_PAC_PRIMER_NOMBRE",
                            formatter : function( value, options, rData ) { return value + " " + rData['TEL_PAC_PRIMER_APELLIDO'] + " " + rData['TEL_PAC_SEGUNDO_APELLIDO']; },
                            width: 160 },
                        {   name: "ETB_NOMBRE"},
                        {   name: "ESP_NOMBRE", width: 90, align: "center" },
                        {   name: "ETB_NIVEL", width: 30, align: "center" },
                        {   name: "TEL_FECHA_HORA_ENVIO", width: 110, align: "center", formatter: "date", formatoptions: { srcformat:"Y-m-d H:i:s", newformat:"H:i:s d-m-Y", parseRe:"" } },
                        {   name: "EST_ID",
                            formatter : function( value, options, rData ) {

                                switch( parseInt( value ) ) {
                                    case 1 : return "<?=$this->lang->line('estado_1')?>";
                                    case 2 : return "<?=$this->lang->line('estado_2')?>";
                                    case 3 : return "<?=$this->lang->line('estado_3')?>";
                                    case 4 : return "<?=$this->lang->line('estado_4')?>";
                                    case 5 : return "<?=$this->lang->line('estado_5')?>";
                                    case 6 : return "<?=$this->lang->line('estado_6')?>";
                                    case 7 : return "<?=$this->lang->line('estado_7')?>";
                                }
                            return "<?=$this->lang->line('estado_')?>"; },
                            width: 50, align: "center"
                        },
                        {   name: "PRI_ID",
                            formatter : function( value, options, rData ) {

                                img = ""; txt = "";
                                switch( parseInt( value ) ) {
                                    case 1 : img = "prioridad_alta.png";  txt = "<?=$this->lang->line('prioridad_1')?>"; break;
                                    case 2 : img = "prioridad_media.png"; txt = "<?=$this->lang->line('prioridad_2')?>"; break;
                                    case 3 : img = "prioridad_baja.png";  txt = "<?=$this->lang->line('prioridad_3')?>"; break;
                                }
                                return '<img src="<?=base_url()?>/images/'+img+'">&nbsp;'+txt;
                            }, width: 60
                        },
                        {   name: "TEL_ATRASO", width: 30, align: "center" },
                        {   name: "TEL_PAC_PRIMER_APELLIDO", hidden: true },
                        {   name: "TEL_PAC_SEGUNDO_APELLIDO", hidden: true },
                        {   name: "desvincular",
                            formatter : function( value, options, rData ) {
                                return '<img src="<?=base_url()?>/images/drop.png" title="<?=$this->lang->line('desvincular')?>" onclick="desvincular_tc_bolsa( '+rData['TEL_ID']+' )">';
                            },
                            width: 20
                        }
                    ]
        } );
    }
</script>

<br />

<!-- Titulo : bolsas -->
<table align="center" cellpadding="0" cellspacing="4" border="0" width="98%">
    <tr>
        <td align="center" class="Subtitulo">&nbsp;<?= $this->lang->line( 'bolsas' ) ?></td>
    </tr>
</table>

<!-- Listado de bolsas -->
<table class="tab_data_form" cellpadding="0" cellspacing="0" border="0" style="width: 100%;">

    <tr>
        <td colspan="2">
            <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                <tr>
                    <td class="title_data_form"><?=$this->lang->line('bolsas_subtitulo')?></td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>
                <select name="bolsa" id="bolsa" style="width: 400px;">
                    <option value="">&nbsp;</option>
                    <?php foreach( $bolsas as $bolsa ) { ?>
                        <option value="<?=$bolsa['BOL_ID']?>"><?=$bolsa['BOL_NOMBRE']?></option>
                    <?php } ?>
                </select>
        </td>
        <td align="right">
            <button id="boton_editar" class="boton_guardar"><?=$this->lang->line('bolsas_editar_bolsa')?></button>
            <button id="boton_crear" class="boton_crear"><?=$this->lang->line('bolsas_crear_bolsa')?></button>
        </td>
    </tr>

    <tr>
        <td colspan="2">
            <div id="div_tabla_teleconsultas_en_bolsa" style="display: none;">
                <table id="tabla_teleconsultas_en_bolsa"><tr><td></td></tr></table>
            </div>
        </td>
    </tr>
</table>

<br />

<!-- Asociar Teleconsultas -->
<form name="form_asociar_bolsas_teleconsultas" id="form_asociar_bolsas_teleconsultas" action="" method="POST">

    <input type="hidden" name="teleconsultas" id="teleconsultas" />
    <input type="hidden" name="bolsas" id="bolsas" />

    <table class="tab_data_form" cellpadding="0" cellspacing="0" border="0" style="width: 100%;">

        <!-- Titulo: Asociar teleconsultas a bolsas -->
        <tr>
            <td>
                <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                    <tr>
                        <td class="title_data_form"><?=$this->lang->line('bolsas_asociar_teleconsultas')?></td>
                    </tr>
                </table>
            </td>
        </tr>

        <tr>
            <td>

                <table align="center" cellpadding="0" cellspacing="4" border="0" width="98%">
                    <tr>
                        <td valign="top" align="right" width="50%">

                            <table align="right" cellpadding="0" cellspacing="0" border="0" width="100%">
                                <tr>
                                    <td align="left"><strong><?= $this->lang->line( 'buscartcporid' ) ?></strong></td>
                                </tr>
                                <tr>
                                    <td>
                                        <!-- Búsqueda por Folio de TC -->
                                        <?= form_open( '', $tcid_form ) ?>
                                        <table align="right" cellpadding="0" cellspacing="4" border="0" class="borde" width="100%">
                                            <tr>
                                                <td align="left"><img src="<?= base_url() ?>images/row.gif" />&nbsp;<?= $this->lang->line( 'idteleconsulta' ) ?>:&nbsp;</td>
                                                <td align="right"><?= form_input( $tcid_inpt ) ?> </td>
                                            </tr>
                                            <tr>
                                                <td>&nbsp;</td>
                                                <td align="right"><?= form_button( $buscar_tcid_butn ) ?> </td>
                                            </tr>
                                        </table>
                                        <?= form_close() ?>

                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <!-- Búsqueda por fecha -->
                                        <?= form_open( '', $tc_fecha_form ) ?>
                                        <table align="right" cellpadding="0" cellspacing="4" border="0" class="borde" width="100%">
                                            <tr>
                                                <td align="left" colspan="5"><img src="<?= base_url() ?>images/row.gif" />&nbsp;<?= $this->lang->line( 'teleconsultas_por_fechas' ) ?>:&nbsp;</td>
                                            </tr>
                                            <tr>
                                                <td style="text-align: right;"><?=$this->lang->line('desde')?>: <?= form_input( $fecha_desde_inpt ) ?> </td>
                                                <td style="text-align: right;"><?=$this->lang->line('hasta')?>: <?= form_input( $fecha_hasta_inpt ) ?> </td>
                                                <td style="text-align: right;"><?= form_button( $buscar_tc_fecha_butn ) ?> </td>
                                            </tr>
                                        </table>
                                        <?= form_close() ?>

                                    </td>
                                </tr>
                                <tr>
                                    <td valign="bottom">
                                        <table align="left" cellpadding="0" cellspacing="0" border="0">
                                            <tr>
                                                <td valign="bottom" align="left">
                                                    <a href="javascript:;" onclick="reloadg('tc_lista', '<?= $estado ?>')"><img src="<?= base_url() ?>images/actualizar.png" border="0" /></a>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>

                        </td>
                        <td valign="top" align="right" width="50%">

                            <table align="right" cellpadding="0" cellspacing="0" border="0" width="100%">
                                <tr>
                                    <td align="left">
                                        <strong><?= $this->lang->line( 'buscartcpor' ) ?></strong>
                                    </td>
                                </tr>
                                <tr>
                                    <td>

                                        <?= form_open( '', $id_form ) ?>
                                        <table align="right" cellpadding="0" cellspacing="4" border="0" class="borde_top_left_right" width="100%">
                                            <tr>
                                                <td align="left"><img src="<?= base_url() ?>images/row.gif" />&nbsp;<?= $this->lang->line( 'identificador' ) ?>:&nbsp;</td>
                                                <td align="right"><?= form_input( $id_inpt ) ?></td>
                                            </tr>
                                            <tr>
                                                <td>&nbsp;</td>
                                                <td>&nbsp;</td>
                                                <td align="right"><?= form_button( $buscar_id_butn ) ?></td>
                                            </tr>
                                        </table>
                                        <?= form_close() ?>

                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <!-- Búsqueda por Nombre y apellido del paciente -->
                                        <?= form_open( '', $nombre_apellido_form ) ?>
                                        <table align="right" cellpadding="0" cellspacing="4" border="0" class="borde" width="100%">
                                            <tr>
                                                <td align="left"><img src="<?= base_url() ?>images/row.gif" />&nbsp;<?= $this->lang->line( 'nombreyoapellido' ) ?>:&nbsp;</td>
                                                <td>
                                                    <table align="right" cellpadding="0" cellspacing="4" border="0" width="100%">
                                                        <tr>
                                                            <td align="right" class="texto"><?= $this->lang->line( 'nombre' ) ?>:&nbsp;<?= form_input( $nombre_inpt ) ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td align="right" class="texto"><?= $this->lang->line( 'apellido' ) ?>:&nbsp;<?= form_input( $apellido_inpt ) ?></td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>&nbsp;</td>
                                                <td align="right"><?= form_button( $buscar_nombre_apellido_butn ) ?> </td>
                                            </tr>
                                        </table>
                                        <?= form_close() ?>

                                    </td>
                                </tr>
                            </table>

                        </td>
                    </tr>
                </table>

            </td>
        </tr>

        <tr>
            <td>
                <table align="center" cellpadding="0" cellspacing="4" border="0" width="98%">
                    <tr>
                        <td align="center" class="Subtitulo">&nbsp;<?= $this->lang->line( 'tc_listado_tc_disponibles' ) ?></td>
                    </tr>
                </table>

                <div id="tabla_teleconsultas">
                    <table id="tabla_teleconsultas_disponibles"></table>
                </div>
            </td>
        </tr>

        <tr>
            <td>

                <table align="center" cellpadding="0" cellspacing="4" border="0" width="98%">
                    <tr>
                        <td align="center" class="Subtitulo">&nbsp;<?= $this->lang->line( 'bolsas_listado_bolsas_disponibles' ) ?></td>
                    </tr>
                </table>

                <table id="tabla_bolsas_disponibles"></table>
            </td>
        </tr>

        <tr>
            <td align="right"><button class="boton_aceptar"><?=$this->lang->line('bolsas_asociar')?></button></td>
        </tr>

    </table>

</form>

<br />
