<?php

// Campo oculto identificador de la TC
$revisor_tc_id_inpt	= array('name'  => 'tc_id',
                            'id'    => 'tc_id',
                            'type'  => 'hidden',
                            'value' => $tc['TEL_ID']);

// Contraseña del revisor para confirmar envio (aprobación) de la TC
$revisor_password_inpt	= array('name'  => 'passwd',
                                'id'    => 'passwd',
                                'type'  => 'password',
                                'maxlength' => '30',
                                'size'  => '30');

// Boton que permite envío de la TC
$revisor_enviar_tc_butn	= array('name'  => 'button',
                                'id'    => 'button',
                                'type'  => 'submit',
                                'class' => 'boton_enviar',
                                'content' => $this->lang->line('enviar'));

/*
 * Lógica Aprobación de la TC
 */
// Boton que permite mostrar bloque de contraseña para envio (aprobacion) de la TC
$revisor_boton_aprobar  = array('name'  => 'revisor_boton_aprobar',
                                'id'    => 'revisor_boton_aprobar',
                                'type'  => 'button',
                                'class' => 'boton_01',
                                'content' => $this->lang->line('tc_aprobar') );

// Formulario para envio (aprobacion) de la TC
$revisor_form_aprobar = array(  'method'=> 'post',
                                'name'  => 'revisor_form_aprobar',
                                'id'    => 'revisor_form_aprobar');
/*
 * Lógica para rechazar TC
 */
$revisor_boton_rechazar	= array('name'  => 'revisor_boton_rechazar',
                                'id'    => 'revisor_boton_rechazar',
                                'type'  => 'button',
                                'class' => 'boton_eliminar',
                                'content' => '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$this->lang->line('tc_responder_rechazar_btn'));

$form_motivo_rechazo = array('method'   => 'post',
                             'name'     => 'form_motivo_rechazo',
                             'id'       => 'form_motivo_rechazo');
$id_inpt	= array('name'  => 'tc_id',
					'id'    => 'tc_id',
					'type'  => 'hidden',
					'value' => $tc['TEL_ID']);
$motiv_rechazo_inpt	= array('name'  => 'motivo_comentario',
                            'id'    => 'motiv_rechazo',
                            'type'  => 'text',
                            'style' => 'width: 478px',
                            'autocomplete' => 'off',
                            'class' => 'validate[required]',
                            'cols'  => '80',
                            'rows'  => '4');
$motiv_rechazo_butn	= array('name'  => 'button',
                            'id'    => 'motiv_rechazo_butn',
                            'type'  => 'button',
                            'class' => 'boton_enviar',
                            'content' => $this->lang->line('enviar'));

// Contraseña del revisor para rechazar la TC
$revisor_rechazar_password_inpt	= array('name'  => 'passwd',
                                        'id'    => 'rechazar_passwd',
                                        'type'  => 'password',
                                        'maxlength' => '30',
                                        'size'  => '30');
?>

<script type="text/javascript">

    $(document).ready( function( ) {

        /*
         * Lógica Aprobar TC
         */
        // Boton que muestra cuadro de solicitud de examenes
        $('#revisor_boton_aprobar').click( function() {

//            ag_responder.f();
//            ag_solicitud_examen.i();

            $('#display_motivo_rechazo').css('display', 'none');
            $('#display_revisor_aprobar').slideDown('slow').css('display', 'block');
        } );

        // Validación para formulario responder
        $('#revisor_form_aprobar').validationEngine( {
            ajaxSubmit: true,
            ajaxSubmitFile: '<?=base_url()?>platc/tc_revisor_aprueba',
            success : false,
            failure : false
        } );

        /*
         * Lógica para rechazar TC
         */
        // Boton de despliegue cuadro de rechazo
        $('#revisor_boton_rechazar').click( function( ) {

            $('#display_revisor_aprobar').css('display', 'none');
            $('#display_motivo_rechazo').slideDown('slow').css('display', 'block');
        } );

        // Boton de envío de formulario motivo rechazo
        $("#motiv_rechazo_butn").click( function() {

            estado = false;

            // Verifica que si se selecciona "otros motivos" en el dropdown,
            // el usuario ingresa datos en campo de texto correspondiente
            if( $('#motivo_rechazo_select').val() === "" ) {
                $.validationEngine.buildPrompt( "#motivo_rechazo_select", "<?=$this->lang->line('obligatorios')?>" );
                estado = true;
            }

            if( parseInt( $('#motivo_rechazo_select').val() ) === 1 ) {

                if( $('#motiv_rechazo').val() === "" ) {
                    $.validationEngine.buildPrompt( "#motiv_rechazo", "<?=$this->lang->line('obligatorios')?>" );
                    estado = true;
                }
            }

            // Verifica que si se selecciona "otros motivos" en el dropdown,
            // el usuario ingresa datos en campo de texto correspondiente
            if( $('#rechazar_passwd').val() === "" ) {
                $.validationEngine.buildPrompt( "#rechazar_passwd", "<?=$this->lang->line('obligatorios')?>" );
                estado = true;
            }

            if( estado == true )
                return false;

            jConfirm('<?=$this->lang->line('rechazar_dialogo')?> TC "<?=$tc['TEL_ID']?>"?', '<?=html_entity_decode( $this->lang->line('confirmacion'), ENT_COMPAT, 'UTF-8' )?>', function(r) {
                if (r == true) {
                    $.post('<?=base_url()?>platc/tc_revisor_enviada_rechazar/'+Math.random(),
                        $('#form_motivo_rechazo').serialize(),
                        function(data){
                        if(data == 'true') {
                            $('#deploy').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?=base_url()?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
                            $('#deploy').load('<?=base_url()?>platc/tc_lista_view/2/'+Math.random());
                            jAlert('<?=$this->lang->line('tc_ok')?>', 'OK');
                            $('html').animate({ scrollTop: 0 });
                        }
                        else {
                            data = $.parseJSON(data);
                            jAlert( data.msg, data.msgt );
                        }
                    });
                }
            });
        });


        // Boton de despliegue cuadro de rechazo "Otros"
        $('#motivo_rechazo_select').change( function( ) {

            // Cierra globo de validación en campo de texto motivo de rechazo
            $.validationEngine.closePrompt( "#motivo_rechazo_select" );
            $.validationEngine.closePrompt( "#motiv_rechazo" );

            // 1: Otro -> debe desplegar cuadro de texto "Otro motivo"
            if( parseInt( $(this).val() ) === 1 ) {

                $('#motivo_rechazo_textarea_div').slideDown('slow').css('display', 'block');
            } else {

                $('#motivo_rechazo_textarea_div').slideUp('slow').css('display', 'none');
            }

        } );

        // Asocia textareas a ckeditor
        $('textarea').ckeditor( function() { },
            {   uiColor: '#cccccc',
                language : '<?php switch( $this->config->item('language') ) { case 'spanish' : echo 'es'; break; case 'portuguese' : echo 'pt-br'; break; } ?>',
                enterMode : CKEDITOR.ENTER_BR,
                shiftEnterMode: CKEDITOR.ENTER_P,
                entities: false,
                toolbar: [ { name: 'editing', groups: [ 'spellchecker' ], items: [ 'Scayt' ] } ],
                removePlugins: 'elementspath',
                resize_enabled: false,
                height: 150,
                scayt_autoStartup: <?= ($this->session->userdata('SIT_ID') == 2 ) ? "false" : "true" ?>,
                scayt_sLang: '<?php switch( $this->config->item('language') ) { case 'spanish' : echo 'es'; break; case 'portuguese' : echo 'pt-br'; break; } ?>'
            }
        );
    } );

</script>

<table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
    <tr>
        <td align="center"><?= form_button($revisor_boton_aprobar) ?></td>
        <td align="center"><?= form_button($revisor_boton_rechazar) ?></td>
    </tr>
</table>
<br />

<!-- Aprobar -->
<div id="display_revisor_aprobar" style="display: none;">
    <table align="center" cellpadding="0" cellspacing="4" border="0">
        <tr>
            <td>
                <?=form_open('', $revisor_form_aprobar)?>
                <?=form_input( $revisor_tc_id_inpt )?>
                <table align="center" cellpadding="0" cellspacing="4" border="0" class="borde">
                    <tr>
                        <td align="right"><?= $this->lang->line('su_clave') ?>: <?= form_input($revisor_password_inpt) ?></td>
                        <td align="left"><?= form_button($revisor_enviar_tc_butn) ?></td>
                    </tr>
                </table>
                <?=form_close()?>
            </td>
        </tr>
    </table>
</div>

<!-- Rechazar -->
<div id="display_motivo_rechazo" style="display: none;" >
    <?= form_open('', $form_motivo_rechazo) ?>
    <?= form_input($id_inpt) ?>

    <br />
    <table class="tab_data_form" align="center" cellpadding="0" cellspacing="0" border="0">
        <tr>
            <td>
                <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                    <tr>
                        <td class="title_data_form"><?= $this->lang->line('tc_motivo_rechazo_title') ?></td>
                        <td class="title_data_form2">(<span class="redtext">&nbsp;*&nbsp;</span>)&nbsp;<?= $this->lang->line('obligatorios') ?></td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td>
                <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                    <tr>
                        <td class="data_form" valign="top"><span class="redtext">*</span>&nbsp;<?= $this->lang->line('tc_motivo_rechazo_ingreso_texto') ?>: </td>
                        <td align="left"><?=form_dropdown( 'motivo_id', $listado_motivos_rechazo, null, 'id="motivo_rechazo_select" ')?></td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td>
                <div id="motivo_rechazo_textarea_div" style="display: none;">
                    <table width="100%">
                        <tr>
                            <td class="data_form" valign="top">&nbsp;</td>
                            <td align="left"><?= form_textarea($motiv_rechazo_inpt) ?></td>
                        </tr>
                    </table>
                </div>
            </td>
        </tr>
    </table>
    <table align="center" cellpadding="0" cellspacing="4" border="0">
        <tr>
            <td>
                <table align="center" cellpadding="0" cellspacing="4" border="0" class="borde">
                    <tr>
                        <td align="right"><?= $this->lang->line('su_clave') ?>: <?= form_input($revisor_rechazar_password_inpt) ?></td>
                        <td align="left"><?= form_button($motiv_rechazo_butn) ?></td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
    <?= form_close() ?>
</div>
