<?php

if( $modo == FormularioXML::$MODO_LECTURA ) { ?>

<table cellspacing="0" cellpadding="0" border="0" align="center" >
    <tbody>

        <!-- Siente dolor -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_siente_dolor')?></td>
            <td align="left">
                <?=( isset ( $odon_siente_dolor ) && ( $odon_siente_dolor == 1 ) ) ?
                    $this->lang->line('odon_si') : $this->lang->line('odon_no') ?>
                <br/>

                <!--  Consigue identificar donde? -->
                <?php if( isset( $odon_siente_dolor ) && ( $odon_siente_dolor == 1 ) ) { ?>
                    <br/>
                    <span style="font-weight: bold"><?=$this->lang->line('odon_identificar_donde')?></span><br/>
                    <?=( isset ( $odon_siente_dolor_donde ) && !empty( $odon_siente_dolor_donde ) ) ?
                         nl2br( $odon_siente_dolor_donde ) : '' ?>
                <?php } ?>
            </td>
        </tr>

        <!-- Esteticamente, que incomada -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_esteticamente_incomoda')?></td>
            <td align="left">
                <?=( isset ( $odon_esteticamente_incomoda ) && !empty( $odon_esteticamente_incomoda ) ) ? nl2br( $odon_esteticamente_incomoda ) : '' ?>
            </td>
        </tr>

        <!-- Intención de cambiar restauraciones antiguas -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_cambiar_restauraciones_antiguas')?></td>
            <td align="left">
                <?=( isset ( $odon_cambiar_restauraciones_antiguas ) && ( $odon_cambiar_restauraciones_antiguas == 1 ) ) ?
                        $this->lang->line('odon_si') : $this->lang->line('odon_no')?>
            </td>
        </tr>

        <!-- Intención de realizar ortodoncia -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_realizar_ortodoncia')?></td>
            <td align="left">
                <?=( isset ( $odon_realizar_ortodoncia ) && ( $odon_realizar_ortodoncia == 1 ) ) ?
                        $this->lang->line('odon_si') : $this->lang->line('odon_no')?>
            </td>
        </tr>

        <!-- Intención de realizar limpieza -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_blanqueamento_dental')?></td>
            <td align="left">
                <?=( isset ( $odon_blanqueamento_dental ) && ( $odon_blanqueamento_dental == 1 ) ) ?
                        $this->lang->line('odon_si') : $this->lang->line('odon_no')?>
            </td>
        </tr>

        <!-- Tiene prótesis? -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_tiene_dentadura_postiza')?></td>
            <td align="left">
                <?=( isset ( $odon_tiene_dentadura_postiza ) && ( $odon_tiene_dentadura_postiza == 1 ) ) ?
                        $this->lang->line('odon_si') : $this->lang->line('odon_no')?>

                <!-- Tiene intención de cambiarlas? -->
                <?php if( isset ( $odon_tiene_dentadura_postiza ) && ( $odon_tiene_dentadura_postiza == 1 ) ) { ?>
                <br/>
                <br/>"<span style="font-weight: bold;"><?=$this->lang->line('odon_intencion_cambiar_protesis')?></span><br/>
                <?=( isset ( $odon_intencion_cambiar_protesis ) && ( $odon_intencion_cambiar_protesis == 1 ) ) ?
                        $this->lang->line('odon_si') : $this->lang->line('odon_no')?>
                <?php } ?>
            </td>
        </tr>

    </tbody>
</table>
<?php }

if( $modo == FormularioXML::$MODO_ESCRITURA) { ?>

<script language="javascript" type="text/javascript">
    
    $(document).ready( function( ) {

        // Activa campo "consigue identificar dolor"
        $('#odon_siente_dolor_si').click( function() {

            $('#odon_siente_dolor_donde').slideDown( );
            $('#odon_siente_dolor_donde').fadeIn( );
        } );

        // Desactiva campo "consigue identificar dolor"
        $('#odon_siente_dolor_no').click( function() {

            $('#odon_siente_dolor_donde').slideUp( );
            $('#odon_siente_dolor_donde').fadeOut( );
            $('#odon_siente_dolor_donde textarea').val( '' );
        } );

        // Activa campo de intención de cambiar prótesis
        $('#odon_tiene_dentadura_postiza_si').click( function() {

            $('#odon_intencion_cambiar_protesis').slideDown( );
            $('#odon_intencion_cambiar_protesis').fadeIn( );
        } );

        // Desactiva campo "consigue identificar dolor"
        $('#odon_tiene_dentadura_postiza_no').click( function() {

            $('#odon_intencion_cambiar_protesis').slideUp( );
            $('#odon_intencion_cambiar_protesis').fadeOut( );
            $('#odon_intencion_cambiar_protesis input[type=radio]').removeAttr( 'checked' );
        } );
    } );
</script>

<table cellspacing="0" cellpadding="0" border="0" align="center" >
    <tbody>

        <!-- Siente dolor -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_siente_dolor')?></td>
            <td align="left">
                <input type="radio"
                       id="odon_siente_dolor_si"
                       name="odon_siente_dolor"
                       value="1"
                       <?=( isset ( $odon_siente_dolor ) && ( $odon_siente_dolor == 1 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_siente_dolor_si"><?=$this->lang->line('odon_si')?></label>
                
                <input type="radio"
                       id="odon_siente_dolor_no"
                       name="odon_siente_dolor"
                       value="0"
                        <?=( !isset ( $odon_siente_dolor ) || ( $odon_siente_dolor == 0 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_siente_dolor_no"><?=$this->lang->line('odon_no')?></label>
                
                <!--  Consigue identificar donde? -->
                <div id="odon_siente_dolor_donde" <?=( isset ( $odon_siente_dolor ) && $odon_siente_dolor == 1 ) ? '' : 'style="display: none;"' ?>>
                    <br/>
                    <?=$this->lang->line('odon_identificar_donde')?><br/>
                    <textarea name="odon_siente_dolor_donde" style="width: 100%;"><?=( isset ( $odon_siente_dolor ) && isset( $odon_siente_dolor_donde ) ) ? $odon_siente_dolor_donde : '' ?></textarea>
                </div>
                <br/>
            </td>
        </tr>

        <!-- Esteticamente, que incomada -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_esteticamente_incomoda')?></td>
            <td align="left">
                <textarea name="odon_esteticamente_incomoda" style="width: 100%;"><?=( isset ( $odon_esteticamente_incomoda ) && !empty( $odon_esteticamente_incomoda ) ) ? $odon_esteticamente_incomoda : '' ?></textarea>
            </td>
        </tr>

        <!-- Intención de cambiar restauraciones antiguas -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_cambiar_restauraciones_antiguas')?></td>
            <td align="left">
                <input type="radio"
                       id="odon_cambiar_restauraciones_antiguas_si"
                       name="odon_cambiar_restauraciones_antiguas"
                       value="1"
                       <?=( isset ( $odon_cambiar_restauraciones_antiguas ) && ( $odon_cambiar_restauraciones_antiguas == 1 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_cambiar_restauraciones_antiguas_si"><?=$this->lang->line('odon_si')?></label>
                
                <input type="radio"
                       id="odon_cambiar_restauraciones_antiguas_no"
                       name="odon_cambiar_restauraciones_antiguas"
                       value="0"
                        <?=( !isset ( $odon_cambiar_restauraciones_antiguas ) || ( $odon_cambiar_restauraciones_antiguas == 0 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_cambiar_restauraciones_antiguas_no"><?=$this->lang->line('odon_no')?></label>
            </td>
        </tr>

        <!-- Intención de realizar ortodoncia -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_realizar_ortodoncia')?></td>
            <td align="left">
                <input type="radio"
                       id="odon_realizar_ortodoncia_si"
                       name="odon_realizar_ortodoncia"
                       value="1"
                       <?=( isset ( $odon_realizar_ortodoncia ) && ( $odon_realizar_ortodoncia == 1 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_realizar_ortodoncia_si"><?=$this->lang->line('odon_si')?></label>
                
                <input type="radio"
                       id="odon_realizar_ortodoncia_no"
                       name="odon_realizar_ortodoncia"
                       value="0"
                        <?=( !isset ( $odon_realizar_ortodoncia ) || ( $odon_realizar_ortodoncia == 0 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_realizar_ortodoncia_no"><?=$this->lang->line('odon_no')?></label>
            </td>
        </tr>

        <!-- Intención de realizar limpieza -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_blanqueamento_dental')?></td>
            <td align="left">
                <input type="radio"
                       id="odon_blanqueamento_dental_si"
                       name="odon_blanqueamento_dental"
                       value="1"
                       <?=( isset ( $odon_blanqueamento_dental ) && ( $odon_blanqueamento_dental == 1 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_blanqueamento_dental_si"><?=$this->lang->line('odon_si')?></label>
                
                <input type="radio"
                       id="odon_blanqueamento_dental_no"
                       name="odon_blanqueamento_dental"
                       value="0"
                        <?=( !isset ( $odon_blanqueamento_dental ) || ( $odon_blanqueamento_dental == 0 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_blanqueamento_dental_no"><?=$this->lang->line('odon_no')?></label>
            </td>
        </tr>

        <!-- Tiene prótesis? -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_tiene_dentadura_postiza')?></td>
            <td align="left">
                <input type="radio"
                       id="odon_tiene_dentadura_postiza_si"
                       name="odon_tiene_dentadura_postiza"
                       value="1"
                       <?=( isset ( $odon_tiene_dentadura_postiza ) && ( $odon_tiene_dentadura_postiza == 1 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_tiene_dentadura_postiza_si"><?=$this->lang->line('odon_si')?></label>
                
                <input type="radio"
                       id="odon_tiene_dentadura_postiza_no"
                       name="odon_tiene_dentadura_postiza"
                       value="0"
                        <?=( !isset ( $odon_tiene_dentadura_postiza ) || ( $odon_tiene_dentadura_postiza == 0 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_tiene_dentadura_postiza_no"><?=$this->lang->line('odon_no')?></label>

                <!-- Tiene intención de cambiarlas? -->
                <div id="odon_intencion_cambiar_protesis" <?=( isset ( $odon_tiene_dentadura_postiza ) && ( $odon_tiene_dentadura_postiza == 1 ) ) ? '' : 'style="display: none;"'?> >
                    <br/>
                    <br/><?=$this->lang->line('odon_intencion_cambiar_protesis')?><br/>
                    <input type="radio"
                           id="odon_intencion_cambiar_protesis_si"
                           name="odon_intencion_cambiar_protesis"
                           value="1"
                           <?=( isset ( $odon_intencion_cambiar_protesis ) && ( $odon_intencion_cambiar_protesis == 1 ) ) ? 'checked="checked"' : ''?>
                    />
                    <label for="odon_intencion_cambiar_protesis_si"><?=$this->lang->line('odon_si')?></label>

                    <input type="radio"
                           id="odon_intencion_cambiar_protesis_no"
                           name="odon_intencion_cambiar_protesis"
                           value="0"
                            <?=( !isset ( $odon_intencion_cambiar_protesis ) || ( $odon_intencion_cambiar_protesis == 0 ) ) ? 'checked="checked"' : ''?>
                    />
                    <label for="odon_intencion_cambiar_protesis_no"><?=$this->lang->line('odon_no')?></label>
                    <br/>
                </div>

            </td>
        </tr>

    </tbody>
</table>

<?php } 

if( $modo == FormularioXML::$MODO_PDF ) {

    // Siente dolor
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_siente_dolor' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $x = $pdf->GetX(); // para posicionar "Consigue identificar donde?"
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $odon_siente_dolor ) && ( $odon_siente_dolor == 1 ) ) ?
                                                $this->lang->line('odon_si') : $this->lang->line('odon_no') ), 0, 1, 'L' );

    // Consigue identificar donde?
    if( ( isset( $odon_siente_dolor ) && ( $odon_siente_dolor == 1 ) ) ) {

        $pdf->SetX( $x );
        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_identificar_donde' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
        $pdf->SetX( $x );
        $pdf->SetFont( 'Arial', '' );
        $pdf->MultiCell( 0, 6, html_entity_decode( ( isset( $odon_siente_dolor_donde ) && !empty( $odon_siente_dolor_donde ) ) ? utf8_decode( $odon_siente_dolor_donde ) : '-' ) , 0, 'L' );
    }

    // Esteticamente, que incomada
    $y = $pdf->GetY();
    $pdf->MultiCell( 60, 6, html_entity_decode( $this->lang->line( 'odon_esteticamente_incomoda' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 'R' );
    $pdf->SetY( $y );
    $pdf->SetX( 70 );
    $pdf->MultiCell( 0, 6, html_entity_decode( ( isset( $odon_esteticamente_incomoda ) && !empty( $odon_esteticamente_incomoda ) ) ? utf8_decode( $odon_esteticamente_incomoda ) : ''  ) , 0, 'L' );

    // Intención de cambiar restauraciones antiguas
    $y = $pdf->GetY();
    $pdf->MultiCell( 60, 6, html_entity_decode( $this->lang->line( 'odon_cambiar_restauraciones_antiguas' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 'R' );
    $y2 = $pdf->GetY();
    $pdf->SetY( $y );
    $pdf->SetX( 70 );
    $pdf->Cell( 0, 6, html_entity_decode( ( isset( $odon_cambiar_restauraciones_antiguas ) && ( $odon_cambiar_restauraciones_antiguas == 1 ) ) ?
                                                $this->lang->line('odon_si') : $this->lang->line('odon_no') ), 0, 1, 'L' );
    $pdf->SetY( $y2 );


    // Intención de realizar ortodoncia
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_realizar_ortodoncia' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $odon_realizar_ortodoncia ) && ( $odon_realizar_ortodoncia == 1 ) ) ?
                                                $this->lang->line('odon_si') : $this->lang->line('odon_no') ), 0, 1, 'L' );

    // Intención de realizar limpieza
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_blanqueamento_dental' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $odon_blanqueamento_dental ) && ( $odon_blanqueamento_dental == 1 ) ) ?
                                                $this->lang->line('odon_si') : $this->lang->line('odon_no') ), 0, 1, 'L' );

    // Tiene prótesis?
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_tiene_dentadura_postiza' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $x = $pdf->GetX(); // para posicionar "Tiene intención de cambiarlas?"
    $pdf->Cell( 10, 6, html_entity_decode( ( isset( $odon_tiene_dentadura_postiza ) && ( $odon_tiene_dentadura_postiza == 1 ) ) ?
                                                $this->lang->line('odon_si') : $this->lang->line('odon_no') ), 0, 1, 'L' );

    // Tiene intención de cambiarlas?
    if( isset( $odon_tiene_dentadura_postiza ) && ( $odon_tiene_dentadura_postiza == 1 ) ) {

        $pdf->SetX( $x );
        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'odon_intencion_cambiar_protesis' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->Cell( 0, 6, html_entity_decode( ( isset( $odon_intencion_cambiar_protesis ) && ( $odon_intencion_cambiar_protesis == 1 ) ) ?
                                                    $this->lang->line('odon_si') : $this->lang->line('odon_no') ), 0, 1, 'L' );
    }
}
