<?php
if( $modo == FormularioXML::$MODO_LECTURA ) { ?>

<!-- 1: Motivo de consulta del paciente -->
<div>
    <span style="font-weight: bold;"><?= $this->lang->line('tc_motivo_paciente') ?></span>
    <br />
    <?php echo isset( $tc_motivo_paciente ) ? nl2br( $tc_motivo_paciente ) : NULL; ?>
</div>
<br/>

<!-- 2: Enfermedad actual -->
<div>
    <span style="font-weight: bold;"><?= $this->lang->line('tc_enfermedad_actual') ?></span>
    <br />
    <?php echo isset( $tc_enfermedad_actual ) ? nl2br( $tc_enfermedad_actual ) : NULL; ?>
</div>
<br/>

<?php
}

if( $modo == FormularioXML::$MODO_ESCRITURA) { ?>
<br/>
<!-- 1: Motivo de consulta del paciente -->
<div>
    <span style="font-weight: bold;"><?= $this->lang->line('tc_motivo_paciente') ?></span>
    <textarea name="tc_motivo_paciente" id="tc_motivo_paciente" style="width: 100%;"><?php echo isset( $tc_motivo_paciente ) ? nl2br( $tc_motivo_paciente ) : NULL; ?></textarea>
</div>
<br/>

<!-- 2: Enfermedad actual -->
<div>
    <span style="font-weight: bold;"><?= $this->lang->line('tc_enfermedad_actual') ?></span>
    <textarea name="tc_enfermedad_actual" id="tc_enfermedad_actual" style="width: 100%;"><?php echo isset( $tc_enfermedad_actual ) ? nl2br( $tc_enfermedad_actual ) : NULL; ?></textarea>
</div>
<br/>

<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    $x = 60;

    // Motivo de paciente
    $pdf->SetFont( 'Arial', 'B' );
    $pdf->MultiCell( 0, 6, html_entity_decode( $this->lang->line( 'tc_motivo_paciente' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 'L', false, 0 );
    $pdf->SetX( $x );

    $pdf->SetFont( 'Arial' );
    $pdf->MultiCell( 0, 6, utf8_decode( $tc_motivo_paciente ), 0, 'L', false, 0 );
    $pdf->Ln();
    $pdf->SetX( $x );

    // Enfermedad actual
    $pdf->SetFont( 'Arial', 'B' );
    $pdf->MultiCell( 0, 6, html_entity_decode( $this->lang->line( 'tc_enfermedad_actual' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 'L', false, 0 );
    $pdf->SetX( $x );

    $pdf->SetFont( 'Arial' );
    $pdf->MultiCell( 0, 6, utf8_decode( $tc_enfermedad_actual ), 0, 'L', false, 0 );
    $pdf->Ln();
    $pdf->SetX( $x );
}

