<?php

if( $modo == FormularioXML::$MODO_LECTURA ) { ?>

<table cellspacing="0" cellpadding="0" border="0" align="center" >
    <tbody>

        <!-- Habitos alimenticios -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_ingesta_azucar')?></td>
            <td align="left">
                <?php
                if( isset( $odon_ingesta_azucar ) && !empty( $odon_ingesta_azucar ) ) {
                    foreach( $odon_ingesta_azucar as $valor ) { ?>
                    <?='- '.$this->lang->line( $valor )?><br/>
                <?php }
                } else echo ' - ';?>
            </td>
        </tr>

        <!-- Frecuencia -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_frequencia')?>:</td>
            <td align="left">
                <?php if( isset( $odon_frequencia ) && !empty( $odon_frequencia ) ) {
                            switch( $odon_frequencia ) {
                                case 'odon_frequencia_diario' : echo $this->lang->line('odon_diario'); break;
                                case 'odon_frequencia_varias' : echo $this->lang->line('odon_varias_veces_dia'); break;
                                case 'odon_frequencia_eventual' : echo $this->lang->line('odon_eventual'); break;
                                case 'odon_frequencia_nunca' : echo $this->lang->line('odon_nunca'); break;
                                default : ' - '; break;
                            }
                        }  else echo ' - ';?>
            </td>
        </tr>

    </tbody>
</table>
<?php } 

if( $modo == FormularioXML::$MODO_ESCRITURA) { ?>

<table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
    <tbody>

        <!-- Habitos alimenticios -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_ingesta_azucar')?></td>
            <td align="left">
                <table>
                    <tr>
                        <td><input type="checkbox" name="odon_ingesta_azucar[]" value="odon_caramelos" <?= ( isset( $odon_ingesta_azucar ) && in_array( 'odon_caramelos', $odon_ingesta_azucar ) ) ? 'checked="checked"' : '' ?> />&nbsp;<?=$this->lang->line( 'odon_caramelos' )?></td>
                        <td><input type="checkbox" name="odon_ingesta_azucar[]" value="odon_miel" <?= ( isset( $odon_ingesta_azucar ) && in_array( 'odon_miel', $odon_ingesta_azucar ) ) ? 'checked="checked"' : '' ?> />&nbsp;<?=$this->lang->line( 'odon_miel' )?></td>
                    </tr>
                    <tr>
                        <td><input type="checkbox" name="odon_ingesta_azucar[]" value="odon_chicles" <?= ( isset( $odon_ingesta_azucar ) && in_array( 'odon_chicles', $odon_ingesta_azucar ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_chicles' )?></td>
                        <td><input type="checkbox" name="odon_ingesta_azucar[]" value="odon_balas" <?= ( isset( $odon_ingesta_azucar ) && in_array( 'odon_balas', $odon_ingesta_azucar ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_balas' )?></td>
                    </tr>
                    <tr>
                        <td><input type="checkbox" name="odon_ingesta_azucar[]" value="odon_refrescos" <?= ( isset( $odon_ingesta_azucar ) && in_array( 'odon_refrescos', $odon_ingesta_azucar ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_refrescos' )?></td>
                        <td><input type="checkbox" name="odon_ingesta_azucar[]" value="odon_frutas" <?= ( isset( $odon_ingesta_azucar ) && in_array( 'odon_frutas', $odon_ingesta_azucar ) ) ? 'checked="checked"' : '' ?>/>&nbsp;<?=$this->lang->line( 'odon_frutas' )?></td>
                    </tr>
                </table>
            </td>
        </tr>

        <!-- Frecuencia -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_frequencia')?>:</td>
            <td align="left">
                <input type="radio" name="odon_frequencia" id="odon_frequencia_diario" value="odon_frequencia_diario"
                    <?=( isset ( $odon_frequencia ) && strcmp( 'odon_frequencia_diario', $odon_frequencia ) == 0 ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_frequencia_diario"> <?=$this->lang->line('odon_diario')?> </label>
                <br/>
                <input type="radio" name="odon_frequencia" id="odon_frequencia_varias" value="odon_frequencia_varias"
                    <?=( isset ( $odon_frequencia ) && strcmp( 'odon_frequencia_varias', $odon_frequencia ) == 0 ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_frequencia_varias"> <?=$this->lang->line('odon_varias_veces_dia')?> </label>
                <br/>
                <input type="radio" name="odon_frequencia" id="odon_frequencia_eventual" value="odon_frequencia_eventual"
                    <?=( isset ( $odon_frequencia ) && strcmp( 'odon_frequencia_eventual', $odon_frequencia ) == 0 ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_frequencia_eventual"> <?=$this->lang->line('odon_eventual')?> </label>
                <br/>
                <input type="radio" name="odon_frequencia" id="odon_frequencia_nunca" value="odon_frequencia_nunca"
                    <?=( isset ( $odon_frequencia ) && strcmp( 'odon_frequencia_nunca', $odon_frequencia ) == 0 ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_frequencia_nuca"> <?=$this->lang->line('odon_nunca')?> </label>
                <br/>
            </td>
        </tr>

    </tbody>
</table>

<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    // Habitos alimenticios
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_ingesta_azucar' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $x = $pdf->GetX(); // para posicionar los sintomas

    if( isset( $odon_ingesta_azucar ) && !empty( $odon_ingesta_azucar ) ) {
        foreach( $odon_ingesta_azucar as $valor ) {
            $pdf->SetX( $x );
            $pdf->Cell( 0, 6, html_entity_decode( '- '.$this->lang->line( $valor ) ), 0, 1, 'L' );
        }
    } else {
        $pdf->Cell( 0, 6, html_entity_decode( ' - ' ), 0, 1, 'L' );
    }

    // Frecuencia
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_frequencia' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    if( isset( $odon_frequencia ) ) {
        if( !empty( $odon_frequencia ) ) {
            switch( $odon_frequencia ) {
                case 'odon_frequencia_diario'       : $pdf->Cell( 10, 6, html_entity_decode( $this->lang->line( 'odon_diario' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' ); break;
                case 'odon_frequencia_varias'    : $pdf->Cell( 10, 6, html_entity_decode( $this->lang->line( 'odon_varias_veces_dia' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' ); break;
                case 'odon_frequencia_eventual'  : $pdf->Cell( 10, 6, html_entity_decode( $this->lang->line( 'odon_eventual' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' ); break;
                case 'odon_frequencia_nunca'  : $pdf->Cell( 10, 6, html_entity_decode( $this->lang->line( 'odon_nunca' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' ); break;
                default : $pdf->Cell( 10, 6, html_entity_decode( ' - ' ), 0, 1, 'L' ); break;
            }
        }
    } else $pdf->Cell( 10, 6, html_entity_decode( ' - ' ), 0, 1, 'L' );

} 

