<?php
if( $modo == FormularioXML::$MODO_LECTURA ) { ?>

    <table id="odon_historico_familiar_seleccionados" align="center" style="width: 50%; text-align: center;">
        <?php if( isset( $odon_historico_familiar ) && !empty( $odon_historico_familiar ) ) {
            foreach( $odon_historico_familiar as $clave => $valor ) {
                $a = explode( '|', $valor );
        ?>
            <tr>
                <td><?=$this->lang->line( (string) $a[0] )?></td>
                <td><?=$this->lang->line( $a[1] )?></td>
            </tr>
        <?php }
        }
        ?>
    </table>
<?php }

if( $modo == FormularioXML::$MODO_ESCRITURA) { ?>

<script language="javascript" type="text/javascript">

    $(document).ready( function( ) {

        $('#odon_historico_familiar_agregar').click( function() {

            pariente    = $('#odon_historico_familiar_pariente').val();
            enfermedad  = $('#odon_historico_familiar_enfermedad').val();
            
            if( pariente != '' && enfermedad != '' ) {
                
                // Inserta texto en tabla
                html = "<tr style=\"display: none;\"><td>"+$('#odon_historico_familiar_pariente option:selected').html()+'</td> <td>'+$('#odon_historico_familiar_enfermedad option:selected').html()+"</td><td><a href=\"#\" ><img src=\"<?=base_url()?>images/trash.gif\" /><input type=\"hidden\" name=\"odon_historico_familiar[]\" value=\""+pariente+'|'+enfermedad+"\" /></a></td></tr>";
                $('#odon_historico_familiar_seleccionados').append(html);
                $('#odon_historico_familiar_seleccionados a').bind( 'click', odon_historico_familiar_eliminar );
                $('#odon_historico_familiar_seleccionados tr:last').fadeIn('slow');

                // Reestablece campos a valor vacío
                $('#odon_historico_familiar_pariente').val('');
                $('#odon_historico_familiar_enfermedad').val('');
            }
        } );

    } );

    function odon_historico_familiar_eliminar ( ) {

        $(this).parent().parent().remove();
        return false;
    }
</script>

<table width="50%" cellspacing="0" cellpadding="0" border="0" align="center" style="text-align: center;" >
    <tbody>

        <!-- Historico familiar -->
        <tr>
            <td>
                <select id="odon_historico_familiar_pariente">
                    <option value=""></option>
                    <option value="odon_padre"><?=$this->lang->line('odon_padre')?></option>
                    <option value="odon_madre"><?=$this->lang->line('odon_madre')?></option>
                    <option value="odon_hermanos"><?=$this->lang->line('odon_hermanos')?></option>
                    <option value="odon_abuelos_maternos"><?=$this->lang->line('odon_abuelos_maternos')?></option>
                    <option value="odon_abuelos_paternos"><?=$this->lang->line('odon_abuelos_paternos')?></option>
                    <option value="odon_hijos"><?=$this->lang->line('odon_hijos')?></option>
                </select>
            </td>
            <td>
                <select id="odon_historico_familiar_enfermedad">
                    <option value=""></option>
                    <option value="odon_buena_salud"><?=$this->lang->line('odon_buena_salud')?></option>
                    <option value="odon_diabetes"><?=$this->lang->line('odon_diabetes')?></option>
                    <option value="odon_enfermedades_cardiovasculares"><?=$this->lang->line('odon_enfermedades_cardiovasculares')?></option>
                    <option value="odon_enfermedades_reumaticas"><?=$this->lang->line('odon_enfermedades_reumaticas')?></option>
                    <option value="odon_enfermedades_hemorragicas"><?=$this->lang->line('odon_enfermedades_hemorragicas')?></option>
                    <option value="odon_enfermedades_alergicas"><?=$this->lang->line('odon_enfermedades_alergicas')?></option>
                    <option value="odon_neoplasias"><?=$this->lang->line('odon_neoplasias')?></option>
                </select>
                &nbsp; &nbsp;
                <img src="<?=base_url()?>images/crear.png" id="odon_historico_familiar_agregar" width="16px" height="16px" />
            </td>
        </tr>

    </tbody>
</table>

<table id="odon_historico_familiar_seleccionados" align="center" style="width: 50%; text-align: center;">
    <?php if( isset( $odon_historico_familiar ) && !empty( $odon_historico_familiar ) ) {
        foreach( $odon_historico_familiar as $clave => $valor ) {
            $a = explode( '|', $valor );
    ?>
        <tr>
            <td><?=$this->lang->line( (string) $a[0] )?></td>
            <td><?=$this->lang->line( $a[1] )?></td>
            <td>
                <a href="#" >
                    <img src="<?=base_url()?>images/trash.gif" />
                    <input type="hidden" name="odon_historico_familiar[]" value="<?=$a[0]."|".$a[1]?>" />
                </a>
            </td>
        </tr>
    <?php }
    }
    ?>
</table>
<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    if( isset( $odon_historico_familiar ) && !empty( $odon_historico_familiar ) ) {

        // Antecedentes historicos familiares
        foreach( $odon_historico_familiar as $clave => $valor ) {

            $a = explode( '|', $valor );
            $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( $a[0] ) ).': ', 0, 0, 'R' );
            $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( $a[1] ) ), 0, 1, 'L' );
        }
    }
}
