<?php

if( $modo == FormularioXML::$MODO_LECTURA ) { ?>

<table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
    <tbody>

        <!-- Esta embarazada? -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_esta_embarazada')?>:</td>
            <td align="left">
                <?=( isset ( $odon_esta_embarazada ) && ( $odon_esta_embarazada == 1 ) ) ?
                        $this->lang->line('odon_si') :  $this->lang->line('odon_no') ?>

                <?php if( isset ( $odon_esta_embarazada ) && ( $odon_esta_embarazada == 1 ) ) { ?>
                    <br/>
                    <span style="font-weight: bold;"><?=$this->lang->line('odon_cuantos_meses')?></span>
                    <br/><?=isset( $odon_cuantos_meses ) ? $odon_cuantos_meses : ''?>
                <?php } ?>
            </td>
        </tr>

        <!-- Está amamantanto? -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_esta_amamantando')?>:</td>
            <td align="left">
                <?=( isset ( $odon_esta_amamantando ) && ( $odon_esta_amamantando == 1 ) ) ?
                        $this->lang->line('odon_si') :  $this->lang->line('odon_no') ?>
            </td>
        </tr>

        <!-- Está tomando anticoncepcional? -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_tomando_anticonceptivos')?>:</td>
            <td align="left">
                <?=( isset ( $odon_tomando_anticonceptivos ) && ( $odon_tomando_anticonceptivos == 1 ) ) ?
                        $this->lang->line('odon_si') :  $this->lang->line('odon_no') ?>
            </td>
        </tr>

        <!-- Está en menopausa? -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_en_menopausa')?>:</td>
            <td align="left">
                <?=( isset ( $odon_en_menopausa ) && ( $odon_en_menopausa == 1 ) ) ?
                        $this->lang->line('odon_si') :  $this->lang->line('odon_no') ?>
            </td>
        </tr>

    </tbody>
</table>

<?php } 

if( $modo == FormularioXML::$MODO_ESCRITURA) { ?>

<script language="javascript" type="text/javascript">
    
    $(document).ready( function( ) {

        // Activa campo "cuantos meses"
        $('#odon_esta_embarazada_si').click( function() {

            $('#odon_cuantos_meses').slideDown( );
            $('#odon_cuantos_meses').fadeIn( );
        } );

        // Desactiva campo "cuantos meses"
        $('#odon_esta_embarazada_no').click( function() {

            $('#odon_cuantos_meses').slideUp( );
            $('#odon_cuantos_meses').fadeOut( );
            $('#odon_cuantos_meses input').val('');
        } );

    } );
</script>

<table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
    <tbody>

        <!-- Esta embarazada? -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_esta_embarazada')?>:</td>
            <td align="left">
                <input type="radio"
                       id="odon_esta_embarazada_si"
                       name="odon_esta_embarazada"
                       value="1"
                       <?=( isset ( $odon_esta_embarazada ) && ( $odon_esta_embarazada == 1 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_esta_embarazada_si"><?=$this->lang->line('odon_si')?></label>
                
                <input type="radio"
                       id="odon_esta_embarazada_no"
                       name="odon_esta_embarazada"
                       value="0"
                        <?=( !isset ( $odon_esta_embarazada ) || ( $odon_esta_embarazada == 0 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_esta_embarazada_no"><?=$this->lang->line('odon_no')?></label>

                <div id="odon_cuantos_meses" <?=( isset ( $odon_esta_embarazada ) && ( $odon_esta_embarazada == 1 ) ) ? '' : 'style="display: none;"'?> >
                    <?=$this->lang->line('odon_cuantos_meses')?>
                    <input type="text"
                           name="odon_cuantos_meses"
                           value="<?=(      isset( $odon_esta_embarazada ) && ( $odon_esta_embarazada == 1 )
                                        &&  isset( $odon_cuantos_meses ) && !empty( $odon_cuantos_meses ) ) ? $odon_cuantos_meses : ''?>"
                    />
                </div>
            </td>
        </tr>

        <!-- Está amamantanto? -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_esta_amamantando')?>:</td>
            <td align="left">
                <input type="radio"
                       id="odon_esta_amamantando_si"
                       name="odon_esta_amamantando"
                       value="1"
                       <?=( isset ( $odon_esta_amamantando ) && ( $odon_esta_amamantando == 1 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_esta_amamantando_si"><?=$this->lang->line('odon_si')?></label>
                
                <input type="radio"
                       id="odon_esta_amamantando_no"
                       name="odon_esta_amamantando"
                       value="0"
                        <?=( !isset ( $odon_esta_amamantando ) || ( $odon_esta_amamantando == 0 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_esta_amamantando_no"><?=$this->lang->line('odon_no')?></label>
            </td>
        </tr>

        <!-- Está tomando anticoncepcional? -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_tomando_anticonceptivos')?>:</td>
            <td align="left">
                <input type="radio"
                       id="odon_tomando_anticonceptivos_si"
                       name="odon_tomando_anticonceptivos"
                       value="1"
                       <?=( isset ( $odon_tomando_anticonceptivos ) && ( $odon_tomando_anticonceptivos == 1 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_tomando_anticonceptivos_si"><?=$this->lang->line('odon_si')?></label>
                
                <input type="radio"
                       id="odon_tomando_anticonceptivos_no"
                       name="odon_tomando_anticonceptivos"
                       value="0"
                        <?=( !isset ( $odon_tomando_anticonceptivos ) || ( $odon_tomando_anticonceptivos == 0 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_tomando_anticonceptivos_no"><?=$this->lang->line('odon_no')?></label>
            </td>
        </tr>

        <!-- Está en menopausa? -->
        <tr>
            <td class="data_form"><?=$this->lang->line('odon_en_menopausa')?>:</td>
            <td align="left">
                <input type="radio"
                       id="odon_en_menopausa_si"
                       name="odon_en_menopausa"
                       value="1"
                       <?=( isset ( $odon_en_menopausa ) && ( $odon_en_menopausa == 1 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_en_menopausa_si"><?=$this->lang->line('odon_si')?></label>
                
                <input type="radio"
                       id="odon_en_menopausa_no"
                       name="odon_en_menopausa"
                       value="0"
                        <?=( !isset ( $odon_en_menopausa ) || ( $odon_en_menopausa == 0 ) ) ? 'checked="checked"' : ''?>
                />
                <label for="odon_en_menopausa_no"><?=$this->lang->line('odon_no')?></label>
            </td>
        </tr>

    </tbody>
</table>

<?php } 

if( $modo == FormularioXML::$MODO_PDF ) {

    // Esta embarazada?
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_esta_embarazada' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $x = $pdf->GetX(); // para posicionar "Esta embarazada? cuanto tiempo"
    $pdf->Cell( 10, 6, html_entity_decode( ( ( isset( $odon_esta_embarazada ) && !empty( $odon_esta_embarazada ) ) ?
                                                        $this->lang->line('odon_si') : $this->lang->line('odon_no') ) ), 0, 1, 'L' );

    // Esta embarazada? cuanto tiempo
    if( isset ( $odon_esta_embarazada ) && ( $odon_esta_embarazada == 1 ) ) {

        $pdf->SetX( $x );
        $pdf->SetFont( 'Arial', 'I' );
        $pdf->Cell( 40, 6, html_entity_decode( $this->lang->line( 'odon_cuantos_meses' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'L' );
        $pdf->SetFont( 'Arial', '' );
        $pdf->Cell( 0, 6, html_entity_decode( ( isset( $odon_cuantos_meses ) && !empty( $odon_cuantos_meses ) ) ?
                                                utf8_decode( $odon_cuantos_meses ) : ' - ' ), 0, 1, 'L' );

    }

    // Está amamantanto?
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_esta_amamantando' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 10, 6, html_entity_decode( ( ( isset( $odon_esta_amamantando ) && !empty( $odon_esta_amamantando ) ) ?
                                                        $this->lang->line('odon_si') : $this->lang->line('odon_no') ) ), 0, 1, 'L' );

    // Está tomando anticoncepcional?
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_tomando_anticonceptivos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 10, 6, html_entity_decode( ( ( isset( $odon_tomando_anticonceptivos ) && !empty( $odon_tomando_anticonceptivos ) ) ?
                                                        $this->lang->line('odon_si') : $this->lang->line('odon_no') ) ), 0, 1, 'L' );

    // Está en menopausa?
    $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'odon_en_menopausa' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 10, 6, html_entity_decode( ( ( isset( $odon_en_menopausa ) && !empty( $odon_en_menopausa ) ) ?
                                                        $this->lang->line('odon_si') : $this->lang->line('odon_no') ) ), 0, 1, 'L' );

}