<?php
if( $modo == FormularioXML::$MODO_LECTURA ) { ?>

    <table cellspacing="0" cellpadding="0" border="0" align="center" >
        <tbody>

            <!-- Producto de -->
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_producto_de')?>:</td>
                <td align="left">
                    <?=( isset( $pediatria_producto_de ) && !empty( $pediatria_producto_de ) ) ? $pediatria_producto_de : ' - ' ?>
                    &nbsp;<span style="font-style: italic;"><?=$this->lang->line('pediatria_numero_embarazos')?></span>
                </td>
            </tr>

            <!-- Madre de -->
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_madre_de')?>:</td>
                <td align="left">
                    <?=( isset( $pediatria_madre_de ) && !empty( $pediatria_madre_de ) ) ? $pediatria_madre_de : ' - ' ?>
                    &nbsp;<span style="font-style: italic;"><?=$this->lang->line('pediatria_n_anos')?></span>
                </td>
            </tr>

            <!-- Control prenatal -->
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_control_prenatal')?>:</td>
                <td align="left">
                    <?=( isset( $pediatria_control_prenatal ) && $pediatria_control_prenatal == 1 ) ?
                            $this->lang->line('pediatria_si') : 
                            $this->lang->line('pediatria_no') ?>
                    <br/>
                    <?php if( isset( $pediatria_cantidad_controles ) && !empty( $pediatria_cantidad_controles ) ) { ?>
                    <div id="pediatria_cantidad_controles"  >
                        <span style="font-style: italic;"> <?=$this->lang->line('pediatria_cantidad_controles')?> </span>:
                        <?=$pediatria_cantidad_controles?>
                    </div>
                    <?php }?>
                </td>
            </tr>

            <!-- Perfil infeccioso -->
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_perfil_infeccioso')?>:</td>
                <td align="left">

                    <br/>
                    <?=( isset( $pediatria_perfil_infeccioso ) && $pediatria_perfil_infeccioso == 1 ) ?
                            $this->lang->line('pediatria_si') : $this->lang->line('pediatria_no') ?>
                    <br/> <br/>
                    <?php if( isset( $pediatria_perfil_infeccioso_descripcion ) && !empty( $pediatria_perfil_infeccioso_descripcion ) ) { ?>
                        <?=$pediatria_perfil_infeccioso_descripcion?>
                    <?php }?>
                </td>
            </tr>

            <!-- Nacido por (parto normal/cesarea) -->
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_nacido_por')?>:</td>
                <td align="left">

                    <?=( isset( $pediatria_nacido_por ) && $pediatria_nacido_por == 1 ) ?
                            $this->lang->line('pediatria_parto_normal') : 
                            $this->lang->line('pediatria_cesarea') ?>

                    <?php if( isset( $pediatria_semanas_gestacion ) && !empty( $pediatria_semanas_gestacion ) ) { ?>
                        <?=$this->lang->line('pediatria_a_las')?>
                        <?=$pediatria_semanas_gestacion?>
                        <?=$this->lang->line('pediatria_semanas_gestacion')?>
                    <?php }?>
                </td>
            </tr>

            <!-- Adaptación neonatal -->
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_adaptacion_neonatal')?>:</td>
                <td align="left">

                    <?=( isset( $pediatria_adaptacion_neonatal ) && $pediatria_adaptacion_neonatal == 1 ) ?
                            $this->lang->line('pediatria_buena') : 
                            $this->lang->line('pediatria_mala') ?>
                </td>
            </tr>

            <!-- Requirió UCIN -->
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_requirio_ucin')?>:</td>
                <td align="left">
                    <?=( isset( $pediatria_requirio_ucin ) && !empty( $pediatria_requirio_ucin ) ) ? $pediatria_requirio_ucin : '' ?>

                </td>
            </tr>

            <!-- Peso al nacer -->
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_peso_al_nacer')?>:</td>
                <td align="left">
                    <?=( isset( $pediatria_peso_al_nacer ) && !empty( $pediatria_peso_al_nacer ) ) ? $pediatria_peso_al_nacer : '' ?>
                    &nbsp;<?=$this->lang->line('pediatria_kg')?>
                </td>
            </tr>

            <!-- Talla al nacer -->
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_talla_al_nacer')?>:</td>
                <td align="left">
                    <?=( isset( $pediatria_talla_al_nacer ) && !empty( $pediatria_talla_al_nacer ) ) ? $pediatria_talla_al_nacer : '' ?>
                    &nbsp;<?=$this->lang->line('pediatria_cm')?>
                </td>
            </tr>

        </tbody>
    </table>
<?php } 

if( $modo == FormularioXML::$MODO_ESCRITURA) { ?>

<script language="javascript" type="text/javascript">
    
    $(document).ready( function( ) {

        // Activa campo del item "cantidad de controles"
        $('#pediatria_control_prenatal_si').click( function( ) {

            $('#pediatria_cantidad_controles').slideDown( );
            $('#pediatria_cantidad_controles').fadeIn( );
        } );

        // Desactiva campo del item "cantidad_controles"
        $('#pediatria_control_prenatal_no').click( function( ) {

            $('#pediatria_cantidad_controles').slideUp( );
            $('#pediatria_cantidad_controles').fadeOut( );
            $('#pediatria_cantidad_controles input').val( '' );
        } );

        // Activa campo del item "perfil infeccioso"
        $('#pediatria_perfil_infeccioso_si').click( function( ) {

            $('#pediatria_perfil_infeccioso').slideDown( );
            $('#pediatria_perfil_infeccioso').fadeIn( );
        } );

        // Desactiva campo del item "perfil infeccioso"
        $('#pediatria_perfil_infeccioso_no').click( function( ) {

            $('#pediatria_perfil_infeccioso').slideUp( );
            $('#pediatria_perfil_infeccioso').fadeOut( );
            $('#pediatria_perfil_infeccioso textarea').val( '' );
        } );
    } );
</script>

<table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
    <tbody>

        <!-- Producto de -->
        <tr>
            <td class="data_form"><?=$this->lang->line('pediatria_producto_de')?>:</td>
            <td align="left">
                <input type="text" name="pediatria_producto_de" value="<?=(isset($pediatria_producto_de) && !empty($pediatria_producto_de) )? $pediatria_producto_de : ''?>" />
                &nbsp;<span style="font-style: italic;"><?=$this->lang->line('pediatria_numero_embarazos')?></span>
            </td>
        </tr>

        <!-- Madre de -->
        <tr>
            <td class="data_form"><?=$this->lang->line('pediatria_madre_de')?>:</td>
            <td align="left">
                <input type="text" name="pediatria_madre_de" value="<?=(isset($pediatria_madre_de) && !empty($pediatria_madre_de) )? $pediatria_madre_de : ''?>" />
                &nbsp;<span style="font-style: italic;"><?=$this->lang->line('pediatria_n_anos')?></span>
            </td>
        </tr>

        <!-- Control prenatal -->
        <tr>
            <td class="data_form"><?=$this->lang->line('pediatria_control_prenatal')?>:</td>
            <td align="left">
                <input type="radio"
                       name="pediatria_control_prenatal"
                       id="pediatria_control_prenatal_si" value="1"
                        <?=( isset( $pediatria_control_prenatal ) && $pediatria_control_prenatal == 1 ) ? 'checked="checked"' : '' ?>
                />
                <label for="pediatria_control_prenatal_si"> <?=$this->lang->line('pediatria_si')?> </label>
                &nbsp;
                <input type="radio" name="pediatria_control_prenatal"
                       id="pediatria_control_prenatal_no"
                       value="0"
                        <?=( !isset( $pediatria_control_prenatal ) || $pediatria_control_prenatal == 0 ) ? 'checked="checked"' : '' ?>
                />
                <label for="pediatria_control_prenatal_no"> <?=$this->lang->line('pediatria_no')?> </label>
                
                <div id="pediatria_cantidad_controles" <?=( isset( $pediatria_control_prenatal ) && $pediatria_control_prenatal == 1 ) ? '' : 'style="display: none;"'?> >
                    <?=$this->lang->line('pediatria_cantidad_controles')?> <br/>
                    <input type="text" name="pediatria_cantidad_controles" value="<?=(isset($pediatria_cantidad_controles) && !empty($pediatria_cantidad_controles) )? $pediatria_cantidad_controles : ''?>" />
                </div>
            </td>
        </tr>

        <!-- Perfil infeccioso -->
        <tr>
            <td class="data_form"><?=$this->lang->line('pediatria_perfil_infeccioso')?>:</td>
            <td align="left">
                <input type="radio"
                       name="pediatria_perfil_infeccioso"
                       value="1"
                       id="pediatria_perfil_infeccioso_si"
                        <?=(isset( $pediatria_perfil_infeccioso ) && $pediatria_perfil_infeccioso == 1 ) ? 'checked="checked"' : '' ?>
                />
                <label for="pediatria_perfil_infeccioso_si"> <?=$this->lang->line('pediatria_si')?> </label>
                &nbsp;
                <input type="radio"
                       name="pediatria_perfil_infeccioso"
                       value="0"
                       id="pediatria_perfil_infeccioso_no"
                        <?=( !isset( $pediatria_perfil_infeccioso ) || $pediatria_perfil_infeccioso == 0 ) ? 'checked="checked"' : '' ?>
                />
                <label for="pediatria_perfil_infeccioso_no"> <?=$this->lang->line('pediatria_no')?> </label>
                
                <div id="pediatria_perfil_infeccioso" <?=( isset( $pediatria_perfil_infeccioso ) && $pediatria_perfil_infeccioso == 1 ) ? '' : 'style="display: none;"'?>>
                    <textarea name="pediatria_perfil_infeccioso_descripcion" title="<?=$this->lang->line('pediatria_perfil_infeccioso_descripcion')?>" style="width: 100%;"><?=(isset( $pediatria_perfil_infeccioso_descripcion ) && !empty( $pediatria_perfil_infeccioso_descripcion ) ) ? $pediatria_perfil_infeccioso_descripcion : ''?></textarea>
                </div>
            </td>
        </tr>

        <!-- Nacido por (parto normal/cesarea) -->
        <tr>
            <td class="data_form"><?=$this->lang->line('pediatria_nacido_por')?>:</td>
            <td align="left">
                <input type="radio"
                       name="pediatria_nacido_por"
                       id="pediatria_nacido_por_si"
                       value="1"
                        <?=(isset( $pediatria_nacido_por ) && $pediatria_nacido_por == 1 ) ? 'checked="checked"' : '' ?>
                />
                <label for="pediatria_nacido_por_si"> <?=$this->lang->line('pediatria_parto_normal')?> </label>
                &nbsp;
                <input type="radio"
                       name="pediatria_nacido_por"
                       id="pediatria_nacido_por_no"
                       value="0"
                        <?=( !isset( $pediatria_nacido_por ) || $pediatria_nacido_por == 0 ) ? 'checked="checked"' : '' ?>
                />
                <label for="pediatria_nacido_por_no"> <?=$this->lang->line('pediatria_cesarea')?> </label>

                <br/>
                <?=$this->lang->line('pediatria_a_las')?>
                <input type="text" name="pediatria_semanas_gestacion" max="3" size="3" value="<?=(isset( $pediatria_semanas_gestacion ) && !empty( $pediatria_semanas_gestacion ) ) ? $pediatria_semanas_gestacion : ''?>"/>
                <?=$this->lang->line('pediatria_semanas_gestacion')?>
            </td>
        </tr>

        <!-- Adaptación neonatal -->
        <tr>
            <td class="data_form"><?=$this->lang->line('pediatria_adaptacion_neonatal')?>:</td>
            <td align="left">
                <input type="radio"
                       name="pediatria_adaptacion_neonatal"
                       value="1"
                       id="pediatria_adaptacion_neonatal_si"
                        <?=(isset( $pediatria_adaptacion_neonatal ) && $pediatria_adaptacion_neonatal == 1 ) ? 'checked="checked"' : '' ?>
                />
                <label for="pediatria_adaptacion_neonatal_si"> <?=$this->lang->line('pediatria_buena')?> </label>
                &nbsp;
                <input type="radio"
                       name="pediatria_adaptacion_neonatal"
                       value="0"
                       id="pediatria_adaptacion_neonatal_no"
                        <?=( !isset( $pediatria_adaptacion_neonatal ) || $pediatria_adaptacion_neonatal == 0 ) ? 'checked="checked"' : '' ?>
                />
                <label for="pediatria_adaptacion_neonatal_no"> <?=$this->lang->line('pediatria_mala')?> </label>
            </td>
        </tr>

        <!-- Requirió UCIN -->
        <tr>
            <td class="data_form"><?=$this->lang->line('pediatria_requirio_ucin')?>:</td>
            <td align="left">
                <input type="text" name="pediatria_requirio_ucin" value="<?=(isset($pediatria_requirio_ucin) && !empty($pediatria_requirio_ucin) )? $pediatria_requirio_ucin : ''?>" />
            </td>
        </tr>

        <!-- Peso al nacer -->
        <tr>
            <td class="data_form"><?=$this->lang->line('pediatria_peso_al_nacer')?>:</td>
            <td align="left">
                <input type="text" name="pediatria_peso_al_nacer" value="<?=(isset($pediatria_peso_al_nacer) && !empty($pediatria_peso_al_nacer) )? $pediatria_peso_al_nacer : ''?>" />
                &nbsp;<?=$this->lang->line('pediatria_kg')?>
            </td>
        </tr>

        <!-- Talla al nacer -->
        <tr>
            <td class="data_form"><?=$this->lang->line('pediatria_talla_al_nacer')?>:</td>
            <td align="left">
                <input type="text" name="pediatria_talla_al_nacer" value="<?=(isset($pediatria_talla_al_nacer) && !empty($pediatria_talla_al_nacer) )? $pediatria_talla_al_nacer : ''?>" />
                &nbsp;<?=$this->lang->line('pediatria_cm')?>
            </td>
        </tr>

    </tbody>
</table>

<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    // Producto de
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'pediatria_producto_de' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->MultiCell( 0, 6, html_entity_decode( ( (isset($pediatria_producto_de) && !empty($pediatria_producto_de) )? $pediatria_producto_de:' - ' ). ' ('.$this->lang->line('pediatria_numero_embarazos') . ')' ), 0, 'L', false, 0 );

    // Madre de
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'pediatria_madre_de' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->MultiCell( 0, 6, html_entity_decode( ( (isset($pediatria_madre_de) && !empty($pediatria_madre_de) )? $pediatria_madre_de : ' - ' ) . ' ' . $this->lang->line( 'annos' ) . ' (' . $this->lang->line('pediatria_n_anos') . ')' ), 0, 'L', false, 0 );

    // Control prenatal
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'pediatria_control_prenatal' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->MultiCell( 0, 6, html_entity_decode( ( isset( $pediatria_control_prenatal ) && $pediatria_control_prenatal == 1 ) ?
                                                        $this->lang->line('pediatria_si') : 
                                                        $this->lang->line('pediatria_no') ), 0, 'L', false, 0 );

    if( isset( $pediatria_cantidad_controles ) && !empty( $pediatria_cantidad_controles ) ) {

        $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'pediatria_cantidad_controles' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, utf8_decode( (isset($pediatria_cantidad_controles) && !empty($pediatria_cantidad_controles) )? $pediatria_cantidad_controles:'' ), 0, 'L', false, 0 );
    }

    // Perfil infeccioso
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'pediatria_perfil_infeccioso' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $x = $pdf->GetX( );
    $pdf->Cell( 0, 6, html_entity_decode( ( isset( $pediatria_perfil_infeccioso ) && $pediatria_perfil_infeccioso == 1 ) ?
                                                        $this->lang->line('pediatria_si') : 
                                                        $this->lang->line('pediatria_no')  ), 0, 1, 'L' );

    // Perfil infeccioso descripcion
    if( isset( $pediatria_perfil_infeccioso_descripcion ) && !empty( $pediatria_perfil_infeccioso_descripcion ) ) {
        $pdf->SetX( $x );
        $pdf->MultiCell( 0, 6, utf8_decode( (isset($pediatria_perfil_infeccioso_descripcion) && !empty($pediatria_perfil_infeccioso_descripcion) )? $pediatria_perfil_infeccioso_descripcion :'' ), 0, 'L', false, 0 );
    }

    // Nacido por (parto normal/cesarea)
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'pediatria_nacido_por' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 20, 6, html_entity_decode( ( ( isset( $pediatria_nacido_por ) && $pediatria_nacido_por == 1 ) ?
                                                        $this->lang->line('pediatria_parto_normal') : 
                                                        $this->lang->line('pediatria_cesarea') ) . ' ' ), 0, 0, 'L' );
    // Nacido por (parto normal/cesarea) semanas de gestacion
    if( isset( $pediatria_semanas_gestacion ) && !empty( $pediatria_semanas_gestacion ) ) {

        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line( 'pediatria_a_las' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' . ' ' .
                                                ( (isset($pediatria_semanas_gestacion) && !empty($pediatria_semanas_gestacion) )? $pediatria_semanas_gestacion:'-' ) . ' ' .
                                                $this->lang->line( 'pediatria_semanas_gestacion' )
                    ), 0, 0, 'L' );
    }
    $pdf->Ln();

    // Adaptación neonatal
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'pediatria_adaptacion_neonatal' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 0, 6, html_entity_decode( ( isset(  $pediatria_adaptacion_neonatal ) && $pediatria_adaptacion_neonatal == 1 ) ?
                                                    $this->lang->line('pediatria_buena') : 
                                                    $this->lang->line('pediatria_mala')
                ), 0, 0, 'L' );

    // Requirió UCIN
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'pediatria_requirio_ucin' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 50, 6, html_entity_decode( ( isset( $pediatria_requirio_ucin ) && !empty( $pediatria_requirio_ucin ) ) ? $pediatria_requirio_ucin : ''  , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

    // Peso al nacer
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'pediatria_peso_al_nacer' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 50, 6, html_entity_decode( ( ( isset( $pediatria_peso_al_nacer ) && !empty( $pediatria_peso_al_nacer ) ) ? $pediatria_peso_al_nacer : ' - ' ) .
                                            ' ' . $this->lang->line('pediatria_kg') ), 0, 1, 'L' );


    // Talla al nacer
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'pediatria_talla_al_nacer' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 50, 6, html_entity_decode( ( ( isset( $pediatria_talla_al_nacer ) && !empty( $pediatria_talla_al_nacer ) ) ? $pediatria_talla_al_nacer : ' - ' ) .
                                            ' ' . $this->lang->line('pediatria_cm') ), 0, 1, 'L' );
}
