<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <title><?= $this->lang->line( "index_title" ) ?></title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

        <link rel="stylesheet" href="<?= base_url() ?>css/style.css" type="text/css" />
        <link rel="stylesheet" href="<?= base_url() ?>css/jquery-ui.css" type="text/css" />

        <style type="text/css">
            body {
                margin-left: 0px;
                margin-top: 0px;
                margin-right: 0px;
                margin-bottom: 0px;
                background-image: url('<?= base_url() ?>images/login/bg.jpg');
                background-repeat: repeat-x;
            }

            .caja_carrusel {
                text-align: left;
                border-style: solid;
                border-width: 1px;
                height: 550px;
            }
            .caja_carrusel .titulo_lesion {
                text-align: center;
                font-weight: bold;
            }

            .caja_carrusel ul {
                padding: 0;
                margin: 0;
            }

            .caja_carrusel ul ul {
                height: 526px;
            }

            .caja_carrusel .lesion_item {
                margin-top: 10px;
                text-align: center;
            }

            #carrusel_subir { cursor: pointer }
            #carrusel_bajar { cursor: pointer }
        </style>

        <script src="<?= base_url() ?>js/jquery.js" type="text/javascript"></script>
        <script src="<?= base_url() ?>js/jquery-ui.min.js" type="text/javascript"></script>
        <script src="<?= base_url() ?>js/jquery.carouFredSel.js" type="text/javascript"></script>

        <script language="javascript" type="text/javascript">

            lesiones = Array;
            <?php foreach( $lesiones as $n_lesion => $lesion ) {

                // Establece carpetas faltantes: sirve para mostrar imagen "no disponible"
                $a = array( Platc::$DERMA_DIR_FOTOS['ANATOMICA'],
                            Platc::$DERMA_DIR_FOTOS['30CM'],
                            Platc::$DERMA_DIR_FOTOS['LUZBLANCA'],
                            Platc::$DERMA_DIR_FOTOS['LUZUV'] );

                $lesion = array_merge( array_fill_keys( $a, array( ) ), $lesion );
            } ?>

            lesiones =  [   <?php foreach( $lesiones as $n_lesion => $lesion ) { ?>
                                    { n_lesion: <?=$n_lesion?>,
                                      lesion: [
                                        <?php foreach( $lesion as $nombre => $data ) { ?>
                                                { nombre: '<?=$nombre?>',
                                                    data: { archivo: <?=( isset( $data['archivo'] ) && !empty( $data['archivo'] ) ) ? json_encode( $data['archivo'] ) : '""' ?>,
                                                            observacion: <?=( isset( $data['observacion'] ) && !empty( $data['observacion'] ) ) ? json_encode( $data['observacion'] ) : '""' ?> } },
                                        <?php } ?>
                                        ]
                                    },
                            <?php } ?>
                        ];

            lesiones_lang = [   {'nombre': '<?=Platc::$DERMA_DIR_FOTOS['ANATOMICA']?>',    'texto': '<?=$this->lang->line('derma_lesiones_foto_ubicacion_anatomica')?>' },
                                {'nombre': '<?=Platc::$DERMA_DIR_FOTOS['30CM']?>',         'texto': '<?=$this->lang->line('derma_lesiones_foto_30cm_lesion')?>' },
                                {'nombre': '<?=Platc::$DERMA_DIR_FOTOS['LUZBLANCA']?>',    'texto': '<?=$this->lang->line('derma_lesiones_foto_detalle_luz_blanca')?>' },
                                {'nombre': '<?=Platc::$DERMA_DIR_FOTOS['LUZUV']?>',        'texto': '<?=$this->lang->line('derma_lesiones_foto_detalle_luz_uv')?>' } ];

            $(document).ready(function( ) {

                $('#informacion_contacto_dialog').dialog({modal: true, autoOpen: false, resizable: false});

                $('#enlace_contacto').click(function(e) {
                    e.preventDefault();
                    $('#informacion_contacto_dialog').dialog('open', true);
                });

                $("#carrusel").carouFredSel({
                    direction: "up",
                    circular: false,
                    infinite: false,
                    auto: false,
                    prev: "#carrusel_subir",
                    next: "#carrusel_bajar",
                    height: "550"
                });

                $('#carrusel a').click(function(e) {

                    e.preventDefault();

                    if( $(this).attr( 'class' ) == 'sin_previsualizacion' ) {
                        // Descarga archivo
                        window.location.href = $(this).attr( 'href' );
                    } else {
                        // Cambia imagen
                        img = "<img src=\"" + $(this).attr('href') + "\" />";
                        $('#visor_imagen').html(img);
                    }
                } );

            } );

            function establecer_data( p_n_lesion, p_ruta_lesion ) {

                for( var i in lesiones ) {

                    if( lesiones[ i ].n_lesion == p_n_lesion ) {

                        fotos = lesiones[ i ].lesion;

                        for( var j in fotos ) {
                            if( fotos[ j ].nombre == p_ruta_lesion ) {

                                data = fotos[ j ].data;

                                //
                                $('#n_lesion').html( lesiones[ i ].n_lesion );

                                // Establece nombre de la foto
                                for( var k in lesiones_lang )
                                    if( lesiones_lang[ k ].nombre == p_ruta_lesion )
                                        $('#nombre_foto').html( lesiones_lang[ k ].texto );

                                // Establece observacion
                                $('#observacion').html( data.observacion );
                            }
                        }
                    }
                }
            }

        </script>
    </head>
    <body bgcolor="#ffffff">
        <table width="993" border="0" align="center" cellpadding="0" cellspacing="0" id="Table_01">
            <tr>
                <td width="3" background="<?= base_url() ?>images/pit2_09.png">&nbsp;</td>
                <td height="3" bgcolor="#B6D4ED">&nbsp;</td>
                <td height="3" bgcolor="#B6D4ED">&nbsp;</td>
                <td height="3" colspan="2" bgcolor="#B6D4ED">&nbsp;</td>
                <td height="3" background="<?= base_url() ?>images/pit2_13.png">&nbsp;</td>
            </tr>
            <tr>
                <td background="<?= base_url() ?>images/pit2_09.png">&nbsp;</td>
                <td align="center" width="136" height="280" valign="top" bgcolor="#B6D4ED">

                    <!-- Navegador: mueve carrusel de imagenes arriba o abajo -->
                    <span id="carrusel_subir">&lt;&lt;<?= $this->lang->line('derma_lesiones_anterior') ?></span>
                    <span id="carrusel_bajar"><?= $this->lang->line('derma_lesiones_siguiente') ?>&gt;&gt;</span>

                    <!-- Listado de imágenes -->
                    <div class="caja_carrusel">
                        <ul id="carrusel">
                            <?php
                            foreach( $lesiones as $n_lesion => $lesion ) {

                                // Establece carpetas faltantes: sirve para mostrar imagen "no disponible"
                                $a = array( Platc::$DERMA_DIR_FOTOS['ANATOMICA'],
                                    Platc::$DERMA_DIR_FOTOS['30CM'],
                                    Platc::$DERMA_DIR_FOTOS['LUZBLANCA'],
                                    Platc::$DERMA_DIR_FOTOS['LUZUV'] );

                                $lesion = array_merge( array_fill_keys( $a, array( ) ), $lesion );
                                ?>
                                <li>
                                    <span class="titulo_lesion"><?= $this->lang->line('derma_lesiones_lesion') ?> <?=$n_lesion?></span>
                                    <ul>
                                        <?php
                                        foreach( $lesion as $nombre_lesion => $lesion_data ) {

                                            switch( $nombre_lesion ) {
                                                case Platc::$DERMA_DIR_FOTOS['ANATOMICA'] : {
                                                        $titulo = $this->lang->line('derma_lesiones_foto_ubicacion_anatomica');
                                                        $ruta_lesion = Platc::$DERMA_DIR_FOTOS['ANATOMICA'];
                                                    } break;
                                                case Platc::$DERMA_DIR_FOTOS['30CM'] : {
                                                        $titulo = $this->lang->line('derma_lesiones_foto_30cm_lesion');
                                                        $ruta_lesion = Platc::$DERMA_DIR_FOTOS['30CM'];
                                                    } break;
                                                case Platc::$DERMA_DIR_FOTOS['LUZBLANCA'] : {
                                                        $titulo = $this->lang->line('derma_lesiones_foto_detalle_luz_blanca');
                                                        $ruta_lesion = Platc::$DERMA_DIR_FOTOS['LUZBLANCA'];
                                                    } break;
                                                case Platc::$DERMA_DIR_FOTOS['LUZUV'] : {
                                                        $titulo = $this->lang->line('derma_lesiones_foto_detalle_luz_uv');
                                                        $ruta_lesion = Platc::$DERMA_DIR_FOTOS['LUZUV'];
                                                    } break;
                                                default: break;
                                            }
                                            ?>
                                            <li class="lesion_item"><?= $titulo ?>
                                                <br />

                                                <?php if( isset( $lesion_data['archivo'] ) && !empty( $lesion_data['archivo'] ) ) {
                                                        if( array_search( array_pop( explode( '.', $lesion_data['archivo'] ) ), Platc::$IMG_EXT ) !== FALSE ) { ?>
                                                            <a href="<?= base_url() ?>files/derma/<?= $tel_id ?>/<?=$n_lesion?>/<?=$ruta_lesion?>/<?=$lesion_data['archivo']?>" onclick="establecer_data( '<?=$n_lesion?>', '<?=$ruta_lesion?>' )" >
                                                                <img src="<?= base_url() ?>files/derma/<?= $tel_id ?>/<?= $n_lesion ?>/<?= $ruta_lesion ?>/thumb_<?= $lesion_data['archivo'] ?>" />
                                                            </a>
                                                        <?php } else { ?>
                                                            <a href="<?= base_url() ?>files/derma/<?= $tel_id ?>/<?=$n_lesion?>/<?=$ruta_lesion?>/<?=$lesion_data['archivo']?>" onclick="establecer_data( '<?=$n_lesion?>', '<?=$ruta_lesion?>' )" class="sin_previsualizacion" >
                                                                <img src="<?=base_url()?>images/file.png" class="sin_previsualizacion" />
                                                            </a>
                                                        <?php } ?>
                                                <?php } elseif( !isset( $lesion_data['archivo'] ) || empty( $lesion_data['archivo'] ) ) { ?>
                                                    <a href="<?= base_url() ?>images/imagen_nodisponible_grande.jpg" >
                                                        <img src="<?= base_url() ?>images/imagen_nodisponible.jpg" />
                                                    </a>
                                                <?php } else { ?>
                                                    <a href="<?= base_url() ?>images/imagen_nodisponible_grande.jpg" >
                                                        <img src="<?= base_url() ?>images/imagen_nodisponible.jpg" />
                                                    </a>
                                                <?php } ?>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                </li>
                            <?php } ?>
                        </ul>
                    </div>

                </td>
                <td width="6" bgcolor="#B6D4ED">&nbsp;</td>
                <td colspan="2" align="left" valign="top" bgcolor="#FFFFFF">
                    <div>
                        <span style="font-weight: bold;"><?=$this->lang->line('derma_lesiones_lesion')?></span> <span id="n_lesion" style="font-weight: bold;"></span>
                        <span id="nombre_foto" style="font-style: italic; font-weight: bold;"></span><br/>
                        <span id="observacion"></span>
                    </div>
                    <div id="visor_imagen" style="margin-left: 8px; text-align: center; vertical-align: middle; "></div>
                </td>
                <td width="29" background="<?= base_url() ?>images/Bderecho.png">&nbsp;</td>
            </tr>

            <tr>
                <td background="<?= base_url() ?>images/pit2_09.png">&nbsp;</td>
                <td height="54" valign="top" bgcolor="#B6D4ED">&nbsp;</td>
                <td bgcolor="#B6D4ED">&nbsp;</td>
                <td colspan="2">&nbsp;</td>
                <td width="29" background="<?= base_url() ?>images/Bderecho.png">&nbsp;</td>
            </tr>
        </table>

        <div id="informacion_contacto_dialog" title="<?= $this->lang->line('contacto') ?>">
            <p><?= $this->lang->line('contact_' . $this->session->userdata('SIT_PAIS') . '_data1') ?></p>
            <p><?= $this->lang->line('contact_' . $this->session->userdata('SIT_PAIS') . '_data2') ?></p>
            <p><?= $this->lang->line('contact_' . $this->session->userdata('SIT_PAIS') . '_data3') ?></p>
        </div>
    </body>
</html>
