<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

if( $modo == FormularioXML::$MODO_LECTURA )  { ?>

    <style type="text/css">
        #ckdepi_div {}

        #ckdepi_div input {
            text-align: right;
            width: 50px;
        }

        #ckdepi_div td.item_etiqueta {
            text-align: right;
            width: 100px;
        }

        #ckdepi_div td.item_valores {
            text-align: left;
            width: 200px;
        }

        #ckdepi_div td.indices {
            text-align: center;
        }

        #ckdepi_div .calculos {
            text-align: right;
            height: 20px;
            width: 150px;
            background-color: #CCCCCC;
            padding: 10px 5px 10 0;
        }

        #ckdepi_div .botonera {
            text-align: center;
        }
    </style>

    <div id="ckdepi_div">
        <table border="0" cellpadding="0" cellspacing="5">

            <!-- Sexo -->
            <tr>
                <td><?=$this->lang->line('p_sexo')?>:</td>
                <td><?php
                    switch( $tc['TEL_PAC_SEXO'] ) {
                        case "M" : echo $this->lang->line('p_masculino'); break;
                        case "F" : echo $this->lang->line('p_femenino'); break;
                        default: echo " - ";
                    } ?></td>
            </tr>

            <!-- Edad -->
            <tr>
                <td><?=$this->lang->line('p_edad')?>:</td>
                <td><?=$tc['TEL_PAC_EDAD']?> <?=$this->lang->line('anos')?></td>
            </tr>

            <!-- Creatinina -->
            <tr>
                <td><?=$this->lang->line('creatinina')?>:</td>
                <td><?= ( isset( $cg_creatinina ) && !empty( $cg_creatinina ) ) ? $cg_creatinina : " - " ?> <?=$this->lang->line('mgdl')?></td>
            </tr>

            <!-- Raza -->
            <tr>
                <td><?=$this->lang->line('afroamericano')?>:</td>
                <td><?php
                    if( isset( $mdrd_afroamericano ) && !empty( $mdrd_afroamericano ) ) {
                        if( $mdrd_afroamericano == "si" )
                            echo $this->lang->line('si');
                        else
                            echo $this->lang->line('no');
                    } else echo " - ";
                ?></td>
            </tr>

            <!-- Estimación CKDEPI -->
            <tr>
                <td><?=$this->lang->line('ckd_epi')?></td>
                <td><?= ( isset( $ckdepi_estimacion ) && !empty( $ckdepi_estimacion ) ) ? $ckdepi_estimacion : " - " ?> <?=$this->lang->line('ml_min_1.73m2')?></td>
            </tr>

        </table>
    </div>
	<hr/>
<?php }

if( $modo == FormularioXML::$MODO_ESCRITURA )  { ?>

    <style type="text/css">
        #ckdepi_div {}

        #ckdepi_div input {
            text-align: right;
            width: 50px;
        }

        #ckdepi_div td.item_etiqueta {
            text-align: right;
            width: 100px;
        }

        #ckdepi_div td.item_valores {
            text-align: left;
            width: 200px;
        }

        #ckdepi_div td.indices {
            text-align: center;
        }

        #ckdepi_div .calculos {
            text-align: right;
            height: 20px;
            width: 150px;
            background-color: #CCCCCC;
            padding: 10px 5px 10 0;
        }

        #ckdepi_div .botonera {
            text-align: center;
        }
    </style>

    <script type="text/javascript" src="<?=base_url()?>js/herramientas.js" />
    <script type="text/javascript">

        ckdepi_sexo = "<?=$tc['TEL_PAC_SEXO']?>";
        ckdepi_edad = parseInt( "<?=$tc['TEL_PAC_EDAD']?>" );

        $(document).ready( function( ) {

            // Vincula cambios de otros campos para recalcular CKD-EPI
            $('#cg_creatinina').change( function( ) { $('#ckdepi_creatinina').html( $.isEmptyObject( $(this).val() ) ? " - " : $(this).val( ) ); } );
            $('#cg_creatinina').change( function( ) { recalcular_ckdepi(); } );
            $('input[name=mdrd_afroamericano]').click( function( ) {

                afroamericano_txt = " - ";
                if( $('input[name=mdrd_afroamericano]:checked').length > 0 ) {
                    if( $('input[name=mdrd_afroamericano]:checked').val() === "si" )
                            $('#ckdepi_afroamericano').html( "<?=$this->lang->line('si')?>" );
                        else
                            $('#ckdepi_afroamericano').html( "<?=$this->lang->line('no')?>" );
                }
            } );
            $('input[name=mdrd_afroamericano]').click( function( ) { recalcular_ckdepi(); } );

            recalcular_ckdepi();
        } );

        function recalcular_ckdepi( ) {

            $('#ckdepi_creatinina').html( $('#cg_creatinina').val() );
            edad            = ckdepi_edad;
            creatinina      = $('#cg_creatinina').val();
            sexo            = ckdepi_sexo;
            afroamericano   = ( $('input[name=mdrd_afroamericano]:checked').length > 0 && $('input[name=mdrd_afroamericano]:checked').val() === "si" ) ? true : false;

            try {

                $('#ckdepi_estimacion').val( HERRAMIENTAS.redondear( HERRAMIENTAS.ckdepi( afroamericano, sexo, creatinina, edad ), 1 ) );
            } catch( e ) {
                
                $('#ckdepi_estimacion').val( "" );
            }

        }

    </script>

    <div id="ckdepi_div">

        <table border="0" cellpadding="0" cellspacing="5">

            <!-- Sexo -->
            <tr>
                <td><?=$this->lang->line('p_sexo')?>:</td>
                <td><?php
                    switch( $tc['TEL_PAC_SEXO'] ) {
                        case "M" : echo $this->lang->line('p_masculino'); break;
                        case "F" : echo $this->lang->line('p_femenino'); break;
                        default: echo " - ";
                    } ?></td>
            </tr>

            <!-- Edad -->
            <tr>
                <td><?=$this->lang->line('p_edad')?>:</td>
                <td><?=$tc['TEL_PAC_EDAD']?> <?=$this->lang->line('anos')?></td>
            </tr>

            <!-- Creatinina -->
            <tr>
                <td><?=$this->lang->line('creatinina')?>:</td>
                <td><span id="ckdepi_creatinina"> - </span> <?=$this->lang->line('mgdl')?></td>
            </tr>

            <!-- Raza -->
            <tr>
                <td><?=$this->lang->line('afroamericano')?>:</td>
                <td><span id="ckdepi_afroamericano" > - </span></td>
            </tr>

            <!-- Estimación CKDEPI -->
            <tr>
                <td><?=$this->lang->line('ckd_epi')?></td>
                <td>
                    <div>
                        <input type="text" readonly="readonly" name="ckdepi_estimacion" id="ckdepi_estimacion" /> <?=$this->lang->line('ml_min_1.73m2')?>
                    </div>
                </td>
            </tr>

        </table>
    </div>
	<hr/>
<?php }

if( $modo == FormularioXML::$MODO_PDF )  {
       $x = $pdf->GetX();

	//SEXO
    if( isset( $tc['TEL_PAC_SEXO'] ) && !empty( $tc['TEL_PAC_SEXO'] ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('p_sexo').": ".(($tc['TEL_PAC_SEXO'] = 'M') ? $this->lang->line('p_masculino') : $this->lang->line('p_femenino')  ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x);
	//EDAD

    if( isset( $tc['TEL_PAC_EDAD'] ) && !empty( $tc['TEL_PAC_EDAD'] ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('p_edad').": ".$tc['TEL_PAC_EDAD'], ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x);
	//CREATININA
    if( isset( $cg_creatinina ) && !empty( $cg_creatinina ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('creatinina').": ".$this->lang->line( $cg_creatinina )." ".$this->lang->line('mgdl'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x);

	//RAZA
    if( isset( $mdrd_afroamericano ) && !empty( $mdrd_afroamericano ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('afroamericano').": ".(($mdrd_afroamericano == "si") ? $this->lang->line('si') : $this->lang->line('no')), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x);
	
	//CKDEPI
    if( isset( $ckdepi_estimacion ) && !empty( $ckdepi_estimacion ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('ckd_epi').": ".$this->lang->line( $ckdepi_estimacion )."-".$this->lang->line('ml_min_1.73m2'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x);
}
