<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

if( $modo == FormularioXML::$MODO_LECTURA )  { ?>

    <style type="text/css">
        #mdrd_div {}

        #mdrd_div input {
            text-align: right;
            width: 50px;
        }

        #mdrd_div td.item_etiqueta {
            text-align: right;
            width: 100px;
        }

        #mdrd_div td.item_valores {
            text-align: left;
            width: 200px;
        }

        #mdrd_div td.indices {
            text-align: center;
        }

        #mdrd_div .calculos {
            text-align: right;
            height: 20px;
            width: 150px;
            background-color: #CCCCCC;
            padding: 10px 5px 10 0;
        }

        #mdrd_div .botonera {
            text-align: center;
        }
    </style>

    <div id="mdrd_div">
        <table border="0" cellpadding="0" cellspacing="5">

            <!-- Sexo -->
            <tr>
                <td><?=$this->lang->line('p_sexo')?>:</td>
                <td><?php
                    switch( $tc['TEL_PAC_SEXO'] ) {
                        case "M" : echo $this->lang->line('p_masculino'); break;
                        case "F" : echo $this->lang->line('p_femenino'); break;
                        default: echo " - ";
                    } ?></td>
            </tr>

            <!-- Edad -->
            <tr>
                <td><?=$this->lang->line('p_edad')?>:</td>
                <td><?=$tc['TEL_PAC_EDAD']?> <?=$this->lang->line('anos')?></td>
            </tr>

            <!-- Creatinina -->
            <tr>
                <td><?=$this->lang->line('creatinina')?>:</td>
                <td><?= ( isset( $cg_creatinina ) && !empty( $cg_creatinina ) ) ? $cg_creatinina : " - " ?> <?=$this->lang->line('mgdl')?></td>
            </tr>

            <!-- Urea -->
            <tr>
                <td><?=$this->lang->line('urea')?>:</td>
                <td><?= ( isset( $mdrd_urea ) && !empty( $mdrd_urea ) ) ? $mdrd_urea : " - " ?> <?=$this->lang->line('mgdl')?></td>
            </tr>

            <!-- Albumia -->
            <tr>
                <td><?=$this->lang->line('albumina')?>:</td>
                <td><?= ( isset( $mdrd_albumina ) && !empty( $mdrd_albumina ) ) ? $mdrd_albumina : " - " ?> <?=$this->lang->line('gdl')?></td>
            </tr>

            <!-- Raza -->
            <tr>
                <td><?=$this->lang->line('afroamericano')?>:</td>
                <td><?php if( isset( $mdrd_afroamericano ) && !empty( $mdrd_afroamericano ) ) {
                    if( $mdrd_afroamericano == "si" )
                        echo $this->lang->line('si');
                    else
                        echo $this->lang->line('no');
                } else echo " - ";
                ?></td>
            </tr>

            <!-- MDRD6 -->
            <tr>
                <td><?=$this->lang->line('mdrd6')?>: </td>
                <td><?= ( isset( $mdrd_mdrd6 ) && !empty( $mdrd_mdrd6 ) ) ? $mdrd_mdrd6 : " - " ?> <?=$this->lang->line('ml_min_1.73m2')?></td>
            </tr>

            <!-- MDRD4 -->
            <tr>
                <td><?=$this->lang->line('mdrd4')?>:</td>
                <td><?= ( isset( $mdrd_mdrd4 ) && !empty( $mdrd_mdrd4 ) ) ? $mdrd_mdrd4 : " - " ?> <?=$this->lang->line('ml_min_1.73m2')?></td>
            </tr>

            <!-- MDRD4 - IDMS -->
            <tr>
                <td><?=$this->lang->line('mdrd4idms')?>:</td>
                <td><?= ( isset( $mdrd_mdrd4idms ) && !empty( $mdrd_mdrd4idms ) ) ? $mdrd_mdrd4idms : " - " ?> <?=$this->lang->line('ml_min_1.73m2')?></td>
            </tr>

        </table>
    </div>
	<hr/>
<?php }

if( $modo == FormularioXML::$MODO_ESCRITURA )  { ?>

    <style type="text/css">
        #mdrd_div {}

        #mdrd_div input[type=text] {
            text-align: right;
            width: 50px;
        }

        #mdrd_div input[type=radio] {
            width: auto;
        }

        #mdrd_div td.item_etiqueta {
            text-align: right;
            width: 100px;
        }

        #mdrd_div td.item_valores {
            text-align: left;
            width: 200px;
        }

        #mdrd_div td.indices {
            text-align: center;
        }

        #mdrd_div .calculos {
            text-align: left;
            height: 20px;
            width: 150px;
            background-color: #CCCCCC;
            padding: 10px 5px 10 0;
        }

        #mdrd_div .botonera {
            text-align: center;
        }
    </style>

    <script type="text/javascript" src="<?=base_url()?>js/herramientas.js" />
    <script type="text/javascript">

        dg_sexo = "<?=$tc['TEL_PAC_SEXO']?>";
        dg_edad = parseInt( "<?=$tc['TEL_PAC_EDAD']?>" );

        $(document).ready( function( ) {

//            $('#df_talla').change( function( ) { $('#mdrd_talla').html( $.isEmptyObject( $(this).val() ) ? " - " : $(this).val( ) ); } );
//            $('#df_peso').change( function( ) { $('#mdrd_peso').html( $.isEmptyObject( $(this).val() ) ? " - " : $(this).val( ) ); } );
            $('#cg_creatinina').change( function( ) { $('#mdrd_creatinina').html( $.isEmptyObject( $(this).val() ) ? " - " : $(this).val( ) ); } );

            // Vincula cambios de otros campos para recalcular MDRD
            $('#cg_creatinina').change( function( ) { recalcular_mdrd(); } );
            $('#mdrd_urea').change( function( ) { recalcular_mdrd(); } );
            $('#mdrd_albumina').change( function( ) { recalcular_mdrd(); } );
            $('input[name=mdrd_afroamericano]').click( function( ) { recalcular_mdrd(); } );

            recalcular_mdrd();
        } );

        function recalcular_mdrd( ) {

            $('#mdrd_creatinina').html( $('#cg_creatinina').val() );

            edad            = dg_edad;
            creatinina      = $('#cg_creatinina').val();
            urea            = $('#mdrd_urea').val();
            albumina        = $('#mdrd_albumina').val();
            sexo            = dg_sexo;
            if( $('input[name=mdrd_afroamericano]:checked').length > 0 )
                afroamericano = ( $('input[name=mdrd_afroamericano]:checked').val() === "si" ) ? true : false;
            else
                afroamericano = null;

            try {
                
                calculo_mdrd6       = HERRAMIENTAS.mdrd6( creatinina, edad, urea, albumina, sexo, afroamericano );
                calculo_mdrd4       = HERRAMIENTAS.mdrd4( creatinina, edad, sexo, afroamericano );
                calculo_mdrd4idms   = HERRAMIENTAS.mdrd4idms( creatinina, edad, sexo, afroamericano );

                $('#mdrd_mdrd6').val( HERRAMIENTAS.redondear( calculo_mdrd6, 2 ) );
                $('#mdrd_mdrd4').val( HERRAMIENTAS.redondear( calculo_mdrd4, 2 ) );
                $('#mdrd_mdrd4idms').val( HERRAMIENTAS.redondear( calculo_mdrd4idms, 2 ) );
            } catch( e ) {
                
                $('#mdrd_mdrd6').val( "" );
                $('#mdrd_mdrd4').val( "" );
                $('#mdrd_mdrd4idms').val( "" );
            }

        }

    </script>

    <div id="mdrd_div">
        <table border="0" cellpadding="0" cellspacing="5">

            <!-- Sexo -->
            <tr>
                <td><?=$this->lang->line('p_sexo')?>:</td>
                <td><?php
                    switch( $tc['TEL_PAC_SEXO'] ) {
                        case "M" : echo $this->lang->line('p_masculino'); break;
                        case "F" : echo $this->lang->line('p_femenino'); break;
                        default: echo " - ";
                    } ?></td>
            </tr>

            <!-- Edad -->
            <tr>
                <td><?=$this->lang->line('p_edad')?>:</td>
                <td><?=$tc['TEL_PAC_EDAD']?> <?=$this->lang->line('anos')?></td>
            </tr>

            <!-- Creatinina -->
            <tr>
                <td><?=$this->lang->line('creatinina')?>:</td>
                <td><span id="mdrd_creatinina"> - </span> <?=$this->lang->line('mgdl')?></td>
            </tr>

            <!-- Urea -->
            <tr>
                <td><?=$this->lang->line('urea')?>:</td>
                <td><input type="text" name="mdrd_urea" id="mdrd_urea" value="<?= ( isset( $mdrd_urea ) && !empty( $mdrd_urea ) ) ? $mdrd_urea : "" ?>" /> <?=$this->lang->line('mgdl')?></td>
            </tr>

            <!-- Albumia -->
            <tr>
                <td><?=$this->lang->line('albumina')?>:</td>
                <td><input type="text" name="mdrd_albumina" id="mdrd_albumina" value="<?= ( isset( $mdrd_albumina ) && !empty( $mdrd_albumina ) ) ? $mdrd_albumina : "" ?>" /> <?=$this->lang->line('gdl')?></td>
            </tr>

            <!-- Raza -->
            <tr>
                <td><?=$this->lang->line('afroamericano')?>:</td>
                <td>
                    <input type="radio" name="mdrd_afroamericano" id="mdrd_afroamericano_si" value="si" />
                    <label for="mdrd_afroamericano_si"><?=$this->lang->line('si')?></label>
                    &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
                    <input type="radio" name="mdrd_afroamericano" id="mdrd_afroamericano_no" value="no" />
                    <label for="mdrd_afroamericano_no"><?=$this->lang->line('no')?></label>
                </td>
            </tr>

            <!-- MDRD6 -->
            <tr>
                <td><?=$this->lang->line('mdrd6')?>: </td>
                <td>
                    <div>
                        <input type="text" readonly="readonly" name="mdrd_mdrd6" id="mdrd_mdrd6" /> <?=$this->lang->line('ml_min_1.73m2')?>
                    </div>
                </td>
            </tr>

            <!-- MDRD4 -->
            <tr>
                <td><?=$this->lang->line('mdrd4')?>:</td>
                <td>
                    <div>
                        <input type="text" readonly="readonly" name="mdrd_mdrd4" id="mdrd_mdrd4" /><?=$this->lang->line('ml_min_1.73m2')?>
                    </div>
                </td>
            </tr>

            <!-- MDRD4 - IDMS -->
            <tr>
                <td><?=$this->lang->line('mdrd4idms')?>:</td>
                <td>
                    <div>
                        <input type="text" readonly="readonly" name="mdrd_mdrd4idms" id="mdrd_mdrd4idms" /><?=$this->lang->line('ml_min_1.73m2')?>
                    </div>
                </td>
            </tr>
        </table>
    </div>
	<hr/>
<?php }

if( $modo == FormularioXML::$MODO_PDF )  {
    $x = $pdf->GetX();

	//SEXO
    if( isset( $tc['TEL_PAC_SEXO'] ) && !empty( $tc['TEL_PAC_SEXO'] ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('p_sexo').": ".(($tc['TEL_PAC_SEXO'] = 'M') ? $this->lang->line('p_masculino') : $this->lang->line('p_femenino')  ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x);
	//EDAD

    if( isset( $tc['TEL_PAC_EDAD'] ) && !empty( $tc['TEL_PAC_EDAD'] ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('p_edad').": ".$tc['TEL_PAC_EDAD'], ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x);
	//CREATININA
    if( isset( $cg_creatinina ) && !empty( $cg_creatinina ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('creatinina').": ".$this->lang->line( $cg_creatinina )." ".$this->lang->line('mgdl'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x);
	
	//UREA
    if( isset( $mdrd_urea ) && !empty( $mdrd_urea ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('urea').": ".$this->lang->line( $mdrd_urea )."-".$this->lang->line('mgdl'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x);
	
	//ALBUMINA
    if( isset( $mdrd_albumina ) && !empty( $mdrd_albumina ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('albumina').": ".$this->lang->line( $mdrd_albumina )."-".$this->lang->line('gdl'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x);

	//RAZA
    if( isset( $mdrd_afroamericano ) && !empty( $mdrd_afroamericano ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('afroamericano').": ".(($mdrd_afroamericano == "si") ? $this->lang->line('si') : $this->lang->line('no')), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x);
	
	//MDRD6
    if( isset( $mdrd_mdrd6 ) && !empty( $mdrd_mdrd6 ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('mdrd6').": ".$this->lang->line( $mdrd_mdrd6 )."-".$this->lang->line('ml_min_1.73m2'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x);
	
	//MDRD4
    if( isset( $mdrd_mdrd4 ) && !empty( $mdrd_mdrd4 ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('mdrd4').": ".$this->lang->line( $mdrd_mdrd4 )."-".$this->lang->line('ml_min_1.73m2'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x);
	
	//MDRD4 - IDMS
    if( isset( $mdrd_mdrd4idms ) && !empty( $mdrd_mdrd4idms ) )
        $pdf->Cell( 20, 6, html_entity_decode( $this->lang->line('mdrd4idms').": ".$this->lang->line( $mdrd_mdrd4idms )."-".$this->lang->line('ml_min_1.73m2'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    else
        $pdf->Cell( 20, 6, " - ", 0, 1, 'L' );
	$pdf->SetX($x); 

}
