<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

if( $modo == FormularioXML::$MODO_LECTURA ) { ?>

    <!-- ¿Olvida alguna vez tomar los medicamentos para tratar su enfermedad? -->
    <?=$this->lang->line('olvida_tomar_medicamentos_tratar_enfermedad')?> <br />
    <?php if( isset( $olvida_tomar_medicamentos_tratar_enfermedad ) && !empty( $olvida_tomar_medicamentos_tratar_enfermedad ) ) {

        switch( (string)$olvida_tomar_medicamentos_tratar_enfermedad ) {
            case "si" : echo $this->lang->line('si'); break;
            case "no" : echo $this->lang->line('no'); break;
            default: echo " - "; break;
        }
    } else
        echo " - ";
    ?>
    <br/>
    <br/>

    <!-- ¿Toma los medicamentos a las horas indicadas? -->
    <?=$this->lang->line('toma_medicamentos_horas_indicadas')?> <br />
    <?php if( isset( $toma_medicamentos_horas_indicadas ) && !empty( $toma_medicamentos_horas_indicadas ) ) {

        switch( (string)$toma_medicamentos_horas_indicadas ) {
            case "si" : echo $this->lang->line('si'); break;
            case "no" : echo $this->lang->line('no'); break;
            default: echo " - "; break;
        }
    } else
        echo " - ";
    ?>
    <br/>
    <br/>

    <!-- Cuando se encuentra bien, ¿deja de tomar la medicación? -->
    <?=$this->lang->line('cuando_encuentra_bien_deja_tomar_medicacion')?> <br />
    <?php if( isset( $cuando_encuentra_bien_deja_tomar_medicacion ) && !empty( $cuando_encuentra_bien_deja_tomar_medicacion ) ) {

        switch( (string)$cuando_encuentra_bien_deja_tomar_medicacion ) {
            case "si" : echo $this->lang->line('si'); break;
            case "no" : echo $this->lang->line('no'); break;
            default: echo " - "; break;
        }
    } else
        echo " - ";
    ?>
    <br/>
    <br/>

    <!-- Si alguna vez le sienta mal, ¿deja usted de tomarla? -->
    <?=$this->lang->line('alguna_sienta_mal_deja_tomarla')?> <br />
    <?php if( isset( $alguna_sienta_mal_deja_tomarla ) && !empty( $alguna_sienta_mal_deja_tomarla ) ) {

        switch( (string)$alguna_sienta_mal_deja_tomarla ) {
            case "si" : echo $this->lang->line('si'); break;
            case "no" : echo $this->lang->line('no'); break;
            default: echo " - "; break;
        }
    } else
        echo " - ";
    ?>
    <br/>
    <br/>

    <?php
    
    $txt = " - ";
    if( isset( $olvida_tomar_medicamentos_tratar_enfermedad ) && !empty( $olvida_tomar_medicamentos_tratar_enfermedad ) &&
        isset( $toma_medicamentos_horas_indicadas ) && !empty( $toma_medicamentos_horas_indicadas ) &&
        isset( $cuando_encuentra_bien_deja_tomar_medicacion ) && !empty( $cuando_encuentra_bien_deja_tomar_medicacion ) &&
        isset( $alguna_sienta_mal_deja_tomarla ) && !empty( $alguna_sienta_mal_deja_tomarla )
    ) {
        if( $olvida_tomar_medicamentos_tratar_enfermedad == "no" && $toma_medicamentos_horas_indicadas == "no" &&
            $cuando_encuentra_bien_deja_tomar_medicacion == "no" && $alguna_sienta_mal_deja_tomarla == "no" )
            $txt = $this->lang->line('paciente_cumplidor_tratamiento');
        else 
            $txt = $this->lang->line('paciente_no_cumplidor_tratamiento');
    } ?>
    <br /> <br />
    <span><?=$txt?></span>
<?php }

if( $modo == FormularioXML::$MODO_ESCRITURA ) { ?>

    <script type="text/javascript">
        
        test_morinsky_green_categorias = [
            { id: "cumple",   texto: "<?=$this->lang->line('paciente_cumplidor_tratamiento')?>" },
            { id: "nocumple", texto: "<?=$this->lang->line('paciente_no_cumplidor_tratamiento')?>" }
        ];

        $(document).ready( function( ) {

            $('form [name=olvida_tomar_medicamentos_tratar_enfermedad], form [name=toma_medicamentos_horas_indicadas], form [name=cuando_encuentra_bien_deja_tomar_medicacion], form [name=alguna_sienta_mal_deja_tomarla]').click( function( ) {

                if( $(this).parent().find("input:checked").length == 4 ) {

                    if( $(this).parent().find("input:checked").filter("[value=si]").length != 0 ) {
                        for( var i in test_morinsky_green_categorias )
                            if( test_morinsky_green_categorias[i].id == "nocumple" )
                                $('#test_morinsky_green_categorizacion').html( test_morinsky_green_categorias[i].texto );
                    } else {
                        for( var i in test_morinsky_green_categorias )
                            if( test_morinsky_green_categorias[i].id == "cumple" )
                                $('#test_morinsky_green_categorizacion').html( test_morinsky_green_categorias[i].texto );
                    }
                } else {
                    $('#test_morinsky_green_categorizacion').html( "" );
                }
            } );
        } );
    </script>

    <!-- ¿Olvida alguna vez tomar los medicamentos para tratar su enfermedad? -->
    <?=$this->lang->line('olvida_tomar_medicamentos_tratar_enfermedad')?><br/>
    <input type="radio" name="olvida_tomar_medicamentos_tratar_enfermedad" id="olvida_tomar_medicamentos_tratar_enfermedad_si" value="si" class="validate[required]"
       <?=( isset( $olvida_tomar_medicamentos_tratar_enfermedad ) && ( $olvida_tomar_medicamentos_tratar_enfermedad == "si" ) ) ? 'checked="checked"' : '' ?>
    />
    <label for="olvida_tomar_medicamentos_tratar_enfermedad_si"><?=$this->lang->line('si')?></label>
    &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
    <input type="radio" name="olvida_tomar_medicamentos_tratar_enfermedad" id="olvida_tomar_medicamentos_tratar_enfermedad_no" value="no" class="validate[required]"
       <?=( ( isset( $olvida_tomar_medicamentos_tratar_enfermedad ) && ( $olvida_tomar_medicamentos_tratar_enfermedad == "no" ) ) ) ? 'checked="checked"' : '' ?>
    />
    <label for="olvida_tomar_medicamentos_tratar_enfermedad_no"><?=$this->lang->line('no')?></label>
    <br /> <br />

    <!-- ¿Toma los medicamentos a las horas indicadas? -->
    <?=$this->lang->line('toma_medicamentos_horas_indicadas')?><br/>
    <input type="radio" name="toma_medicamentos_horas_indicadas" id="toma_medicamentos_horas_indicadas_si" value="si" class="validate[required]"
       <?=( isset( $toma_medicamentos_horas_indicadas ) && ( $toma_medicamentos_horas_indicadas == "si" ) ) ? 'checked="checked"' : '' ?>
    />
    <label for="toma_medicamentos_horas_indicadas_si"><?=$this->lang->line('si')?></label>
    &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
    <input type="radio" name="toma_medicamentos_horas_indicadas" id="toma_medicamentos_horas_indicadas_no" value="no" class="validate[required]"
       <?=( ( isset( $toma_medicamentos_horas_indicadas ) && ( $toma_medicamentos_horas_indicadas == "no" ) ) ) ? 'checked="checked"' : '' ?>
    />
    <label for="toma_medicamentos_horas_indicadas_no"><?=$this->lang->line('no')?></label>
    <br /> <br />

    <!-- Cuando se encuentra bien, ¿deja de tomar la medicación? -->
    <?=$this->lang->line('cuando_encuentra_bien_deja_tomar_medicacion')?><br/>
    <input type="radio" name="cuando_encuentra_bien_deja_tomar_medicacion" id="cuando_encuentra_bien_deja_tomar_medicacion_si" value="si" class="validate[required]"
       <?=( isset( $cuando_encuentra_bien_deja_tomar_medicacion ) && ( $cuando_encuentra_bien_deja_tomar_medicacion == "si" ) ) ? 'checked="checked"' : '' ?>
    />
    <label for="cuando_encuentra_bien_deja_tomar_medicacion_si"><?=$this->lang->line('si')?></label>
    &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
    <input type="radio" name="cuando_encuentra_bien_deja_tomar_medicacion" id="cuando_encuentra_bien_deja_tomar_medicacion_no" value="no" class="validate[required]"
       <?=( isset( $cuando_encuentra_bien_deja_tomar_medicacion ) && ( $cuando_encuentra_bien_deja_tomar_medicacion == "no" ) ) ? 'checked="checked"' : '' ?>
    />
    <label for="cuando_encuentra_bien_deja_tomar_medicacion_no"><?=$this->lang->line('no')?></label>
    <br /> <br />

    <!-- Si alguna vez le sienta mal, ¿deja usted de tomarla? -->
    <?=$this->lang->line('alguna_sienta_mal_deja_tomarla')?><br/>
    <input type="radio" name="alguna_sienta_mal_deja_tomarla" id="alguna_sienta_mal_deja_tomarla_si" value="si" class="validate[required]"
       <?=( isset( $alguna_sienta_mal_deja_tomarla ) && ( $alguna_sienta_mal_deja_tomarla == "si" ) ) ? 'checked="checked"' : '' ?>
    />
    <label for="alguna_sienta_mal_deja_tomarla_si"><?=$this->lang->line('si')?></label>
    &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
    <input type="radio" name="alguna_sienta_mal_deja_tomarla" id="alguna_sienta_mal_deja_tomarla_no" value="no" class="validate[required]"
       <?=( isset( $alguna_sienta_mal_deja_tomarla ) && ( $alguna_sienta_mal_deja_tomarla == "no" ) ) ? 'checked="checked"' : '' ?>
    />
    <label for="alguna_sienta_mal_deja_tomarla_no"><?=$this->lang->line('no')?></label>
    <br /> <br />

    <span id="test_morinsky_green_categorizacion">&nbsp;</span>
<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    // ¿Olvida alguna vez tomar los medicamentos para tratar su enfermedad?
    $x = $pdf->GetX();
    $pdf->MultiCell( 0, 6, html_entity_decode( $this->lang->line('olvida_tomar_medicamentos_tratar_enfermedad'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 'L' );
    if( isset( $olvida_tomar_medicamentos_tratar_enfermedad ) && !empty( $olvida_tomar_medicamentos_tratar_enfermedad ) ) {

        switch( (string)$olvida_tomar_medicamentos_tratar_enfermedad ) {
            case "si" : $txt = $this->lang->line('si'); break;
            case "no" : $txt = $this->lang->line('no'); break;
            default: $txt = " - ";
        }
    } else
        $txt = " - ";

    $pdf->SetX($x);
    $pdf->Cell( 20, 6, html_entity_decode( $txt, ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    $pdf->Ln();

    // ¿Toma los medicamentos a las horas indicadas?
    $pdf->SetX( $x );
    $pdf->MultiCell( 0, 6, html_entity_decode( $this->lang->line('toma_medicamentos_horas_indicadas'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 'L' );
    if( isset( $toma_medicamentos_horas_indicadas ) && !empty( $toma_medicamentos_horas_indicadas ) ) {

        switch( (string)$toma_medicamentos_horas_indicadas ) {
            case "si" : $txt = $this->lang->line('si'); break;
            case "no" : $txt = $this->lang->line('no'); break;
            default: $txt = " - ";
        }
    } else
        $txt = " - ";

    $pdf->SetX($x);
    $pdf->Cell( 20, 6, html_entity_decode( $txt, ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    $pdf->Ln();

    // Cuando se encuentra bien, ¿deja de tomar la medicación?
    $pdf->SetX( $x );
    $pdf->MultiCell( 0, 6, html_entity_decode( $this->lang->line('cuando_encuentra_bien_deja_tomar_medicacion'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 'L' );
    if( isset( $cuando_encuentra_bien_deja_tomar_medicacion ) && !empty( $cuando_encuentra_bien_deja_tomar_medicacion ) ) {

        switch( (string)$cuando_encuentra_bien_deja_tomar_medicacion ) {
            case "si" : $txt = $this->lang->line('si'); break;
            case "no" : $txt = $this->lang->line('no'); break;
            default: $txt = " - ";
        }
    } else
        $txt = " - ";

    $pdf->SetX($x);
    $pdf->Cell( 20, 6, html_entity_decode( $txt, ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    $pdf->Ln();

    // Si alguna vez le sienta mal, ¿deja usted de tomarla?
    $pdf->SetX( $x );
    $pdf->MultiCell( 0, 6, html_entity_decode( $this->lang->line('alguna_sienta_mal_deja_tomarla'), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 'L' );
    if( isset( $alguna_sienta_mal_deja_tomarla ) && !empty( $alguna_sienta_mal_deja_tomarla ) ) {

        switch( (string)$alguna_sienta_mal_deja_tomarla ) {
            case "si" : $txt = $this->lang->line('si'); break;
            case "no" : $txt = $this->lang->line('no'); break;
            default: $txt = " - ";
        }
    } else
        $txt = " - ";

    $pdf->SetX($x);
    $pdf->Cell( 20, 6, html_entity_decode( $txt, ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );
    $pdf->Ln();

    $txt = " - ";
    if( isset( $olvida_tomar_medicamentos_tratar_enfermedad ) && !empty( $olvida_tomar_medicamentos_tratar_enfermedad ) &&
        isset( $toma_medicamentos_horas_indicadas ) && !empty( $toma_medicamentos_horas_indicadas ) &&
        isset( $cuando_encuentra_bien_deja_tomar_medicacion ) && !empty( $cuando_encuentra_bien_deja_tomar_medicacion ) &&
        isset( $alguna_sienta_mal_deja_tomarla ) && !empty( $alguna_sienta_mal_deja_tomarla )
    ) {
        if( $olvida_tomar_medicamentos_tratar_enfermedad == "no" && $toma_medicamentos_horas_indicadas == "no" &&
            $cuando_encuentra_bien_deja_tomar_medicacion == "no" && $alguna_sienta_mal_deja_tomarla == "no" )
            $txt = $this->lang->line('paciente_cumplidor_tratamiento');
        else 
            $txt = $this->lang->line('paciente_no_cumplidor_tratamiento');
    }
    $pdf->SetX( $x );
    $pdf->MultiCell( 0, 6, html_entity_decode( $txt, ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 'L' );    
}
