<?php

if( $modo == FormularioXML::$MODO_LECTURA ) {

    $ef_campos = array( 'tc_examen_fisico_cabeza', 'tc_examen_fisico_cuello', 'tc_examen_fisico_torax',
                'tc_examen_fisico_abdomen', 'tc_examen_fisico_genitales', 'tc_examen_fisico_extremidades',
                'tc_examen_fisico_neurologico' );

    $tc_chkbx_examen_fisico = !isset( $tc_chkbx_examen_fisico ) ? $ef_campos : $tc_chkbx_examen_fisico;

    foreach( $tc_chkbx_examen_fisico as $valor ) {
        if( isset( ${$valor} ) && !empty( ${$valor} ) ) { ?>

        <span style="font-weight: bold;"><?=$this->lang->line($valor)?>:</span></br>
        <?=nl2br( ${$valor} )?><br/><br/>

<?php   }
    }
}

if( $modo == FormularioXML::$MODO_ESCRITURA) { ?>
<style type="text/css">
    .plantilla_agregar {
        cursor: pointer;
        vertical-align: middle;
    }
</style>

<script language="javascript" type="text/javascript">

    $(document).ready( function( ) {

        tc_examen_plantillas = new Array();

        // Selección de plantilla: Cabeza
        $('#plantilla_examen_fisico_cabeza_agregar').click( function( ) {

            if( tc_examen_plantillas.hasOwnProperty( "tc_examen_fisico_cabeza" ) ) {

                for ( var i in tc_examen_plantillas.tc_examen_fisico_cabeza )
                    if( tc_examen_plantillas.tc_examen_fisico_cabeza[i].id == $('#plantilla_examen_fisico_cabeza').val() )
                        $('#tc_examen_fisico_cabeza').val( $('#tc_examen_fisico_cabeza').val()+'<br/>'+ tc_examen_plantillas.tc_examen_fisico_cabeza[i].texto );
            }
        } );

        // Selección de plantilla: Cuello
        $('#plantilla_examen_fisico_cuello_agregar').click( function( ) {

            if( tc_examen_plantillas.hasOwnProperty( "tc_examen_fisico_cuello" ) ) {

                for ( var i in tc_examen_plantillas.tc_examen_fisico_cuello )
                    if( tc_examen_plantillas.tc_examen_fisico_cuello[i].id == $('#plantilla_examen_fisico_cuello').val() )
                        $('#tc_examen_fisico_cuello').val( $('#tc_examen_fisico_cuello').val()+'<br/>'+ tc_examen_plantillas.tc_examen_fisico_cuello[i].texto );
            }
        } );

        // Selección de plantilla: Tórax
        $('#plantilla_examen_fisico_torax_agregar').click( function( ) {
            if( tc_examen_plantillas.hasOwnProperty( "tc_examen_fisico_torax" ) ) {

                for ( var i in tc_examen_plantillas.tc_examen_fisico_torax )
                    if( tc_examen_plantillas.tc_examen_fisico_torax[i].id == $('#plantilla_examen_fisico_torax').val() )
                        $('#tc_examen_fisico_torax').val( $('#tc_examen_fisico_torax').val()+'<br/>'+ tc_examen_plantillas.tc_examen_fisico_torax[i].texto );
            }
        } );

        // Selección de plantilla: Abdomen
        $('#plantilla_examen_fisico_abdomen_agregar').click( function( ) {
            if( tc_examen_plantillas.hasOwnProperty( "tc_examen_fisico_abdomen" ) ) {

                for ( var i in tc_examen_plantillas.tc_examen_fisico_abdomen )
                    if( tc_examen_plantillas.tc_examen_fisico_abdomen[i].id == $('#plantilla_examen_fisico_abdomen').val() )
                        $('#tc_examen_fisico_abdomen').val( $('#tc_examen_fisico_abdomen').val()+'<br/>'+ tc_examen_plantillas.tc_examen_fisico_abdomen[i].texto );
            }
        } );

        // Selección de plantilla: Genitales
        $('#plantilla_examen_fisico_genitales_agregar').click( function( ) {
            if( tc_examen_plantillas.hasOwnProperty( "tc_examen_fisico_genitales" ) ) {

                for ( var i in tc_examen_plantillas.tc_examen_fisico_genitales )
                    if( tc_examen_plantillas.tc_examen_fisico_genitales[i].id == $('#plantilla_examen_fisico_genitales').val() )
                        $('#tc_examen_fisico_genitales').val( $('#tc_examen_fisico_genitales').val()+'<br/>'+ tc_examen_plantillas.tc_examen_fisico_genitales[i].texto );
            }
        } );

        // Selección de plantilla: Extremidades
        $('#plantilla_examen_fisico_extremidades_agregar').click( function( ) {
            if( tc_examen_plantillas.hasOwnProperty( "tc_examen_fisico_extremidades" ) ) {

                for ( var i in tc_examen_plantillas.tc_examen_fisico_extremidades )
                    if( tc_examen_plantillas.tc_examen_fisico_extremidades[i].id == $('#plantilla_examen_fisico_extremidades').val() )
                        $('#tc_examen_fisico_extremidades').val( $('#tc_examen_fisico_extremidades').val()+'<br/>'+ tc_examen_plantillas.tc_examen_fisico_extremidades[i].texto );
            }
        } );

        // Selección de plantilla: Neurologico
        $('#plantilla_examen_fisico_neurologico_agregar').click( function( ) {
            if( tc_examen_plantillas.hasOwnProperty( "tc_examen_fisico_neurologico" ) ) {

                for ( var i in tc_examen_plantillas.tc_examen_fisico_neurologico )
                    if( tc_examen_plantillas.tc_examen_fisico_neurologico[i].id == $('#plantilla_examen_fisico_neurologico').val() )
                        $('#tc_examen_fisico_neurologico').val( $('#tc_examen_fisico_neurologico').val()+'<br/>'+ tc_examen_plantillas.tc_examen_fisico_neurologico[i].texto );
            }
        } );

        $.getJSON(
            '<?=base_url()?>platc/plantillas_get/'+Math.random( ),
            {},
            function( data ) {

                tc_examen_plantillas = data;

                // Carga listado examen físico cabeza
                option = "";
                if( data.hasOwnProperty( "tc_examen_fisico_cabeza" ) ) {

                    // Genera select
                    for( var i in data.tc_examen_fisico_cabeza )
                        option+= "<option value="+data.tc_examen_fisico_cabeza[i].id+">"+data.tc_examen_fisico_cabeza[i].nombre+"</option>";

                    // Empotra listado de plantillas al dropdown
                    $('#plantilla_examen_fisico_cabeza').append( option );
                }

                // Carga listado examen físico cuello
                option = "";
                if( data.hasOwnProperty( "tc_examen_fisico_cuello" ) ) {

                    // Genera select
                    for( var i in data.tc_examen_fisico_cuello )
                        option+= "<option value="+data.tc_examen_fisico_cuello[i].id+">"+data.tc_examen_fisico_cuello[i].nombre+"</option>";

                    // Empotra listado de plantillas al dropdown
                    $('#plantilla_examen_fisico_cuello').append( option );
                }

                // Carga listado examen físico tórax
                option = "";
                if( data.hasOwnProperty( "tc_examen_fisico_torax" ) ) {

                    // Genera select
                    for( var i in data.tc_examen_fisico_torax )
                        option+= "<option value="+data.tc_examen_fisico_torax[i].id+">"+data.tc_examen_fisico_torax[i].nombre+"</option>";

                    // Empotra listado de plantillas al dropdown
                    $('#plantilla_examen_fisico_torax').append( option );
                }

                // Carga listado examen físico abdomen
                option = "";
                if( data.hasOwnProperty( "tc_examen_fisico_abdomen" ) ) {

                    // Genera select
                    for( var i in data.tc_examen_fisico_abdomen )
                        option+= "<option value="+data.tc_examen_fisico_abdomen[i].id+">"+data.tc_examen_fisico_abdomen[i].nombre+"</option>";

                    // Empotra listado de plantillas al dropdown
                    $('#plantilla_examen_fisico_abdomen').append( option );
                }

                // Carga listado examen físico genitales
                option = "";
                if( data.hasOwnProperty( "tc_examen_fisico_genitales" ) ) {

                    // Genera select
                    for( var i in data.tc_examen_fisico_genitales )
                        option+= "<option value="+data.tc_examen_fisico_genitales[i].id+">"+data.tc_examen_fisico_genitales[i].nombre+"</option>";

                    // Empotra listado de plantillas al dropdown
                    $('#plantilla_examen_fisico_genitales').append( option );
                }

                // Carga listado examen físico extremidades
                option = "";
                if( data.hasOwnProperty( "tc_examen_fisico_extremidades" ) ) {

                    // Genera select
                    for( var i in data.tc_examen_fisico_extremidades )
                        option+= "<option value="+data.tc_examen_fisico_extremidades[i].id+">"+data.tc_examen_fisico_extremidades[i].nombre+"</option>";

                    // Empotra listado de plantillas al dropdown
                    $('#plantilla_examen_fisico_extremidades').append( option );
                }

                // Carga listado examen físico neurologico
                option = "";
                if( data.hasOwnProperty( "tc_examen_fisico_neurologico" ) ) {

                    // Genera select
                    for( var i in data.tc_examen_fisico_neurologico )
                        option+= "<option value="+data.tc_examen_fisico_neurologico[i].id+">"+data.tc_examen_fisico_neurologico[i].nombre+"</option>";

                    // Empotra listado de plantillas al dropdown
                    $('#plantilla_examen_fisico_neurologico').append( option );
                }

            }
        );
    } );

</script>

<br />

<!-- 1: Cabeza -->
<div>
    <span style="font-weight: bold;"><?= $this->lang->line('tc_examen_fisico_cabeza') ?></span>
    <?= $this->lang->line('tc_examen_fisico_cabeza_desc') ?> <br/>
    <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_fisico_cabeza"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
    <img src="<?=base_url()?>images/check.png" id ="plantilla_examen_fisico_cabeza_agregar" class="plantilla_agregar" />
    <textarea name="tc_examen_fisico_cabeza" id="tc_examen_fisico_cabeza" style="width: 100%;"><?php echo isset( $tc_examen_fisico_cabeza ) ? nl2br( $tc_examen_fisico_cabeza ) : NULL; ?></textarea>
</div>
<br/>

<!-- 2: Cuello -->
<div>
    <span style="font-weight: bold;"><?= $this->lang->line('tc_examen_fisico_cuello') ?></span>
    <?= $this->lang->line('tc_examen_fisico_cuello_desc') ?> <br/>
    <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_fisico_cuello"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
    <img src="<?=base_url()?>images/check.png" id ="plantilla_examen_fisico_cuello_agregar" class="plantilla_agregar" />
    <textarea name="tc_examen_fisico_cuello" id="tc_examen_fisico_cuello" style="width: 100%;"><?php echo isset( $tc_examen_fisico_cuello ) ? nl2br( $tc_examen_fisico_cuello ) : NULL; ?></textarea>
</div>
<br/>

<!-- 3: Tórax -->
<div>
    <span style="font-weight: bold;"><?= $this->lang->line('tc_examen_fisico_torax') ?></span>
    <?= $this->lang->line('tc_examen_fisico_torax_desc') ?> <br/>
    <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_fisico_torax"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
    <img src="<?=base_url()?>images/check.png" id ="plantilla_examen_fisico_torax_agregar" class="plantilla_agregar" />
    <textarea name="tc_examen_fisico_torax" id="tc_examen_fisico_torax" style="width: 100%;"><?php echo isset( $tc_examen_fisico_torax ) ? nl2br( $tc_examen_fisico_torax ) : NULL; ?></textarea>
</div>
<br/>

<!-- 4: Abdomen -->
<div>
    <span style="font-weight: bold;"><?= $this->lang->line('tc_examen_fisico_abdomen') ?></span>
    <?= $this->lang->line('tc_examen_fisico_abdomen_desc') ?> <br/>
    <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_fisico_abdomen"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
    <img src="<?=base_url()?>images/check.png" id ="plantilla_examen_fisico_abdomen_agregar" class="plantilla_agregar" />
    <textarea name="tc_examen_fisico_abdomen" id="tc_examen_fisico_abdomen" style="width: 100%;"><?php echo isset( $tc_examen_fisico_abdomen ) ? nl2br( $tc_examen_fisico_abdomen ) : NULL; ?></textarea>
</div>
<br/>

<!-- 5: Genitales -->
<div>
    <span style="font-weight: bold;"><?= $this->lang->line('tc_examen_fisico_genitales') ?></span>
    <br/>
    <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_fisico_genitales"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
    <img src="<?=base_url()?>images/check.png" id ="plantilla_examen_fisico_genitales_agregar" class="plantilla_agregar" />
    <textarea name="tc_examen_fisico_genitales" id="tc_examen_fisico_genitales" style="width: 100%;"><?php echo isset( $tc_examen_fisico_genitales ) ? nl2br( $tc_examen_fisico_genitales ) : NULL; ?></textarea>
</div>
<br/>

<!-- 6: Extremidades -->
<div>
    <span style="font-weight: bold;"><?= $this->lang->line('tc_examen_fisico_extremidades') ?></span>
    <?= $this->lang->line('tc_examen_fisico_extremidades_desc') ?> <br/>
    <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_fisico_extremidades"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
    <img src="<?=base_url()?>images/check.png" id ="plantilla_examen_fisico_extremidades_agregar" class="plantilla_agregar" />
    <textarea name="tc_examen_fisico_extremidades" id="tc_examen_fisico_extremidades" style="width: 100%;"><?php echo isset( $tc_examen_fisico_extremidades ) ? nl2br( $tc_examen_fisico_extremidades ) : NULL; ?></textarea>
</div>
<br/>

<!-- 7: Neurológico -->
<div>
    <span style="font-weight: bold;"><?= $this->lang->line('tc_examen_fisico_neurologico') ?></span>
    <?= $this->lang->line('tc_examen_fisico_neurologico_desc') ?> <br/>
    <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_fisico_neurologico"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
    <img src="<?=base_url()?>images/check.png" id ="plantilla_examen_fisico_neurologico_agregar" class="plantilla_agregar" />
    <textarea name="tc_examen_fisico_neurologico" id="tc_examen_fisico_neurologico" style="width: 100%;"><?php echo isset( $tc_examen_fisico_neurologico ) ? nl2br( $tc_examen_fisico_neurologico ) : NULL; ?></textarea>
</div>
<br/>
<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    $ef_campos = array( 'tc_examen_fisico_cabeza', 'tc_examen_fisico_cuello', 'tc_examen_fisico_torax',
                'tc_examen_fisico_abdomen', 'tc_examen_fisico_genitales', 'tc_examen_fisico_extremidades',
                'tc_examen_fisico_neurologico' );

    $tc_chkbx_examen_fisico = !isset( $tc_chkbx_examen_fisico ) ? $ef_campos : $tc_chkbx_examen_fisico;

    $x = $pdf->GetX();

    foreach( $tc_chkbx_examen_fisico as $valor ) {

        $pdf->SetFont( 'Arial', 'B' );
        $pdf->MultiCell( 0, 6, html_entity_decode( $this->lang->line( $valor ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 'L', false, 0 );
        $pdf->SetX( $x );

        $pdf->SetFont( 'Arial' );
        $pdf->MultiCell( 0, 6, utf8_decode( ${$valor} ), 0, 'L', false, 0 );
        $pdf->Ln();
        $pdf->SetX( $x );
    }
}

