<?php

if( $modo == FormularioXML::$MODO_LECTURA ) { ?>

<table cellspacing="0" cellpadding="0" border="0" width="100%" align="center">
    <tbody>

        <tr>
            <td class="data_form"><?= $this->lang->line('p_sexo') ?>: </td>
            <td align="left" style="width: 100%"><?=( isset( $tc['TEL_PAC_SEXO'] ) && !empty( $tc['TEL_PAC_SEXO'] ) && $tc['TEL_PAC_SEXO'] == "M" ) ? $this->lang->line('p_masculino') : $this->lang->line('p_femenino') ?></td>
        </tr>
        <tr>
            <td class="data_form"><?= $this->lang->line('nutricion_medida_muneca') ?>: </td>
            <td align="left" style="width: 100%"><?=( isset( $eo_medida_muneca ) && !empty( $eo_medida_muneca ) ) ? $eo_medida_muneca : '' ?> <?=$this->lang->line('cm')?></td>
        </tr>
        <tr>
            <td class="data_form"><?= $this->lang->line('nutricion_altura') ?>: </td>
            <td align="left" style="width: 100%"><?=( isset( $eo_altura ) && !empty( $eo_altura ) ) ? $eo_altura : '' ?> <?=$this->lang->line('cm')?></td>
        </tr>
        <tr>
            <td class="data_form"><?= $this->lang->line('nutricion_medida_estructura') ?>: </td>
            <td align="left" style="width: 100%"><?=( isset( $eo_medida_estructura ) && !empty( $eo_medida_estructura ) ) ? $eo_medida_estructura : '' ?></td>
        </tr>
        <tr>
            <td class="data_form"><?= $this->lang->line('nutricion_tipo_estructura') ?>: </td>
            <td align="left" style="width: 100%"><?php

                /*
                 * Retorna texto en función del sexo y de la ponderación del tipo de
                 * estructura del paciente
                 */
                switch( $tc['TEL_PAC_SEXO'] ) {

                    case "M" : {if( $eo_medida_estructura < 9.6 )   $texto = $this->lang->line('nutricion_estructura_grande');
                                if( $eo_medida_estructura >= 9.6 && $eo_medida_estructura <= 10.4 )  $texto = $this->lang->line('nutricion_estructura_mediana');
                                if( $eo_medida_estructura > 10.4 ) $texto = $this->lang->line('nutricion_estructura_pequena');
                    }; break;

                    case "F" : {if( $eo_medida_estructura < 10.1 ) $texto = $this->lang->line('nutricion_estructura_grande');
                                if( $eo_medida_estructura >= 10.1 && $eo_medida_estructura <= 11 )   $texto = $this->lang->line('nutricion_estructura_mediana');
                                if( $eo_medida_estructura > 11 )  $texto = $this->lang->line('nutricion_estructura_pequena');
                    }; break;

                    default: return "-"; break;
                }

                echo $texto;
            ?> </td>
        </tr>
        <tr>
            <td class="data_form"><?= $this->lang->line('nutricion_peso_ideal') ?>: </td>
            <td align="left" style="width: 100%"><?=( isset( $eo_peso_ideal ) && !empty( $eo_peso_ideal ) ) ? $eo_peso_ideal : '' ?> <?=$this->lang->line('kg')?></td>
        </tr>
    </tbody>
</table>

<?php }

if( $modo == FormularioXML::$MODO_ESCRITURA ) { ?>

<script language="javascript" type="text/javascript">

    var tipo_estructura = [ { tag: "e_g", nombre: "<?=$this->lang->line('nutricion_estructura_grande')?>" },
                            { tag: "e_m", nombre: "<?=$this->lang->line('nutricion_estructura_mediana')?>" },
                            { tag: "e_p", nombre: "<?=$this->lang->line('nutricion_estructura_pequena')?>" } ];

    function calcular_peso_ideal( altura, tag ) {

        var peso_ideal = 0;
        switch( tag ) {
            case "e_g" : peso_ideal = Math.round( ( ( ( altura / 100 ) *  ( altura / 100 ) ) * 25 ) * 10 ) / 10; break;
            case "e_m" : peso_ideal = Math.round( ( ( ( altura / 100 ) *  ( altura / 100 ) ) * 22.5 ) * 10 ) / 10; break;
            case "e_p" : peso_ideal = Math.round( ( ( ( altura / 100 ) *  ( altura / 100 ) ) * 20 ) * 10 ) / 10; break;
            default: peso_ideal = 0;
        }

        return peso_ideal;
    }

    /*
     * Retorna texto en función del sexo y de la ponderación del tipo de
     * estructura del paciente
     */
    function calcular_tipo_estructura_peso_ideal ( sexo, ponderacion ) {

        switch( sexo ) {

            case "M" : {
                if( ponderacion < 9.6 )
                    for( var i in tipo_estructura )
                        if( tipo_estructura[i].tag == "e_g" ) {
                            $('#eo_peso_ideal').val( calcular_peso_ideal( parseInt( $('#eo_altura').val() ), "e_g" ) );
                            $('#eo_tipo_estructura').html( tipo_estructura[i].nombre );
                        };

                if( ponderacion >= 9.6 && ponderacion <= 10.4 )
                    for( var i in tipo_estructura )
                        if( tipo_estructura[i].tag == "e_m" ) {
                            $('#eo_peso_ideal').val( calcular_peso_ideal( parseInt( $('#eo_altura').val() ), "e_m" ) );
                            $('#eo_tipo_estructura').html( tipo_estructura[i].nombre );
                        };

                if( ponderacion > 10.4 )
                    for( var i in tipo_estructura )
                        if( tipo_estructura[i].tag == "e_p" ) {
                            $('#eo_peso_ideal').val( calcular_peso_ideal( parseInt( $('#eo_altura').val() ), "e_p" ) );
                            $('#eo_tipo_estructura').html( tipo_estructura[i].nombre );
                        };
            }; break;

            case "F" : {
                if( ponderacion < 10.1 )
                    for( var i in tipo_estructura )
                        if( tipo_estructura[i].tag == "e_g" ) {
                            $('#eo_peso_ideal').val( calcular_peso_ideal( parseInt( $('#eo_altura').val() ), "e_g" ) );
                            $('#eo_tipo_estructura').html( tipo_estructura[i].nombre );
                        };

                if( ponderacion >= 10.1 && ponderacion <= 11 )
                    for( var i in tipo_estructura )
                        if( tipo_estructura[i].tag == "e_m" ) {
                            $('#eo_peso_ideal').val( calcular_peso_ideal( parseInt( $('#eo_altura').val() ), "e_m" ) );
                            $('#eo_tipo_estructura').html( tipo_estructura[i].nombre );
                        };

                if( ponderacion > 11 )
                    for( var i in tipo_estructura )
                        if( tipo_estructura[i].tag == "e_p" ) {
                            $('#eo_peso_ideal').val( calcular_peso_ideal( parseInt( $('#eo_altura').val() ), "e_p" ) );
                            $('#eo_tipo_estructura').html( tipo_estructura[i].nombre );
                        };
            }; break;

            default: return "-"; break;
        }

    }

    $(document).ready( function( ) {

        $('#eo_medida_muneca').blur( function( ) {

            eo_altura        = parseInt( $('#eo_altura').val( ) );
            eo_medida_muneca = parseInt( $(this).val( ) );

            if( !isNaN( eo_altura ) && !isNaN( eo_medida_muneca ) ) {
                ponderacion = Math.round( ( parseInt( eo_altura ) / parseInt( eo_medida_muneca ) ) * 10 ) / 10;
                $('#eo_medida_estructura').val( ponderacion );
                calcular_tipo_estructura_peso_ideal( "<?=( isset( $tc['TEL_PAC_SEXO'] ) && !empty( $tc['TEL_PAC_SEXO'] ) ) ? $tc['TEL_PAC_SEXO'] : "" ?>", ponderacion );
            }
        } );

        // Agrega funcionalidad de carga de valor de talla al campo "df_talla" del parcial datos_fisicos
        $('#df_talla').blur( function( ) {

            $('#eo_altura').val( $(this).val() );
            $('#eo_altura').blur();
        } ) ;

        $('#eo_altura').blur( function( ) {

            eo_altura        = parseInt( $(this).val() );
            eo_medida_muneca = parseInt( $('#eo_medida_muneca').val( ) );

            if( !isNaN( eo_altura ) && !isNaN( eo_medida_muneca ) ) {
                ponderacion = Math.round( ( parseInt( eo_altura ) / parseInt( eo_medida_muneca ) ) * 10 ) / 10;
                $('#eo_medida_estructura').val( ponderacion );
                calcular_tipo_estructura_peso_ideal( "<?=( isset( $tc['TEL_PAC_SEXO'] ) && !empty( $tc['TEL_PAC_SEXO'] ) ) ? $tc['TEL_PAC_SEXO'] : "" ?>", ponderacion );
            }
        } );

        $('#eo_tipo_estructura').html( calcular_tipo_estructura_peso_ideal( "<?=( isset( $tc['TEL_PAC_SEXO'] ) && !empty( $tc['TEL_PAC_SEXO'] ) ) ? $tc['TEL_PAC_SEXO'] : "" ?>", $('#eo_medida_estructura').val( ) ) );
    } );

</script>

<table cellspacing="0" cellpadding="0" border="0" width="100%" align="center">
    <tbody>

        <tr>
            <td class="data_form"><span class="redtext">*</span>&nbsp;<?= $this->lang->line('p_sexo') ?>: </td>
            <td align="left" style="width: 100%"><input type="text" name="eo_sexo" id="eo_sexo" value="<?=( isset( $tc['TEL_PAC_SEXO'] ) && !empty( $tc['TEL_PAC_SEXO'] ) && $tc['TEL_PAC_SEXO'] == "M" ) ? $this->lang->line('p_masculino') : $this->lang->line('p_femenino') ?>" class="validate[required]" readonly /></td>
        </tr>
        <tr>
            <td class="data_form"><span class="redtext">*</span>&nbsp;<?= $this->lang->line('nutricion_medida_muneca') ?>: </td>
            <td align="left" style="width: 100%"><input type="text" name="eo_medida_muneca" id="eo_medida_muneca" value="<?=( isset( $eo_medida_muneca ) && !empty( $eo_medida_muneca ) ) ? $eo_medida_muneca : '' ?>" class="validate[required]" /> <?=$this->lang->line('cm')?></td>
        </tr>
        <tr>
            <td class="data_form"><span class="redtext">*</span>&nbsp;<?= $this->lang->line('nutricion_altura') ?>: </td>
            <td align="left" style="width: 100%"><input type="text" name="eo_altura" id="eo_altura" value="<?=( isset( $eo_altura ) && !empty( $eo_altura ) ) ? $eo_altura : '' ?>" class="validate[required]" readonly /> <?=$this->lang->line('cm')?></td>
        </tr>
        <tr>
            <td class="data_form"><?= $this->lang->line('nutricion_medida_estructura') ?>: </td>
            <td align="left" style="width: 100%"><input type="text" name="eo_medida_estructura" id="eo_medida_estructura" value="<?=( isset( $eo_medida_estructura ) && !empty( $eo_medida_estructura ) ) ? $eo_medida_estructura : '' ?>" class="validate[required]" readonly /></td>
        </tr>
        <tr>
            <td class="data_form"><?= $this->lang->line('nutricion_tipo_estructura') ?>: </td>
            <td align="left" style="width: 100%" ><span id="eo_tipo_estructura" ><?=( isset( $eo_tipo_estructura ) && !empty( $eo_tipo_estructura ) ) ? $eo_tipo_estructura : '' ?> </span></td>
        </tr>
        <tr>
            <td class="data_form"><?= $this->lang->line('nutricion_peso_ideal') ?>: </td>
            <td align="left" style="width: 100%"><input type="text" name="eo_peso_ideal" id="eo_peso_ideal" value="<?=( isset( $eo_peso_ideal ) && !empty( $eo_peso_ideal ) ) ? $eo_peso_ideal : '' ?>" class="validate[required]" readonly /> <?=$this->lang->line('kg')?></td>
        </tr>
    </tbody>
</table>

<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    // Sexo del paciente
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'p_sexo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 0, 6, html_entity_decode( ( isset( $tc['TEL_PAC_SEXO'] ) && !empty( $tc['TEL_PAC_SEXO'] ) && $tc['TEL_PAC_SEXO'] == "M" ) ? $this->lang->line('p_masculino') : $this->lang->line('p_femenino') , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

    // Medida muñeca
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'nutricion_medida_muneca' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 0, 6, html_entity_decode( ( ( isset( $eo_medida_muneca ) && !empty( $eo_medida_muneca ) ) ? $eo_medida_muneca : '-' ) . ' ' . $this->lang->line('cm') , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

    // Altura
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'nutricion_altura' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 0, 6, html_entity_decode( ( ( isset( $eo_altura ) && !empty( $eo_altura ) ) ? $eo_altura : '-' ) . ' ' . $this->lang->line('cm') , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

    // Medida estructura
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'nutricion_medida_estructura' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 0, 6, html_entity_decode( ( isset( $eo_medida_estructura ) && !empty( $eo_medida_estructura ) ) ? $eo_medida_estructura : '-' , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

    // Tipo de la estructura
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'nutricion_tipo_estructura' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );

    /*
     * Retorna texto en función del sexo y de la ponderación del tipo de
     * estructura del paciente
     */
    switch( $tc['TEL_PAC_SEXO'] ) {

        case "M" : {if( $eo_medida_estructura < 9.6 )   $texto = $this->lang->line('nutricion_estructura_grande');
                    if( $eo_medida_estructura >= 9.6 && $eo_medida_estructura <= 10.4 )  $texto = $this->lang->line('nutricion_estructura_mediana');
                    if( $eo_medida_estructura > 10.4 ) $texto = $this->lang->line('nutricion_estructura_pequena');
        }; break;

        case "F" : {if( $eo_medida_estructura < 10.1 ) $texto = $this->lang->line('nutricion_estructura_grande');
                    if( $eo_medida_estructura >= 10.1 && $eo_medida_estructura <= 11 )   $texto = $this->lang->line('nutricion_estructura_mediana');
                    if( $eo_medida_estructura > 11 )  $texto = $this->lang->line('nutricion_estructura_pequena');
        }; break;

        default: return "-"; break;
    }
    $pdf->Cell( 0, 6, html_entity_decode( ( isset( $texto ) && !empty( $texto ) ) ? $texto : '-' , ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

    // Medida estructura
    $pdf->Cell( 50, 6, html_entity_decode( $this->lang->line( 'nutricion_peso_ideal' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->Cell( 0, 6, html_entity_decode( ( isset( $eo_peso_ideal ) && !empty( $eo_peso_ideal ) ) ? $eo_peso_ideal : '-' ) . ' ' . $this->lang->line('kg', ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 1, 'L' );

} ?>
