<?php

if( $modo == FormularioXML::$MODO_LECTURA ) { ?>

<style type="text/css">
    .plantilla_agregar {
        cursor: pointer;
        vertical-align: middle;
    }

    .examen_externo_ojos {
        padding: 0px 10px;
    }

    .examen_externo_ojos_div_izquierdo {
        float: left;
        width: 365px;
    }

    .examen_externo_ojos_div_derecho {
        float: right;
        width: 366px;
        border-left: 1px solid rgb(170, 170, 170);
        border-color: rgb(170, 170, 170);
        border-width: 1px;
    }

    .examen_externo_ojos .titulo {
        font-size: 18px;
        margin: 10px 0;
        text-align: center;
    }
</style>

<div class="examen_externo_ojos examen_externo_ojos_div_izquierdo">

    <div class="titulo"><?=$this->lang->line('oftalmologia_izquierdo')?></div>

    <!-- 1: Parpado -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_parpado') ?>: </span> &nbsp; <?=( isset( $examen_externo_izquierdo_parpado ) && (int)$examen_externo_izquierdo_parpado == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_izquierdo_parpado_observaciones ) ? nl2br( $examen_externo_izquierdo_parpado_observaciones ) : NULL; ?>
    </div>
    <br/>

    <!-- 2: Orbita -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_orbita') ?>: </span> &nbsp; <?=( isset( $examen_externo_izquierdo_orbita ) && $examen_externo_izquierdo_orbita == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_izquierdo_orbita_observaciones ) ? nl2br( $examen_externo_izquierdo_orbita_observaciones ) : NULL; ?>
    </div>
    <br/>

    <!-- 3: Conjuntiva -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_conjuntiva') ?>: </span> &nbsp; <?=( !isset( $examen_externo_izquierdo_conjuntiva ) || $examen_externo_izquierdo_conjuntiva == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_izquierdo_conjuntiva_observaciones ) ? nl2br( $examen_externo_izquierdo_conjuntiva_observaciones ) : NULL; ?>
    </div>
    <br/>

    <!-- 4: Cornea -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_cornea') ?>: </span> &nbsp; <?=( !isset( $examen_externo_izquierdo_cornea ) || $examen_externo_izquierdo_cornea == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_izquierdo_cornea_observaciones ) ? nl2br( $examen_externo_izquierdo_cornea_observaciones ) : NULL; ?>
    </div>
    <br/>

    <!-- 5: Iris y Pupila -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_iris_pupila') ?>: </span> &nbsp; <?=( !isset( $examen_externo_izquierdo_iris_pupila ) || $examen_externo_izquierdo_iris_pupila == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_izquierdo_iris_pupila_observaciones ) ? nl2br( $examen_externo_izquierdo_iris_pupila_observaciones ) : NULL; ?>
    </div>
    <br/>

</div>

<div  class="examen_externo_ojos examen_externo_ojos_div_derecho">

    <div class="titulo"><?=$this->lang->line('oftalmologia_derecho')?></div>


    <!-- 1: Parpado -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_parpado') ?>: </span> &nbsp; <?=( !isset( $examen_externo_derecho_parpado ) || $examen_externo_derecho_parpado == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_derecho_parpado_observaciones ) ? nl2br( $examen_externo_derecho_parpado_observaciones ) : NULL; ?>
    </div>
    <br/>

    <!-- 2: Orbita -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_orbita') ?>: </span> &nbsp; <?=( !isset( $examen_externo_derecho_orbita ) || $examen_externo_derecho_orbita == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_derecho_orbita_observaciones ) ? nl2br( $examen_externo_derecho_orbita_observaciones ) : NULL; ?>
    </div>
    <br/>

    <!-- 3: Conjuntiva -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_conjuntiva') ?>: </span> &nbsp; <?=( !isset( $examen_externo_derecho_conjuntiva ) || $examen_externo_derecho_conjuntiva == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_derecho_conjuntiva_observaciones ) ? nl2br( $examen_externo_derecho_conjuntiva_observaciones ) : NULL; ?>
    </div>
    <br/>

    <!-- 4: Cornea -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_cornea') ?>: </span> &nbsp; <?=( !isset( $examen_externo_derecho_cornea ) || $examen_externo_derecho_cornea == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_derecho_cornea_observaciones ) ? nl2br( $examen_externo_derecho_cornea_observaciones ) : NULL; ?>
    </div>
    <br/>

    <!-- 5: Iris y Pupila -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_iris_pupila') ?>: </span> &nbsp; <?=( !isset( $examen_externo_derecho_iris_pupila ) || $examen_externo_derecho_iris_pupila == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal') ?>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> <br/>
        <?= isset( $examen_externo_derecho_iris_pupila_observaciones ) ? nl2br( $examen_externo_derecho_iris_pupila_observaciones ) : NULL; ?>
    </div>
    <br/>

</div>

<?php
}

if( $modo == FormularioXML::$MODO_ESCRITURA) { ?>
<style type="text/css">
    .plantilla_agregar {
        cursor: pointer;
        vertical-align: middle;
    }

    .examen_externo_ojos {
        padding: 0px 10px;
    }

    .examen_externo_ojos_div_izquierdo {
        float: left;
        width: 365px;
    }

    .examen_externo_ojos_div_derecho {
        float: right;
        width: 366px;
        border-left: 1px solid rgb(170, 170, 170);
        border-color: rgb(170, 170, 170);
        border-width: 1px;
    }

    .examen_externo_ojos .titulo {
        font-size: 18px;
        margin: 10px 0;
        text-align: center;
    }
</style>

<script language="javascript" type="text/javascript">

    $(document).ready( function( ) {

        examen_externo_plantillas = new Array();

        /*
         * Lado izquierdo
         */
        // Parpado
        $('#plantilla_examen_externo_izquierdo_parpado_agregar').click( function( ) {

            if( examen_externo_plantillas.hasOwnProperty( "examen_externo_parpado" ) ) {

                for ( var i in examen_externo_plantillas.examen_externo_parpado )
                    if( examen_externo_plantillas.examen_externo_parpado[i].id == parseInt( $('#plantilla_examen_externo_izquierdo_parpado').val() ) )
                        $('#examen_externo_izquierdo_parpado_observaciones').val( ( ( $('#examen_externo_izquierdo_parpado_observaciones').val() == "" ) ? examen_externo_plantillas.examen_externo_parpado[i].texto : $('#examen_externo_izquierdo_parpado_observaciones').val() + '<br />' + examen_externo_plantillas.examen_externo_parpado[i].texto  ) );
            }
        } );

        // Orbita
        $('#plantilla_examen_externo_izquierdo_orbita_agregar').click( function( ) {

            if( examen_externo_plantillas.hasOwnProperty( "examen_externo_orbita" ) ) {

                for ( var i in examen_externo_plantillas.examen_externo_orbita )
                    if( examen_externo_plantillas.examen_externo_orbita[i].id == $('#plantilla_examen_externo_izquierdo_orbita').val() )
                        $('#examen_externo_izquierdo_orbita_observaciones').val( ( ( $('#examen_externo_izquierdo_orbita_observaciones').val() == "" ) ? examen_externo_plantillas.examen_externo_orbita[i].texto : $('#examen_externo_izquierdo_orbita_observaciones').val() + '<br />' + examen_externo_plantillas.examen_externo_orbita[i].texto  ) );
            }
        } );

        // Conjuntiva
        $('#plantilla_examen_externo_izquierdo_conjuntiva_agregar').click( function( ) {
            if( examen_externo_plantillas.hasOwnProperty( "examen_externo_conjuntiva" ) ) {

                for ( var i in examen_externo_plantillas.examen_externo_conjuntiva )
                    if( examen_externo_plantillas.examen_externo_conjuntiva[i].id == $('#plantilla_examen_externo_izquierdo_conjuntiva').val() )
                        $('#examen_externo_izquierdo_conjuntiva_observaciones').val( ( ( $('#examen_externo_izquierdo_conjuntiva_observaciones').val() == "" ) ? examen_externo_plantillas.examen_externo_conjuntiva[i].texto : $('#examen_externo_izquierdo_conjuntiva_observaciones').val() + '<br />' + examen_externo_plantillas.examen_externo_conjuntiva[i].texto  ) );
            }
        } );

        // Córnea
        $('#plantilla_examen_externo_izquierdo_cornea_agregar').click( function( ) {
            if( examen_externo_plantillas.hasOwnProperty( "examen_externo_cornea" ) ) {

                for ( var i in examen_externo_plantillas.examen_externo_cornea )
                    if( examen_externo_plantillas.examen_externo_cornea[i].id == $('#plantilla_examen_externo_izquierdo_cornea').val() )
                        $('#examen_externo_izquierdo_cornea_observaciones').val( ( ( $('#examen_externo_izquierdo_cornea_observaciones').val() == "" ) ? examen_externo_plantillas.examen_externo_cornea[i].texto : $('#examen_externo_izquierdo_cornea_observaciones').val() + '<br />' + examen_externo_plantillas.examen_externo_cornea[i].texto  ) );
            }
        } );

        // Iris y Pupila
        $('#plantilla_examen_externo_izquierdo_iris_pupila_agregar').click( function( ) {
            if( examen_externo_plantillas.hasOwnProperty( "examen_externo_iris_pupila" ) ) {

                for ( var i in examen_externo_plantillas.examen_externo_iris_pupila )
                    if( examen_externo_plantillas.examen_externo_iris_pupila[i].id == $('#plantilla_examen_externo_izquierdo_iris_pupila').val() )
                        $('#examen_externo_izquierdo_iris_pupila_observaciones').val( ( ( $('#examen_externo_izquierdo_iris_pupila_observaciones').val() == "" ) ? examen_externo_plantillas.examen_externo_iris_pupila[i].texto : $('#examen_externo_izquierdo_iris_pupila_observaciones').val() + '<br />' + examen_externo_plantillas.examen_externo_iris_pupila[i].texto  ) );
            }
        } );

        /*
         * Lado derecho
         */
        // Parpado
        $('#plantilla_examen_externo_derecho_parpado_agregar').click( function( ) {

            if( examen_externo_plantillas.hasOwnProperty( "examen_externo_parpado" ) ) {

                for ( var i in examen_externo_plantillas.examen_externo_parpado )
                    if( examen_externo_plantillas.examen_externo_parpado[i].id == parseInt( $('#plantilla_examen_externo_derecho_parpado').val() ) )
                        $('#examen_externo_derecho_parpado_observaciones').val( ( ( $('#examen_externo_derecho_parpado_observaciones').val() == "" ) ? examen_externo_plantillas.examen_externo_parpado[i].texto : $('#examen_externo_derecho_parpado_observaciones').val() + '<br />' + examen_externo_plantillas.examen_externo_parpado[i].texto  ) );
            }
        } );

        // Orbita
        $('#plantilla_examen_externo_derecho_orbita_agregar').click( function( ) {

            if( examen_externo_plantillas.hasOwnProperty( "examen_externo_orbita" ) ) {

                for ( var i in examen_externo_plantillas.examen_externo_orbita )
                    if( examen_externo_plantillas.examen_externo_orbita[i].id == $('#plantilla_examen_externo_derecho_orbita').val() )
                        $('#examen_externo_derecho_orbita_observaciones').val( ( ( $('#examen_externo_derecho_orbita_observaciones').val() == "" ) ? examen_externo_plantillas.examen_externo_orbita[i].texto : $('#examen_externo_derecho_orbita_observaciones').val() + '<br />' + examen_externo_plantillas.examen_externo_orbita[i].texto  ) );
            }
        } );

        // Conjuntiva
        $('#plantilla_examen_externo_derecho_conjuntiva_agregar').click( function( ) {
            if( examen_externo_plantillas.hasOwnProperty( "examen_externo_conjuntiva" ) ) {

                for ( var i in examen_externo_plantillas.examen_externo_conjuntiva )
                    if( examen_externo_plantillas.examen_externo_conjuntiva[i].id == $('#plantilla_examen_externo_derecho_conjuntiva').val() )
                        $('#examen_externo_derecho_conjuntiva_observaciones').val( ( ( $('#examen_externo_derecho_conjuntiva_observaciones').val() == "" ) ? examen_externo_plantillas.examen_externo_conjuntiva[i].texto : $('#examen_externo_derecho_conjuntiva_observaciones').val() + '<br />' + examen_externo_plantillas.examen_externo_conjuntiva[i].texto  ) );
            }
        } );

        // Córnea
        $('#plantilla_examen_externo_derecho_cornea_agregar').click( function( ) {
            if( examen_externo_plantillas.hasOwnProperty( "examen_externo_cornea" ) ) {

                for ( var i in examen_externo_plantillas.examen_externo_cornea )
                    if( examen_externo_plantillas.examen_externo_cornea[i].id == $('#plantilla_examen_externo_derecho_cornea').val() )
                        $('#examen_externo_derecho_cornea_observaciones').val( ( ( $('#examen_externo_derecho_cornea_observaciones').val() == "" ) ? examen_externo_plantillas.examen_externo_cornea[i].texto : $('#examen_externo_derecho_cornea_observaciones').val() + '<br />' + examen_externo_plantillas.examen_externo_cornea[i].texto  ) );
            }
        } );

        // Iris y Pupila
        $('#plantilla_examen_externo_derecho_iris_pupila_agregar').click( function( ) {
            if( examen_externo_plantillas.hasOwnProperty( "examen_externo_iris_pupila" ) ) {

                for ( var i in examen_externo_plantillas.examen_externo_iris_pupila )
                    if( examen_externo_plantillas.examen_externo_iris_pupila[i].id == $('#plantilla_examen_externo_derecho_iris_pupila').val() )
                        $('#examen_externo_derecho_iris_pupila_observaciones').val( ( ( $('#examen_externo_derecho_iris_pupila_observaciones').val() == "" ) ? examen_externo_plantillas.examen_externo_iris_pupila[i].texto : $('#examen_externo_derecho_iris_pupila_observaciones').val() + '<br />' + examen_externo_plantillas.examen_externo_iris_pupila[i].texto  ) );
            }
        } );

        $.getJSON(
            '<?=base_url()?>platc/oftalmologia_plantillas_get/'+Math.random( ),
            {},
            function( data ) {

                examen_externo_plantillas = data;

                // Carga listado: Párpado
                option = "";
                if( data.hasOwnProperty( "examen_externo_parpado" ) ) {

                    // Genera select
                    for( var i in data.examen_externo_parpado )
                        option+= "<option value="+data.examen_externo_parpado[i].id+">"+data.examen_externo_parpado[i].nombre+"</option>";

                    // Empotra listado de plantillas al dropdown
                    $('#plantilla_examen_externo_izquierdo_parpado').append( option );
                    $('#plantilla_examen_externo_derecho_parpado').append( option );
                }

                // Carga listado: Orbita
                option = "";
                if( data.hasOwnProperty( "examen_externo_orbita" ) ) {

                    // Genera select
                    for( var i in data.examen_externo_orbita )
                        option+= "<option value="+data.examen_externo_orbita[i].id+">"+data.examen_externo_orbita[i].nombre+"</option>";

                    // Empotra listado de plantillas al dropdown
                    $('#plantilla_examen_externo_izquierdo_orbita').append( option );
                    $('#plantilla_examen_externo_derecho_orbita').append( option );
                }

                // Carga listado: Conjuntiva
                option = "";
                if( data.hasOwnProperty( "examen_externo_conjuntiva" ) ) {

                    // Genera select
                    for( var i in data.examen_externo_conjuntiva )
                        option+= "<option value="+data.examen_externo_conjuntiva[i].id+">"+data.examen_externo_conjuntiva[i].nombre+"</option>";

                    // Empotra listado de plantillas al dropdown
                    $('#plantilla_examen_externo_izquierdo_conjuntiva').append( option );
                    $('#plantilla_examen_externo_derecho_conjuntiva').append( option );
                }

                // Carga listado: Córnea
                option = "";
                if( data.hasOwnProperty( "examen_externo_cornea" ) ) {

                    // Genera select
                    for( var i in data.examen_externo_cornea )
                        option+= "<option value="+data.examen_externo_cornea[i].id+">"+data.examen_externo_cornea[i].nombre+"</option>";

                    // Empotra listado de plantillas al dropdown
                    $('#plantilla_examen_externo_izquierdo_cornea').append( option );
                    $('#plantilla_examen_externo_derecho_cornea').append( option );
                }

                // Carga listado: Iris y Pupila
                option = "";
                if( data.hasOwnProperty( "examen_externo_iris_pupila" ) ) {

                    // Genera select
                    for( var i in data.examen_externo_iris_pupila )
                        option+= "<option value="+data.examen_externo_iris_pupila[i].id+">"+data.examen_externo_iris_pupila[i].nombre+"</option>";

                    // Empotra listado de plantillas al dropdown
                    $('#plantilla_examen_externo_izquierdo_iris_pupila').append( option );
                    $('#plantilla_examen_externo_derecho_iris_pupila').append( option );
                }
            }
        );
    } );

</script>

<div class="examen_externo_ojos examen_externo_ojos_div_izquierdo">

    <div class="titulo">Izquierdo</div>

    <!-- 1: Parpado -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_parpado') ?></span> &nbsp;
        <input type="radio" id="examen_externo_izquierdo_parpado_normal" name="examen_externo_izquierdo_parpado" value="1" <?=( !isset( $examen_externo_izquierdo_parpado ) || $examen_externo_izquierdo_parpado == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_parpado_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_izquierdo_parpado_anormal" name="examen_externo_izquierdo_parpado" value="2" <?=( !isset( $examen_externo_izquierdo_parpado ) || $examen_externo_izquierdo_parpado == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_parpado_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> &nbsp;
        <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_externo_izquierdo_parpado"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
        <img src="<?=base_url()?>images/check.png" id ="plantilla_examen_externo_izquierdo_parpado_agregar" class="plantilla_agregar" />
        <textarea name="examen_externo_izquierdo_parpado_observaciones" id="examen_externo_izquierdo_parpado_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_izquierdo_parpado_observaciones ) ? nl2br( $examen_externo_izquierdo_parpado_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

    <!-- 2: Orbita -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_orbita') ?></span> &nbsp;
        <input type="radio" id="examen_externo_izquierdo_orbita_normal" name="examen_externo_izquierdo_orbita" value="1" <?=( !isset( $examen_externo_izquierdo_orbita ) || $examen_externo_izquierdo_orbita == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_orbita_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_izquierdo_orbita_anormal" name="examen_externo_izquierdo_orbita" value="2" <?=( !isset( $examen_externo_izquierdo_orbita ) || $examen_externo_izquierdo_orbita == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_orbita_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> &nbsp;
        <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_externo_izquierdo_orbita"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
        <img src="<?=base_url()?>images/check.png" id ="plantilla_examen_externo_izquierdo_orbita_agregar" class="plantilla_agregar" />
        <textarea name="examen_externo_izquierdo_orbita_observaciones" id="examen_externo_izquierdo_orbita_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_izquierdo_orbita_observaciones ) ? nl2br( $examen_externo_izquierdo_orbita_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

    <!-- 3: Conjuntiva -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_conjuntiva') ?></span> &nbsp;
        <input type="radio" id="examen_externo_izquierdo_conjuntiva_normal" name="examen_externo_izquierdo_conjuntiva" value="1" <?=( !isset( $examen_externo_izquierdo_conjuntiva ) || $examen_externo_izquierdo_conjuntiva == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_conjuntiva_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_izquierdo_conjuntiva_anormal" name="examen_externo_izquierdo_conjuntiva" value="2" <?=( !isset( $examen_externo_izquierdo_conjuntiva ) || $examen_externo_izquierdo_conjuntiva == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_conjuntiva_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> &nbsp;
        <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_externo_izquierdo_conjuntiva"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
        <img src="<?=base_url()?>images/check.png" id ="plantilla_examen_externo_izquierdo_conjuntiva_agregar" class="plantilla_agregar" />
        <textarea name="examen_externo_izquierdo_conjuntiva_observaciones" id="examen_externo_izquierdo_conjuntiva_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_izquierdo_conjuntiva_observaciones ) ? nl2br( $examen_externo_izquierdo_conjuntiva_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

    <!-- 4: Cornea -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_cornea') ?></span> &nbsp;
        <input type="radio" id="examen_externo_izquierdo_cornea_normal" name="examen_externo_izquierdo_cornea" value="1" <?=( !isset( $examen_externo_izquierdo_cornea ) || $examen_externo_izquierdo_cornea == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_cornea_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_izquierdo_cornea_anormal" name="examen_externo_izquierdo_cornea" value="2" <?=( !isset( $examen_externo_izquierdo_cornea ) || $examen_externo_izquierdo_cornea == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_cornea_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> &nbsp;
        <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_externo_izquierdo_cornea"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
        <img src="<?=base_url()?>images/check.png" id ="plantilla_examen_externo_izquierdo_cornea_agregar" class="plantilla_agregar" />
        <textarea name="examen_externo_izquierdo_cornea_observaciones" id="examen_externo_izquierdo_cornea_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_izquierdo_cornea_observaciones ) ? nl2br( $examen_externo_izquierdo_cornea_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

    <!-- 5: Iris y Pupila-->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_iris_pupila') ?></span> &nbsp;
        <input type="radio" id="examen_externo_izquierdo_iris_pupila_normal" name="examen_externo_izquierdo_iris_pupila" value="1" <?=( !isset( $examen_externo_izquierdo_iris_pupila ) || $examen_externo_izquierdo_iris_pupila == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_iris_pupila_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_izquierdo_iris_pupila_anormal" name="examen_externo_izquierdo_iris_pupila" value="2" <?=( !isset( $examen_externo_izquierdo_iris_pupila ) || $examen_externo_izquierdo_iris_pupila == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_izquierdo_iris_pupila_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> &nbsp;
        <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_externo_izquierdo_iris_pupila"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
        <img src="<?=base_url()?>images/check.png" id ="plantilla_examen_externo_izquierdo_iris_pupila_agregar" class="plantilla_agregar" />
        <textarea name="examen_externo_izquierdo_iris_pupila_observaciones" id="examen_externo_izquierdo_iris_pupila_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_izquierdo_iris_pupila_observaciones ) ? nl2br( $examen_externo_izquierdo_iris_pupila_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

</div>

<div  class="examen_externo_ojos examen_externo_ojos_div_derecho">

    <div class="titulo">Derecho</div>


    <!-- 1: Parpado -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_parpado') ?></span> &nbsp;
        <input type="radio" id="examen_externo_derecho_parpado_normal" name="examen_externo_derecho_parpado" value="1" <?=( !isset( $examen_externo_derecho_parpado ) || $examen_externo_derecho_parpado == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_parpado_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_derecho_parpado_anormal" name="examen_externo_derecho_parpado" value="2" <?=( !isset( $examen_externo_derecho_parpado ) || $examen_externo_derecho_parpado == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_parpado_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> &nbsp;
        <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_externo_derecho_parpado"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
        <img src="<?=base_url()?>images/check.png" id ="plantilla_examen_externo_derecho_parpado_agregar" class="plantilla_agregar" />
        <textarea name="examen_externo_derecho_parpado_observaciones" id="examen_externo_derecho_parpado_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_derecho_parpado_observaciones ) ? nl2br( $examen_externo_derecho_parpado_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

    <!-- 2: Orbita -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_orbita') ?></span> &nbsp;
        <input type="radio" id="examen_externo_derecho_orbita_normal" name="examen_externo_derecho_orbita" value="1" <?=( !isset( $examen_externo_derecho_orbita ) || $examen_externo_derecho_orbita == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_orbita_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_derecho_orbita_anormal" name="examen_externo_derecho_orbita" value="2" <?=( !isset( $examen_externo_derecho_orbita ) || $examen_externo_derecho_orbita == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_orbita_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> &nbsp;
        <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_externo_derecho_orbita"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
        <img src="<?=base_url()?>images/check.png" id ="plantilla_examen_externo_derecho_orbita_agregar" class="plantilla_agregar" />
        <textarea name="examen_externo_derecho_orbita_observaciones" id="examen_externo_derecho_orbita_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_derecho_orbita_observaciones ) ? nl2br( $examen_externo_derecho_orbita_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

    <!-- 3: Conjuntiva -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_conjuntiva') ?></span> &nbsp;
        <input type="radio" id="examen_externo_derecho_conjuntiva_normal" name="examen_externo_derecho_conjuntiva" value="1" <?=( !isset( $examen_externo_derecho_conjuntiva ) || $examen_externo_derecho_conjuntiva == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_conjuntiva_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_derecho_conjuntiva_anormal" name="examen_externo_derecho_conjuntiva" value="2" <?=( !isset( $examen_externo_derecho_conjuntiva ) || $examen_externo_derecho_conjuntiva == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_conjuntiva_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> &nbsp;
        <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_externo_derecho_conjuntiva"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
        <img src="<?=base_url()?>images/check.png" id ="plantilla_examen_externo_derecho_conjuntiva_agregar" class="plantilla_agregar" />
        <textarea name="examen_externo_derecho_conjuntiva_observaciones" id="examen_externo_derecho_conjuntiva_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_derecho_conjuntiva_observaciones ) ? nl2br( $examen_externo_derecho_conjuntiva_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

    <!-- 4: Cornea -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_cornea') ?></span> &nbsp;
        <input type="radio" id="examen_externo_derecho_cornea_normal" name="examen_externo_derecho_cornea" value="1" <?=( !isset( $examen_externo_derecho_cornea ) || $examen_externo_derecho_cornea == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_cornea_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_derecho_cornea_anormal" name="examen_externo_derecho_cornea" value="2" <?=( !isset( $examen_externo_derecho_cornea ) || $examen_externo_derecho_cornea == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_cornea_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> &nbsp;
        <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_externo_derecho_cornea"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
        <img src="<?=base_url()?>images/check.png" id ="plantilla_examen_externo_derecho_cornea_agregar" class="plantilla_agregar" />
        <textarea name="examen_externo_derecho_cornea_observaciones" id="examen_externo_derecho_cornea_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_derecho_cornea_observaciones ) ? nl2br( $examen_externo_derecho_cornea_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

    <!-- 5: Iris y Pupila -->
    <div>
        <span style="font-weight: bold;"><?= $this->lang->line('oftalmologia_iris_pupila') ?></span> &nbsp;
        <input type="radio" id="examen_externo_derecho_iris_pupila_normal" name="examen_externo_derecho_iris_pupila" value="1" <?=( !isset( $examen_externo_derecho_iris_pupila ) || $examen_externo_derecho_iris_pupila == 1 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_iris_pupila_normal"><?=$this->lang->line('oftalmologia_normal')?></label>
        <input type="radio" id="examen_externo_derecho_iris_pupila_anormal" name="examen_externo_derecho_iris_pupila" value="2" <?=( !isset( $examen_externo_derecho_iris_pupila ) || $examen_externo_derecho_iris_pupila == 2 ) ? "checked=\"checked\"" : ""?> />
        <label for="examen_externo_derecho_iris_pupila_anormal"><?=$this->lang->line('oftalmologia_anormal')?></label>
        <br/> <?= $this->lang->line('oftalmologia_observaciones') ?> &nbsp;
        <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_externo_derecho_iris_pupila"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
        <img src="<?=base_url()?>images/check.png" id ="plantilla_examen_externo_derecho_iris_pupila_agregar" class="plantilla_agregar" />
        <textarea name="examen_externo_derecho_iris_pupila_observaciones" id="examen_externo_derecho_iris_pupila_observaciones" style="width: 100%;"><?php echo isset( $examen_externo_derecho_iris_pupila_observaciones ) ? nl2br( $examen_externo_derecho_iris_pupila_observaciones ) : NULL; ?></textarea>
    </div>
    <br/>

</div>

<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    /*
     * Ojo izquierdo
     */

    $campos = array('parpado', 'orbita', 'conjuntiva', 'cornea', 'iris_pupila' );

    $x = $pdf->GetX();

    foreach( array( 'izquierdo', 'derecho' ) as $lado ) {

        $pdf->SetFont( 'Arial', 'B' );
        $pdf->MultiCell( 0, 6, html_entity_decode( $this->lang->line( 'oftalmologia_ojo_'.$lado ) ), 0, 'L', false, 0 );

        foreach( $campos as $valor ) {

            $pdf->SetFont( 'Arial', '' );
            $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'oftalmologia_'.$valor ) ).': ', 0, 0, 'R' );
            $pdf->Cell( 0, 6, ( (int)${'examen_externo_'.$lado.'_'.$valor} == 1 ) ? $this->lang->line('oftalmologia_normal') : $this->lang->line('oftalmologia_anormal'), 0, 1, 'L' );

            if( isset( ${'examen_externo_'.$lado.'_'.$valor.'_observaciones' } ) &&
                !empty( ${'examen_externo_'.$lado.'_'.$valor.'_observaciones' } ) ) {

                $pdf->Cell( 60, 6, html_entity_decode( $this->lang->line( 'oftalmologia_observaciones' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
                $pdf->MultiCell( 0, 6, utf8_decode( ${'examen_externo_'.$lado.'_'.$valor.'_observaciones'} ), 0, 'L' );
            } else {

                $pdf->SetFont( 'Arial', 'I' );
                $pdf->Cell( 0, 6, html_entity_decode( $this->lang->line( 'oftalmologia_sin_observaciones' ) ), 0, 1, 'L' );
            }
            $pdf->Ln();
        }
    }
}

