<?php
if( $modo == FormularioXML::$MODO_LECTURA ) { ?>

<!-- Edad del paciente -->
<table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
    <tbody>

        <tr>
            <td class="data_form"><?=$this->lang->line('p_edad')?>:</td>
            <td align="left" id="info_edad" >
                <?=(isset( $pediatria_edad_anos ) && !empty( $pediatria_edad_anos ) ) ? $pediatria_edad_anos : ' -' ?> <?=$this->lang->line('annos')?>, &nbsp;
                <?=(isset( $pediatria_edad_meses ) && !empty( $pediatria_edad_meses ) ) ? $pediatria_edad_meses : ' - '?> <?=$this->lang->line('edad_meses')?>, &nbsp;
                <?=(isset( $pediatria_edad_dias ) && !empty( $pediatria_edad_dias ) ) ? $pediatria_edad_dias : ' - '?> <?=$this->lang->line('edad_dias')?>
            </td>
        </tr>

    </tbody>
</table>

<?php
    $intervalo = "";
    $anos  = ( isset( $pediatria_edad_anos ) && !empty( $pediatria_edad_anos ) ) ? $pediatria_edad_anos : '-';
    $meses = ( isset( $pediatria_edad_meses ) && !empty( $pediatria_edad_meses ) ) ? $pediatria_edad_meses : '-';
    $t_meses = $anos*12 + $meses;

        if( $t_meses > 0 && $t_meses < 1 ) { ?>

            <!-- Menor de 1 mes -->
            <table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
                <tbody>

                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_reflejo_de_moro')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_reflejo_de_moro) && !empty($pediatria_reflejo_de_moro) ) ? nl2br( $pediatria_reflejo_de_moro ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_reflejo_cocleo_palpebral')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_reflejo_cocleo_palpebral) && !empty($pediatria_reflejo_cocleo_palpebral) ) ? nl2br( $pediatria_reflejo_cocleo_palpebral ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_brazos_y_piernas_flexionadas')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_brazos_y_piernas_flexionadas) && !empty($pediatria_brazos_y_piernas_flexionadas) ) ? nl2br( $pediatria_brazos_y_piernas_flexionadas ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_observa_el_rostro')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_observa_el_rostro) && !empty($pediatria_observa_el_rostro) ) ? nl2br( $pediatria_observa_el_rostro ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_eleva_cabeza')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_eleva_cabeza) && !empty($pediatria_eleva_cabeza) ) ? nl2br( $pediatria_eleva_cabeza ) : ''?>                            </td>
                    </tr>
                </tbody>
            </table>
        <?php   }

        if( $t_meses >= 1 && $t_meses < 2 ) { ?>

            <!-- 1 mes a menos de dos meses -->
            <table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
                <tbody>

                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_vocaliza')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_vocaliza) && !empty($pediatria_vocaliza) ) ? nl2br( $pediatria_vocaliza ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_movimiento_de_piernas_alternado')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_movimiento_de_piernas_alternado) && !empty($pediatria_movimiento_de_piernas_alternado) ) ? nl2br( $pediatria_movimiento_de_piernas_alternado ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_sonrisa_social')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_sonrisa_social) && !empty($pediatria_sonrisa_social) ) ? nl2br( $pediatria_sonrisa_social ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_sigue_objetos_en_la_linea_media')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_sigue_objetos_en_la_linea_media) && !empty($pediatria_sigue_objetos_en_la_linea_media) ) ? nl2br( $pediatria_sigue_objetos_en_la_linea_media ) : ''?>                            </td>
                    </tr>
                </tbody>
            </table>
        <?php   }

        if( $t_meses >= 2 && $t_meses < 4 ) { ?>

            <!-- 2 a menos de 4 meses -->
            <table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
                <tbody>

                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_responde_al_examinador')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_responde_al_examinador) && !empty($pediatria_responde_al_examinador) ) ? nl2br( $pediatria_responde_al_examinador ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_agarra_objetos')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_agarra_objetos) && !empty($pediatria_agarra_objetos) ) ? nl2br( $pediatria_agarra_objetos ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_emite_sonidos')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_emite_sonidos) && !empty($pediatria_emite_sonidos) ) ? nl2br( $pediatria_emite_sonidos ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_sostiene_la_cabeza')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_sostiene_la_cabeza) && !empty($pediatria_sostiene_la_cabeza) ) ? nl2br( $pediatria_sostiene_la_cabeza ) : ''?>                            </td>
                    </tr>
                </tbody>
            </table>
        <?php   }

        if( $t_meses >= 4 && $t_meses < 6 ) { ?>

            <!-- 4 a menos de 6 meses -->
            <table id="4-6" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
                <tbody>

                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_intenta_alcanzar_un_juguete')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_intenta_alcanzar_un_juguete) && !empty($pediatria_intenta_alcanzar_un_juguete) ) ? nl2br( $pediatria_intenta_alcanzar_un_juguete ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_lleva_objetos_a_la_boca')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_lleva_objetos_a_la_boca) && !empty($pediatria_lleva_objetos_a_la_boca) ) ? nl2br( $pediatria_lleva_objetos_a_la_boca ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_localiza_un_sonido')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_localiza_un_sonido) && !empty($pediatria_localiza_un_sonido) ) ? nl2br( $pediatria_localiza_un_sonido ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_gira')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_gira) && !empty($pediatria_gira) ) ? nl2br( $pediatria_gira ) : ''?>                            </td>
                    </tr>
                </tbody>
            </table>
        <?php   }

        if( $t_meses >= 6 && $t_meses < 9 ) { ?>

            <!-- 6 a menos de 9 meses -->
            <table id="6-9" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
                <tbody>

                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_juega_a_taparse_y_descubrirse')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_juega_a_taparse_y_descubrirse) && !empty($pediatria_juega_a_taparse_y_descubrirse) ) ? nl2br( $pediatria_juega_a_taparse_y_descubrirse ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_trasfiere_objetos_entre_una_mano_y_otra')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_trasfiere_objetos_entre_una_mano_y_otra) && !empty($pediatria_trasfiere_objetos_entre_una_mano_y_otra) ) ? nl2br( $pediatria_trasfiere_objetos_entre_una_mano_y_otra ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_duplica_silabas')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_duplica_silabas) && !empty($pediatria_duplica_silabas) ) ? nl2br( $pediatria_duplica_silabas ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_se_sienta_sin_apoyo')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_se_sienta_sin_apoyo) && !empty($pediatria_se_sienta_sin_apoyo) ) ? nl2br( $pediatria_se_sienta_sin_apoyo ) : ''?>                            </td>
                    </tr>
                </tbody>
            </table>
        <?php   }

        if( $t_meses >= 9 && $t_meses < 12 ) { ?>

            <!-- 9 a menos de 12 meses -->
            <table id="9-12" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
                <tbody>

                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_imita_gestos')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_imita_gestos) && !empty($pediatria_imita_gestos) ) ? nl2br( $pediatria_imita_gestos ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_pinzas_superior')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_pinzas_superior) && !empty($pediatria_pinzas_superior) ) ? nl2br( $pediatria_pinzas_superior ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_jerga_jerigonza')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_jerga_jerigonza) && !empty($pediatria_jerga_jerigonza) ) ? nl2br( $pediatria_jerga_jerigonza ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_camina_con_apoyo')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_camina_con_apoyo) && !empty($pediatria_camina_con_apoyo) ) ? nl2br( $pediatria_camina_con_apoyo ) : ''?>                            </td>
                    </tr>
                </tbody>
            </table>
        <?php   }

        if( $t_meses >= 12 && $t_meses < 15 ) { ?>

            <!-- 12 a menos de 15 meses -->
            <table id="12-15" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
                <tbody>

                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_ejecuta_gestos_a_pedido')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_ejecuta_gestos_a_pedido) && !empty($pediatria_ejecuta_gestos_a_pedido) ) ? nl2br( $pediatria_ejecuta_gestos_a_pedido ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_coloca_cubos_en_un_recipiente')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_coloca_cubos_en_un_recipiente) && !empty($pediatria_coloca_cubos_en_un_recipiente) ) ? nl2br( $pediatria_coloca_cubos_en_un_recipiente ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_dice_una_palabra')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_dice_una_palabra) && !empty($pediatria_dice_una_palabra) ) ? nl2br( $pediatria_dice_una_palabra ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_camina_sin_apoyo')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_camina_sin_apoyo) && !empty($pediatria_camina_sin_apoyo) ) ? nl2br( $pediatria_camina_sin_apoyo ) : ''?>                            </td>
                    </tr>
                </tbody>
            </table>
        <?php   }

        if( $t_meses >= 15 && $t_meses < 18 ) { ?>

            <!-- 15 a menos de 18 meses -->
            <table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
                <tbody>

                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_identifica_dos_objetos')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_identifica_dos_objetos) && !empty($pediatria_identifica_dos_objetos) ) ? nl2br( $pediatria_identifica_dos_objetos ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_garabatea_espontaneamente')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_garabatea_espontaneamente) && !empty($pediatria_garabatea_espontaneamente) ) ? nl2br( $pediatria_garabatea_espontaneamente ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_dice_tres_palabras')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_dice_tres_palabras) && !empty($pediatria_dice_tres_palabras) ) ? nl2br( $pediatria_dice_tres_palabras ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_camina_para_atras')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_camina_para_atras) && !empty($pediatria_camina_para_atras) ) ? nl2br( $pediatria_camina_para_atras ) : ''?>                            </td>
                    </tr>
                </tbody>
            </table>
        <?php   }

        if( $t_meses >= 18 && $t_meses < 24 ) { ?>

            <!-- 18 a menos de 24 meses -->
            <table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
                <tbody>

                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_se_quita_la_ropa')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_se_quita_la_ropa) && !empty($pediatria_se_quita_la_ropa) ) ? nl2br( $pediatria_se_quita_la_ropa ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_construye_una_torre_de_tres_cubos')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_construye_una_torre_de_tres_cubos) && !empty($pediatria_construye_una_torre_de_tres_cubos) ) ? nl2br( $pediatria_construye_una_torre_de_tres_cubos ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_senala_dos_figuras')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_senala_dos_figuras) && !empty($pediatria_senala_dos_figuras) ) ? nl2br( $pediatria_senala_dos_figuras ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_patea_una_pelota')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_patea_una_pelota) && !empty($pediatria_patea_una_pelota) ) ? nl2br( $pediatria_patea_una_pelota ) : ''?>                            </td>
                    </tr>
                </tbody>
            </table>
        <?php   }

        if( $t_meses >= 24 && $t_meses < 30  ) { ?>

            <!-- Dos años a menos de dos años y seis meses -->
            <table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
                <tbody>

                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_se_viste_con_supervision')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_se_viste_con_supervision) && !empty($pediatria_se_viste_con_supervision) ) ? nl2br( $pediatria_se_viste_con_supervision ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_construye_torre_de_seis_cubos')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_construye_torre_de_seis_cubos) && !empty($pediatria_construye_torre_de_seis_cubos) ) ? nl2br( $pediatria_construye_torre_de_seis_cubos ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_forma_frases_con_dos_palabras')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_forma_frases_con_dos_palabras) && !empty($pediatria_forma_frases_con_dos_palabras) ) ? nl2br( $pediatria_forma_frases_con_dos_palabras ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_salta_con_ambos_pies')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_salta_con_ambos_pies) && !empty($pediatria_salta_con_ambos_pies) ) ? nl2br( $pediatria_salta_con_ambos_pies ) : ''?>                            </td>
                    </tr>
                </tbody>
            </table>
        <?php   }

        if( $t_meses >= 30 && $t_meses < 36 ) { ?>
            <!-- Dos años y seis meses a menos de tres años -->
            <table id="2_6-3_0" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
                <tbody>

                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_dice_el_nombre_de_un_amigo')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_dice_el_nombre_de_un_amigo) && !empty($pediatria_dice_el_nombre_de_un_amigo) ) ? nl2br( $pediatria_dice_el_nombre_de_un_amigo ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_imita_una_linea_vertical')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_imita_una_linea_vertical) && !empty($pediatria_imita_una_linea_vertical) ) ? nl2br( $pediatria_imita_una_linea_vertical ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_reconoce_dos_acciones')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_reconoce_dos_acciones) && !empty($pediatria_reconoce_dos_acciones) ) ? nl2br( $pediatria_reconoce_dos_acciones ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_tira_la_pelota')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_tira_la_pelota) && !empty($pediatria_tira_la_pelota) ) ? nl2br( $pediatria_tira_la_pelota ) : ''?>                            </td>
                    </tr>
                </tbody>
            </table>
        <?php   }

        if( $t_meses >= 36 && $t_meses < 42 ) { ?>

            <!-- Tres años a antes de tres años y seis mes -->
            <table id="3_0-3_6" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
                <tbody>

                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_se_pone_un_saco')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_se_pone_un_saco) && !empty($pediatria_se_pone_un_saco) ) ? nl2br( $pediatria_se_pone_un_saco ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_mueve_el_pulgar_con_mano_cerrada')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_mueve_el_pulgar_con_mano_cerrada) && !empty($pediatria_mueve_el_pulgar_con_mano_cerrada) ) ? nl2br( $pediatria_mueve_el_pulgar_con_mano_cerrada ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_comprende_dos_adjetivos')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_comprende_dos_adjetivos) && !empty($pediatria_comprende_dos_adjetivos) ) ? nl2br( $pediatria_comprende_dos_adjetivos ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_se_para_en_cada_pie_por_un_segundo')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_se_para_en_cada_pie_por_un_segundo) && !empty($pediatria_se_para_en_cada_pie_por_un_segundo) ) ? nl2br( $pediatria_se_para_en_cada_pie_por_un_segundo ) : ''?>                            </td>
                    </tr>
                </tbody>
            </table>
        <?php   }

        if( $t_meses >= 42 && $t_meses < 48 ) { ?>

            <!-- Tres años y seis meses a antes de cuatro años -->
            <table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
                <tbody>

                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_aparea_colores')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_aparea_colores) && !empty($pediatria_aparea_colores) ) ? nl2br( $pediatria_aparea_colores ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_copia_circulo')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_copia_circulo) && !empty($pediatria_copia_circulo) ) ? nl2br( $pediatria_copia_circulo ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_habla_inteligible')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_habla_inteligible) && !empty($pediatria_habla_inteligible) ) ? nl2br( $pediatria_habla_inteligible ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_salta_en_un_solo_pie')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_salta_en_un_solo_pie) && !empty($pediatria_salta_en_un_solo_pie) ) ? nl2br( $pediatria_salta_en_un_solo_pie ) : ''?>                            </td>
                    </tr>
                </tbody>
            </table>
        <?php   }

        if( $t_meses >= 48 && $t_meses < 54 ) { ?>

            <!-- Cuatro años a antes de cuatro años y seis meses -->
            <table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
                <tbody>

                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_se_viste_sin_ayuda')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_se_viste_sin_ayuda) && !empty($pediatria_se_viste_sin_ayuda) ) ? nl2br( $pediatria_se_viste_sin_ayuda ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_copia_cruz')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_copia_cruz) && !empty($pediatria_copia_cruz) ) ? nl2br( $pediatria_copia_cruz ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_comprende_cuatro_preposiciones')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_comprende_cuatro_preposiciones) && !empty($pediatria_comprende_cuatro_preposiciones) ) ? nl2br( $pediatria_comprende_cuatro_preposiciones ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_se_para_en_cada_pie_por_tres_segundos')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_se_para_en_cada_pie_por_tres_segundos) && !empty($pediatria_se_para_en_cada_pie_por_tres_segundos) ) ? nl2br( $pediatria_se_para_en_cada_pie_por_tres_segundos ) : ''?>                            </td>
                    </tr>
                </tbody>
            </table>
        <?php   }

        if( $t_meses >= 54 && $t_meses < 60  ) { ?>

            <!-- Cuatro años y seis meses a antes de cinco años -->
            <table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
                <tbody>

                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_se_cepilla_los_dientes_sin_ayuda')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_se_cepilla_los_dientes_sin_ayuda) && !empty($pediatria_se_cepilla_los_dientes_sin_ayuda) ) ? nl2br( $pediatria_se_cepilla_los_dientes_sin_ayuda ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_señala_la_linea_mas_larga')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_senala_la_linea_mas_larga) && !empty($pediatria_senala_la_linea_mas_larga) ) ? nl2br( $pediatria_senala_la_linea_mas_larga ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_define_cinco_palabras')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_define_cinco_palabras) && !empty($pediatria_define_cinco_palabras) ) ? nl2br( $pediatria_define_cinco_palabras ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_se_para_en_un_pie_por_cinco_segundos')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_se_para_en_un_pie_por_cinco_segundos) && !empty($pediatria_se_para_en_un_pie_por_cinco_segundos) ) ? nl2br( $pediatria_se_para_en_un_pie_por_cinco_segundos ) : ''?>                            </td>
                    </tr>
                </tbody>
            </table>
        <?php   }

        if( $t_meses >= 60 && $t_meses < 66 ) { ?>

            <!-- Cinco años a antes de cinco años y seis meses -->
            <table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
                <tbody>

                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_juega_a_hacer_de_cuenta_con_otros_niños')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_juega_a_hacer_de_cuenta_con_otros_ninos) && !empty($pediatria_juega_a_hacer_de_cuenta_con_otros_ninos) ) ? nl2br( $pediatria_juega_a_hacer_de_cuenta_con_otros_ninos ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_dibuja_una_persona_con_seis_partes')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_dibuja_una_persona_con_seis_partes) && !empty($pediatria_dibuja_una_persona_con_seis_partes) ) ? nl2br( $pediatria_dibuja_una_persona_con_seis_partes ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_hace_analogias')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_hace_analogias) && !empty($pediatria_hace_analogias) ) ? nl2br( $pediatria_hace_analogias ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_marcha_punta_talon')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_marcha_punta_talon) && !empty($pediatria_marcha_punta_talon) ) ? nl2br( $pediatria_marcha_punta_talon ) : ''?>                            </td>
                    </tr>
                </tbody>
            </table>
        <?php   }

        if( $t_meses >= 66 && $t_meses < 72  ) { ?>

            <!-- Cinco años y seis meses a seis años -->
            <table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
                <tbody>

                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_acepta_y_sigue_las_reglas_de_juegos_de_mesa')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_acepta_y_sigue_las_reglas_de_juegos_de_mesa) && !empty($pediatria_acepta_y_sigue_las_reglas_de_juegos_de_mesa) ) ? nl2br( $pediatria_acepta_y_sigue_las_reglas_de_juegos_de_mesa ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_copia_un_cuadrado')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_copia_un_cuadrado) && !empty($pediatria_copia_un_cuadrado) ) ? nl2br( $pediatria_copia_un_cuadrado ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_define_siete_palabras')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_define_siete_palabras) && !empty($pediatria_define_siete_palabras) ) ? nl2br( $pediatria_define_siete_palabras ) : ''?>                            </td>
                    </tr>
                    <tr>
                        <td class="data_form"><?=$this->lang->line('pediatria_se_equilibra_en_cada_pie_por_siete_segundos')?>:</td>
                        <td align="left">
                            <?=(isset($pediatria_se_equilibra_en_cada_pie_por_siete_segundos) && !empty($pediatria_se_equilibra_en_cada_pie_por_siete_segundos) ) ? nl2br( $pediatria_se_equilibra_en_cada_pie_por_siete_segundos ) : ''?>                            </td>
                    </tr>

                </tbody>
            </table>
        <?php   }

        if( $t_meses >= 72 ) { ?>

            <!-- No aplica -->
            <table id="pediatria_no_aplica" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
                <tbody>

                    <tr>
                        <td colspan="2" align="center"><span style="font-weight: bold;"><?=$this->lang->line('no_aplica')?></span></td>
                    </tr>

                </tbody>
            </table>
<?php   }
}

if( $modo == FormularioXML::$MODO_ESCRITURA) { ?>

<script language="javascript" type="text/javascript">

    $(document).ready( function( ) {

        // Establece todos los campos de texto de las tablas desactivadas
        // con esto se evita que se envíe la información al sistema
        // solo se activa los que por la edad deben estar activos.
        $('#pediatria_tablas_desarrollo_psicomotor textarea').attr( 'disabled', 'disabled' );

        $('#pediatria_edad_anos' ).val( $('#edad').val() );
        $('#pediatria_edad_meses' ).val( $('#edad_meses').val() );
        $('#pediatria_edad_dias' ).val( $('#edad_dias').val() );

        intervalo = "";
        anos    = $('#edad').val();
        meses   = $('#edad_meses').val();
        t_meses = parseInt( anos )*12 + parseInt( meses );

        if( t_meses >= 0 && t_meses < 1 ) intervalo = '0-1';

        if( t_meses >= 1 && t_meses < 2 ) intervalo = '1-2';

        if( t_meses >= 2 && t_meses < 4 ) intervalo = '2-4';

        if( t_meses >= 4 && t_meses < 6 ) intervalo = '4-6';

        if( t_meses >= 6 && t_meses < 9 ) intervalo = '6-9';

        if( t_meses >= 9 && t_meses < 12 ) intervalo = '9-12';

        if( t_meses >= 12 && t_meses < 15 ) intervalo = '12-15';

        if( t_meses >= 15 && t_meses < 18 ) intervalo = '15-18';

        if( t_meses >= 18 && t_meses < 24 ) intervalo = '18-24';

        if( t_meses >= 24 && t_meses < 30 ) intervalo = '24-30';

        if( t_meses >= 24 && t_meses < 30 ) intervalo = '24-30';

        if( t_meses >= 30 && t_meses < 36 ) intervalo = '30-36';

        if( t_meses >= 36 && t_meses < 42 ) intervalo = '36-42';

        if( t_meses >= 42 && t_meses < 48 ) intervalo = '42-48';

        if( t_meses >= 48 && t_meses < 54 ) intervalo = '48-54';

        if( t_meses >= 54 && t_meses < 60 ) intervalo = '54-60';

        if( t_meses >= 60 && t_meses < 66 ) intervalo = '60-66';

        if( t_meses >= 66 && t_meses < 72 ) intervalo = '66-72';

        // Si tiene 5 años (inclusive) no se muestra formulario
        // desarrollo psicomotor, en cambio se debe mostrar formulario
        // escolaridad
        if( !( t_meses >= 72 ) ) {

            // Aparece y activa campos según el intervalo de edad calculada
			if(intervalo){
				$('#'+intervalo+' textarea').removeAttr( 'disabled' );
				$('#'+intervalo+'').show();
			}
        } else {

            // Aparece y activa texto de "no aplica"
            $('#desarrollo_no_aplica').show( );
        }
    } );
</script>

<div id="pediatria_tablas_desarrollo_psicomotor">

    <!-- Edad del paciente -->
    <table width="90%" cellspacing="0" cellpadding="0" border="0" align="center" >
        <tbody>

            <tr>
                <td class="data_form"><?=$this->lang->line('p_edad')?>:</td>
                <td align="left" >
                    <input type="text" name="pediatria_edad_anos" value="" id="pediatria_edad_anos" size="3" maxlength="3" readonly="readonly" /> <?=$this->lang->line('annos')?>
                    <input type="text" name="pediatria_edad_meses" value="" id="pediatria_edad_meses" size="3" maxlength="3" readonly="readonly" /> <?=$this->lang->line('edad_meses')?>
                    <input type="text" name="pediatria_edad_dias" value="" id="pediatria_edad_dias" size="3" maxlength="3" readonly="readonly" /> <?=$this->lang->line('edad_dias')?>
                </td>
            </tr>

        </tbody>
    </table>

    <!-- Menor de 1 mes -->
    <table id="0-1" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_reflejo_de_moro')?>:</td>
                <td align="left">
                    <textarea name="pediatria_reflejo_de_moro" style="width: 100%" ><?=(isset($pediatria_reflejo_de_moro) && !empty($pediatria_reflejo_de_moro) )? $pediatria_reflejo_de_moro:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_reflejo_cocleo_palpebral')?>:</td>
                <td align="left">
                    <textarea name="pediatria_reflejo_cocleo_palpebral" style="width: 100%" ><?=(isset($pediatria_reflejo_cocleo_palpebral) && !empty($pediatria_reflejo_cocleo_palpebral) )? $pediatria_reflejo_cocleo_palpebral:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_brazos_y_piernas_flexionadas')?>:</td>
                <td align="left">
                    <textarea name="pediatria_brazos_y_piernas_flexionadas" style="width: 100%" ><?=(isset($pediatria_brazos_y_piernas_flexionadas) && !empty($pediatria_brazos_y_piernas_flexionadas) )? $pediatria_brazos_y_piernas_flexionadas:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_observa_el_rostro')?>:</td>
                <td align="left">
                    <textarea name="pediatria_observa_el_rostro" style="width: 100%" ><?=(isset($pediatria_observa_el_rostro) && !empty($pediatria_observa_el_rostro) )? $pediatria_observa_el_rostro:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_eleva_cabeza')?>:</td>
                <td align="left">
                    <textarea name="pediatria_eleva_cabeza" style="width: 100%" ><?=(isset($pediatria_eleva_cabeza) && !empty($pediatria_eleva_cabeza) )? $pediatria_eleva_cabeza:''?></textarea>
                </td>
            </tr>
        </tbody>
    </table>

    <!-- 1 mes a menos de dos meses -->
    <table id="1-2" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_vocaliza')?>:</td>
                <td align="left">
                    <textarea name="pediatria_vocaliza" style="width: 100%" ><?=(isset($pediatria_vocaliza) && !empty($pediatria_vocaliza) )? $pediatria_vocaliza:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_movimiento_de_piernas_alternado')?>:</td>
                <td align="left">
                    <textarea name="pediatria_movimiento_de_piernas_alternado" style="width: 100%" ><?=(isset($pediatria_movimiento_de_piernas_alternado) && !empty($pediatria_movimiento_de_piernas_alternado) )? $pediatria_movimiento_de_piernas_alternado:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_sonrisa_social')?>:</td>
                <td align="left">
                    <textarea name="pediatria_sonrisa_social" style="width: 100%" ><?=(isset($pediatria_sonrisa_social) && !empty($pediatria_sonrisa_social) )? $pediatria_sonrisa_social:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_sigue_objetos_en_la_linea_media')?>:</td>
                <td align="left">
                    <textarea name="pediatria_sigue_objetos_en_la_linea_media" style="width: 100%" ><?=(isset($pediatria_sigue_objetos_en_la_linea_media) && !empty($pediatria_sigue_objetos_en_la_linea_media) )? $pediatria_sigue_objetos_en_la_linea_media:''?></textarea>
                </td>
            </tr>
        </tbody>
    </table>

    <!-- 2 a menos de 4 meses -->
    <table id="2-4" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_responde_al_examinador')?>:</td>
                <td align="left">
                    <textarea name="pediatria_responde_al_examinador" style="width: 100%" ><?=(isset($pediatria_responde_al_examinador) && !empty($pediatria_responde_al_examinador) )? $pediatria_responde_al_examinador:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_agarra_objetos')?>:</td>
                <td align="left">
                    <textarea name="pediatria_agarra_objetos" style="width: 100%" ><?=(isset($pediatria_agarra_objetos) && !empty($pediatria_agarra_objetos) )? $pediatria_agarra_objetos:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_emite_sonidos')?>:</td>
                <td align="left">
                    <textarea name="pediatria_emite_sonidos" style="width: 100%" ><?=(isset($pediatria_emite_sonidos) && !empty($pediatria_emite_sonidos) )? $pediatria_emite_sonidos:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_sostiene_la_cabeza')?>:</td>
                <td align="left">
                    <textarea name="pediatria_sostiene_la_cabeza" style="width: 100%" ><?=(isset($pediatria_sostiene_la_cabeza) && !empty($pediatria_sostiene_la_cabeza) )? $pediatria_sostiene_la_cabeza:''?></textarea>
                </td>
            </tr>
        </tbody>
    </table>

    <!-- 4 a menos de 6 meses -->
    <table id="4-6" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_intenta_alcanzar_un_juguete')?>:</td>
                <td align="left">
                    <textarea name="pediatria_intenta_alcanzar_un_juguete" style="width: 100%" ><?=(isset($pediatria_intenta_alcanzar_un_juguete) && !empty($pediatria_intenta_alcanzar_un_juguete) )? $pediatria_intenta_alcanzar_un_juguete:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_lleva_objetos_a_la_boca')?>:</td>
                <td align="left">
                    <textarea name="pediatria_lleva_objetos_a_la_boca" style="width: 100%" ><?=(isset($pediatria_lleva_objetos_a_la_boca) && !empty($pediatria_lleva_objetos_a_la_boca) )? $pediatria_lleva_objetos_a_la_boca:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_localiza_un_sonido')?>:</td>
                <td align="left">
                    <textarea name="pediatria_localiza_un_sonido" style="width: 100%" ><?=(isset($pediatria_localiza_un_sonido) && !empty($pediatria_localiza_un_sonido) )? $pediatria_localiza_un_sonido:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_gira')?>:</td>
                <td align="left">
                    <textarea name="pediatria_gira" style="width: 100%" ><?=(isset($pediatria_gira) && !empty($pediatria_gira) )? $pediatria_gira:''?></textarea>
                </td>
            </tr>
        </tbody>
    </table>

    <!-- 6 a menos de 9 meses -->
    <table id="6-9" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_juega_a_taparse_y_descubrirse')?>:</td>
                <td align="left">
                    <textarea name="pediatria_juega_a_taparse_y_descubrirse" style="width: 100%" ><?=(isset($pediatria_juega_a_taparse_y_descubrirse) && !empty($pediatria_juega_a_taparse_y_descubrirse) )? $pediatria_juega_a_taparse_y_descubrirse:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_trasfiere_objetos_entre_una_mano_y_otra')?>:</td>
                <td align="left">
                    <textarea name="pediatria_trasfiere_objetos_entre_una_mano_y_otra" style="width: 100%" ><?=(isset($pediatria_trasfiere_objetos_entre_una_mano_y_otra) && !empty($pediatria_trasfiere_objetos_entre_una_mano_y_otra) )? $pediatria_trasfiere_objetos_entre_una_mano_y_otra:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_duplica_silabas')?>:</td>
                <td align="left">
                    <textarea name="pediatria_duplica_silabas" style="width: 100%" ><?=(isset($pediatria_duplica_silabas) && !empty($pediatria_duplica_silabas) )? $pediatria_duplica_silabas:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_se_sienta_sin_apoyo')?>:</td>
                <td align="left">
                    <textarea name="pediatria_se_sienta_sin_apoyo" style="width: 100%" ><?=(isset($pediatria_se_sienta_sin_apoyo) && !empty($pediatria_se_sienta_sin_apoyo) )? $pediatria_se_sienta_sin_apoyo:''?></textarea>
                </td>
            </tr>
        </tbody>
    </table>

    <!-- 9 a menos de 12 meses -->
    <table id="9-12" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_imita_gestos')?>:</td>
                <td align="left">
                    <textarea name="pediatria_imita_gestos" style="width: 100%" ><?=(isset($pediatria_imita_gestos) && !empty($pediatria_imita_gestos) )? $pediatria_imita_gestos:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_pinzas_superior')?>:</td>
                <td align="left">
                    <textarea name="pediatria_pinzas_superior" style="width: 100%" ><?=(isset($pediatria_pinzas_superior) && !empty($pediatria_pinzas_superior) )? $pediatria_pinzas_superior:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_jerga_jerigonza')?>:</td>
                <td align="left">
                    <textarea name="pediatria_jerga_jerigonza" style="width: 100%" ><?=(isset($pediatria_jerga_jerigonza) && !empty($pediatria_jerga_jerigonza) )? $pediatria_jerga_jerigonza:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_camina_con_apoyo')?>:</td>
                <td align="left">
                    <textarea name="pediatria_camina_con_apoyo" style="width: 100%" ><?=(isset($pediatria_camina_con_apoyo) && !empty($pediatria_camina_con_apoyo) )? $pediatria_camina_con_apoyo:''?></textarea>
                </td>
            </tr>
        </tbody>
    </table>

    <!-- 12 a menos de 15 meses -->
    <table id="12-15" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_ejecuta_gestos_a_pedido')?>:</td>
                <td align="left">
                    <textarea name="pediatria_ejecuta_gestos_a_pedido" style="width: 100%" ><?=(isset($pediatria_ejecuta_gestos_a_pedido) && !empty($pediatria_ejecuta_gestos_a_pedido) )? $pediatria_ejecuta_gestos_a_pedido:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_coloca_cubos_en_un_recipiente')?>:</td>
                <td align="left">
                    <textarea name="pediatria_coloca_cubos_en_un_recipiente" style="width: 100%" ><?=(isset($pediatria_coloca_cubos_en_un_recipiente) && !empty($pediatria_coloca_cubos_en_un_recipiente) )? $pediatria_coloca_cubos_en_un_recipiente:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_dice_una_palabra')?>:</td>
                <td align="left">
                    <textarea name="pediatria_dice_una_palabra" style="width: 100%" ><?=(isset($pediatria_dice_una_palabra) && !empty($pediatria_dice_una_palabra) )? $pediatria_dice_una_palabra:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_camina_sin_apoyo')?>:</td>
                <td align="left">
                    <textarea name="pediatria_camina_sin_apoyo" style="width: 100%" ><?=(isset($pediatria_camina_sin_apoyo) && !empty($pediatria_camina_sin_apoyo) )? $pediatria_camina_sin_apoyo:''?></textarea>
                </td>
            </tr>
        </tbody>
    </table>

    <!-- 15 a menos de 18 meses -->
    <table id="15-18" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_identifica_dos_objetos')?>:</td>
                <td align="left">
                    <textarea name="pediatria_identifica_dos_objetos" style="width: 100%" ><?=(isset($pediatria_identifica_dos_objetos) && !empty($pediatria_identifica_dos_objetos) )? $pediatria_identifica_dos_objetos:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_garabatea_espontaneamente')?>:</td>
                <td align="left">
                    <textarea name="pediatria_garabatea_espontaneamente" style="width: 100%" ><?=(isset($pediatria_garabatea_espontaneamente) && !empty($pediatria_garabatea_espontaneamente) )? $pediatria_garabatea_espontaneamente:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_dice_tres_palabras')?>:</td>
                <td align="left">
                    <textarea name="pediatria_dice_tres_palabras" style="width: 100%" ><?=(isset($pediatria_dice_tres_palabras) && !empty($pediatria_dice_tres_palabras) )? $pediatria_dice_tres_palabras:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_camina_para_atras')?>:</td>
                <td align="left">
                    <textarea name="pediatria_camina_para_atras" style="width: 100%" ><?=(isset($pediatria_camina_para_atras) && !empty($pediatria_camina_para_atras) )? $pediatria_camina_para_atras:''?></textarea>
                </td>
            </tr>
        </tbody>
    </table>

    <!-- 18 a menos de 24 meses -->
    <table id="18-24" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_se_quita_la_ropa')?>:</td>
                <td align="left">
                    <textarea name="pediatria_se_quita_la_ropa" style="width: 100%" ><?=(isset($pediatria_se_quita_la_ropa) && !empty($pediatria_se_quita_la_ropa) )? $pediatria_se_quita_la_ropa:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_construye_una_torre_de_tres_cubos')?>:</td>
                <td align="left">
                    <textarea name="pediatria_construye_una_torre_de_tres_cubos" style="width: 100%" ><?=(isset($pediatria_construye_una_torre_de_tres_cubos) && !empty($pediatria_construye_una_torre_de_tres_cubos) )? $pediatria_construye_una_torre_de_tres_cubos:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_senala_dos_figuras')?>:</td>
                <td align="left">
                    <textarea name="pediatria_senala_dos_figuras" style="width: 100%" ><?=(isset($pediatria_senala_dos_figuras) && !empty($pediatria_senala_dos_figuras) )? $pediatria_senala_dos_figuras:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_patea_una_pelota')?>:</td>
                <td align="left">
                    <textarea name="pediatria_patea_una_pelota" style="width: 100%" ><?=(isset($pediatria_patea_una_pelota) && !empty($pediatria_patea_una_pelota) )? $pediatria_patea_una_pelota:''?></textarea>
                </td>
            </tr>
        </tbody>
    </table>

    <!-- Dos años a menos de dos años y seis meses -->
    <table id="24-30" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_se_viste_con_supervision')?>:</td>
                <td align="left">
                    <textarea name="pediatria_se_viste_con_supervision" style="width: 100%" ><?=(isset($pediatria_se_viste_con_supervision) && !empty($pediatria_se_viste_con_supervision) )? $pediatria_se_viste_con_supervision:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_construye_torre_de_seis_cubos')?>:</td>
                <td align="left">
                    <textarea name="pediatria_construye_torre_de_seis_cubos" style="width: 100%" ><?=(isset($pediatria_construye_torre_de_seis_cubos) && !empty($pediatria_construye_torre_de_seis_cubos) )? $pediatria_construye_torre_de_seis_cubos:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_forma_frases_con_dos_palabras')?>:</td>
                <td align="left">
                    <textarea name="pediatria_forma_frases_con_dos_palabras" style="width: 100%" ><?=(isset($pediatria_forma_frases_con_dos_palabras) && !empty($pediatria_forma_frases_con_dos_palabras) )? $pediatria_forma_frases_con_dos_palabras:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_salta_con_ambos_pies')?>:</td>
                <td align="left">
                    <textarea name="pediatria_salta_con_ambos_pies" style="width: 100%" ><?=(isset($pediatria_salta_con_ambos_pies) && !empty($pediatria_salta_con_ambos_pies) )? $pediatria_salta_con_ambos_pies:''?></textarea>
                </td>
            </tr>
        </tbody>
    </table>

    <!-- Dos años y seis meses a menos de tres años -->
    <table id="30-36" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_dice_el_nombre_de_un_amigo')?>:</td>
                <td align="left">
                    <textarea name="pediatria_dice_el_nombre_de_un_amigo" style="width: 100%" ><?=(isset($pediatria_dice_el_nombre_de_un_amigo) && !empty($pediatria_dice_el_nombre_de_un_amigo) )? $pediatria_dice_el_nombre_de_un_amigo:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_imita_una_linea_vertical')?>:</td>
                <td align="left">
                    <textarea name="pediatria_imita_una_linea_vertical" style="width: 100%" ><?=(isset($pediatria_imita_una_linea_vertical) && !empty($pediatria_imita_una_linea_vertical) )? $pediatria_imita_una_linea_vertical:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_reconoce_dos_acciones')?>:</td>
                <td align="left">
                    <textarea name="pediatria_reconoce_dos_acciones" style="width: 100%" ><?=(isset($pediatria_reconoce_dos_acciones) && !empty($pediatria_reconoce_dos_acciones) )? $pediatria_reconoce_dos_acciones:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_tira_la_pelota')?>:</td>
                <td align="left">
                    <textarea name="pediatria_tira_la_pelota" style="width: 100%" ><?=(isset($pediatria_tira_la_pelota) && !empty($pediatria_tira_la_pelota) )? $pediatria_tira_la_pelota:''?></textarea>
                </td>
            </tr>
        </tbody>
    </table>

    <!-- Tres años a antes de tres años y seis mes -->
    <table id="36-42" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_se_pone_un_saco')?>:</td>
                <td align="left">
                    <textarea name="pediatria_se_pone_un_saco" style="width: 100%" ><?=(isset($pediatria_se_pone_un_saco) && !empty($pediatria_se_pone_un_saco) )? $pediatria_se_pone_un_saco:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_mueve_el_pulgar_con_mano_cerrada')?>:</td>
                <td align="left">
                    <textarea name="pediatria_mueve_el_pulgar_con_mano_cerrada" style="width: 100%" ><?=(isset($pediatria_mueve_el_pulgar_con_mano_cerrada) && !empty($pediatria_mueve_el_pulgar_con_mano_cerrada) )? $pediatria_mueve_el_pulgar_con_mano_cerrada:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_comprende_dos_adjetivos')?>:</td>
                <td align="left">
                    <textarea name="pediatria_comprende_dos_adjetivos" style="width: 100%" ><?=(isset($pediatria_comprende_dos_adjetivos) && !empty($pediatria_comprende_dos_adjetivos) )? $pediatria_comprende_dos_adjetivos:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_se_para_en_cada_pie_por_un_segundo')?>:</td>
                <td align="left">
                    <textarea name="pediatria_se_para_en_cada_pie_por_un_segundo" style="width: 100%" ><?=(isset($pediatria_se_para_en_cada_pie_por_un_segundo) && !empty($pediatria_se_para_en_cada_pie_por_un_segundo) )? $pediatria_se_para_en_cada_pie_por_un_segundo:''?></textarea>
                </td>
            </tr>
        </tbody>
    </table>

    <!-- Tres años y seis meses a antes de cuatro años -->
    <table id="42-48" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_aparea_colores')?>:</td>
                <td align="left">
                    <textarea name="pediatria_aparea_colores" style="width: 100%" ><?=(isset($pediatria_aparea_colores) && !empty($pediatria_aparea_colores) )? $pediatria_aparea_colores:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_copia_circulo')?>:</td>
                <td align="left">
                    <textarea name="pediatria_copia_circulo" style="width: 100%" ><?=(isset($pediatria_copia_circulo) && !empty($pediatria_copia_circulo) )? $pediatria_copia_circulo:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_habla_inteligible')?>:</td>
                <td align="left">
                    <textarea name="pediatria_habla_inteligible" style="width: 100%" ><?=(isset($pediatria_habla_inteligible) && !empty($pediatria_habla_inteligible) )? $pediatria_habla_inteligible:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_salta_en_un_solo_pie')?>:</td>
                <td align="left">
                    <textarea name="pediatria_salta_en_un_solo_pie" style="width: 100%" ><?=(isset($pediatria_salta_en_un_solo_pie) && !empty($pediatria_salta_en_un_solo_pie) )? $pediatria_salta_en_un_solo_pie:''?></textarea>
                </td>
            </tr>
        </tbody>
    </table>

    <!-- Cuatro años a antes de cuatro años y seis meses -->
    <table id="48-54" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_se_viste_sin_ayuda')?>:</td>
                <td align="left">
                    <textarea name="pediatria_se_viste_sin_ayuda" style="width: 100%" ><?=(isset($pediatria_se_viste_sin_ayuda) && !empty($pediatria_se_viste_sin_ayuda) )? $pediatria_se_viste_sin_ayuda:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_copia_cruz')?>:</td>
                <td align="left">
                    <textarea name="pediatria_copia_cruz" style="width: 100%" ><?=(isset($pediatria_copia_cruz) && !empty($pediatria_copia_cruz) )? $pediatria_copia_cruz:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_comprende_cuatro_preposiciones')?>:</td>
                <td align="left">
                    <textarea name="pediatria_comprende_cuatro_preposiciones" style="width: 100%" ><?=(isset($pediatria_comprende_cuatro_preposiciones) && !empty($pediatria_comprende_cuatro_preposiciones) )? $pediatria_comprende_cuatro_preposiciones:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_se_para_en_cada_pie_por_tres_segundos')?>:</td>
                <td align="left">
                    <textarea name="pediatria_se_para_en_cada_pie_por_tres_segundos" style="width: 100%" ><?=(isset($pediatria_se_para_en_cada_pie_por_tres_segundos) && !empty($pediatria_se_para_en_cada_pie_por_tres_segundos) )? $pediatria_se_para_en_cada_pie_por_tres_segundos:''?></textarea>
                </td>
            </tr>
        </tbody>
    </table>

    <!-- Cuatro años y seis meses a antes de cinco años -->
    <table id="54-60" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_se_cepilla_los_dientes_sin_ayuda')?>:</td>
                <td align="left">
                    <textarea name="pediatria_se_cepilla_los_dientes_sin_ayuda" style="width: 100%" ><?=(isset($pediatria_se_cepilla_los_dientes_sin_ayuda) && !empty($pediatria_se_cepilla_los_dientes_sin_ayuda) )? $pediatria_se_cepilla_los_dientes_sin_ayuda:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_señala_la_linea_mas_larga')?>:</td>
                <td align="left">
                    <textarea name="pediatria_senala_la_linea_mas_larga" style="width: 100%" ><?=(isset($pediatria_senala_la_linea_mas_larga) && !empty($pediatria_senala_la_linea_mas_larga) )? $pediatria_senala_la_linea_mas_larga:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_define_cinco_palabras')?>:</td>
                <td align="left">
                    <textarea name="pediatria_define_cinco_palabras" style="width: 100%" ><?=(isset($pediatria_define_cinco_palabras) && !empty($pediatria_define_cinco_palabras) )? $pediatria_define_cinco_palabras:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_se_para_en_un_pie_por_cinco_segundos')?>:</td>
                <td align="left">
                    <textarea name="pediatria_se_para_en_un_pie_por_cinco_segundos" style="width: 100%" ><?=(isset($pediatria_se_para_en_un_pie_por_cinco_segundos) && !empty($pediatria_se_para_en_un_pie_por_cinco_segundos) )? $pediatria_se_para_en_un_pie_por_cinco_segundos:''?></textarea>
                </td>
            </tr>
        </tbody>
    </table>

    <!-- Cinco años a antes de cinco años y seis meses -->
    <table id="60-66" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_juega_a_hacer_de_cuenta_con_otros_niños')?>:</td>
                <td align="left">
                    <textarea name="pediatria_juega_a_hacer_de_cuenta_con_otros_ninos" style="width: 100%" ><?=(isset($pediatria_juega_a_hacer_de_cuenta_con_otros_ninos) && !empty($pediatria_juega_a_hacer_de_cuenta_con_otros_ninos) )? $pediatria_juega_a_hacer_de_cuenta_con_otros_ninos:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_dibuja_una_persona_con_seis_partes')?>:</td>
                <td align="left">
                    <textarea name="pediatria_dibuja_una_persona_con_seis_partes" style="width: 100%" ><?=(isset($pediatria_dibuja_una_persona_con_seis_partes) && !empty($pediatria_dibuja_una_persona_con_seis_partes) )? $pediatria_dibuja_una_persona_con_seis_partes:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_hace_analogias')?>:</td>
                <td align="left">
                    <textarea name="pediatria_hace_analogias" style="width: 100%" ><?=(isset($pediatria_hace_analogias) && !empty($pediatria_hace_analogias) )? $pediatria_hace_analogias:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_marcha_punta_talon')?>:</td>
                <td align="left">
                    <textarea name="pediatria_marcha_punta_talon" style="width: 100%" ><?=(isset($pediatria_marcha_punta_talon) && !empty($pediatria_marcha_punta_talon) )? $pediatria_marcha_punta_talon:''?></textarea>
                </td>
            </tr>
        </tbody>
    </table>

    <!-- Cinco años y seis meses a seis años -->
    <table id="66-72" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_acepta_y_sigue_las_reglas_de_juegos_de_mesa')?>:</td>
                <td align="left">
                    <textarea name="pediatria_acepta_y_sigue_las_reglas_de_juegos_de_mesa" style="width: 100%" ><?=(isset($pediatria_acepta_y_sigue_las_reglas_de_juegos_de_mesa) && !empty($pediatria_acepta_y_sigue_las_reglas_de_juegos_de_mesa) )? $pediatria_acepta_y_sigue_las_reglas_de_juegos_de_mesa:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_copia_un_cuadrado')?>:</td>
                <td align="left">
                    <textarea name="pediatria_copia_un_cuadrado" style="width: 100%" ><?=(isset($pediatria_copia_un_cuadrado) && !empty($pediatria_copia_un_cuadrado) )? $pediatria_copia_un_cuadrado:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_define_siete_palabras')?>:</td>
                <td align="left">
                    <textarea name="pediatria_define_siete_palabras" style="width: 100%" ><?=(isset($pediatria_define_siete_palabras) && !empty($pediatria_define_siete_palabras) )? $pediatria_define_siete_palabras:''?></textarea>
                </td>
            </tr>
            <tr>
                <td class="data_form"><?=$this->lang->line('pediatria_se_equilibra_en_cada_pie_por_siete_segundos')?>:</td>
                <td align="left">
                    <textarea name="pediatria_se_equilibra_en_cada_pie_por_siete_segundos" style="width: 100%" ><?=(isset($pediatria_se_equilibra_en_cada_pie_por_siete_segundos) && !empty($pediatria_se_equilibra_en_cada_pie_por_siete_segundos) )? $pediatria_se_equilibra_en_cada_pie_por_siete_segundos:''?></textarea>
                </td>
            </tr>

        </tbody>
    </table>

    <!-- No aplica -->
    <table id="desarrollo_no_aplica" width="90%" cellspacing="0" cellpadding="0" border="0" align="center" style="display: none;" >
        <tbody>

            <tr>
                <td colspan="2" align="center"><?=$this->lang->line('no_aplica')?></td>
            </tr>

        </tbody>
    </table>
</div>
<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    // Edad del paciente
    $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'p_edad' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
    $pdf->MultiCell( 0, 6, html_entity_decode(
                                ( ( isset( $pediatria_edad_anos ) && !empty( $pediatria_edad_anos ) ) ? $pediatria_edad_anos : ' - ' ). ' ' . $this->lang->line('annos') . ', ' .
                                ( ( isset( $pediatria_edad_meses ) && !empty( $pediatria_edad_meses ) ) ? $pediatria_edad_meses : ' - ' ). ' ' . $this->lang->line('edad_meses') . ', ' .
                                ( ( isset( $pediatria_edad_dias ) && !empty( $pediatria_edad_dias ) ) ? $pediatria_edad_dias : ' - ' ). ' ' . $this->lang->line('edad_dias')
                            ), 0, 'L', false, 0 );

    $intervalo = "";
    $anos  = ( isset( $pediatria_edad_anos ) && !empty( $pediatria_edad_anos ) ) ? $pediatria_edad_anos : '-';
    $meses = ( isset( $pediatria_edad_meses ) && !empty( $pediatria_edad_meses ) ) ? $pediatria_edad_meses : '-';
    $t_meses = $anos * 12 + $meses;

    // Menor de 1 mes
    if( $t_meses >= 0 && $t_meses < 1  ) {

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_reflejo_de_moro' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_reflejo_de_moro) && !empty($pediatria_reflejo_de_moro) ) ? utf8_decode( $pediatria_reflejo_de_moro ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_reflejo_cocleo_palpebral' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_reflejo_cocleo_palpebral) && !empty($pediatria_reflejo_cocleo_palpebral) ) ? utf8_decode( $pediatria_reflejo_cocleo_palpebral ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_brazos_y_piernas_flexionadas' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_brazos_y_piernas_flexionadas) && !empty($pediatria_brazos_y_piernas_flexionadas) ) ? utf8_decode( $pediatria_brazos_y_piernas_flexionadas ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_observa_el_rostro' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_observa_el_rostro) && !empty($pediatria_observa_el_rostro) ) ? utf8_decode( $pediatria_observa_el_rostro ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_eleva_cabeza' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_eleva_cabeza) && !empty($pediatria_eleva_cabeza) ) ? utf8_decode( $pediatria_eleva_cabeza ) : '' ), 0, 'L', false, 0 );

    }

    // 1 mes a menos de dos meses
    if( $t_meses >= 1 && $t_meses < 2 ) {

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_vocaliza' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_vocaliza) && !empty($pediatria_vocaliza) ) ? utf8_decode( $pediatria_vocaliza ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_movimiento_de_piernas_alternado' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_movimiento_de_piernas_alternado) && !empty($pediatria_movimiento_de_piernas_alternado) ) ? utf8_decode( $pediatria_movimiento_de_piernas_alternado ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_sonrisa_social' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_sonrisa_social) && !empty($pediatria_sonrisa_social) ) ? utf8_decode( $pediatria_sonrisa_social ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_sigue_objetos_en_la_linea_media' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_sigue_objetos_en_la_linea_media) && !empty($pediatria_sigue_objetos_en_la_linea_media) ) ? utf8_decode( $pediatria_sigue_objetos_en_la_linea_media ) : '' ), 0, 'L', false, 0 );
    }

    // 2 a menos de 4 meses
    if( $t_meses >= 2 && $t_meses < 4 ) {

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_responde_al_examinador' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_responde_al_examinador) && !empty($pediatria_responde_al_examinador) ) ? utf8_decode( $pediatria_responde_al_examinador ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_agarra_objetos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_agarra_objetos) && !empty($pediatria_agarra_objetos) ) ? utf8_decode( $pediatria_agarra_objetos ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_emite_sonidos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_emite_sonidos) && !empty($pediatria_emite_sonidos) ) ? utf8_decode( $pediatria_emite_sonidos ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_sostiene_la_cabeza' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_sostiene_la_cabeza) && !empty($pediatria_sostiene_la_cabeza) ) ? utf8_decode( $pediatria_sostiene_la_cabeza ) : '' ), 0, 'L', false, 0 );
    }

    // 4 a menos de 6 meses
    if( $t_meses >= 4 && $t_meses < 6 ) {

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_intenta_alcanzar_un_juguete' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_intenta_alcanzar_un_juguete) && !empty($pediatria_intenta_alcanzar_un_juguete) ) ? utf8_decode( $pediatria_intenta_alcanzar_un_juguete ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_lleva_objetos_a_la_boca' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_lleva_objetos_a_la_boca) && !empty($pediatria_lleva_objetos_a_la_boca) ) ? utf8_decode( $pediatria_lleva_objetos_a_la_boca ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_localiza_un_sonido' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_localiza_un_sonido) && !empty($pediatria_localiza_un_sonido) ) ? utf8_decode( $pediatria_localiza_un_sonido ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_gira' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_gira) && !empty($pediatria_gira) ) ? utf8_decode( $pediatria_gira ) : '' ), 0, 'L', false, 0 );
    }

    // 6 a menos de 9 meses
    if( $t_meses >= 6 && $t_meses < 9 ) {

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_juega_a_taparse_y_descubrirse' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_juega_a_taparse_y_descubrirse) && !empty($pediatria_juega_a_taparse_y_descubrirse) ) ? utf8_decode( $pediatria_juega_a_taparse_y_descubrirse ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_trasfiere_objetos_entre_una_mano_y_otra' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_trasfiere_objetos_entre_una_mano_y_otra) && !empty($pediatria_trasfiere_objetos_entre_una_mano_y_otra) ) ? utf8_decode( $pediatria_trasfiere_objetos_entre_una_mano_y_otra ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_duplica_silabas' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_duplica_silabas) && !empty($pediatria_duplica_silabas) ) ? utf8_decode( $pediatria_duplica_silabas ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_se_sienta_sin_apoyo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_se_sienta_sin_apoyo) && !empty($pediatria_se_sienta_sin_apoyo) ) ? utf8_decode( $pediatria_se_sienta_sin_apoyo ) : '' ), 0, 'L', false, 0 );
    }

    // 9 a menos de 12 meses
    if( $t_meses >= 9 && $t_meses < 12 ) {

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_imita_gestos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_imita_gestos) && !empty($pediatria_imita_gestos) ) ? utf8_decode( $pediatria_imita_gestos ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_pinzas_superior' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_pinzas_superior) && !empty($pediatria_pinzas_superior) ) ? utf8_decode( $pediatria_pinzas_superior ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_jerga_jerigonza' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_jerga_jerigonza) && !empty($pediatria_jerga_jerigonza) ) ? utf8_decode( $pediatria_jerga_jerigonza ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_camina_con_apoyo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_camina_con_apoyo) && !empty($pediatria_camina_con_apoyo) ) ? utf8_decode( $pediatria_camina_con_apoyo ) : '' ), 0, 'L', false, 0 );
    }

    // 12 a menos de 15 meses
    if( $t_meses >= 12 && $t_meses < 15 ) {

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_ejecuta_gestos_a_pedido' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_ejecuta_gestos_a_pedido) && !empty($pediatria_ejecuta_gestos_a_pedido) ) ? utf8_decode( $pediatria_ejecuta_gestos_a_pedido ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_coloca_cubos_en_un_recipiente' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_coloca_cubos_en_un_recipiente) && !empty($pediatria_coloca_cubos_en_un_recipiente) ) ? utf8_decode( $pediatria_coloca_cubos_en_un_recipiente ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_dice_una_palabra' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_dice_una_palabra) && !empty($pediatria_dice_una_palabra) ) ? utf8_decode( $pediatria_dice_una_palabra ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_camina_sin_apoyo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_camina_sin_apoyo) && !empty($pediatria_camina_sin_apoyo) ) ? utf8_decode( $pediatria_camina_sin_apoyo ) : '' ), 0, 'L', false, 0 );
    }

    // 15 a menos de 18 meses
    if( $t_meses >= 15 && $t_meses < 18 ) {

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_identifica_dos_objetos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_identifica_dos_objetos) && !empty($pediatria_identifica_dos_objetos) ) ? utf8_decode( $pediatria_identifica_dos_objetos ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_garabatea_espontaneamente' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_garabatea_espontaneamente) && !empty($pediatria_garabatea_espontaneamente) ) ? utf8_decode( $pediatria_garabatea_espontaneamente ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_dice_tres_palabras' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_dice_tres_palabras) && !empty($pediatria_dice_tres_palabras) ) ? utf8_decode( $pediatria_dice_tres_palabras ) : '' ), 0, 'L', false, 0 );


        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_camina_para_atras' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_camina_para_atras) && !empty($pediatria_camina_para_atras) ) ? utf8_decode( $pediatria_camina_para_atras ) : '' ), 0, 'L', false, 0 );
    }

    // 18 a menos de 24 meses
    if( $t_meses >= 18 && $t_meses < 24 ) {

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_se_quita_la_ropa' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_se_quita_la_ropa) && !empty($pediatria_se_quita_la_ropa) ) ? utf8_decode( $pediatria_se_quita_la_ropa ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_construye_una_torre_de_tres_cubos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_construye_una_torre_de_tres_cubos) && !empty($pediatria_construye_una_torre_de_tres_cubos) ) ? utf8_decode( $pediatria_construye_una_torre_de_tres_cubos ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_senala_dos_figuras' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_senala_dos_figuras) && !empty($pediatria_senala_dos_figuras) ) ? utf8_decode( $pediatria_senala_dos_figuras ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_patea_una_pelota' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_patea_una_pelota) && !empty($pediatria_patea_una_pelota) ) ? utf8_decode( $pediatria_patea_una_pelota ) : '' ), 0, 'L', false, 0 );
    }

    // Dos años a menos de dos años y seis meses
    if( $t_meses >= 24 && $t_meses < 30 ) {

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_se_viste_con_supervision' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_se_viste_con_supervision) && !empty($pediatria_se_viste_con_supervision) ) ? utf8_decode( $pediatria_se_viste_con_supervision ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_construye_torre_de_seis_cubos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_construye_torre_de_seis_cubos) && !empty($pediatria_construye_torre_de_seis_cubos) ) ? utf8_decode( $pediatria_construye_torre_de_seis_cubos ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_forma_frases_con_dos_palabras' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_forma_frases_con_dos_palabras) && !empty($pediatria_forma_frases_con_dos_palabras) ) ? utf8_decode( $pediatria_forma_frases_con_dos_palabras ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_salta_con_ambos_pies' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_salta_con_ambos_pies) && !empty($pediatria_salta_con_ambos_pies) ) ? utf8_decode( $pediatria_salta_con_ambos_pies ) : '' ), 0, 'L', false, 0 );
    }

    // Dos años y seis meses a menos de tres años
    if( $t_meses >= 30 && $t_meses < 36 ) {

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_dice_el_nombre_de_un_amigo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_dice_el_nombre_de_un_amigo) && !empty($pediatria_dice_el_nombre_de_un_amigo) ) ? utf8_decode( $pediatria_dice_el_nombre_de_un_amigo ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_imita_una_linea_vertical' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_imita_una_linea_vertical) && !empty($pediatria_imita_una_linea_vertical) ) ? utf8_decode( $pediatria_imita_una_linea_vertical ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_reconoce_dos_acciones' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_reconoce_dos_acciones) && !empty($pediatria_reconoce_dos_acciones) ) ? utf8_decode( $pediatria_reconoce_dos_acciones ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_tira_la_pelota' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_tira_la_pelota) && !empty($pediatria_tira_la_pelota) ) ? utf8_decode( $pediatria_tira_la_pelota ) : '' ), 0, 'L', false, 0 );
    }

    // Tres años a antes de tres años y seis mes
    if( $t_meses >= 36 && $t_meses < 42 ) {

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_se_pone_un_saco' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_se_pone_un_saco) && !empty($pediatria_se_pone_un_saco) ) ? utf8_decode( $pediatria_se_pone_un_saco ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_mueve_el_pulgar_con_mano_cerrada' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_mueve_el_pulgar_con_mano_cerrada) && !empty($pediatria_mueve_el_pulgar_con_mano_cerrada) ) ? utf8_decode( $pediatria_mueve_el_pulgar_con_mano_cerrada ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_comprende_dos_adjetivos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_comprende_dos_adjetivos) && !empty($pediatria_comprende_dos_adjetivos) ) ? utf8_decode( $pediatria_comprende_dos_adjetivos ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_se_para_en_cada_pie_por_un_segundo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_se_para_en_cada_pie_por_un_segundo) && !empty($pediatria_se_para_en_cada_pie_por_un_segundo) ) ? utf8_decode( $pediatria_se_para_en_cada_pie_por_un_segundo ) : '' ), 0, 'L', false, 0 );
    }

    // Tres años y seis meses a antes de cuatro años
    if( $t_meses >= 42 && $t_meses < 48 ) {

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_aparea_colores' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_aparea_colores) && !empty($pediatria_aparea_colores) ) ? utf8_decode( $pediatria_aparea_colores ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_copia_circulo' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_copia_circulo) && !empty($pediatria_copia_circulo) ) ? utf8_decode( $pediatria_copia_circulo ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_habla_inteligible' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_habla_inteligible) && !empty($pediatria_habla_inteligible) ) ? utf8_decode( $pediatria_habla_inteligible ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_salta_en_un_solo_pie' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_salta_en_un_solo_pie) && !empty($pediatria_salta_en_un_solo_pie) ) ? utf8_decode( $pediatria_salta_en_un_solo_pie ) : '' ), 0, 'L', false, 0 );
    }

    // Cuatro años a antes de cuatro años y seis meses
    if( $t_meses >= 48 && $t_meses < 54 ) {

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_se_viste_sin_ayuda' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_se_viste_sin_ayuda) && !empty($pediatria_se_viste_sin_ayuda) ) ? utf8_decode( $pediatria_se_viste_sin_ayuda ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_copia_cruz' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_copia_cruz) && !empty($pediatria_copia_cruz) ) ? utf8_decode( $pediatria_copia_cruz ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_comprende_cuatro_preposiciones' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_comprende_cuatro_preposiciones) && !empty($pediatria_comprende_cuatro_preposiciones) ) ? utf8_decode( $pediatria_comprende_cuatro_preposiciones ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_se_para_en_cada_pie_por_tres_segundos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_se_para_en_cada_pie_por_tres_segundos) && !empty($pediatria_se_para_en_cada_pie_por_tres_segundos) ) ? utf8_decode( $pediatria_se_para_en_cada_pie_por_tres_segundos ) : '' ), 0, 'L', false, 0 );
    }

    // Cuatro años y seis meses a antes de cinco años
    if( $t_meses >= 54 && $t_meses < 60 ) {

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_se_cepilla_los_dientes_sin_ayuda' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_se_cepilla_los_dientes_sin_ayuda) && !empty($pediatria_se_cepilla_los_dientes_sin_ayuda) ) ? utf8_decode( $pediatria_se_cepilla_los_dientes_sin_ayuda ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_señala_la_linea_mas_larga' ) ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_senala_la_linea_mas_larga) && !empty($pediatria_senala_la_linea_mas_larga) ) ? utf8_decode( $pediatria_senala_la_linea_mas_larga ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_define_cinco_palabras' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_define_cinco_palabras) && !empty($pediatria_define_cinco_palabras) ) ? utf8_decode( $pediatria_define_cinco_palabras ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_se_para_en_un_pie_por_cinco_segundos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_se_para_en_un_pie_por_cinco_segundos) && !empty($pediatria_se_para_en_un_pie_por_cinco_segundos) ) ? utf8_decode( $pediatria_se_para_en_un_pie_por_cinco_segundos ) : '' ), 0, 'L', false, 0 );
    }

    // Cinco años a antes de cinco años y seis meses
    if( $t_meses >= 60 && $t_meses < 66 ) {

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_juega_a_hacer_de_cuenta_con_otros_niños' ) ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_juega_a_hacer_de_cuenta_con_otros_ninos) && !empty($pediatria_juega_a_hacer_de_cuenta_con_otros_ninos) ) ? utf8_decode( $pediatria_juega_a_hacer_de_cuenta_con_otros_ninos ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_dibuja_una_persona_con_seis_partes' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_dibuja_una_persona_con_seis_partes) && !empty($pediatria_dibuja_una_persona_con_seis_partes) ) ? utf8_decode( $pediatria_dibuja_una_persona_con_seis_partes ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_hace_analogias' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_hace_analogias) && !empty($pediatria_hace_analogias) ) ? utf8_decode( $pediatria_hace_analogias ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_marcha_punta_talon' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_marcha_punta_talon) && !empty($pediatria_marcha_punta_talon) ) ? utf8_decode( $pediatria_marcha_punta_talon ) : '' ), 0, 'L', false, 0 );
    }

    // Cinco años y seis meses a seis años
    if( $t_meses >= 66 && $t_meses < 72 ) {

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_acepta_y_sigue_las_reglas_de_juegos_de_mesa' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_acepta_y_sigue_las_reglas_de_juegos_de_mesa) && !empty($pediatria_acepta_y_sigue_las_reglas_de_juegos_de_mesa) ) ? utf8_decode( $pediatria_acepta_y_sigue_las_reglas_de_juegos_de_mesa ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_copia_un_cuadrado' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_copia_un_cuadrado) && !empty($pediatria_copia_un_cuadrado) ) ? utf8_decode( $pediatria_copia_un_cuadrado ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_define_siete_palabras' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_define_siete_palabras) && !empty($pediatria_define_siete_palabras) ) ? utf8_decode( $pediatria_define_siete_palabras ) : '' ), 0, 'L', false, 0 );

        $pdf->Cell( 70, 6, html_entity_decode( $this->lang->line( 'pediatria_se_equilibra_en_cada_pie_por_siete_segundos' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ).': ', 0, 0, 'R' );
        $pdf->MultiCell( 0, 6, html_entity_decode( (isset($pediatria_se_equilibra_en_cada_pie_por_siete_segundos) && !empty($pediatria_se_equilibra_en_cada_pie_por_siete_segundos) ) ? utf8_decode( $pediatria_se_equilibra_en_cada_pie_por_siete_segundos ) : '' ), 0, 'L', false, 0 );
    }

    if( $t_meses >= 72 ) {
        $pdf->SetFont( 'Arial', 'B' );
        $pdf->Cell( 0, 6, html_entity_decode( $this->lang->line( 'no_aplica' ) ), 0, 0, 'C' );
        $pdf->SetFont( 'Arial', '' );
    }
}
