<?php

if( $modo == FormularioXML::$MODO_LECTURA ) {

    $ef_campos = array( 'tc_examen_fisico_cabeza', 'tc_examen_fisico_cuello', 'tc_examen_fisico_torax',
                'tc_examen_fisico_abdomen', 'tc_examen_fisico_genitales', 'tc_examen_fisico_extremidades',
                'tc_examen_fisico_neurologico' );

    $tc_chkbx_examen_fisico = !isset( $tc_chkbx_examen_fisico ) ? $ef_campos : $tc_chkbx_examen_fisico;

    foreach( $tc_chkbx_examen_fisico as $valor ) {
        if( isset( ${$valor} ) && !empty( ${$valor} ) ) { ?>

        <span style="font-weight: bold;"><?=$this->lang->line($valor)?>:</span></br>
        <?=nl2br( ${$valor} )?><br/><br/>

<?php   }
    }
}

if( $modo == FormularioXML::$MODO_ESCRITURA) { ?>

<script language="javascript" type="text/javascript">

    $(document).ready( function( ) {

        // Selección de plantilla: Cabeza
        $('#plantilla_examen_fisico_cabeza').change( function( ) {

            if( $(this).val() != '' )
                $.get( '<?=base_url()?>platc/plantilla_get/'+parseInt( $(this).val() )+'/'+Math.random( ), {},
                    function( data ) { $('#tc_examen_fisico_cabeza').val( data ); } );
        } );

        // Selección de plantilla: Cuello
        $('#plantilla_examen_fisico_cuello').change( function( ) {

            if( $(this).val() != '' )
                $.get( '<?=base_url()?>platc/plantilla_get/'+parseInt( $(this).val() )+'/'+Math.random( ), {},
                    function( data ) { $('#tc_examen_fisico_cuello').val( data ); } );
        } );

        // Selección de plantilla: Tórax
        $('#plantilla_examen_fisico_torax').change( function( ) {

            if( $(this).val() != '' )
                $.get( '<?=base_url()?>platc/plantilla_get/'+parseInt( $(this).val() )+'/'+Math.random( ), {},
                    function( data ) { $('#tc_examen_fisico_torax').val( data ); } );
        } );

        // Selección de plantilla: Abdomen
        $('#plantilla_examen_fisico_abdomen').change( function( ) {

            if( $(this).val() != '' )
                $.get( '<?=base_url()?>platc/plantilla_get/'+parseInt( $(this).val() )+'/'+Math.random( ), {},
                    function( data ) { $('#tc_examen_fisico_abdomen').val( data ); } );
        } );

        // Selección de plantilla: Genitales
        $('#plantilla_examen_fisico_genitales').change( function( ) {

            if( $(this).val() != '' )
                $.get( '<?=base_url()?>platc/plantilla_get/'+parseInt( $(this).val() )+'/'+Math.random( ), {},
                    function( data ) { $('#tc_examen_fisico_genitales').val( data ); } );
        } );

        // Selección de plantilla: Extremidades
        $('#plantilla_examen_fisico_extremidades').change( function( ) {

            if( $(this).val() != '' )
                $.get( '<?=base_url()?>platc/plantilla_get/'+parseInt( $(this).val() )+'/'+Math.random( ), {},
                    function( data ) { $('#tc_examen_fisico_extremidades').val( data ); } );
        } );

        // Selección de plantilla: Neurologico
        $('#plantilla_examen_fisico_neurologico').change( function( ) {

            if( $(this).val() != '' )
                $.get( '<?=base_url()?>platc/plantilla_get/'+parseInt( $(this).val() )+'/'+Math.random( ), {},
                    function( data ) { $('#tc_examen_fisico_neurologico').val( data ); } );
        } );

        $.getJSON(
            '<?=base_url()?>platc/plantillas_get/'+Math.random( ),
            {},
            function( data ) {

                for ( var i in data )
                    $('[id*=plantilla_examen_fisico_]').append( '<option value="'+data[i].id+'">'+data[i].nombre+'</option>' );
            }
        );
    } );

</script>

<br />

<!-- 1: Cabeza -->
<div>
    <span style="font-weight: bold;"><?= $this->lang->line('tc_examen_fisico_cabeza') ?></span>
    <?= $this->lang->line('tc_examen_fisico_cabeza_desc') ?> <br/>
    <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_fisico_cabeza"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
    <textarea name="tc_examen_fisico_cabeza" id="tc_examen_fisico_cabeza" style="width: 100%;"><?php echo isset( $tc_examen_fisico_cabeza ) ? nl2br( $tc_examen_fisico_cabeza ) : NULL; ?></textarea>
</div>
<br/>

<!-- 2: Cuello -->
<div>
    <span style="font-weight: bold;"><?= $this->lang->line('tc_examen_fisico_cuello') ?></span>
    <?= $this->lang->line('tc_examen_fisico_cuello_desc') ?> <br/>
    <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_fisico_cuello"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
    <textarea name="tc_examen_fisico_cuello" id="tc_examen_fisico_cuello" style="width: 100%;"><?php echo isset( $tc_examen_fisico_cuello ) ? nl2br( $tc_examen_fisico_cuello ) : NULL; ?></textarea>
</div>
<br/>

<!-- 3: Tórax -->
<div>
    <span style="font-weight: bold;"><?= $this->lang->line('tc_examen_fisico_torax') ?></span>
    <?= $this->lang->line('tc_examen_fisico_torax_desc') ?> <br/>
    <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_fisico_torax"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
    <textarea name="tc_examen_fisico_torax" id="tc_examen_fisico_torax" style="width: 100%;"><?php echo isset( $tc_examen_fisico_torax ) ? nl2br( $tc_examen_fisico_torax ) : NULL; ?></textarea>
</div>
<br/>

<!-- 4: Abdomen -->
<div>
    <span style="font-weight: bold;"><?= $this->lang->line('tc_examen_fisico_abdomen') ?></span>
    <?= $this->lang->line('tc_examen_fisico_abdomen_desc') ?> <br/>
    <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_fisico_abdomen"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
    <textarea name="tc_examen_fisico_abdomen" id="tc_examen_fisico_abdomen" style="width: 100%;"><?php echo isset( $tc_examen_fisico_abdomen ) ? nl2br( $tc_examen_fisico_abdomen ) : NULL; ?></textarea>
</div>
<br/>

<!-- 5: Genitales -->
<div>
    <span style="font-weight: bold;"><?= $this->lang->line('tc_examen_fisico_genitales') ?></span> <br/>
    <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_fisico_genitales"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
    <textarea name="tc_examen_fisico_genitales" id="tc_examen_fisico_genitales" style="width: 100%;"><?php echo isset( $tc_examen_fisico_genitales ) ? nl2br( $tc_examen_fisico_genitales ) : NULL; ?></textarea>
</div>
<br/>

<!-- 6: Extremidades -->
<div>
    <span style="font-weight: bold;"><?= $this->lang->line('tc_examen_fisico_extremidades') ?></span>
    <?= $this->lang->line('tc_examen_fisico_extremidades_desc') ?> <br/>
    <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_fisico_extremidades"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
    <textarea name="tc_examen_fisico_extremidades" id="tc_examen_fisico_extremidades" style="width: 100%;"><?php echo isset( $tc_examen_fisico_extremidades ) ? nl2br( $tc_examen_fisico_extremidades ) : NULL; ?></textarea>
</div>    
<br/>

<!-- 7: Neurológico -->
<div>
    <span style="font-weight: bold;"><?= $this->lang->line('tc_examen_fisico_neurologico') ?></span>
    <?= $this->lang->line('tc_examen_fisico_neurologico_desc') ?> <br/>
    <span><?=$this->lang->line('plantilla_plantilla')?>: </span><select id="plantilla_examen_fisico_neurologico"><option value=""><?=$this->lang->line('plantilla_seleccione')?></option></select>
    <textarea name="tc_examen_fisico_neurologico" id="tc_examen_fisico_neurologico" style="width: 100%;"><?php echo isset( $tc_examen_fisico_neurologico ) ? nl2br( $tc_examen_fisico_neurologico ) : NULL; ?></textarea>
</div>    
<br/>
<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    $ef_campos = array( 'tc_examen_fisico_cabeza', 'tc_examen_fisico_cuello', 'tc_examen_fisico_torax',
                'tc_examen_fisico_abdomen', 'tc_examen_fisico_genitales', 'tc_examen_fisico_extremidades',
                'tc_examen_fisico_neurologico' );

    $tc_chkbx_examen_fisico = !isset( $tc_chkbx_examen_fisico ) ? $ef_campos : $tc_chkbx_examen_fisico;

    $x = $pdf->GetX();

    foreach( $tc_chkbx_examen_fisico as $valor ) {

        $pdf->SetFont( 'Arial', 'B' );
        $pdf->MultiCell( 0, 6, html_entity_decode( $this->lang->line( $valor ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1' ), 0, 'L', false, 0 );
        $pdf->SetX( $x );

        $pdf->SetFont( 'Arial' );
        $pdf->MultiCell( 0, 6, utf8_decode( ${$valor} ), 0, 'L', false, 0 );
        $pdf->Ln();
        $pdf->SetX( $x );
    }
}

