<?php

if( $modo == FormularioXML::$MODO_LECTURA ) {

    $preexistencia_chkbx = !isset( $preexistencia_chkbx ) ? array() : $preexistencia_chkbx;

    if( !empty( $preexistencia_chkbx ) ) {

        foreach( $preexistencia_chkbx as $valor ) {

            $texto = "";
            switch( (string)$valor ) {
                case 'preexistencia_miope'      : $texto = $this->lang->line('oftalmologia_miope'); break;
                case 'preexistencia_hipermetro' : $texto = $this->lang->line('oftalmologia_hipermetro'); break;
                case 'preexistencia_catarata'   : $texto = $this->lang->line('oftalmologia_catarata'); break;
                case 'preexistencia_glaucoma'   : $texto = $this->lang->line('oftalmologia_glaucoma'); break;
                default : $texto = '-'; break;
            } ?>

            <span><?= !empty( $texto ) ? $texto : '-' ?></span><br />
<?php   }
    } else { ?>
        <span><?=$this->lang->line('oftalmologia_sin_preexistencia')?></span><br />
<?php }
}

if( $modo == FormularioXML::$MODO_ESCRITURA) { ?>

<script language="javascript" type="text/javascript">

    $(document).ready( function( ) {

    } );

</script>

<?php $preexistencia_chkbx = !isset( $preexistencia_chkbx ) ? array() : $preexistencia_chkbx; ?>

<!-- 1: Miope -->
<input type="checkbox"
   id="preexistencia_chkbx_miope"
   name="preexistencia_chkbx[]"
   value="preexistencia_miope"
      <?php if( array_search( 'preexistencia_miope', $preexistencia_chkbx ) !== FALSE ) echo( 'checked="checked"' ); ?>
/>
<label for="preexistencia_chkbx_miope"><?= $this->lang->line('oftalmologia_miope') ?></label>
<br/>

<!--2: Hipermetro -->
<input type="checkbox"
   id="preexistencia_chkbx_hipermetro"
   name="preexistencia_chkbx[]"
   value="preexistencia_hipermetro"
      <?php if( array_search( 'preexistencia_hipermetro', $preexistencia_chkbx ) !== FALSE ) echo( 'checked="checked"' ); ?>
/>
<label for="preexistencia_chkbx_hipermetro"><?= $this->lang->line('oftalmologia_hipermetro') ?></label>
<br/>

<!--3: Catarata -->
<input type="checkbox"
   id="preexistencia_chkbx_catarata"
   name="preexistencia_chkbx[]"
   value="preexistencia_catarata"
      <?php if( array_search( 'preexistencia_catarata', $preexistencia_chkbx ) !== FALSE ) echo( 'checked="checked"' ); ?>
/>
<label for="preexistencia_chkbx_catarata"><?= $this->lang->line('oftalmologia_catarata') ?></label>
<br/>

<!--4: Glaucoma -->
<input type="checkbox"
   id="preexistencia_chkbx_glaucoma"
   name="preexistencia_chkbx[]"
   value="preexistencia_glaucoma"
      <?php if( array_search( 'preexistencia_glaucoma', $preexistencia_chkbx ) !== FALSE ) echo( 'checked="checked"' ); ?>
/>
<label for="preexistencia_chkbx_glaucoma"><?= $this->lang->line('oftalmologia_glaucoma') ?></label>
<br/>

<?php }

if( $modo == FormularioXML::$MODO_PDF ) {

    $preexistencia_chkbx = !isset( $preexistencia_chkbx ) ? array() : $preexistencia_chkbx;

    $x = $pdf->GetX();

    $pdf->SetX( $x );
    $pdf->SetFont( 'Arial' );

    if( !empty( $preexistencia_chkbx ) ) {

        foreach( $preexistencia_chkbx as $valor ) {

            $texto = "";
            switch( (string)$valor ) {
                case 'preexistencia_miope'      : $texto = $this->lang->line('oftalmologia_miope'); break;
                case 'preexistencia_hipermetro' : $texto = $this->lang->line('oftalmologia_hipermetro'); break;
                case 'preexistencia_catarata'   : $texto = $this->lang->line('oftalmologia_catarata'); break;
                case 'preexistencia_glaucoma'   : $texto = $this->lang->line('oftalmologia_glaucoma'); break;
                default : $texto = '-'; break;
            }

            $pdf->MultiCell( 0, 6, html_entity_decode( $texto, ENT_COMPAT, 'UTF-8'  ), 0, 'L', false, 0 );
            $pdf->SetX( $x );
        }
    } else {

        $pdf->SetFont( 'Arial', 'I' );
        $pdf->MultiCell( 0, 6, html_entity_decode( $this->lang->line( 'oftalmologia_sin_preexistencia' ), ENT_COMPAT | ENT_HTML401, 'ISO-8859-1', ENT_COMPAT, 'UTF-8' ), 0, 'L', false, 0 );
        $pdf->SetFont( 'Arial' );
    }
}