
<div id="formula" >

    <style type="text/css">

        #formula {  }
        #formula table { border-spacing: 0px; width: 100%; border-collapse: collapse; }
        #formula table td { border: 1px; border-style: solid; }
        #formula table .titulo { background-color: #CCCCCC; }
        #formula table .texto_derecha { text-align: right; }
        #formula table .texto_item  { text-align: center; background-color: #DDDDFF }
        #formula .eliminar_formula  {
            height: 18px;
            width:  17px;
            background-image: url( '../images/drop.png' );
            border: 0;
            padding: 0;
        }
        #formula .crear_medicamento {
            height: 14px;
            cursor: pointer;
            vertical-align: middle;
        }
    </style>

    <form name="formula_form" method="POST" id="formula_form">
        <input type="hidden" value="<?=$tc['TEL_ID']?>" name="tel_id" />
        <input type="hidden" value="<?=$generalista['USU_ID']?>" name="id_medico_generalista" />
        <input type="hidden" value="<?=$especialista['USU_ID']?>" name="id_medico_especialista" />
        <input type="hidden" value="" name="recetario_id_municipio" id="recetario_id_municipio" />

        <table>
            <tr>
                <td style="border: 0; padding: 0; text-align: right;" ><button class="boton_01" id="guardar_formula" type="submit"><?=$this->lang->line('guardar')?></button></td>
            </tr>
        </table>

        <?php
        // Compatibilidad para atrás: nueva funcionalidad elimina nombre en fórmula
        if( count( $tc['FORMULAS'] ) > 1 ) { ?>
        <!-- 0. Nombre -->
        <table>
            <tbody>
                <tr>
                    <td><?=$this->lang->line('recetario_nombre')?>: <input type="text" name="recetario_nombre_formula" id="recetario_nombre_formula" size="50" class="validate[required]" /></td>
                </tr>
            </tbody>
        </table>
        <?php } ?>

        <!-- 1. Paciente, fecha -->
        <table>
            <tbody>
                <tr>
                    <td class="titulo" >1. <?=$this->lang->line('recetario_paciente')?></td>
                </tr>
            </tbody>
        </table>

        <!-- Nombre del paciente -->
        <table>
            <tbody>
                <tr>
                    <td class="texto_item" style="width: 33%"><?=$this->lang->line('recetario_primer_apellido')?></td>
                    <td class="texto_item" style="width: 33%"><?=$this->lang->line('recetario_segundo_apellido')?></td>
                    <td class="texto_item" style="width: 34%"><?=$this->lang->line('recetario_nombres')?></td>
                </tr>
                <tr>
                    <td style="width: 33%"><?=$tc['TEL_PAC_PRIMER_APELLIDO']?></td>
                    <td style="width: 33%"><?=$tc['TEL_PAC_SEGUNDO_APELLIDO']?></td>
                    <td style="width: 34%"><?=$tc['TEL_PAC_PRIMER_NOMBRE']. ' ' .$tc['TEL_PAC_SEGUNDO_NOMBRE']?></td>
                </tr>
            </tbody>
        </table>

        <!-- Documentación, edad, género -->
        <table>
            <tbody>
                <tr>
                    <td class="texto_item" style="width: 35%"><?=$this->lang->line('recetario_documento_identificacion')?></td>
                    <td class="texto_item" style="width: 25%"><?=$this->lang->line('recetario_numero')?></td>
                    <td class="texto_item" style="width: 20%"><?=$this->lang->line('recetario_edad')?></td>
                    <td class="texto_item" style="width: 20%"><?=$this->lang->line('recetario_genero')?></td>
                </tr>
                <tr>
                    <td>
                        <?=$this->lang->line('recetario_t_i')?>
                        <span style="text-decoration: underline">&nbsp;&nbsp;<?=( $paciente_identificadores[0]['TIPO_IDENTIFICACION'] == 'TI' )? 'X':'&nbsp;'?>&nbsp;&nbsp;</span>

                        &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
                        <?=$this->lang->line('recetario_c_c')?>
                        <span style="text-decoration: underline">&nbsp;&nbsp;<?=( $paciente_identificadores[0]['TIPO_IDENTIFICACION'] == 'CC' )? 'X':'&nbsp;'?>&nbsp;&nbsp;</span>

                        &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
                        <?=$this->lang->line('recetario_otro')?>
                        <span style="text-decoration: underline">&nbsp;&nbsp;<?=( $paciente_identificadores[0]['TIPO_IDENTIFICACION'] != 'TI' && $paciente_identificadores[0]['TIPO_IDENTIFICACION'] != 'CC' )? 'X':'&nbsp;'?>&nbsp;&nbsp;</span>
                    </td>
                    <td><?=$paciente_identificadores[0]['PAC_IDT_VALOR']?></td>
                    <td style="text-align: center;"><?=$tc['TEL_PAC_EDAD']?></td>
                    <td style="text-align: center;">
                        <?=$this->lang->line('recetario_genero_f')?>
                        <span style="text-decoration: underline">&nbsp;&nbsp;<?=( $tc['TEL_PAC_SEXO'] == 'F' )? 'X':'&nbsp;'?>&nbsp;&nbsp;</span>
                        &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
                        <?=$this->lang->line('recetario_genero_m')?>
                        <span style="text-decoration: underline">&nbsp;&nbsp;<?=( $tc['TEL_PAC_SEXO'] == 'M' )? 'X':'&nbsp;'?>&nbsp;&nbsp;</span>
                    </td>
                </tr>
            </tbody>
        </table>

        <!-- Télefono, municipio, dirección de la residencia, departamento -->
        <table>
            <tbody>
                <tr>
                    <td class="texto_item"><?=$this->lang->line('recetario_telefono')?></td>
                    <td class="texto_item"><?=$this->lang->line('recetario_municipio')?></td>
                    <td class="texto_item"><?=$this->lang->line('recetario_direccion_residencia')?></td>
                    <td class="texto_item"><?=$this->lang->line('recetario_departamento')?></td>
                </tr>
                <tr>
                    <td><input type="text" name="recetario_telefono" value="<?=!empty( $tc['TEL_PAC_TELEFONO'] ) ? $tc['TEL_PAC_TELEFONO'] : '' ?>" style="width: 99%"/></td>
                    <td><input type="text" name="recetario_municipio" id="recetario_municipio" style="width: 99%" /></td>
                    <td><input type="text" name="recetario_direccion_residencia" value="" style="width: 99%"/> </td>
                    <td><input type="text" name="recetario_departamento" id="recetario_departamento" style="width: 99%" readonly="readonly" /></td>
                </tr>
            </tbody>
        </table>

        <!-- Afiliación SGSSS, Subsidiado, contributivo, vinculado, nombre de la identidad -->
        <table>
            <tbody>
                <tr>
                    <td class="texto_item"><?=$this->lang->line('recetario_afiliacion')?></td>
                    <td class="texto_item"><?=$this->lang->line('recetario_nombre_entidad')?></td>
                </tr>
                <tr>
                    <td>
                        <?=$this->lang->line('recetario_subsidiado')?>
                        <span style="text-decoration: underline">&nbsp;&nbsp;<?=( $tc['AFI_ID'] == Platc::$AFILIACIONES_CO['REGIMENES_SUBSIDIADO'] )? 'X':'&nbsp;'?>&nbsp;&nbsp;</span>
                        &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;

                        <?=$this->lang->line('recetario_contributivo')?>
                        <span style="text-decoration: underline">&nbsp;&nbsp;<?=( $tc['AFI_ID'] == Platc::$AFILIACIONES_CO['REGIMENES_CONTRIBUTIVO'] )? 'X':'&nbsp;'?>&nbsp;&nbsp;</span>
                        &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;

                        <?=$this->lang->line('recetario_vinculado')?>
                        <span style="text-decoration: underline">&nbsp;&nbsp;<?=( $tc['AFI_ID'] == Platc::$AFILIACIONES_CO['VINCULADO'] )? 'X':'&nbsp;'?>&nbsp;&nbsp;</span>
                        &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;

                        <?=$this->lang->line('recetario_otro')?>
                        <span style="text-decoration: underline">&nbsp;&nbsp;<?=(   $tc['AFI_ID'] != Platc::$AFILIACIONES_CO['REGIMENES_SUBSIDIADO'] &&
                                                                                    $tc['AFI_ID'] != Platc::$AFILIACIONES_CO['REGIMENES_CONTRIBUTIVO']  &&
                                                                                    $tc['AFI_ID'] != Platc::$AFILIACIONES_CO['VINCULADO'] )? 'X':'&nbsp;'?>&nbsp;&nbsp;</span>
                    </td>
                    <td><?=( isset( $tc['ENTADM_NOMBRE'] ) && !empty( $tc['ENTADM_NOMBRE'] ) ) ? $tc['ENTADM_NOMBRE'] : '<input type="text" name="recetario_entidad_administradora" style="width: 99%" />' ?></td>
                </tr>

            </tbody>
        </table>


        <!-- 2. Medicamentos -->
        <table>
            <tbody>
                <tr>
                    <td class="titulo" style="width: 80%">2. <?=$this->lang->line('recetario_medicamentos')?></td>
                    <td class="titulo" style="width: 20%; text-align: center;"><a href="#" id="crear_medicamento" ><img src="<?=base_url()?>images/crear.png" class="crear_medicamento" />&nbsp;<?=$this->lang->line('recetario_agregar_medicamento')?></a></td>
                </tr>
            </tbody>
        </table>

        <!-- Nombre genérico, concentración, forma farmacéutica, dosis, via administracion, cantidad prescrita, en número, en letras -->
        <table  id="grilla_formula">
            <tbody>
                <tr>
                    <td class="texto_item" rowspan="2" ><?=$this->lang->line('recetario_nombre_generico')?></td>
                    <td class="texto_item" rowspan="2" ><?=$this->lang->line('recetario_concentracion')?></td>
                    <td class="texto_item" rowspan="2" ><?=$this->lang->line('recetario_forma_farmaceutica')?></td>
                    <td class="texto_item" rowspan="2" ><?=$this->lang->line('recetario_dosis')?></td>
                    <td class="texto_item" rowspan="2" ><?=$this->lang->line('recetario_via_administracion')?></td>
                    <td class="texto_item" colspan="2" ><?=$this->lang->line('recetario_cantidad_prescrita')?></td>
                </tr>
                <tr>
                    <td><?=$this->lang->line('recetario_en_numeros')?></td>
                    <td><?=$this->lang->line('recetario_en_letras')?></td>
                </tr>
                <tr>
                    <td><textarea style="width: 225px;" type="text" id="nombre_generico_1" name="nombre_generico[1]" class="validate[required]" ></textarea></td>
                    <td><textarea style="width: 150px;" type="text" id="concentracion_1" name="concentracion[1]" class="validate[required]" ></textarea></td>
                    <td><textarea style="width: 100px;" type="text" id="forma_farmaceutica_1" name="forma_farmaceutica[1]" class="validate[required]" ></textarea></td>
                    <td><textarea style="width: 100px;" type="text" id="dosis_1" name="dosis[1]" class="validate[required]" ></textarea></td>
                    <td><textarea style="width: 110px;" type="text" id="via_administracion_1" name="via_administracion[1]" class="validate[required]" ></textarea></td>
                    <td><textarea style="width: 54px;"  type="text" id="cantidad_prescrita_numeros_1" name="cantidad_prescrita_numeros[1]" class="validate[required]" ></textarea></td>
                    <td><textarea style="width: 50px;"  type="text" id="cantidad_prescrita_letras_1" name="cantidad_prescrita_letras[1]" class="validate[required]" ></textarea></td>
                    <td><img src="<?=base_url()?>images/drop.png" onclick="eliminar_medicamento( this )" /></td>
                </tr>
            </tbody>
        </table>

        <!-- Diagnóstico -->
        <table>
            <tbody>
                <tr>
                    <td class="texto_item"><?=$this->lang->line('recetario_diagnostico')?></td>
                </tr>
                <tr>
                    <td>
                        <?php
                            if( isset( $tc['data']['dm_general'] ) && !empty( $tc['data']['dm_general'] ) ) {

                                foreach( $tc['data']['dm_general'] as $cie_id => $descripcion )
                                    echo( $descripcion.'<br />' );
                            }
                        ?>
                    </td>
                </tr>
            </tbody>
        </table>


        <!-- 3. Profesional que remite el caso -->
        <table>
            <tbody>
                <tr>
                    <td class="titulo">3. <?=$this->lang->line('recetario_profesional_remite_caso')?></td>
                </tr>
            </tbody>
        </table>

        <!-- Nombre completo -->
        <table>
            <tbody>
                <tr>
                    <td class="texto_item"><?=$this->lang->line('recetario_nombre_completo')?></td>
                </tr>
                <tr>
                    <td><?=$generalista['USU_NOMBRE']?></td>
                </tr>
            </tbody>
        </table>

        <!-- Documento de identidad, numero, resolución por la que se autoriza..., firma -->
        <table>
            <tbody>
                <tr>
                    <td class="texto_item"><?=$this->lang->line('recetario_documento_identidad')?></td>
                    <td class="texto_item"><?=$this->lang->line('recetario_numero')?></td>
                    <td class="texto_item"><?=$this->lang->line('recetario_resolucion_autorizacion')?></td>
                    <td class="texto_item"><?=$this->lang->line('recetario_firma')?></td>
                </tr>
                <tr>
                    <td>
                        <?=$this->lang->line('recetario_c_c')?>
                        <span style="text-decoration: underline">&nbsp;&nbsp;<?=( $generalista_identificacion['TIPO_IDENTIFICACION'] == 'CC' )? 'X':'&nbsp;'?>&nbsp;&nbsp;</span>

                        &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
                        <?=$this->lang->line('recetario_t_e')?>
                        <span style="text-decoration: underline">&nbsp;&nbsp;<?=( $generalista_identificacion['TIPO_IDENTIFICACION'] == 'TI' )? 'X':'&nbsp;'?>&nbsp;&nbsp;</span>

                        &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
                        <?=$this->lang->line('recetario_otro')?>
                        <span style="text-decoration: underline">&nbsp;&nbsp;<?=( $generalista_identificacion['TIPO_IDENTIFICACION'] != 'TI' && $generalista_identificacion['TIPO_IDENTIFICACION'] != 'CC' )? 'X':'&nbsp;'?>&nbsp;&nbsp;</span>
                    </td>
                    <td><?=$generalista['IDT_VALOR']?></td>
                    <td><?=$generalista['USU_NRO_REGISTRO']?></td>
                    <td>
                        <?php if( !empty( $generalista['USU_FIRMA'] ) ) { ?>
                            <img src="data:image/png;base64,<?php echo $generalista['USU_FIRMA']; ?>" style="width: 50px;"/>
                        <?php } ?>
                    </td>
                </tr>
            </tbody>
        </table>

        <!-- Institución donde labora, dirección, ciudad, teléfono -->
        <table>
            <tbody>
                <tr>
                    <td class="texto_item"><?=$this->lang->line('recetario_institucion_donde_labora')?></td>
                    <td class="texto_item"><?=$this->lang->line('recetario_institucion_direccion')?></td>
                    <td class="texto_item"><?=$this->lang->line('recetario_institucion_ciudad')?></td>
                    <td class="texto_item"><?=$this->lang->line('recetario_institucion_telefono')?></td>
                </tr>
                <tr>
                    <td><?=$tc['ETB_NOMBRE']?></td>
                    <td><?=$tc['ETB_DIRECCION']?></td>
                    <td><?=$tc['ETB_CIUDAD']?></td>
                    <td><?=$tc['ETB_TELEFONO']?></td>
                </tr>
            </tbody>
        </table>


        <!-- 4. Profesional especialista -->
        <table>
            <tbody>
                <tr>
                    <td class="titulo">4. <?=$this->lang->line('recetario_profesional')?></td>
                </tr>
            </tbody>
        </table>

        <!-- Nombre completo -->
        <table>
            <tbody>
                <tr>
                    <td class="texto_item"><?=$this->lang->line('recetario_nombre_completo')?></td>
                </tr>
                <tr>
                    <td><?=$especialista['USU_NOMBRE']?></td>
                </tr>
            </tbody>
        </table>

        <!-- Documento de identidad, numero, resolución por la que se autoriza..., firma -->
        <table>
            <tbody>
                <tr>
                    <td class="texto_item"><?=$this->lang->line('recetario_documento_identidad')?></td>
                    <td class="texto_item"><?=$this->lang->line('recetario_numero')?></td>
                    <td class="texto_item"><?=$this->lang->line('recetario_resolucion_autorizacion')?></td>
                    <td class="texto_item"><?=$this->lang->line('recetario_firma')?></td>
                </tr>
                <tr>
                    <td>
                        <?=$this->lang->line('recetario_c_c')?>
                        <span style="text-decoration: underline">&nbsp;&nbsp;<?=( $especialista_identificacion['TIPO_IDENTIFICACION'] == 'CC' )? 'X':'&nbsp;'?>&nbsp;&nbsp;</span>

                        &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
                        <?=$this->lang->line('recetario_t_e')?>
                        <span style="text-decoration: underline">&nbsp;&nbsp;<?=( $especialista_identificacion['TIPO_IDENTIFICACION'] == 'TI' )? 'X':'&nbsp;'?>&nbsp;&nbsp;</span>

                        &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;
                        <?=$this->lang->line('recetario_otro')?>
                        <span style="text-decoration: underline">&nbsp;&nbsp;<?=( $especialista_identificacion['TIPO_IDENTIFICACION'] != 'TI' && $especialista_identificacion['TIPO_IDENTIFICACION'] != 'CC' )? 'X':'&nbsp;'?>&nbsp;&nbsp;</span>
                    </td>
                    <td><?=$especialista['IDT_VALOR']?></td>
                    <td><?=$especialista['USU_NRO_REGISTRO']?></td>
                    <td>
                        <?php if( !empty( $especialista['USU_FIRMA'] ) ) { ?>
                            <img src="data:image/png;base64,<?php echo $especialista['USU_FIRMA']; ?>" style="width: 50px;"/>
                        <?php } ?>
                    </td>
                </tr>
            </tbody>
        </table>

        <!-- Institución donde labora, dirección, ciudad, teléfono -->
        <table>
            <tbody>
                <tr>
                    <td class="texto_item"><?=$this->lang->line('recetario_institucion_donde_labora')?></td>
                    <td class="texto_item"><?=$this->lang->line('recetario_institucion_direccion')?></td>
                    <td class="texto_item"><?=$this->lang->line('recetario_institucion_ciudad')?></td>
                    <td class="texto_item"><?=$this->lang->line('recetario_institucion_telefono')?></td>
                </tr>
                <tr>
                    <td><?=$this->config->item( 'receta_institucion', 'platc' )?></td>
                    <td><?=$this->config->item( 'receta_direccion', 'platc' )?></td>
                    <td><?=$this->config->item( 'receta_ciudad', 'platc' )?></td>
                    <td><?=$this->config->item( 'receta_telefono', 'platc' )?></td>
                </tr>
            </tbody>
        </table>


        <!-- 5. Entrega del medicamento -->
        <table>
            <tbody>
                <tr>
                    <td class="titulo">5. <?=$this->lang->line('recetario_entrega_medicamento')?></td>
                </tr>
            </tbody>
        </table>

        <!-- Nombre completo quien recibe -->
        <table>
            <tbody>
                <tr>
                    <td class="texto_item"><?=$this->lang->line('recetario_apellidos_nombre_quien_recibe')?></td>
                    <td class="texto_item"><?=$this->lang->line('recetario_n_identidad')?></td>
                    <td class="texto_item"><?=$this->lang->line('recetario_firma')?></td>
                </tr>
                <tr style="height: 50px;">
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                </tr>

                <!-- Nombre completo quien dispensa -->
                <tr>
                    <td class="texto_item"><?=$this->lang->line('recetario_apellidos_nombre_quien_dispensa')?></td>
                    <td class="texto_item"><?=$this->lang->line('recetario_n_identidad')?></td>
                    <td class="texto_item"><?=$this->lang->line('recetario_firma')?></td>
                </tr>
                <tr style="height: 50px;">
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                </tr>
            </tbody>
        </table>

        <!-- Establecimiento farmaceutico minorista -->
        <table>
            <tbody>
                <tr>
                    <td class="texto_item" style="width: 30%" ><?=$this->lang->line('recetario_establecimiento_farmaceutico_nombre')?></td>
                    <td class="texto_item" style="width: 30%"><?=$this->lang->line('recetario_establecimiento_farmaceutico_direccion')?></td>
                    <td class="texto_item" colspan="6" style="width: 40%"><?=$this->lang->line('recetario_fecha_de_despacho')?></td>
                </tr>
                <tr style="height: 50px;">
                    <td>&nbsp;</td>
                    <td>&nbsp;</td>
                    <td><?=$this->lang->line('dia')?></td>
                    <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
                    <td><?=$this->lang->line('mes')?></td>
                    <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
                    <td><?=$this->lang->line('anno')?></td>
                    <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
                </tr>
            </tbody>
        </table>

    </form>
</div>

<script type="text/javascript">

    // Deja registro de los id's creados temporalmente para que no se sobreescriban
    cache_id = new Array();

    $(document).ready( function() {

        $('#formula_form').validationEngine( {
            ajaxSubmit: true,
            ajaxSubmitFile: '<?= base_url() ?>platc/recetario_formula_crea/'+Math.random(),
            success: function( data ) {

                if( data.action == "true" ) {

                    jAlert( "<?=$this->lang->line('recetario_guardar_formula_ok')?>", "OK");

                    <?php if( count( $tc['FORMULAS'] ) > 1 ) { ?>
                        $('#listado_formulas').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?= base_url() ?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
                        $('#listado_formulas').load( '<?=base_url()?>platc/recetario_formula_listar/<?=$tc['TEL_ID']?>/'+Math.random() );
                    <?php } else { ?>
                        $('#recetario_formula_si').attr( 'checked', 'checked' );

                        $('#listado_formulas').jqGrid( 'GridUnload', 'listado_formulas' );
                        $('#listado_formulas').jqGrid( {
                            url: "<?=base_url()?>platc/recetario_formula_listar_medicamentos_tc/<?=$tc['TEL_ID']?>/",
                            datatype: "json",
                            loadonce: true,
                            autowidth: true,
                            colNames: [ "<?=$this->lang->line('recetario_nombre_generico')?>", "<?=$this->lang->line('recetario_dosis')?>" ],
                            colModel: [ {   name: "RFM_NOMBRE_GENERICO" }, {   name: "RFM_DOSIS" } ],
                            ignoreCase: true
                        } );
                        $('#listado_formulas_div').slideDown();

                        // Establece valor del id de la formula y muestra enlace para editarlas
                        formulario_id = data.id_receta;
                    <?php } ?>

                    $('#ventana_formula').dialog("close");
                    $('#ventana_formula').dialog("destroy");
                } else {
                    jAlert(data.msg, data.msgt);
                }
            },
            failure: false
        } );

        $('#recetario_municipio').focus( function( ) {
            nombre_municipio = $(this).val();
            $(this).val('');
        } );

        $('#recetario_municipio').blur( function( ) {
            if( $(this).val() == '' )
                $(this).val( nombre_municipio );
        } );

        $('#recetario_municipio').autocomplete( {
            minLength: 2,
            source: function( request, response ) {

                        $.getJSON(
                            '<?=base_url()?>platc/municipio_autocomplete/'+request.term,
                            {},
                            function( data ) {
                                response( data );
                            }
                        );
                    },
            select: function( event, ui ) {

                if( typeof ui !== 'undefined' ){

                    if( ui.item.label != '' && ui.item.value != '' ) {
                        $( "#recetario_municipio" ).val( ui.item.label );
                        $( "#recetario_id_municipio" ).val( ui.item.value );
                        $.get( '<?=base_url()?>platc/municipio_get_por_id', { id_municipio: ui.item.value }, function( data ) {

                            data = $.parseJSON( data );
                            $('#recetario_departamento').val( data.DEPTO_NOMBRE );
                        } );
                    }
                }

                return false;
            }
        } );

        $('a#crear_medicamento').click( function( e ) {

            // Genera hash: para evitar crear id de elementos html iguales
            do {
                hash = genera_hash( 4 );
                cache_id.push( hash );
            } while( cache_id.indexOf( hash ) === -1 );

            // Evita seguir enlace
            e.preventDefault();

            // Genera html asociado a los medicamentos
            html ='<tr>';
            html+='<td><textarea style="width: 225px;" type="text" id="nombre_generico_'+hash+'" name="nombre_generico['+hash+']" class="validate[required]" ></textarea></td>';
            html+='<td><textarea style="width: 150px;" type="text" id="concentracion_'+hash+'" name="concentracion['+hash+']" class="validate[required]" ></textarea></td>';
            html+='<td><textarea style="width: 100px;" type="text" id="forma_farmaceutica_'+hash+'" name="forma_farmaceutica['+hash+']" class="validate[required]" ></textarea></td>';
            html+='<td><textarea style="width: 100px;" type="text" id="dosis_'+hash+'" name="dosis['+hash+']" class="validate[required]" ></textarea></td>';
            html+='<td><textarea style="width: 110px;" type="text" id="via_administracion_'+hash+'" name="via_administracion['+hash+']" class="validate[required]" ></textarea></td>';
            html+='<td><textarea style="width: 54px;"  type="text" id="cantidad_prescrita_numeros_'+hash+'" name="cantidad_prescrita_numeros['+hash+']" class="validate[required]" ></textarea></td>';
            html+='<td><textarea style="width: 50px;"  type="text" id="cantidad_prescrita_letras_'+hash+'" name="cantidad_prescrita_letras['+hash+']" class="validate[required]" ></textarea></td>';
            html+='<td><img src="<?=base_url()?>images/drop.png" onclick="eliminar_medicamento( this )" /></td>';
            html+='</tr>';
            $('#grilla_formula tbody').append( html );
        } );
    } );

    function genera_hash( largo ) {

        a = Math.random().toString();
        if( a.length-2 < largo ) return false;

        return a.slice( -(largo) );
    }

    function eliminar_medicamento( object ) {

        if( $('#grilla_formula textarea').parent().parent().length === 1 ) {

            jAlert( "<?=$this->lang->line('recetario_formulario_medicamento_error')?>", "<?=$this->lang->line('error')?>" );
            return false;
        } else {
            $(object).parent().parent().remove();
            formulario_modificado = true;
            $('#formula_imprimir').removeClass('boton_imprimir');
            $('#formula_imprimir').addClass('boton_imprimir_desactivado');
        }
    }
</script>
