<?php if( !defined( 'BASEPATH' ) ) exit( 'No direct script access allowed' ); ?>

<script language="javascript" type="text/javascript">

    $(document).ready( function( ) {

        tableToGrid( '#grilla_formulas', {

            width: 500,
            shrinkToFit: true,

            // Numero total de registros a mostrar, usado para evitar que grilla
            // limite filas a su valor por omision (20 filas por pagina) cuando se ordena por columnas
            rowNum: 99999999,

            // Al seleccionar una TC se carga la vista para responder la solicitud del examen
            onSelectRow: function( rowid ) {

                id = $(this).getCell( rowid, 0 );

                $('#ventana_formula').dialog(
                    {   modal: true,
                        resizable: false,
                        width: 900,
                        open: function( event, ui ) {

                            $(this).empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?= base_url() ?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');

                            <?php if( $tc['EST_ID'] == 7 ) { ?>
                            $(this).load('<?=base_url()?>platc/recetario_formula_ver/'+id+'/'+Math.random() );
                            <?php } else { ?>
                            $(this).load('<?=base_url()?>platc/recetario_formula_editar/'+id+'/'+Math.random() );
                            <?php } ?>
                        }
                    }
                );
            },

            gridComplete: function( ) {

                $(this).jqGrid( 'hideCol', 'id_formula' );
            }
        } );

    } );

</script>

<span style="font-weight: bold;"><?=$this->lang->line('recetario_formula_medicamentos')?></span>:

<?php if( !empty( $listado_formulas ) ) { ?>

    <table id="grilla_formulas">
        <thead>
            <tr>
                <th>id_formula</th>
                <th style="width: 500px"><?= $this->lang->line( 'recetario_nombre' ) ?></th>
            </tr>
        </thead>
        <tbody>
            <?php foreach( $listado_formulas as $formula ) { ?>
                <tr>
                    <td><?= $formula['REC_ID'] ?></td>
                    <td><?= character_limiter( $formula['RFM_NOMBRE_GENERICO'], 10 ) ?></td>
                </tr>
            <?php } ?>
        </tbody>
    </table>
<?php } else { ?>

    <?=$this->lang->line( 'recetario_sin_formulas' )?>

<?php } ?>
