<?php if( !defined( 'BASEPATH' ) ) exit( 'No direct script access allowed' );

$boton_cambiar_paciente = array(    'name'  => 'boton_cambiar_paciente',
                                    'id'    => 'boton_cambiar_paciente',
                                    'type'  => 'button',
                                    'class' => 'boton_01',
                                    'content' => $this->lang->line('tc_admin_btn_cambiar_paciente') );

$id_tc_inpt = array('name'  => 'id_teleconsulta',
                    'id'    => 'id_teleconsulta',
                    'type'  => 'hidden',
                    'value' => $tc['TEL_ID'] );

$idpac_inpt	= array('name'  => 'idpac',
                    'id'    => 'idpac',
                    'type'  => 'hidden',
                    'value' => $tc['PAC_ID'] );

$id_form                = array( 'method' => 'post', 'name' => 'id_form', 'id' => 'id_form' );
$id_inpt                = array( 'name' => 'id', 'id' => 'id', 'type' => 'text', 'size' => '30' );
$buscar_id_butn         = array( 'name' => 'button', 'id' => 'busqueda_paciente_id', 'type' => 'button', 'class' => 'boton_buscar' );
$nombre_apellido_form   = array( 'method' => 'post', 'name' => 'nombre_apellido_form', 'id' => 'nombre_apellido_form' );
$nombre_inpt            = array( 'name' => 'nombre', 'id' => 'nombre', 'type' => 'text', 'size' => '30' );
$apellido_inpt          = array( 'name' => 'apellido', 'id' => 'apellido', 'type' => 'text', 'size' => '30' );
$buscar_nombre_apellido_butn = array( 'name' => 'buscar_nombre_apellido_butn', 'id' => 'buscar_nombre_apellido_butn', 'type' => 'button', 'class' => 'boton_buscar' );
?>

<script language="javascript" type="text/javascript">

    $(document).ready(function() {

        $.validationEngine.closePrompt('.formError', true);

        $('#regresar').click( function( ) {
            $('#deploy').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?=base_url()?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
            $('#deploy').load( '<?=base_url()?>platc/tc_admin' );
        } );

        // Boton de despliegue cuadro de solicitud de examenes
        $('#boton_cambiar_paciente').toggle( function( ) {

            $('#display_busqueda_paciente').slideDown( );
        }, function( ) {

            $('#display_busqueda_paciente').slideUp( );
        } );

        $('#busqueda_paciente_id').click( function( ) {
            buscar_paciente_por_id( document.id_form.id.value, '1' );
        } );

        // Busqueda por ID paciente: Evita envío de formulario al apretar tecla Enter y cambia grilla con los resultados de la búsqueda
        $('#id_form input[type="text"]').keypress( function( e ) {

            // e.which == 13: Comprueba tecla Enter
            if( e.which == 13 ) {

                e.preventDefault();     // Evita envío de formulario

                buscar_paciente_por_id( document.id_form.id.value, '1' );
            }
        } );

        // Busqueda por Nombre|Apellido paciente: al hacer click en la lupa
        $('#buscar_nombre_apellido_butn').click( function( ) {
            buscar_paciente_por_nombre_apellido( document.nombre_apellido_form.nombre.value, document.nombre_apellido_form.apellido.value, '1' );
        } );

        // Busqueda por Nombre|Apellido paciente: Evita envío de formulario al apretar tecla Enter y cambia grilla con los resultados de la búsqueda
        $('#nombre_apellido_form input[type="text"]').keypress( function( e ) {

            // e.which == 13: Comprueba tecla Enter
            if( e.which == 13 ) {

                e.preventDefault();     // Evita envío de formulario

                buscar_paciente_por_nombre_apellido( document.nombre_apellido_form.nombre.value, document.nombre_apellido_form.apellido.value, '1' );
            }
        } );

    } );

    /*
     * Busca paciente usando su ID
     */
    function buscar_paciente_por_id( id, resp ) {

        $('#datos_paciente_view').empty();
        $('#deploy_busqueda').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?= base_url() ?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
        $.post(
            "<?= base_url() ?>platc/paciente_busca_id",
            { id: id, resp: resp  },
            function( data ) {

                document.getElementById("deploy_busqueda").innerHTML=data;
                tableToGrid( '#grilla_resultado_busqueda', {

                    onSelectRow: function( rowid, status, e ) {
                        id_paciente = $(this).getCell( rowid, 0 );
                        cargar_paciente_tc( id_paciente );
                    },
                    gridComplete: function( ) {

                        $(this).jqGrid( 'hideCol', 'id_paciente' );
                    }
                } );
            }
        );
    }

    /*
     * Busca paciente usando su nombre y/o apellido
     */
    function buscar_paciente_por_nombre_apellido( nombre, apellido, resp) {

        $('#datos_paciente_view').empty();
        $('#deploy_busqueda').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?= base_url() ?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
        $.post(
            "<?= base_url() ?>platc/paciente_busca_na",
            { nombre: nombre, apellido: apellido, resp: resp },
            function( data ) {
                document.getElementById("deploy_busqueda").innerHTML=data;
                tableToGrid( '#grilla_resultado_busqueda', {

                    autowidth: true,
                    onSelectRow: function( rowid, status, e ) {
                        id_paciente = $(this).getCell( rowid, 0 );
                        cargar_paciente_tc( id_paciente );
                    }
                } );
                $("#grilla_resultado_busqueda").jqGrid( 'hideCol', 'id_paciente' );
            }
        );
    }

    function cargar_paciente_tc( id_paciente ) {
    	$('#datos_paciente_view').empty().html('<div align="center"><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?= base_url() ?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
    	$('#datos_paciente_view').load('<?= base_url() ?>platc/tc_admin_getpacientenuevo/'+id_paciente+'/'+ Math.random());
    	$('#idpac').val( id_paciente );
    }

    function actualizar_tc_admin() {

        if ($('#establecimiento').val() != '') {

            $.post(
                    '<?php echo base_url() ?>platc/tc_admin_actualizar',
                    {   tel_id: $('#id_teleconsulta').val(),
                        etb_id: $('#establecimiento').val(),
                        pac_id: $('#idpac').val() },
                    function( data ) {
                        if (data != '') {
                            alert('<?php echo $this->lang->line( 'tc_admin_btn_msg_guardar' ) ?>');
                            $('#deploy').load('<?php echo base_url() ?>platc/tc_admin/');
                        }
                        else
                            alert('<?php echo $this->lang->line( 'tc_admin_btn_msg_error' ) ?>');
                    }
            );
        }
    }
</script>

<table width="100%" border="0" cellspacing="0" cellpadding="0">
    <tr>
        <td align="center" class="Subtitulo">&nbsp;<?= $titulo ?></td>
    </tr>
    <tr>
        <td align="center">

            <!-- Informacion como títulos -->
            <table align="center" cellpadding="0" cellspacing="0" border="0" width="98%">
                <tr>
                    <td align="right"><?= $this->lang->line('tc_numero') ?>: <strong><?= $tc['TEL_ID'] ?></strong></td>
                </tr>
            </table>

            <table align="center" cellpadding="0" cellspacing="0" border="0" width="98%">
                <tr>
                    <td align="left">
                        <a id="regresar">
                            <img src="<?= base_url() ?>images/volver.png" border="0" />
                        </a>
                    </td>
                    <td align="right" width="60%">
                        <table align="right" cellpadding="0" cellspacing="0" border="0" class="tab_data_form">
                            <tr>
                                <td align="right" class="title_data_form3"><strong><?= $this->lang->line('prioridad_actual') ?>:</strong>&nbsp;</td>
                                <td align="left" valign="bottom" class="title_data_form3" background="<?= base_url() ?>images/<?= $this->lang->line('prioridad_' . $tc['PRI_ID'] . '_img') ?>">&nbsp;&nbsp;&nbsp;&nbsp;<?= $this->lang->line('prioridad_' . $tc['PRI_ID']) ?></td>
                                <td align="right" class="title_data_form3"><strong><?= $this->lang->line('fecha') ?>:</strong>&nbsp;&nbsp;<?= $tc['TEL_FECHA_HORA'] ?></td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>

            <!-- Datos de la Teleconsulta -->
            <table class="tab_data_form" align="center" cellpadding="0" cellspacing="0" border="0">
                <tr>
                    <td>
                        <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                            <tr>
                                <td class="title_data_form"><?=$this->lang->line('tc_form_cliente')?></td>
                                <td class="title_data_form2">(<span class="redtext">&nbsp;*&nbsp;</span>)&nbsp;<?=$this->lang->line('obligatorios')?></td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td>
                        <table cellpadding="0" cellspacing="0" border="0" align="center" width="70%">
            <?php
                        // Campos para RIPS
                        if( $this->session->userdata('SIT_ID') == 22 ) { ?>
                            <tr>
                                <td class="data_form"><?=$this->lang->line('tc_entidad_administradora')?>: </td>
                                <td align="left"><?=$tc['ENTADM_NOMBRE']?></td>
                            </tr>
                            <tr>
                                <td class="data_form"><?=$this->lang->line('tc_finalidad_procedimiento')?>: </td>
                                <td align="left"><?=$tc['FINPROC_DESCRIPCION']?></td>
                            </tr>
                            <tr>
                                <td class="data_form"><?=$this->lang->line('tc_ambito_procedimiento')?>: </td>
                                <td align="left"><?=$tc['AMBPROC_DESCRIPCION']?></td>
                            </tr>
                            <tr>
                                <td class="data_form"><?=$this->lang->line('tc_codigo_autorizacion')?>: </td>
                                <td align="left"><?=$tc['TEL_CODIGO_AUTORIZACION']?></td>
                            </tr>
                            <tr>
                                <td class="data_form"><?=$this->lang->line('tc_zona_residencia')?>: </td>
                                <td align="left"><?=$tc['ZON_NOMBRE']?></td>
                            </tr>
            <?php } ?>
                            <tr>
                                <td class="data_form"><span class="redtext">*</span>&nbsp;<?=$this->lang->line('tc_establecimiento')?>: </td>
                                <td align="left">
                                    <?=form_dropdown('establecimiento', $establecimiento_select, $tc['ETB_ID'], 'class="validate[required]" id="establecimiento"')?>
                                    <input type="hidden" name="tc_establecimiento" id="tc_establecimiento" />
                                </td>
                            </tr>
                            <tr>
                                <td class="data_form"><span class="redtext">*</span>&nbsp;<?=$this->lang->line('tc_prioridad')?>: </td>
                                <td align="left"><?=$this->lang->line('prioridad_'.$tc['PRI_ID']);?>
                                </td>
                            </tr>
                            <tr>
                                <td class="data_form"><span class="redtext">*</span>&nbsp;<?=$this->lang->line('tc_especialidad')?>: </td>
                                <td align="left"><?=$tc['ESP_NOMBRE']?></td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>

            <br/>

            <!-- Datos del paciente -->
            <?=form_input($id_tc_inpt) ?>
            <?=form_input($idpac_inpt) ?>
            <table class="tab_data_form" align="center" cellpadding="0" cellspacing="0" border="0">
                <tr>
                    <td>
                        <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                            <tr>
                                <td class="title_data_form"><?= $this->lang->line('tc_datos_paciente') ?></td>
                            </tr>
                        </table>
                    </td>
                    <td>
                        <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                            <tr>
                                <td class="title_data_form"><?= $this->lang->line('tc_ident_paciente') ?></td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td>
                        <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                            <tr>
                                <td class="data_form"><?= $this->lang->line('p_nombre_completo') ?>: </td>
                                <td align="left"><?= $tc['TEL_PAC_PRIMER_NOMBRE'] ?> <?= $tc['TEL_PAC_SEGUNDO_NOMBRE'] ?> <?= $tc['TEL_PAC_PRIMER_APELLIDO'] ?> <?= $tc['TEL_PAC_SEGUNDO_APELLIDO'] ?></td>
                            </tr>
                            <tr>
                                <td class="data_form"><?= $this->lang->line('p_fecha_nacimiento') ?>: </td>
                                <td align="left"><?= $this->util->fecha_orden($tc['TEL_PAC_NACIMIENTO']) ?></td>
                            </tr>
                            <tr>
                                <td class="data_form"><?= $this->lang->line('p_edad') ?>: </td>
                                <td align="left"><?= $tc['TEL_PAC_EDAD'] ?>&nbsp;<?= $this->lang->line('annos') ?></td>
                            </tr>
                            <tr>
                                <td class="data_form"><?= $this->lang->line('p_sexo') ?>: </td>
                                <td align="left">
                                    <?php
                                    if ($tc['TEL_PAC_SEXO'] == 'M')
                                        echo $this->lang->line('p_masculino');
                                    else
                                        echo $this->lang->line('p_femenino');
                                    ?>
                                </td>
                            </tr>
                            <tr>
                                <td class="data_form"><?= $this->lang->line('p_telefono') ?>: </td>
                                <td align="left"><?= ( !empty( $tc['TEL_PAC_TELEFONO'] ) ? $tc['TEL_PAC_TELEFONO'] : '-' ) ?></td>
                            </tr>
                            <tr>
                                <td class="data_form"><?= $this->lang->line('p_email') ?>: </td>
                                <td align="left"><?= ( !empty( $tc['TEL_PAC_EMAIL'] ) ? $tc['TEL_PAC_EMAIL'] : '-' ) ?></td>
                            </tr>
                            <tr>
                                <td class="data_form"><?= $this->lang->line('p_procedencia') ?>: </td>
                                <td align="left"><?= $tc['TEL_PAC_PROCEDENCIA'] ?></td>
                            </tr>
                            <tr>
                                <td class="data_form"><?= $this->lang->line('p_ocupacion') ?>: </td>
                                <td align="left"><?= $tc['TEL_PAC_OCUPACION'] ?></td>
                            </tr>
                            <tr>
                                <td class="data_form"><?= $this->lang->line('afiliacion') ?>: </td>
                                <td align="left"><?= $tc['TEL_PAC_AFI_NOMBRE'] ?></td>
                            </tr>
                        </table>
                    </td>
                    <td valign="top">
                        <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                            <?php foreach ($identificadores as $identificador) { ?>
                                <tr>
                                    <td class="data_form"><?= $identificador['TCI_NOMBRE'] ?>: </td>
                                    <td align="left"><?php if(  (int)$this->session->userdata('ROL_ID') == (int)Platc::$ROL['MEDICO_GENERAL'] ||
                                                                (int)$this->session->userdata('ROL_ID') == (int)Platc::$ROL['MEDICO_ASISTENTE'] ) { ?><a class="thickbox" href="<?= base_url() ?>platc/tc_examenes_get/<?= $identificador['TCI_VALOR'] ?>/<?= $tc['SIT_ID'] ?>/?TB_iframe=true&height=420&width=600" title="<?= $this->lang->line('examenes_pit') ?>"><?php } ?><?= $identificador['TCI_VALOR'] ?><?php if( (int)$this->session->userdata('ROL_ID') == (int)Platc::$ROL['ADMIN'] || (int)$this->session->userdata('ROL_ID') == (int)Platc::$ROL['SUPERVISOR'] || (int)$this->session->userdata('ROL_ID') == (int)Platc::$ROL['ESPECIALISTA'] ) { ?></a><?php } ?></td>
                                </tr>
                            <?php } ?>
                        </table>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td><div id="tc_admin_buscar_paciente">&nbsp;</div></td>
    </tr>

</table>

<!-- Botones -->
<table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
    <tr>
        <td align="center"><?= form_button($boton_cambiar_paciente) ?></td>
        <td align="center">
            <button id="btn_tc_admin_actualizar_tc"
                    name="btn_tc_admin_actualizar_tc"
                    class="boton_guardar"
                    type="button"
                    onclick="actualizar_tc_admin()"><?php echo $this->lang->line('guardar')?></button>
        </td>
    </tr>
</table>

<div id="display_busqueda_paciente" style="display: none;">
    <table align="right" cellpadding="0" cellspacing="0" border="0" width="100%">
        <tr>
            <td align="left"><strong><?= $this->lang->line( 'buscarpor' ) ?></strong></td>
        </tr>
        <tr>
            <td style="vertical-align: top;">
                <?= form_open( '', $id_form ) ?>
                <table align="right" cellpadding="0" cellspacing="4" border="0" class="borde_top_left_right" width="100%">
                    <tr>
                        <td align="left"><img src="<?= base_url() ?>images/row.gif" />&nbsp;<?= $this->lang->line( 'identificador' ) ?>:&nbsp;</td>
                        <td align="right"><?= form_input( $id_inpt ) ?></td>
                    </tr>
                    <tr>
                        <td>&nbsp;</td>
                        <td>&nbsp;</td>
                        <td align="right"><?= form_button( $buscar_id_butn ) ?></td>
                    </tr>
                </table>
                <?= form_close() ?>
            </td>

            <td>
                <?= form_open( '', $nombre_apellido_form ) ?>
                <table align="right" cellpadding="0" cellspacing="4" border="0" class="borde" width="100%">
                    <tr>
                        <td align="left"><img src="<?= base_url() ?>images/row.gif" />&nbsp;<?= $this->lang->line( 'nombreyoapellido' ) ?>:&nbsp;</td>
                        <td>
                            <table align="right" cellpadding="0" cellspacing="4" border="0" width="100%">
                                <tr>
                                    <td align="right" class="texto"><?= $this->lang->line( 'nombre' ) ?>:&nbsp;<?= form_input( $nombre_inpt ) ?></td>
                                </tr>
                                <tr>
                                    <td align="right" class="texto"><?= $this->lang->line( 'apellido' ) ?>:&nbsp;<?= form_input( $apellido_inpt ) ?></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td>&nbsp;</td>
                        <td align="right"><?= form_button( $buscar_nombre_apellido_butn ) ?></td>
                    </tr>
                </table>
                <?= form_close() ?>
            </td>
        </tr>
    </table>

    <div id="deploy_busqueda" style="float: left; width: 100%;"></div>
    <div id="datos_paciente_view" style="float: left; width: 100%;"></div>
</div>

<table class="tab_data_form" align="center" cellpadding="0" cellspacing="0" border="0">
    <tr>
        <td>
            <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
                <tr>
                    <td class="title_data_form"><?= $this->lang->line( 'tc_admin_historia_teleconsulta' ) ?></td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>
            <?php if( isset( $historia ) && !empty( $historia ) ) { ?>
                <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">

                    <thead>
                        <th align="center"><?=$this->lang->line('tc_time')?></th>
                        <th align="center"><?=$this->lang->line('tc_estado')?></th>
                        <th align="center"><?=$this->lang->line('usuario')?></th>
                        <th align="center"><?=$this->lang->line('descripcion')?></th>
                    </thead>
                    <?php foreach( $historia as $suceso ) { ?>
                        <tr>
                            <td class="data_form" style="width:100px;"><?= $suceso['TEP_FECHA_HORA'] ?> </td>
                            <td class="data_form" style="width:100px; text-align: center;"><?=$this->lang->line( 'estado_'.$suceso['EST_ID'] )?> </td>
                            <td class="data_form" style="width:100px; text-align: center;"><?= $suceso['USU_NOMBRE'] ?> </td>
                            <td align="left"><?= nl2br( $suceso['TEP_COMENTARIO'] ) ?></td>
                        </tr>
                    <?php } ?>
                </table>
            <?php } else { ?>
                Sin registros
            <?php } ?>
        </td>
    </tr>
</table>
