<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); ?>

<script type="text/javascript">

    $(document).ready( function( ) {

        tableToGrid( '#grilla_tc_desvinculadas', {

            // Numero total de registros a mostrar, usado para evitar que grilla
            // limite filas a su valor por omision (20 filas por pagina) cuando se ordena por columnas
            rowNum: 99999999,

            onCellSelect: function( rowid, iCol, cellcontent, e ) {

                if( iCol != 7 && rowid != '' ) {
                    id_tc = $(this).getCell( rowid, 0 );

                    if( parseInt( id_tc ) < <?= element( 'id_platc20', $this->config->item( 'platc' ) ) ?> )
                        url = '<?= base_url() ?>platc20/tc_ver/'+id_tc;
                    else
                        url = '<?= base_url() ?>platc/tc_ver/'+id_tc;

                    window.open( url );
                }
            }
        } );
    } );

</script>

<!-- Desvinculación de Teleconsultas -->
<table class="tab_data_form" >
    <tr>
        <td class="title_data_form"><?= $this->lang->line( 'pacientes_teleconsultas_no_vinculadas' ) ?></td>
    </tr>
    <tr>
        <td>
            <?php if( !empty( $tc_desvinculadas ) ) { ?>

            <table id="grilla_tc_desvinculadas" >
                <thead>
                    <tr>
                        <th><?= $this->lang->line( 'tc_id' ) ?></th>
                        <th><?= $this->lang->line( 'tc_establ' ) ?></th>
                        <th><?= $this->lang->line( 'usuarios_especialidad' ) ?></th>
                        <th><?= $this->lang->line( 'tc_time' ) ?></th>
                        <th><?= $this->lang->line( 'tc_estado' ) ?></th>
                        <th><?= $this->lang->line( 'tc_motivo_teleconsulta' ) ?></th>
                        <th><?= $this->lang->line( 'tc_prioridad' ) ?></th>
                        <th>&nbsp;&nbsp;&nbsp;&nbsp;</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach( $tc_desvinculadas as $tc ) { ?>
                        <tr>
                            <td><?= $tc[ 'TEL_ID' ] ?></td>
                            <td><?= $tc[ 'ETB_NOMBRE' ] ?></td>
                            <td><?= $tc[ 'ESP_NOMBRE' ] ?></td>
                            <td><?= $tc[ 'TEL_FECHA_HORA' ] ?></td>
                            <td><?= $this->lang->line( 'estado_' . $tc[ 'EST_ID' ] ) ?></td>
                            <td><?php
                                switch( $tc[ 'TEL_MOTIVO' ] ) {
                                    case '1' : { echo $this->lang->line( 'tc_mot_1' ); } break;
                                    case '2' : { echo $this->lang->line( 'tc_mot_2' ); } break;
                                    case '3' : { echo $this->lang->line( 'tc_mot_3' ); } break;
                                    case '4' : { echo $this->lang->line( 'tc_mot_4' ); } break;
                                    default: echo ' - ';
                                } ?></td>
                            <td> <img src="<?=base_url()?>images/<?= $this->lang->line( 'prioridad_' . $tc[ 'PRI_ID' ] . '_img' ) ?>"> <?= $this->lang->line( 'prioridad_' . $tc[ 'PRI_ID' ] ) ?></td>
                            <td> <a id="vincular_tc" href="#" onclick="return vincular_teleconsulta( <?= $tc[ 'TEL_ID' ] ?> );" > <img src="<?=base_url()?>images/accept.png" title="<?=$this->lang->line('pacientes_vincular_teleconsulta')?>"> </a> </td>
                        </tr> 
                    <?php } ?>
                </tbody>
            </table>

            <?php } else
                echo $this->lang->line( 'grid_nodata' );
            ?>
        </td>
    </tr>
</table>
