<?php

require( APPPATH.'libraries/fpdf/fpdf.php' );

class TC_FPDF20 extends FPDF {

    private $CI = NULL;
    private $imagen_cliente = NULL;

    public function __construct( $orientation='P', $unit='mm', $size='Letter' ) {

        parent::FPDF( $orientation, $unit, $size );

        /**
        * Permite carga de archivos de imagenes desde la base de datos.
        * Obtenido desde: http://www.fpdf.org/en/script/script45.php
        */
        @stream_wrapper_register('var', 'VariableStream');

        // Tipo de fuente por omisión
        $this->SetFont('Arial', '',10);

        $this->CI = &get_instance( );
    }

    function Header() {

        $y = $this->GetY();
        $this->Image( 'images/pdf/top.jpg', null, null, 0, 20 );
//        $x = $this->GetX(); //<--- no funciona
        $x = 175;

        if( !empty( $this->imagen_cliente ) ) {
            $this->Image( 'images/clientes/'.$this->imagen_cliente, $x, $y, 30, 20 );
        }
    }

    function Footer() {

        $this->SetFont('Arial', '', 10);

        $this->SetY(-15);

        $texto = html_entity_decode( $this->CI->lang->line( 'pdf_fecha_y_hora_impresion' ) ) . ': ' . date( 'd-m-Y' ) . ' ' . date( 'H:i' );
        $texto.= '                                               ';
        $texto.= html_entity_decode( $this->CI->lang->line( 'pdf_numero_pagina' ) ) . ' '. $this->PageNo().' de (total): {nb}';
        $this->Ln();
        $this->Cell( 0,0, $texto, 0,0, 'C');
    }

    /**
     * Permite carga de archivos de imagenes desde la base de datos.
     * Obtenido desde: http://www.fpdf.org/en/script/script45.php
     */
    function MemImage($data, $x=null, $y=null, $w=0, $h=0, $link='')
    {
        //Display the image contained in $data
        $v = 'img'.md5($data);
        $GLOBALS[$v] = $data;
        $a = getimagesize('var://'.$v);
        if(!$a)
            $this->Error('Invalid image data');
        $type = substr(strstr($a['mime'],'/'),1);
        $this->Image('var://'.$v, $x, $y, $w, $h, $type, $link);
        unset($GLOBALS[$v]);
    }

    /**
     * Permite carga de archivos de imagenes desde la base de datos.
     * Obtenido desde: http://www.fpdf.org/en/script/script45.php
     */
    function GDImage($im, $x=null, $y=null, $w=0, $h=0, $link='')
    {
        //Display the GD image associated to $im
        ob_start();
        imagepng($im);
        $data = ob_get_clean();
        $this->MemImage($data, $x, $y, $w, $h, $link);
    }

    public function establecer_imagen_cliente( $datos ) {
        $this->imagen_cliente = trim( $datos[ 'usuario_envia' ]['CLI_IMAGEN_INSTITUCIONAL'] );
    }
    /**
     * 
     */
    public function establecer_datos_solicitud( $datos ) {

        $this->AddPage();

        // Datos de la solicitud
        $this->SetFont('Arial', 'B', 10);
        $this->Cell( 0, 6, html_entity_decode( $this->CI->lang->line( 'pdf_datos_de_la_solicitud' ) ), 1, 1 );

        // Primera fila
        $this->SetFont('Arial', '',10);
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'idteleconsulta' ) ).': ', 0, 0, 'R' );
        $this->Cell( 50, 6, utf8_decode( $datos[ 'tc' ][ 'TEL_ID' ] ), 0, 0, 'L' );
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'estado_teleconsulta' ) ).': ', 0, 0, 'R' );
        $this->Cell( 40, 6, html_entity_decode( $this->CI->lang->line( 'estado_' . $datos[ 'estado' ] ) ), 0, 1, 'L' );

        // Segunda fila
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'enviada_por' ) ) .': ', 0, 0, 'R' );
        $y = $this->GetY();     // Lógica para mantener posición en la misma línea: FPDF aunque tenga el parametro correcto realiza salto
        $this->MultiCell( 50, 6, utf8_decode( $datos['usuario_envia'][ 'USU_NOMBRE' ] ), 0, 'L', false, 0 );
        $this->SetY( $y );
        $this->SetX( $this->lMargin + 100 );
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'fechahora_envio' ) ).': ', 0, 0, 'R' );
        $this->Cell( 40, 6, utf8_decode( $datos['estado_enviada'][ 'TEP_FECHA_HORA' ] ), 0, 1, 'L' );

        // Tercera fila
        $this->Cell( 150, 6, html_entity_decode( $this->CI->lang->line( 'nivel_establ_origen' ) ).': ', 0, 0, 'R' );
        $this->Cell( 40, 6, $datos['etb'][ 'ETB_NIVEL' ], 0, 1, 'L' );

        // Cuarta fila: Dibujado en columnas para poner firma después de nº de registro
        //              Así, si establecimiento (2da columna) genera 2 lineas firma y
        //              nº de registro no se separan
        // 1era columna
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'pdf_nro_registro' ) ).': ', 0, 0, 'R' );
        $this->Cell( 50, 6, utf8_decode( $datos['usuario_envia'][ 'USU_NRO_REGISTRO' ] ), 0, 0, 'L' );
        $establ_x = $this->GetX();
        $establ_y = $this->GetY();

        $this->ln( );

        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'usuarios_firma' ) ). ': ', 0, 0, 'R' );
        $x = $this->GetX();
        $y = $this->GetY();
        if( !empty( $datos['usuario_envia'][ 'USU_FIRMA' ] ) ) {
            $this->MemImage( base64_decode( $datos['usuario_envia'][ 'USU_FIRMA' ] ), $x, $y, null, 15 );
        } else
            $this->Cell( 50, 6, '', 0, 1, 'L' );

        // 2da columna
        $this->SetY( $establ_y );
        $this->SetX( $establ_x );
        $this->Cell( 50 , 6, html_entity_decode( $this->CI->lang->line( 'establecimiento_origen' ) ).': ', 0, 0, 'R' );
        $this->MultiCell( 50, 6, utf8_decode( $datos['etb'][ 'ETB_NOMBRE' ] ), 0, 'L', false, 0 );

        // Quinta fila
        $this->SetX( $establ_x );
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'especialidad_destino' ) ).': ', 0, 0, 'R' );
        $this->Cell( 50, 6, utf8_decode( $datos['tc'][ 'ESP_NOMBRE' ] ), 0, 1, 'L' );

        $this->SetX( $establ_x );
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'prioridad_origen' ) ).': ', 0, 0, 'R' );
        $this->Cell( 40, 6, html_entity_decode( $this->CI->lang->line( 'prioridad_' . $datos['estado_enviada'][ 'PRI_ID' ] ) ), 0, 1, 'L' );
    }

    /**
     * 
     */
    public function establecer_datos_paciente( $datos ) {

        // Datos del paciente
        $this->Ln();
        $this->SetFont( 'Arial', 'B', 10 );
        $this->Cell( 0, 6, html_entity_decode( $this->CI->lang->line( 'pdf_datos_del_paciente' ) ), 1, 1 );

        $y = $this->GetY();

        // Primera fila
        $this->SetFont( 'Arial', '', 10 );
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'tc_nombres_apellidos' ) ).': ', 0, 0, 'R' );

        $y2 = $this->GetY();
        $nombre = $datos['tc'][ 'TEL_PAC_PRIMER_NOMBRE' ] . ' ' . $datos['tc'][ 'TEL_PAC_SEGUNDO_NOMBRE' ] . ' ' .
                  $datos['tc'][ 'TEL_PAC_PRIMER_APELLIDO' ] . ' ' . $datos['tc'][ 'TEL_PAC_SEGUNDO_APELLIDO' ];
        $this->MultiCell( 50, 6, utf8_decode( $nombre ), 0, 'L', false, 0 );
        $y = $this->GetY();

        $x = $this->lMargin + 100;
        $this->SetY($y2);
        $this->SetX($x);

        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'pacientes_nacimiento' ) ).': ', 0, 0, 'R' );
        $this->Cell( 40, 6, $this->CI->util->fecha_orden( $datos['tc'][ 'TEL_PAC_NACIMIENTO' ] ), 0, 1, 'L' );
        $y2 = $this->GetY();

        // Segunda fila
//        $this->ln();
        $this->SetY($y);
        $this->Cell( 50, 6, utf8_decode( $datos['identificadores'][ 0 ][ 'TCI_NOMBRE' ] ).': ', 0, 0, 'R' );
        $this->Cell( 50, 6, utf8_decode( $datos['identificadores'][ 0 ][ 'TCI_VALOR' ] ), 0, 1, 'L' );
        $y = $this->GetY();
        $this->SetY($y2);
        $this->SetX($x);
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'edad' ) ).': ', 0, 0, 'R' );
        $this->Cell( 40, 6, utf8_decode( $datos['tc'][ 'TEL_PAC_EDAD' ] ) . ' ' . html_entity_decode( $this->CI->lang->line( 'annos' ) ), 0, 1, 'L' );
        $y2 = $this->GetY( );

        // Tercera fila
        $this->SetY($y);
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'pacientes_procedencia' ) ).': ', 0, 0, 'R' );
        $this->Cell( 50, 6, utf8_decode( $datos['tc'][ 'TEL_PAC_PROCEDENCIA' ] ), 0, 1, 'L' );
        $y = $this->GetY();
        $this->SetY($y2);
        $this->SetX($x);
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'pacientes_sexo' ) ).': ', 0, 0, 'R' );
        $this->Cell( 40, 6, $this->CI->lang->line( 'pacientes_sexo_' . $datos['tc'][ 'TEL_PAC_SEXO' ] ), 0, 1, 'L' );        
        $y2 = $this->GetY( );

        // Cuarta fila
        $this->SetY($y);
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'ocupacion_pdf' ) ).': ', 0, 0, 'R' );
        $this->Cell( 50, 6, utf8_decode( $datos['tc'][ 'TEL_PAC_OCUPACION' ] ), 0, 1, 'L' );
        $y = $this->GetY();
        $this->SetY($y2);
        $this->SetX($x);
        $this->Cell( 50, 6, html_entity_decode( $this->CI->lang->line( 'afiliacion_pdf' ) ).': ', 0, 0, 'R' );
        $this->Cell( 40, 6, utf8_decode( $datos['tc'][ 'TEL_PAC_AFI_NOMBRE' ] ), 0, 1, 'L' );

        $this->SetY($y);
    }

    /**
     * 
     */
    public function establecer_datos_episodio( $datos ) {

        // Datos del episodio/evento
        $this->Ln();
        $this->SetFont( 'Arial', 'B', 10 );
        $this->Cell( 0, 6, html_entity_decode( $this->CI->lang->line( 'pdf_datos_episodio/evento' ) ), 1, 1 );

        // Primera fila
        $this->SetFont( 'Arial', '', 10 );
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'tc_motpaciente' ) ).': ', 0, 0, 'R' );
        $this->Cell( 30, 6, utf8_decode( $datos['tc'][ 'TEL_MOT_PACIENTE' ] ), 0, 1, 'L' );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'tc_motinterconsulta' ) ).': ', 0, 0, 'R' );
        $this->MultiCell( 0, 6, utf8_decode( html_entity_decode( $datos['tc'][ 'TEL_MOTIVO_TEXTO' ], ENT_COMPAT, 'UTF-8' ) ) );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'tc_resatencion' ) ).': ', 0, 0, 'R' );
        $this->MultiCell( 0, 6, utf8_decode( $datos['tc'][ 'TEL_RES_ATENCION' ] ) );

        // Signos vitales y datos físicos del paciente
        $this->SetFont( 'Arial', 'B', 10 );
        $this->Cell( 0, 6, html_entity_decode( $this->CI->lang->line( 'pdf_signos_vitales' ) ), 0, 1 );

        $this->SetFont( 'Arial', '', 10 );
        $this->Cell( 40, 6, html_entity_decode( $this->CI->lang->line( 'tc_svpa_sistolica_pdf' ) ). ' (mmHg): ', 0, 0, 'R' );
        $this->Cell( 20, 6, utf8_decode( $datos['tc'][ 'TEL_SV_PA_SISTOLICA' ] ), 0, 0, 'L' );

        $this->Cell( 40, 6, html_entity_decode( $this->CI->lang->line( 'tc_svpa_diastolica_pdf' ) ). ' (mmHg): ', 0, 0, 'R' );
        $this->Cell( 20, 6, utf8_decode( $datos['tc'][ 'TEL_SV_PA_DIASTOLICA' ] ), 0, 0, 'L' );

        $this->Cell( 40, 6, html_entity_decode( $this->CI->lang->line( 'tc_svpeso' ) ).' (Kg): ', 0, 0, 'R' );
        $this->Cell( 20, 6, utf8_decode( $datos['tc'][ 'TEL_SV_PESO' ] ), 0, 1, 'L' );

        $this->Cell( 40, 6, html_entity_decode( $this->CI->lang->line( 'tc_svfc' ) ).' (lpm): ', 0, 0, 'R' );
        $this->Cell( 20, 6, utf8_decode( $datos['tc'][ 'TEL_SV_FC' ] ), 0, 0, 'L' );

        $this->Cell( 40, 6, html_entity_decode( $this->CI->lang->line( 'tc_svfr' ) ).' (rpm): ', 0, 0, 'R' );
        $this->Cell( 20, 6, utf8_decode( $datos['tc'][ 'TEL_SV_FR' ] ), 0, 0, 'L' );

        $this->Cell( 40, 6, html_entity_decode( $this->CI->lang->line( 'tc_svtalla' ) ).' (cm): ', 0, 0, 'R' );
        $this->Cell( 20, 6, utf8_decode( $datos['tc'][ 'TEL_SV_TALLA' ] ), 0, 1, 'L' );

        $this->Cell( 40, 6, html_entity_decode( $this->CI->lang->line( 'tc_svtemp' ) ).' (C): ', 0, 0, 'R' );
        $this->Cell( 20, 6, utf8_decode( $datos['tc'][ 'TEL_SV_TEMP' ] ), 0, 0, 'L' );

        $this->Cell( 40, 6, html_entity_decode( $this->CI->lang->line( 'tc_svsato2' ) ).' (%): ', 0, 0, 'R' );
        $this->Cell( 20, 6, utf8_decode( $datos['tc'][ 'TEL_SV_SATO2' ] ), 0, 0, 'L' );

        $this->Cell( 40, 6, html_entity_decode( $this->CI->lang->line( 'tc_svimc' ) ) . ': ', 0, 0, 'R' );
        $this->Cell( 20, 6, utf8_decode( $datos['tc'][ 'TEL_SV_IMC' ] ), 0, 1, 'L' );

        $x = $this->GetX() + 120;
        $this->SetX($x);
        $this->Cell( 40, 6, html_entity_decode( $this->CI->lang->line( 'tc_svimc_clasificacion' ) ). ': ', 0, 0, 'R' );
        $this->Cell( 20, 6, utf8_decode( $datos['tc'][ 'TEL_SV_IMC_CLASIFICACION' ] ), 0, 1, 'L' );

        // Signos vitales y datos físicos del paciente
        $this->SetFont( 'Arial', 'B', 10 );
        $this->Cell( 0, 6, html_entity_decode( $this->CI->lang->line( 'pdf_otras_observaciones' ) ), 0, 1 );

        $this->SetFont( 'Arial', '', 10 );
         $ante = array();
        $ante= explode('#/#',$datos['tc']['TEL_ANTECEDENTES']);
        
        $ante_desc = array();
        $ante_desc= explode('#/#',$datos['tc']['TEL_ANTECEDENTES_DESC']);
        $antece="";
        $resp = array_search('1',$ante);
        if($resp!==false)
            $antece.=$this->CI->lang->line('tc_ant_1').'/'.$ante_desc[0]."\n";
        $resp = array_search('2',$ante);
        if($resp!==false)
            $antece.=$this->CI->lang->line('tc_ant_2').'/'.$ante_desc[1]."\n";
        $resp = array_search('3',$ante);
        if($resp!==false)
            $antece.=$this->CI->lang->line('tc_ant_3').'/'.$ante_desc[2]."\n";
        $resp = array_search('4',$ante);
        if($resp!==false)
            $antece.=$this->CI->lang->line('tc_ant_4').'/'.$ante_desc[3]."\n";
        $resp = array_search('5',$ante);
        if($resp!==false)
            $antece.=$this->CI->lang->line('tc_ant_5').'/'.$ante_desc[4]."\n";
        $resp = array_search('6',$ante);
        if($resp!==false)
            $antece.=$this->CI->lang->line('tc_ant_6').'/'.$ante_desc[5]."\n";
        
       
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'tc_antecedentes' ) ). ': ', 0, 0, 'R' );
        $this->MultiCell( 0, 6, html_entity_decode( utf8_decode( $antece ), ENT_COMPAT, 'ISO-8859-1' ) );
        
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'tc_ayudiagnostica' ) ). ': ', 0, 0, 'R' );
        $this->MultiCell( 0, 6, utf8_decode( $datos['tc'][ 'TEL_AYU_DIAGNOSTICA' ] ) );

//        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'tc_obsadicionales' ) ). ': ', 0, 0, 'R' );
//        $this->MultiCell( 0, 6, utf8_decode( $datos['tc'][ 'TEL_OBS_ADICIONALES' ] ) );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'tc_diapresuntivo' ) ). ': ', 0, 0, 'R' );
        $this->MultiCell( 0, 6, utf8_decode( $datos['tc'][ 'TEL_DIA_PRESUNTIVO' ] ) );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'tc_traactual' ) ). ': ', 0, 0, 'R' );
        $this->MultiCell( 0, 6, utf8_decode( $datos['tc'][ 'TEL_TRA_ACTUAL' ] ) );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'archivos_adjuntos' ) ). ': ', 0, 0, 'R' );
        
        if( !empty( $datos['tc']['file3'] ) )
            $archivos = implode( ', ', $datos['tc']['file3'] );
        else
            $archivos = html_entity_decode( $this->CI->lang->line( 'attach_vacio' ) );
        $this->MultiCell( 0, 6, utf8_decode( $archivos ) );
    }

    /**
     * 
     */
    public function establecer_datos_solicitud_info_examen( $datos ) {

        $this->establecer_datos_solicitud( $datos );
        $this->establecer_datos_paciente( $datos );

        // Evaluación y respuesta del especialista
        $this->SetFont( 'Arial', 'B', 10 );
        $this->Cell( 0, 6, html_entity_decode( $this->CI->lang->line( 'pdf_solicitudes_adicionales' ) ), 1, 1 );

        // Primera fila
        $this->SetFont( 'Arial', '', 10 );
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'exsol_por' ) ).': ', 0, 0, 'R' );
        $this->Cell( 30, 6, utf8_decode( $datos['usuario_exsol'][ 'USU_NOMBRE' ] ), 0, 1, 'L' );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'fechahora_exsol' ) ).': ', 0, 0, 'R' );
        $this->Cell( 30, 6, utf8_decode( $datos['estado_exsol'][ 'TEP_FECHA_HORA' ] ), 0, 1, 'L' );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'exsol_por_nro_registro' ) ).': ', 0, 0, 'R' );
        $this->Cell( 30, 6, utf8_decode( $datos['usuario_exsol'][ 'USU_NRO_REGISTRO' ] ), 0, 1, 'L' );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'prioridad_exsol' ) ).': ', 0, 0, 'R' );
        $this->Cell( 30, 6, $this->CI->lang->line( 'prioridad_' . $datos['estado_exsol'][ 'PRI_ID' ] ), 0, 1, 'L' );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'usuarios_firma' ) ).': ', 0, 0, 'R' );
        $x = $this->GetX();
        $y = $this->GetY();
        if( !empty( $datos['usuario_exsol'][ 'USU_FIRMA' ] ) ) {
            $this->MemImage( base64_decode( $datos['usuario_exsol'][ 'USU_FIRMA' ] ), $x, $y, null, 15 );
            $this->Ln( ); $this->Ln( );
        } else
            $this->Cell( 60, 6, '', 0, 0, 'L' );
 
        $this->Ln( );
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'solicitud_adicional' ) ).': ', 0, 0, 'R' );

        if( !empty( $datos['tc']['TEL_SOL_ADICIONALES'] ) )
            $archivos = $datos['tc']['TEL_SOL_ADICIONALES'];
        else
            $archivos = html_entity_decode( $this->CI->lang->line( 'attach_vacio' ) );
        $this->MultiCell( 0, 6, utf8_decode( $archivos ) );
    }

    /**
     * 
     */
    public function establecer_datos_solicitud_respuesta( $datos ) {

        // Respuesta información adicional
        $this->SetFont( 'Arial', 'B', 10 );
        $this->Cell( 0, 6, html_entity_decode( $this->CI->lang->line( 'pdf_resultados_examenes' ) ), 1, 1 );

        // Primera fila
        $this->SetFont( 'Arial', '', 10 );
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'resultados' ) ).': ', 0, 0, 'R' );
        $this->MultiCell( 0, 6, utf8_decode( $datos['tc'][ 'TEL_SOL_ADICIONALES_RESP' ] ) );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'exreal_por' ) ).': ', 0, 0, 'R' );
        $this->Cell( 30, 6, utf8_decode( $datos['usuario_exreal'][ 'USU_NOMBRE' ] ), 0, 1, 'L' );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'exreal_por_nro_registro' ) ).': ', 0, 0, 'R' );
        $this->Cell( 30, 6, utf8_decode( $datos['usuario_exreal'][ 'USU_NRO_REGISTRO' ] ), 0, 1, 'L' );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'usuarios_firma' ) ).': ', 0, 0, 'R' );
        $x = $this->GetX();
        $y = $this->GetY();
        if( !empty( $datos['usuario_exreal'][ 'USU_FIRMA' ] ) ) {
            $this->MemImage( base64_decode( $datos['usuario_exreal'][ 'USU_FIRMA' ] ), $x, $y, null, 15 );
            $this->Ln( ); $this->Ln( );
        } else
            $this->Cell( 60, 6, '', 0, 0, 'L' );

        $this->Ln( );
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'fechahora_exreal' ) ).': ', 0, 0, 'R' );
        $this->Cell( 30, 6, utf8_decode( $datos['estado_exreal'][ 'TEP_FECHA_HORA' ] ), 0, 1, 'L' );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'archivos_adjuntos' ) ).': ', 0, 0, 'R' );
        if( !empty( $datos['tc']['file5'] ) )
            $archivos = implode( ', ', utf8_decode( $datos['tc']['file5'] ) );
        else
            $archivos = html_entity_decode( $this->CI->lang->line( 'attach_vacio' ) );
        $this->MultiCell( 0, 6, utf8_decode( $archivos ) );
    }

    public function establecer_datos_respuesta_especialista( $datos ) {

        $this->establecer_datos_solicitud( $datos );
        $this->establecer_datos_paciente( $datos );

        // Evaluación y respuesta del especialista
        $this->SetFont( 'Arial', 'B', 10 );
        $this->Cell( 0, 6, html_entity_decode( $this->CI->lang->line( 'pdf_evaluacion_respuesta' ) ), 1, 1 );

        // Primera fila
        $this->SetFont( 'Arial', '', 10 );
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'contestada_por' ) ).': ', 0, 0, 'R' );
        $this->MultiCell( 0, 6, utf8_decode( $datos['usuario_contesta'][ 'USU_NOMBRE' ] ) );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'fechahora_contestada' ) ).': ', 0, 0, 'R' );
        $this->Cell( 30, 6, utf8_decode( $datos['estado_contestada'][ 'TEP_FECHA_HORA'] ), 0, 1, 'L' );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'contestada_por_nro_registro' ) ).': ', 0, 0, 'R' );
        $this->Cell( 30, 6, utf8_decode( $datos['usuario_contesta'][ 'USU_NRO_REGISTRO'] ), 0, 1, 'L' );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'prioridad_contestada_pdf' ) ).': ', 0, 0, 'R' );
        $this->Cell( 30, 6, html_entity_decode( $this->CI->lang->line( 'prioridad_' . $datos['estado_contestada'][ 'PRI_ID' ] ) ), 0, 1, 'l' );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'usuarios_firma' ) ).': ', 0, 0, 'R' );
        $x = $this->GetX();
        $y = $this->GetY();
        if( !empty( $datos['usuario_contesta'][ 'USU_FIRMA' ] ) ) {
            $this->MemImage( base64_decode( $datos['usuario_contesta'][ 'USU_FIRMA' ] ), $x, $y, null, 15 );
            $this->Ln( ); $this->Ln( );
        } else
            $this->Cell( 60, 6, '', 0, 0, 'L' );

        $this->Ln( );
        $this->Cell(60, 6, html_entity_decode( $this->CI->lang->line( 'tc_responder_conespecialista_pdf' ) ).': ', 0, 0, 'R' );
        $this->MultiCell( 0, 6, utf8_decode( $datos['tc'][ 'TEL_CON_ESPECIALISTA'] ) );

        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'tc_responder_diaespecialista_pdf' ) ).': ', 0, 0, 'R' );
        $this->Multicell( 0, 6, utf8_decode( $datos['tc'][ 'TEL_DIA_ESPECIALISTA'] ) );
        
        $this->Cell( 60, 6, html_entity_decode( $this->CI->lang->line( 'tc_responder_diaorientacion_pdf' ) ).': ', 0, 0, 'R' );
        $this->MultiCell( 0, 6, utf8_decode( $datos['tc'][ 'TEL_DIA_ORIENTACION'] ) );
        
        $y = $this->GetY();
        $this->MultiCell( 60, 6, html_entity_decode( $this->CI->lang->line( 'tc_responder_diafundamentos_pdf' ) ).': ', 0, 'R' );
        $x = $this->lMargin + 60;

        $this->SetY( $y );
        $this->SetX( $x );
        $this->MultiCell( 0, 6, utf8_decode( $datos['tc'][ 'TEL_DIA_FUNDAMENTOS'] ) );
    }
}

/**
 * Permite carga de archivos de imagenes desde la base de datos.
 * Obtenido desde: http://www.fpdf.org/en/script/script45.php
 */
class VariableStream
{
    var $varname;
    var $position;

    function stream_open($path, $mode, $options, &$opened_path)
    {
        $url = parse_url($path);
        $this->varname = $url['host'];
        if(!isset($GLOBALS[$this->varname]))
        {
            trigger_error('Global variable '.$this->varname.' does not exist', E_USER_WARNING);
            return false;
        }
        $this->position = 0;
        return true;
    }

    function stream_read($count)
    {
        $ret = substr($GLOBALS[$this->varname], $this->position, $count);
        $this->position += strlen($ret);
        return $ret;
    }

    function stream_eof()
    {
        return $this->position >= strlen($GLOBALS[$this->varname]);
    }

    function stream_tell()
    {
        return $this->position;
    }

    function stream_seek($offset, $whence)
    {
        if($whence==SEEK_SET)
        {
            $this->position = $offset;
            return true;
        }
        return false;
    }
    
    function stream_stat()
    {
        return array();
    }
}