<?php if( !defined( 'BASEPATH' ) ) exit( 'No direct script access allowed' );

if( !empty( $teleconsultas ) ) { ?>

    <script language="javascript" type="text/javascript">

        $(document).ready( function( ) {

            tableToGrid( '#grilla_teleconsultas', {

                // Numero total de registros a mostrar, usado para evitar que grilla
                // limite filas a su valor por omision (20 filas por pagina) cuando se ordena por columnas
                rowNum: 99999999,

                // Al seleccionar una TC se carga la vista de los examenes respondidos
                onSelectRow: function( rowid ) {

                    id = $(this).jqGrid( 'getCell', rowid, 0 );

                    $('#deploy').empty().html('<div><br /><br /><br /><br /><br /><br /><br /><br /><img src="<?= base_url() ?>images/loading.gif" /><br /><br /><br /><br /><br /><br /><br /><br /></div>');
                    $('#deploy').load('<?= base_url() ?>platc/tc_view/<?= $estado ?>/'+id+'/false/true/'+Math.random());
                },
                gridComplete: function( ) {

                    // Oculta columna tel_abierta
                    $(this).jqGrid( 'hideCol', 'tel_abierta' );
                },
                afterInsertRow: function( rowid, rowdata, rowelem ) {

                    // Marca fila como abierta o cerrada poniendola en texto negrita
                    if( parseInt( rowdata.tel_abierta ) == 1 ) {

                        fila = $(this).jqGrid( 'getInd', rowid, true );
                        $(fila).find('td').each( function() {
                            $(this).addClass( 'negrita' );
                        } );
                    }
                }
            } );
        } );

    </script>

    <table id="grilla_teleconsultas">
        <thead>
            <tr>
                <th><?= $this->lang->line( 'tc_id' ) ?></th>
                <th>tel_abierta</th>
                <th><?= $this->lang->line( 'tc_nom_ape' ) ?></th>
                <th><?= $this->lang->line( 'tc_establ' ) ?></th>
                <th><?= $this->lang->line( 'establecimientos_nivel' ) ?></th>
                <th><?= $this->lang->line( 'tc_time' ) ?></th>
                <th><?= $this->lang->line( 'tc_estado' ) ?></th>
                <th><?= $this->lang->line( 'tc_prioridad' ) ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if( $this->session->userdata( 'ROL_ID' ) == 3 && ($estado == 2 || $estado == 6) ) {
                foreach( $teleconsultas as $tc ) { ?>
                <tr>
                    <td><?= $tc[ 'TEL_ID' ] ?></td>
                    <td><?= $tc[ 'TEL_ABIERTA' ] ?></td>
                    <td><?= $tc[ 'TEL_PAC_PRIMER_NOMBRE' ] ?> <?= $tc[ 'TEL_PAC_PRIMER_APELLIDO' ] ?></td>
                    <td><?= $tc[ 'ETB_NOMBRE' ] ?></td>
                    <td><?= $tc[ 'ETB_NIVEL' ] ?></td>
                    <td><?= $tc[ 'TEL_FECHA_HORA' ] ?></td>
                    <td><?= $this->lang->line( 'estado_' . $tc[ 'EST_ID' ] ) ?></td>
                    <td> <img src="<?=base_url()?>images/<?= $this->lang->line( 'prioridad_' . $tc[ 'PRI_ID' ] . '_img' ) ?>"> <?= $this->lang->line( 'prioridad_' . $tc[ 'PRI_ID' ] ) ?></td>
                </tr> 
            <?php
                }
            } elseif( $this->session->userdata( 'ROL_ID' ) > 3 && ($estado == 1 || $estado == 3 || $estado == 5 || $estado == 7) ) {
                foreach( $teleconsultas as $tc ) { ?>
                <tr>
                    <td><?= $tc[ 'TEL_ID' ] ?></td>
                    <td><?= $tc[ 'TEL_ABIERTA' ] ?></td>
                    <td><?= $tc[ 'TEL_PAC_PRIMER_NOMBRE' ] ?> <?= $tc[ 'TEL_PAC_PRIMER_APELLIDO' ] ?></td>
                    <td><?= $tc[ 'ETB_NOMBRE' ] ?></td>
                    <td><?= $tc[ 'ETB_NIVEL' ] ?></td>
                    <td><?= $tc[ 'TEL_FECHA_HORA' ] ?></td>
                    <td><?= $this->lang->line( 'estado_' . $tc[ 'EST_ID' ] ) ?></td>
                    <td> <img src="<?=base_url()?>images/<?= $this->lang->line( 'prioridad_' . $tc[ 'PRI_ID' ] . '_img' ) ?>"> <?= $this->lang->line( 'prioridad_' . $tc[ 'PRI_ID' ] ) ?></td>
                </tr>
            <?php
                }
            } else {
                foreach( $teleconsultas as $tc ) { ?>
                    <tr>
                        <td><?= $tc[ 'TEL_ID' ] ?></td>
                        <td><?= $tc[ 'TEL_ABIERTA' ] ?></td>
                        <td><?= $tc[ 'TEL_PAC_PRIMER_NOMBRE' ] ?> <?= $tc[ 'TEL_PAC_PRIMER_APELLIDO' ] ?></td>
                        <td><?= $tc[ 'ETB_NOMBRE' ] ?></td>
                        <td><?= $tc[ 'ETB_NIVEL' ] ?></td>
                        <td><?= $tc[ 'TEL_FECHA_HORA' ] ?></td>
                        <td><?= $this->lang->line( 'estado_' . $tc[ 'EST_ID' ] ) ?></td>
                        <td> <img src="<?=base_url()?>images/<?= $this->lang->line( 'prioridad_' . $tc[ 'PRI_ID' ] . '_img' ) ?>"> <?= $this->lang->line( 'prioridad_' . $tc[ 'PRI_ID' ] ) ?></td>
                    </tr> 
                <?php }
            } ?>
        </tbody>
    </table>
<?php }
else
    echo $this->lang->line( 'grid_nodata' );
?>