<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Especialidad_Model extends CI_Model {
	
    public function select( $where = '',$activo = TRUE ) {
		$this->db->select("e.*");
		$this->db->from("TC_ESPECIALIDAD e");
		$this->db->join("TC_CLIENTE_ESPECIALIDAD ce","ce.ESP_ID = e.ESP_ID");
		$this->db->where("e.ESP_ID <> '1'");
		if($activo) $this->db->where("e.ESP_ACTIVO",1);
		if($where) $this->db->where($where); //Arreglo de condiciones = array()
        $query = $this->db->get();
        if ($query->num_rows() > 0)
            return $query->result_array();
        else
            return NULL;
    }
    public function select_especialista_agenda( $id_site = '', $esp_id = '') {
		if($id_site){
			$this->db->select( "u.USU_ID, u.USU_NOMBRE, e.ESP_DESCRIPCION, e.ESP_NOMBRE" );
			$this->db->distinct();
			$this->db->from('TC_USUARIO u');
			$this->db->join('TC_USUARIO_ESPECIALIDAD ue', 'ue.USU_ID = u.USU_ID', 'left');
			$this->db->join('TC_ESPECIALIDAD e','ue.ESP_ID = e.ESP_ID');
			$this->db->join('TC_BOLSA_USUARIO bu','u.USU_ID = bu.USU_ID');
			$this->db->join('TC_BOLSA b','bu.BOL_ID = b.BOL_ID');
			// Valida filtro por especialidad
			if( $esp_id ) {
				$this->db->where_in( 'ue.ESP_ID', $esp_id );
			}
			//$this->db->where('b.BOL_FECHA_INICIO >= CURRENT_DATE()');
			$this->db->order_by( "u.USU_NOMBRE", "asc" );
			$query = $this->db->get();
			//echo $this->db->last_query();
			if($query->num_rows){
				return $query->result_array();
			}
			else{
				return FALSE;
			}
		}
		else{
			return FALSE;
		}
    }
}
