<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Tc_Virtual_Model extends CI_Model {
	public function __construct(){
		parent::__construct();
		$this->load->model('platc/platc_model');
	}
	public function insert($data = ''){
		if($data){
			return $this->db->insert('TC_VIRTUAL',$data);
		}
		else{
			return FALSE;
		}
	}
	public function select_agendas($pac_idt = '', $nombre = '', $apellido = '', $etb_id = '', $esp_id = ''){
		$this->db->select("
							a.AGE_ID,
							a.AGE_FECHA,
							a.AGE_HORA,
							p . *,
							pi.PAC_IDT_VALOR,
							etb.ETB_NOMBRE,
							esp.ESP_NOMBRE,
							esp.ESP_DESCRIPCION
		",FALSE);
		$this->db->from("TC_PACIENTE p");
		$this->db->join("TC_PACIENTE_IDENTIFICADOR pi","p.PAC_ID = pi.PAC_ID");
		$this->db->join("TC_VIRTUAL tcv","p.PAC_ID = tcv.TCV_PAC_ID");
		$this->db->join("TC_AGENDA a","tcv.TCV_AGE_ID = a.AGE_ID");
		$this->db->join("TC_ESTABLECIMIENTO etb","tcv.TCV_ETB_ID = etb.ETB_ID");
		$this->db->join("TC_ESPECIALIDAD esp","tcv.TCV_ESP_ID = esp.ESP_ID");
		if($pac_idt) $this->db->where("pi.PAC_IDT_VALOR",$pac_idt);
		if($etb_id) $this->db->where("tcv.TCV_ETB_ID",$etb_id);
		if($esp_id) $this->db->where("pi.TCV_ESP_ID",$esp_id);
		if($nombre){
			if(is_array($nombre)){
				foreach($nombre as $n){ $this->db->where("(p.PAC_PRIMER_NOMBRE LIKE '%".$n."%' OR p.PAC_SEGUNDO_NOMBRE LIKE '%".$n."%')"); }
			}
			else{
				$this->db->where("(p.PAC_PRIMER_NOMBRE LIKE '%".$nombre."%' OR p.PAC_SEGUNDO_NOMBRE LIKE '%".$nombre."%')");
			}
		}
		if($apellido){
			if(is_array($apellido)){
				foreach($apellido as $a){ $this->db->where("(p.PAC_PRIMER_APELLIDO LIKE '%".$a."%' OR p.PAC_SEGUNDO_APELLIDO LIKE '%".$a."%')"); }
			}
			else{
				$this->db->where("(p.PAC_PRIMER_APELLIDO LIKE '%".$apellido."%' OR p.PAC_SEGUNDO_APELLIDO LIKE '%".$apellido."%')");
			}
		}
		$this->db->where('a.AGEEST_ID IN (1,2)');
		$this->db->order_by('a.AGE_FECHA, a.AGE_HORA');
		$query = $this->db->get();
		//echo $this->db->last_query();
		if($query->num_rows()){
			return $query->result_array();
		}
		else{
			return FALSE;
		}
	}
    public function agendamiento_cambiar_fecha_hora( $id_agendamiento, $fecha, $hora ) {
		$this->load->model('platc/platc_model');	
        $agendamiento_anterior = $this->platc_model->agendamiento_get( $id_agendamiento, $this->session->userdata('SIT_ID') );
        $data = array( 'AGE_FECHA' => $fecha, 'AGE_HORA' => $hora );
        $this->db->where( 'AGE_ID', $id_agendamiento );
        $estado = $this->db->update( 'TC_AGENDA', $data );
        $id_teleconsulta= (int)$agendamiento_anterior['TEL_ID'];
        $id_estado      = (int)$agendamiento_anterior['AGEEST_ID'];
        $id_usuario     = (int)$this->session->userdata('USU_ID');
        $observaciones  = sprintf(  $this->lang->line('agendamiento_cambio_hora_observacion'),
                                    $this->session->userdata('USU_NOMBRE'),
                                    $agendamiento_anterior['AGE_HORA'], $this->util->fecha_orden( $agendamiento_anterior['AGE_FECHA'] ),
                                    $hora, $this->util->fecha_orden( $fecha ) );
        $info_tecnico   = sprintf( $this->lang->line('agendamiento_cambio_hora_info_tecnico'),
                                    $this->session->userdata('USU_ID'), $this->session->userdata('USU_NOMBRE'),
                                    $id_agendamiento, $agendamiento_anterior['AGE_HORA'], $agendamiento_anterior['AGE_FECHA'],
                                    $hora, $fecha );
        $this->platc_model->agendamiento_registro_suceso( $id_teleconsulta, $id_agendamiento, $id_estado, $id_usuario, $observaciones, $info_tecnico );
        return $estado;
    }
    public function agendamientos_get( $id_site, $id_estado = NULL, $id_rol = NULL, $id_usuario_medico = NULL ) {
        if ( ( !empty( $id_rol )  ) && ( $id_rol == 9  )  ){
            $sql = "SELECT  a.AGE_ID, ae.AGEEST_DESCRIPCION,
                            t.TEL_ID , a.AGE_FECHA, a.AGE_HORA,
                            e.ESP_NOMBRE,
                            etb.ETB_NOMBRE,
							CONCAT_WS(' ',p.PAC_PRIMER_NOMBRE,p.PAC_PRIMER_APELLIDO,p.PAC_SEGUNDO_APELLIDO) AS PAC_NOMBRE
                    FROM    TC_AGENDA a
								INNER JOIN TC_VIRTUAL tcv ON a.AGE_ID = tcv.TCV_AGE_ID
								INNER JOIN TC_PACIENTE p ON tcv.TCV_PAC_ID = p.PAC_ID 
                                INNER JOIN TC_AGENDA_ESTADO ae ON ( ae.AGEEST_ID = a.AGEEST_ID )";
        } else {
            $sql = "SELECT  a.AGE_ID, ae.AGEEST_DESCRIPCION,
                            t.TEL_ID, u.USU_NOMBRE, a.AGE_FECHA, a.AGE_HORA,
                            e.ESP_NOMBRE,
                            etb.ETB_NOMBRE,
							CONCAT(p.PAC_PRIMER_NOMBRE,' ',p.PAC_PRIMER_APELLIDO,' ',p.PAC_SEGUNDO_APELLIDO) AS PAC_NOMBRE
                    FROM    TC_AGENDA a
								INNER JOIN TC_VIRTUAL tcv ON a.AGE_ID = tcv.TCV_AGE_ID
								INNER JOIN TC_PACIENTE p ON tcv.TCV_PAC_ID = p.PAC_ID 
                                INNER JOIN TC_AGENDA_ESTADO ae ON ( ae.AGEEST_ID = a.AGEEST_ID )";
        }
        // Cambia join para obtener médico especialista o generalista según parametros
        if( !empty( $id_rol ) ) {
            switch( (int)$id_rol ) {
                // Obtiene agendas del especialista
                case 1 : 
                case 2 : $sql.= "            INNER JOIN TC_USUARIO u ON ( u.USU_ID = a.USU_ID_ESPECIALISTA )"; break;
                // Obtiene agendas del especialista
                case 3 : $sql.= "            INNER JOIN TC_USUARIO u ON ( u.USU_ID = a.USU_ID_MEDICO )"; break;
                // Obtiene agendas del 4: generalista y 5: Asistente
                case 4 :
                case 5 : $sql.= "            INNER JOIN TC_USUARIO u ON ( u.USU_ID = a.USU_ID_ESPECIALISTA ) "; break;
            }
        }
        $sql.= "            INNER LEFT ( TC_TELECONSULTA t
                                INNER JOIN TC_ESPECIALIDAD e ON ( e.ESP_ID = t.ESP_ID )
                                INNER JOIN TC_ESTABLECIMIENTO etb ON ( etb.ETB_ID = t.ETB_ID )
                            ) ON ( t.TEL_ID = a.TEL_ID )
                WHERE   a.SIT_ID = " . $id_site;
        if( !empty( $id_estado ) ) {
            $sql .= '   AND a.AGEEST_ID = ' . $id_estado;
        }
        // Filtra agendamientos según rol al que pertenecen
        if( !empty( $id_rol ) ) {
            switch( (int)$id_rol ) {
                // Obtiene agendas de todos los especialistas
                case 1 : break;
                case 2 : break;
                // Obtiene agendas del especialista
                case 3 : $sql .= '   AND a.USU_ID_ESPECIALISTA = ' . $id_usuario_medico; break;
                // Obtiene agendas del 4: generalista y 5: Asistente
                case 4 : break;
            }
        }
		
		$sql .= " AND a.AGE_FECHA = CURDATE() ";
        // Ordena listado dejando los pendientes desde los próximos hacia los más lejanos
        $sql .= ' ORDER BY a.AGE_FECHA ASC, a.AGE_HORA ASC';
        $query = $this->db->query( $sql );
        return $query->result_array( );
    }
	public function add_tc($id = '', $data = ''){
		if($id && $data){
			$this->db->where('AGE_ID',$id);
			return $this->db->update('TC_AGENDA',$data);
		}
		else{
			return FALSE;
		}
	}
    public function tc_lista_get($user_id = '', $site = '', $etb_id = '', $pac_id = '', $esp_id = ''){
		if($user_id && $etb_id && $pac_id && $esp_id){
			$sql  = "SELECT DISTINCT t.TEL_ID, t.TEL_PAC_PRIMER_NOMBRE, t.TEL_PAC_PRIMER_APELLIDO, t.TEL_PAC_SEGUNDO_APELLIDO
							, case when t.EST_ID = 1 then t.TEL_FECHA_HORA else max( t.TEL_FECHA_HORA_ENVIO ) end as TEL_FECHA_HORA
							, t.EST_ID, t.TEL_LOCK_USED, t.PRI_ID,
							e.ETB_NOMBRE, e.ETB_NIVEL, esp.ESP_NOMBRE
							, case when t.EST_ID = 7 then DATEDIFF( DATE_ADD( TEL_FECHA_HORA_RESPUESTA, INTERVAL 10 MINUTE ), TEL_FECHA_HORA_ENVIO )
									when t.EST_ID = 1 then DATEDIFF( DATE_ADD( NOW(), INTERVAL 10 MINUTE ), TEL_FECHA_HORA )
							else DATEDIFF( DATE_ADD( NOW(), INTERVAL 10 MINUTE ), t.TEL_FECHA_HORA_ENVIO ) end as TEL_ATRASO ";
			if( $site == 22 ){
				$sql .= "FROM   TC_TELECONSULTA AS t
								INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID )
								INNER JOIN ( TC_ESTABLECIMIENTO e ) ON ( t.ETB_ID = e.ETB_ID )
						WHERE   t.SIT_ID = '".$site."' ";
			} else{
				$sql .= "FROM   TC_TELECONSULTA AS t";
				$sql .= "       INNER JOIN ( TC_ESPECIALIDAD esp ) ON ( t.ESP_ID = esp.ESP_ID ) ";
				$sql .= "       INNER JOIN ( TC_ESTABLECIMIENTO e
												INNER JOIN ( TC_CLIENTE c
																INNER JOIN ( TC_GRUPO_CLIENTE gc
																				INNER JOIN ( TC_GRUPO g
																								INNER JOIN ( TC_GRUPO_USUARIO gu ) ON ( gu.GRU_ID = g.GRU_ID )
																				) ON ( g.GRU_ID = gc.GRU_ID )
																) ON ( gc.CLI_ID = c.CLI_ID )
												) ON ( c.CLI_ID = e.CLI_ID )
								) ON ( t.ETB_ID = e.ETB_ID ) ";
				$sql .= "WHERE  gu.USU_ID = " . $user_id;
			}
			// Establece el estado
			$sql .= " AND t.EST_ID IN (2,6)";
			$sql .= " AND t.ETB_ID = ".$etb_id;
			$sql .= " AND t.PAC_ID = ".$pac_id;
			$sql .= " AND t.ESP_ID = ".$esp_id;
			$sql .= " GROUP BY t.TEL_ID ORDER BY t.PRI_ID ASC ";
			$query = $this->db->query($sql);
			if($query->num_rows() > 0){
				return $query->result_array();
			}
			else
				return FALSE;
		}
		else
			return FALSE;
    }
	public function select($where = ''){
		if($where) $this->db->where($where);
		$query = $this->db->get('TC_VIRTUAL');
		if($query->num_rows()){
			return $query->row_array();
		}
		else{
			return FALSE;
		}
	}
	public function update($id = '', $data = ''){
		if($id && $data){
			$this->db->where('TCV_AGE_ID',$id);
			echo $this->db->update('TC_VIRTUAL',$data);
		}
		else{
			return FALSE;
		}
	}
}
